/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ProcessoArquivoAssinaturaRepository
extends CrudRepository<ProcessoArquivoAssinatura, Long> {
    @Query(value="select count(*) from arquivos_assinatura pa where pa.dataAssinatura is null   and pa.dataRecusa is null   and pa.usuario = :usuario   and pa.entidade = :entidade ", nativeQuery=true)
    public Long countProcessosPendentesByUsuarioAndEntidade(@Param(value="usuario") String var1, @Param(value="entidade") Long var2);

    @Query(value=" from ProcessoArquivoAssinatura pa where pa.dataAssinatura is null   and pa.dataRecusa is null   and pa.usuario.id = :usuario   and pa.entidade = :entidade ")
    public List<ProcessoArquivoAssinatura> findAssinaturasPendentesByUsuarioAndEntidade(@Param(value="usuario") String var1, @Param(value="entidade") Long var2);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="update ProcessoArquivoAssinatura set situacao = 'ASSINANDO' ,     idProcessamento = :idProcessamento,     dataassinando = :dataHoraAtual where id in (:ids)  and dataAssinatura is null  and dataRecusa is null  and (situacao = 'PENDENTE' or situacao is null) ")
    public void atualizarAssinaturasPendentesParaAssinando(@Param(value="ids") List<Long> var1, @Param(value="idProcessamento") String var2, @Param(value="dataHoraAtual") LocalDateTime var3);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="update ProcessoArquivoAssinatura   set situacao = 'PENDENTE',       erro = :erro  where idProcessamento = :idProcessamento  and dataAssinatura is null  and dataRecusa is null")
    public void voltarAssinaturasParaPendente(@Param(value="erro") String var1, @Param(value="idProcessamento") String var2);

    @Query(value="select id from ProcessoArquivoAssinatura where idProcessamento = :idProcessamento ")
    public Set<Long> findIdsByIdProcessamento(@Param(value="idProcessamento") String var1);

    public List<ProcessoArquivoAssinatura> findIdByIdProcessamento(@Param(value="idProcessamento") String var1);

    @Query(value="select aa.id from arquivos_assinatura aa  where aa.tipo = :tipo    and aa.ano = :ano    and aa.numero = :numero ", nativeQuery=true)
    public List<Long> findByArquivoAssinaturaProcessoId(@Param(value="tipo") Long var1, @Param(value="ano") Long var2, @Param(value="numero") Long var3);

    @Query(value="select case when count(aa.id) > 0 then 'true' else 'false' end  from arquivos_assinatura aa  where aa.tipo = :tipo    and aa.ano = :ano    and aa.numero = :numero    and aa.situacao <> 'PENDENTE' ", nativeQuery=true)
    public Boolean exitsAssinaturaDiferenteDePendente(@Param(value="tipo") Long var1, @Param(value="ano") Long var2, @Param(value="numero") Long var3);
}

