/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.report.resolver;

import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.report.file.ReportFileResolver;
import br.com.elotech.report.file.ReportFileResolverFactory;
import com.google.common.base.Strings;
import java.io.File;
import org.springframework.stereotype.Component;

@Component
public class ParametroReportResolver {
    private final ParametroService parametroService;
    private final ReportFileResolverFactory reportFileResolverFactory;

    public ParametroReportResolver(ReportFileResolverFactory reportFileResolverFactory, ParametroService parametroService) {
        this.parametroService = parametroService;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    public File resolveFromRelatorio(RelatorioProtocolo relatorio) {
        return this.reportFileResolverFactory.fromFile(relatorio.getDefaultRpt()).resolve();
    }

    public ReportFileResolver resolveFromRelatorio(String nomeRelatorio) {
        return this.reportFileResolverFactory.fromFile(nomeRelatorio);
    }

    public File resolveFromParametro(RelatorioProtocolo relatorio, ParametroEnum parametroEnum) {
        String arquivoParametro = this.parametroService.getParamValueAsString(parametroEnum.getCodigo());
        if (Strings.isNullOrEmpty((String)arquivoParametro)) {
            return this.reportFileResolverFactory.fromFile(relatorio.getDefaultRpt()).resolve();
        }
        return this.reportFileResolverFactory.fromFile(arquivoParametro).resolve();
    }

    public ReportFileResolver fromFile(String reportName) {
        return this.reportFileResolverFactory.fromFile(reportName);
    }
}

