/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.report.loader;

import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.fluent.dataset.Dataset;
import br.com.elotech.fluent.dataset.ReportDatasets;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.report.datasetrecord.ComprovanteProcessoDatasetRecord;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ComprovanteProcessoParamLoader
implements ParamLoader {
    public static final String PARAM_USUARIO = "USUARIO";
    public static final String PARAM_CLIENTE = "CLIENTE";
    public static final String PARAM_TIPO = "TIPO";
    public static final String PARAM_ANO = "ANO";
    public static final String PARAM_NUMERO = "NUMERO";
    public static final String PARAM_ZONA = "ZONA";
    public static final String PARAM_QUADRA = "QUADRA";
    public static final String PARAM_DATA = "DATA";
    public static final String PARAM_CADASTRO = "CADASTRO";
    public static final String PARAM_INFORMACAO_COMPROVANTE = "INFORMACAO_COMPROVANTE";
    public static final String PARAM_INFORMACAO_COMPLEMENTAR = "INFORMACAO_COMPLEMENTAR";
    private static final int ZERO = 0;
    private static final int TAMANHO_MAX_INFORMACAO = 255;
    private final EntidadeService entidadeService;
    private final ParametroService parametroService;
    private final ExercicioService exercicioService;
    private final ProcessoPesquisaService processoPesquisaService;

    public ComprovanteProcessoParamLoader(EntidadeService entidadeService, ParametroService parametroService, ExercicioService exercicioService, ProcessoPesquisaService processoPesquisaService) {
        this.entidadeService = entidadeService;
        this.parametroService = parametroService;
        this.exercicioService = exercicioService;
        this.processoPesquisaService = processoPesquisaService;
    }

    public Set<Param> load(ReportDatasets datasets) {
        Dataset dataset = (Dataset)datasets.get("ComprovanteProcessoGeral");
        ComprovanteProcessoDatasetRecord comprovante = (ComprovanteProcessoDatasetRecord)dataset.getRecords().stream().findFirst().orElseThrow(() -> new IllegalStateException("N\u00e3o foi poss\u00edvel encontrar o registro no dataset para carregar os par\u00e2metros do relat\u00f3rio"));
        Entidade entidadeComprovante = Optional.ofNullable((Entidade)this.entidadeService.findOne((Serializable)comprovante.getEntidade())).orElseThrow(() -> new RegistroNaoEncontradoException("Entidade n\u00e3o localizada para emiss\u00e3o do comprovante"));
        Processo processo = this.processoPesquisaService.loadProcesso(entidadeComprovante, comprovante.getTipo(), comprovante.getNumero(), comprovante.getAno());
        HashSet params = Sets.newHashSet();
        String parametroInformacao = this.getParametroInformacao();
        params.add(Param.of((String)PARAM_ANO, (Object)comprovante.getAno()));
        params.add(Param.of((String)PARAM_CADASTRO, (Object)processo.getCadastro()));
        params.add(Param.of((String)PARAM_CLIENTE, (Object)processo.getId().getEntidade()));
        params.add(Param.of((String)PARAM_DATA, (Object)processo.getDataProcessoAsString()));
        params.add(Param.of((String)PARAM_NUMERO, (Object)comprovante.getNumero()));
        params.add(Param.of((String)PARAM_QUADRA, (Object)processo.getQuadra()));
        params.add(Param.of((String)PARAM_TIPO, (Object)processo.getId().getTipo().getDescricao()));
        params.add(Param.of((String)PARAM_USUARIO, (Object)comprovante.getUsuarioReg()));
        params.add(Param.of((String)PARAM_ZONA, (Object)processo.getZona()));
        params.add(Param.of((String)PARAM_INFORMACAO_COMPROVANTE, (Object)StringUtils.safeSubstring((String)parametroInformacao, (int)0, (int)255)));
        params.add(Param.of((String)PARAM_INFORMACAO_COMPLEMENTAR, (Object)this.getInformacaoComplementar(parametroInformacao)));
        return params;
    }

    private String getInformacaoComplementar(String parametroInformacao) {
        if (parametroInformacao.length() > 255) {
            return StringUtils.safeSubstring((String)parametroInformacao, (int)255, (int)510);
        }
        return " ";
    }

    private String getParametroInformacao() {
        Long exercicioAtual = this.exercicioService.getExercicioAtual();
        Parametro paramInformacaoComplementar = this.parametroService.getByEntidadeAndExercicioAndCodigo(this.entidadeService.getEntidadeAtual(), exercicioAtual, ParametroEnum.INFORMACAO_COMPROVANTE.getCodigo());
        return Optional.ofNullable(paramInformacaoComplementar).map(p -> p.getValor()).orElse("");
    }
}

