/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.report.loader;

import br.com.elotech.fluent.dataset.Dataset;
import br.com.elotech.fluent.dataset.ReportDatasets;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.report.datasetrecord.CapaProcessoMainDatasetRecord;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class CapaProcessoParamLoader
implements ParamLoader {
    private static final String DATASOURCE_NOTFOUND = "N\u00e3o \u00e9 poss\u00edvel carregar os par\u00e2metros da capa do processo sem ter o datasource preenchido.";
    private static final String USUARIO_EXTERNO = "Usu\u00e1rio Externo";
    public static final String PARAM_PREFEITO = "Prefeito";
    public static final String PARAM_REPARTICAO = "Reparticao";
    public static final String PARAM_ZONA = "ZONA";
    public static final String PARAM_QUADRA = "QUADRA";
    public static final String PARAM_DATA = "DATA";
    public static final String PARAM_CADASTRO = "CADASTRO";
    public static final String PARAM_DESCENDERECO = "DESCENDERECO";
    public static final String PARAM_NUMEROENDERECO = "NUMEROENDERECO";
    public static final String PARAM_DESCBAIRRO = "DESCBAIRRO";
    public static final String PARAM_DESCCIDADE = "DESCCIDADE";
    public static final String PARAM_DESCUNIDADEFEDERACAO = "DESCUNIDADEFEDERACAO";
    public static final String PARAM_CEP = "CEP";
    public static final String PARAM_COMPLEMENTOENDERECO = "COMPLEMENTOENDERECO";
    public static final String PARAM_TELEFONE2 = "TELEFONE2";
    public static final String PARAM_CELULAR2 = "CELULAR2";
    public static final String PARAM_EMAIL = "EMAIL";
    public static final String PARAM_DESCRICAOTIPO = "DESCRICAOTIPO";
    public static final String PARAM_USUARIO = "USUARIO";
    private static final String SIM = "S";
    private final ParametroService parametroService;
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;
    private final UsuarioService usuarioService;
    private String datasetName;

    public CapaProcessoParamLoader(ParametroService parametroService, ExercicioService exercicioService, EntidadeService entidadeService, UsuarioService usuarioService) {
        this.parametroService = parametroService;
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
        this.usuarioService = usuarioService;
    }

    public CapaProcessoParamLoader beforeLoad(String datasetName) {
        this.datasetName = datasetName;
        return this;
    }

    public Set<Param> load(ReportDatasets datasets) {
        Dataset dataset = (Dataset)datasets.get(this.datasetName);
        CapaProcessoMainDatasetRecord processo = (CapaProcessoMainDatasetRecord)dataset.first().orElseThrow(() -> new IllegalStateException(DATASOURCE_NOTFOUND));
        HashSet params = Sets.newHashSet();
        params.add(this.parametroPrefeito());
        params.add(this.parametroReparticao());
        params.add(this.parameterDescricaoTipo(processo));
        params.add(Param.of((String)PARAM_ZONA, (Object)processo.getZona()));
        params.add(Param.of((String)PARAM_QUADRA, (Object)processo.getQuadra()));
        params.add(Param.of((String)PARAM_DATA, (Object)processo.getData()));
        params.add(Param.of((String)PARAM_CADASTRO, (Object)processo.getCadastro()));
        params.add(Param.of((String)PARAM_DESCENDERECO, (Object)processo.getDescEndereco()));
        params.add(Param.of((String)PARAM_NUMEROENDERECO, (Object)processo.getNumeroendereco()));
        params.add(Param.of((String)PARAM_DESCBAIRRO, (Object)processo.getDescbairro()));
        params.add(Param.of((String)PARAM_DESCCIDADE, (Object)processo.getDesccidade()));
        params.add(Param.of((String)PARAM_DESCUNIDADEFEDERACAO, (Object)processo.getDescunidadefederacao()));
        params.add(Param.of((String)PARAM_CEP, (Object)processo.getCep()));
        params.add(Param.of((String)PARAM_COMPLEMENTOENDERECO, (Object)processo.getComplementoendereco()));
        params.add(Param.of((String)PARAM_TELEFONE2, (Object)processo.getTelefone()));
        params.add(Param.of((String)PARAM_CELULAR2, (Object)processo.getCelular()));
        params.add(Param.of((String)PARAM_EMAIL, (Object)processo.getEmail()));
        Authentication usuarioAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (usuarioAuthentication != null) {
            params.add(Param.of((String)PARAM_USUARIO, (Object)this.getNomeUsuario()));
        }
        return params;
    }

    private String getNomeUsuario() {
        Authentication usuarioAuthentication = SecurityContextHolder.getContext().getAuthentication();
        Usuario usuarioLogado = (Usuario)this.usuarioService.findOne((Serializable)((Object)usuarioAuthentication.getName()));
        if (Objects.isNull(usuarioLogado)) {
            return USUARIO_EXTERNO;
        }
        return usuarioLogado.getNome();
    }

    private Param parametroReparticao() {
        String parametroReparticao = this.getParamValue(ParametroEnum.REPARTICAO.getCodigo());
        if (parametroReparticao.length() > 0) {
            return Param.of((String)PARAM_REPARTICAO, (Object)parametroReparticao);
        }
        return Param.of((String)PARAM_REPARTICAO, (Object)", supra qualificado, vem respeitosamente \u00e0 presen\u00e7a de Vossa Excel\u00eancia requerer para que determine \u00e0 reparti\u00e7\u00e3o competente desta Prefeitura que lhe expe\u00e7a:");
    }

    private String getParamValue(Long codigo) {
        Long exercicioAtual = this.exercicioService.getExercicioAtual();
        Parametro param = this.parametroService.getByEntidadeAndExercicioAndCodigo(this.entidadeService.getEntidadeAtual(), exercicioAtual, codigo);
        return Optional.ofNullable(param).map(p -> p.getValor()).orElse("");
    }

    private Param parameterDescricaoTipo(CapaProcessoMainDatasetRecord processo) {
        String parametroTipoSequencia = this.getParamValue(ParametroEnum.NUMERACAO_SEQUENCIA_TIPO.getCodigo());
        String parametroTipoNumero = this.getParamValue(ParametroEnum.LIBERA_TIPO_NUMERO.getCodigo());
        if (SIM.equalsIgnoreCase(parametroTipoNumero) || SIM.equalsIgnoreCase(parametroTipoSequencia)) {
            StringBuilder tipoProcesso = new StringBuilder();
            tipoProcesso.append(processo.getTipo()).append(" - ").append(processo.getDesctipoprotocolo());
            return Param.of((String)PARAM_DESCRICAOTIPO, (Object)tipoProcesso.toString());
        }
        return Param.of((String)PARAM_DESCRICAOTIPO, (Object)"");
    }

    private Param parametroPrefeito() {
        String parametroPrefeito = this.getParamValue(ParametroEnum.PREFEITO.getCodigo());
        if (parametroPrefeito.length() > 0) {
            return Param.of((String)PARAM_PREFEITO, (Object)parametroPrefeito);
        }
        return Param.of((String)PARAM_PREFEITO, (Object)"Excelent\u00edssimo Senhor Prefeito,");
    }
}

