/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.report.function;

import br.com.elotech.adm.utils.HtmlUtils;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.report.datasetrecord.PapeletaDatasetRecord;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.rowset.serial.SerialClob;

public class TramiteToPapeletaDatasetRecord
implements Function<Tramite, PapeletaDatasetRecord> {
    @Override
    public PapeletaDatasetRecord apply(Tramite tramite) {
        Processo processo = tramite.getId().getProcesso();
        PapeletaDatasetRecord dto = new PapeletaDatasetRecord();
        dto.setParecer(this.convertClobParecer(tramite.getParecer()));
        dto.setAno(processo.getId().getAno());
        dto.setNome(Optional.ofNullable(processo.getPessoa()).map(Pessoa::getNome).orElse(""));
        dto.setCodPessoa(Optional.ofNullable(tramite.getId().getProcesso().getPessoa()).map(Pessoa::getId).orElse(0L));
        dto.setNomeRequerente(Optional.ofNullable(tramite.getId().getProcesso().getPessoa()).map(Pessoa::getNome).orElse(""));
        dto.setResponsavelDestino("");
        dto.setTipo(processo.getId().getTipo().getId());
        dto.setDescTipo(processo.getId().getTipo().getDescricao());
        dto.setFuncao(tramite.getFuncao().getDescricao());
        dto.setNomeEntidade(processo.getId().getEntidade().getNome());
        dto.setNumero(processo.getId().getNumero());
        dto.setResponsavelOrigem(tramite.getUsuarioRegistro());
        dto.setSequencia(tramite.getId().getSequencia());
        dto.setUsuarioRegistro(tramite.getUsuarioRegistro());
        Optional.ofNullable(tramite.getUsuario()).ifPresent(u -> {
            dto.setNomeUsuario(u.getNome());
            dto.setCpfUsuario(u.getCpf());
        });
        Long sequenciaTramiteAnterior = tramite.getSequencia() - 1L;
        Optional<Tramite> tramiteAnteriorOptional = processo.getTramites().stream().filter(t -> t.getSequencia().equals(sequenciaTramiteAnterior)).findAny();
        tramiteAnteriorOptional.ifPresent(ta -> {
            dto.setTramiteAnteriorUsuario(ta.getUsuarioRegistro());
            Optional.ofNullable(ta.getLocal()).ifPresent(l -> {
                dto.setTramiteAnteriorLocal(l.getId().getId());
                dto.setTramiteAnteriorLocalDescricao(l.getDescricao());
            });
            Optional.ofNullable(ta.getUsuario()).ifPresent(ua -> {
                dto.setTramiteAnteriorCpfUsuario(ua.getCpf());
                dto.setTramiteAnteriorNomeUsuario(ua.getNome());
            });
        });
        dto.setLote(Optional.ofNullable(tramite.getLote()).orElse(0L));
        dto.setLoteSequencia(Optional.ofNullable(tramite.getLoteSequencia()).orElse(0L));
        if (Objects.nonNull(tramite.getUsuario())) {
            dto.setNomeUsuario(tramite.getUsuario().getNome());
        }
        if (Objects.nonNull(tramite.getData())) {
            dto.setData(Date.valueOf(tramite.getData()));
        }
        if (Objects.nonNull(tramite.getHora())) {
            dto.setHora(Time.valueOf(tramite.getHora()));
        }
        this.transformarAssunto(processo, dto);
        this.transformarLocalDestino(tramite, dto);
        this.transformarLocalOrigem(tramite, dto);
        return dto;
    }

    private void transformarLocalOrigem(Tramite tramite, PapeletaDatasetRecord dto) {
        Processo processo = tramite.getId().getProcesso();
        Optional tramiteAnterior = processo.findBySequencia(Long.valueOf(tramite.getSequencia() - 1L));
        if (tramiteAnterior.isPresent()) {
            dto.setCodLocalOrigem(((Tramite)tramiteAnterior.get()).getLocal().getId().getId());
            dto.setOrigem(((Tramite)tramiteAnterior.get()).getLocal().getDescricao());
        } else {
            dto.setCodLocalOrigem(processo.getLocalOrigem().getId().getId());
            dto.setOrigem(processo.getLocalOrigem().getDescricao());
        }
    }

    private void transformarLocalDestino(Tramite tramite, PapeletaDatasetRecord dto) {
        if (Objects.nonNull(tramite.getLocal())) {
            dto.setCodlocaldestino(tramite.getLocal().getId().getId());
            dto.setDestino(tramite.getLocal().getDescricao());
        }
    }

    private void transformarAssunto(Processo processo, PapeletaDatasetRecord dto) {
        if (Objects.nonNull(processo.getAssunto())) {
            dto.setCodAssunto(processo.getAssunto().getId());
            dto.setDescAssunto(processo.getAssunto().getDescricao());
            dto.setDescricao(processo.getAssunto().getDescricao());
        }
    }

    private Clob convertClobParecer(String parecer) {
        if (parecer == null) {
            return null;
        }
        parecer = HtmlUtils.toText((String)parecer).trim();
        return new SerialClob(parecer.toCharArray());
    }
}

