/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.report.datasetrecord;

import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.protocolo.domain.Entidade;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import lombok.Generated;

public class CabecalhoReport
implements DatasetRecord {
    private String entidade;
    private String cnpj;
    private String estado;
    private Long exercicio;
    private BufferedImage brasao;

    public CabecalhoReport(Entidade entidade, Long exercicio) throws IOException {
        this.entidade = entidade.getNome();
        this.cnpj = entidade.getCnpj();
        this.estado = entidade.getCidade().getUf().getId();
        this.exercicio = exercicio;
        if (Objects.nonNull(entidade.getBrasao())) {
            this.brasao = ImageIO.read(new ByteArrayInputStream(entidade.getBrasao()));
        }
    }

    @Generated
    public String getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public String getEstado() {
        return this.estado;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public BufferedImage getBrasao() {
        return this.brasao;
    }

    @Generated
    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setEstado(String estado) {
        this.estado = estado;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setBrasao(BufferedImage brasao) {
        this.brasao = brasao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CabecalhoReport)) {
            return false;
        }
        CabecalhoReport other = (CabecalhoReport)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        String this$entidade = this.getEntidade();
        String other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !this$entidade.equals(other$entidade)) {
            return false;
        }
        String this$cnpj = this.getCnpj();
        String other$cnpj = other.getCnpj();
        if (this$cnpj == null ? other$cnpj != null : !this$cnpj.equals(other$cnpj)) {
            return false;
        }
        String this$estado = this.getEstado();
        String other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        BufferedImage this$brasao = this.getBrasao();
        BufferedImage other$brasao = other.getBrasao();
        return !(this$brasao == null ? other$brasao != null : !this$brasao.equals(other$brasao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CabecalhoReport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        String $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : $entidade.hashCode());
        String $cnpj = this.getCnpj();
        result = result * 59 + ($cnpj == null ? 43 : $cnpj.hashCode());
        String $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        BufferedImage $brasao = this.getBrasao();
        result = result * 59 + ($brasao == null ? 43 : $brasao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CabecalhoReport(entidade=" + this.getEntidade() + ", cnpj=" + this.getCnpj() + ", estado=" + this.getEstado() + ", exercicio=" + this.getExercicio() + ", brasao=" + String.valueOf(this.getBrasao()) + ")";
    }
}

