/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.outboxdataintegration.consumer;

import br.com.elotech.outbox.consumer.BaseConsumer;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.domain.OutboxEvent;
import br.com.elotech.outbox.hook.OutBoxBeforeProcessHook;
import br.com.elotech.protocolo.domain.ORCUnidade;
import br.com.elotech.protocolo.outboxdataintegration.payload.ORCUnidadePayload;
import br.com.elotech.protocolo.repository.ORCUnidadeRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;

@RabbitListener(bindings={@QueueBinding(value=@Queue(value="ORCAMENTO_UNIDADE_QUEUE_PROTOCOLO"), exchange=@Exchange(value="ORCAMENTO_UNIDADE", type="topic"), key={""})}, errorHandler="ORCUnidadeErrorHandler")
public class ORCUnidadeConsumer
extends BaseConsumer<ORCUnidadePayload> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ORCUnidadeConsumer.class);
    private ORCUnidadeRepository unidadeRepository;

    public ORCUnidadeConsumer(List<OutBoxBeforeProcessHook> beforeHooks, ObjectMapper objectMapper, ORCUnidadeRepository unidadeRepository) {
        super(beforeHooks, objectMapper);
        this.unidadeRepository = unidadeRepository;
    }

    public void process(OutboxEvent outboxEvent, ORCUnidadePayload payload) {
        log.info("Iniciando consumo da entidade {} {}", (Object)outboxEvent.getAggregateType(), (Object)payload);
        if (OutboxActions.DELETED.equals((Object)outboxEvent.getAction())) {
            this.unidadeRepository.deleteById((Object)payload.getId());
            log.info("Entidade {} {} deletada", (Object)outboxEvent.getAggregateType(), (Object)payload);
            return;
        }
        ORCUnidade entity = new ORCUnidade(payload.getId());
        Optional optEntity = this.unidadeRepository.findById((Object)payload.getId());
        if (optEntity.isPresent()) {
            entity = (ORCUnidade)optEntity.get();
        }
        entity.setCodigo(payload.getCodigo());
        entity.setDescricao(payload.getDescricao());
        entity.setUnidadeComposta(payload.getUnidadeComposta());
        if (Objects.nonNull(payload.getUnidadeSuperior())) {
            entity.setUnidadeSuperiorId(payload.getUnidadeSuperior().getId());
        }
        if (Objects.nonNull(payload.getEntidade())) {
            entity.setEntidadeId(payload.getEntidade().getId());
        }
        this.unidadeRepository.saveAndFlush((Object)entity);
        log.info("Finalizando consumo da entidade {} {}", (Object)outboxEvent.getAggregateType(), (Object)payload);
    }
}

