/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.outboxdataintegration.consumer;

import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.outbox.consumer.BaseConsumer;
import br.com.elotech.outbox.domain.OutboxEvent;
import br.com.elotech.outbox.hook.OutBoxBeforeProcessHook;
import br.com.elotech.protocolo.dto.LoteProcessamentoAssinaturaDTO;
import br.com.elotech.protocolo.service.assinatura.AssinaturaProcessaLoteThreadService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;

@RabbitListener(bindings={@QueueBinding(key={""}, value=@Queue(value="OXY_PROTOCOLO_LOTE_ASSINATURA"), exchange=@Exchange(value="OXY_PROTOCOLO_LOTE_ASSINATURA_TOPIC", type="topic"))}, errorHandler="LoteProcessamentoAssinaturaErrorHandler")
public class LoteProcessamentoAssinaturaConsumer
extends BaseConsumer<LoteProcessamentoAssinaturaDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoteProcessamentoAssinaturaConsumer.class);
    private final AssinaturaProcessaLoteThreadService assinaturaProcessaLoteThreadService;

    public LoteProcessamentoAssinaturaConsumer(List<OutBoxBeforeProcessHook> beforeHooks, ObjectMapper objectMapper, AssinaturaProcessaLoteThreadService assinaturaProcessaLoteThreadService) {
        super(beforeHooks, objectMapper);
        this.assinaturaProcessaLoteThreadService = assinaturaProcessaLoteThreadService;
    }

    public void process(OutboxEvent outboxEvent, LoteProcessamentoAssinaturaDTO payload) {
        ContextHolder.setKeyValue((String)"ENTIDADE", (String)payload.getEntidade().toString());
        log.info("Iniciando consumo do Lote de Assinaturas \n idProcessamento:{} \n entidade: {}  \n payload: {} ", new Object[]{payload.getId(), payload.getTenant(), payload});
        this.assinaturaProcessaLoteThreadService.processarAssinaturaLote(payload);
        log.info("Finalizado consumo do Lote de Assinaturas \n idProcessamento:{} \n entidade: {}", (Object)payload.getId(), (Object)outboxEvent.getKey());
        ContextHolder.clear();
    }
}

