/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.monitoring;

import br.com.elotech.logging.mdc.LogFieldsCustomizer;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.repository.EntidadeRepository;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFieldsConfigurer
implements LogFieldsCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingFieldsConfigurer.class);
    private final EntidadeRepository entidadeRepository;

    public LoggingFieldsConfigurer(EntidadeRepository entidadeRepository) {
        this.entidadeRepository = entidadeRepository;
    }

    public void customize(Map<String, String> fields) {
        log.info("Configurando o nome da entidade para o logger");
        Entidade entidadePrincipal = this.entidadeRepository.findEntidadePrincipal();
        if (Objects.nonNull(entidadePrincipal)) {
            log.info("Adicionando entidade [{}] no logger e cnpj [{}] ", (Object)entidadePrincipal.getNome(), (Object)entidadePrincipal.getCnpj());
            fields.put("entidade", entidadePrincipal.getNome());
            fields.put("entidadeCnpj", entidadePrincipal.getCnpj());
        } else {
            log.warn("A entidade principal n\u00e3o est\u00e1 configurada. N\u00e3o ser\u00e1 poss\u00edvel filtrar pelos campos entidade e entidadeCnpj nos logs :/");
        }
    }
}

