/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.senders.impl;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.domain.HistoricoTramiteEmail;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.TramitePK;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.enums.TipoEnvioEmailEnum;
import br.com.elotech.protocolo.mail.processors.TramitacaoContentProcessor;
import br.com.elotech.protocolo.mail.senders.EntityEmailSender;
import br.com.elotech.protocolo.service.HistoricoEnvioEmailService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TramiteEmailSender
extends EntityEmailSender<HistoricoTramiteEmail, TramitePK> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TramiteEmailSender.class);
    private final TramitacaoContentProcessor tramitacaoContentProcessor;

    public TramiteEmailSender(MailService mailService, TramitacaoContentProcessor tramitacaoContentProcessor, ParametroService parametroService, ProtocoloProperties emailProperties, UsuarioService usuarioService, HistoricoEnvioEmailService<HistoricoTramiteEmail, TramitePK> historicoEnvioEmailService) {
        super(mailService, parametroService, emailProperties, usuarioService, historicoEnvioEmailService);
        this.tramitacaoContentProcessor = tramitacaoContentProcessor;
    }

    public void enviarEmailTramite(Tramite tramite) {
        if (!this.validaConfiguracaoEmail()) {
            return;
        }
        String emailRemetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
        String assunto = String.format("%s (%s)", this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_ASSUNTO_PADRAO.getCodigo()), tramite.getId().getProcesso().getIdentificacaoProcesso());
        boolean deveAvisarRequerente = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.AVISA_REQUERENTE_POR_EMAIL.getCodigo()));
        boolean deveAvisarLocal = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.AVISA_LOCAL_POR_EMAIL.getCodigo()));
        boolean deveAvisarUsuariosDoLocal = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.AVISA_USUARIOS_LOCAL_POR_EMAIL.getCodigo()));
        boolean deveAvisarSomenteUsuarioEncaminhamentoSeEspecificado = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.AVISA_SOMENTE_USUARIO_ENCAMINHAMENTO_ESPECIFICADO.getCodigo()));
        String content = this.tramitacaoContentProcessor.process(tramite);
        if (deveAvisarRequerente) {
            this.enviarEmailRequerente(tramite.getId().getProcesso(), emailRemetente, assunto, content, TipoEnvioEmailEnum.TRAMITE_REQUERENTE, (DomainEntity)tramite);
        } else {
            log.warn("Requerente n\u00e3o est\u00e1 parametrizado para envio de email ao tramitar.");
        }
        Boolean possuiEmailUsuarioEncaminhamento = Optional.ofNullable(tramite.getUsuarioResponsavelTramite()).map(Usuario::possuiEmail).orElse(false);
        if (deveAvisarSomenteUsuarioEncaminhamentoSeEspecificado && possuiEmailUsuarioEncaminhamento.booleanValue()) {
            this.enviarEmailUsuario(tramite.getUsuarioResponsavelTramite(), emailRemetente, assunto, content, TipoEnvioEmailEnum.TRAMITE_USUARIO_ENCAMINHAMENTO, (DomainEntity)tramite);
            return;
        }
        log.warn("Usu\u00e1rio encaminhamento n\u00e3o est\u00e1 parametrizado para envio de email ao tramitar.");
        if (deveAvisarLocal) {
            this.enviarEmailLocal(tramite.getLocal(), emailRemetente, assunto, content, TipoEnvioEmailEnum.TRAMITE_LOCAL, (DomainEntity)tramite);
        } else {
            log.warn("Local n\u00e3o est\u00e1 parametrizado para envio de email ao tramitar.");
        }
        if (deveAvisarUsuariosDoLocal) {
            this.avisaUsuariosDoLocal(tramite.getLocal(), emailRemetente, assunto, content, TipoEnvioEmailEnum.TRAMITE_RESPONSAVEL_LOCAL, (DomainEntity)tramite);
        } else {
            log.warn("Usu\u00e1rios do Local n\u00e3o est\u00e1 parametrizado para envio de email ao tramitar.");
        }
    }
}

