/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.senders.impl;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.domain.Contato;
import br.com.elotech.protocolo.domain.EmailInfo;
import br.com.elotech.protocolo.domain.HistoricoProcessoEmail;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.enums.TipoEnvioEmailEnum;
import br.com.elotech.protocolo.mail.processors.ListaProcessoContentProcessor;
import br.com.elotech.protocolo.mail.processors.ProcessoContentProcessor;
import br.com.elotech.protocolo.mail.senders.EntityEmailSender;
import br.com.elotech.protocolo.service.HistoricoEnvioEmailService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessoEmailSender
extends EntityEmailSender<HistoricoProcessoEmail, ProcessoPK> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoEmailSender.class);
    private final ListaProcessoContentProcessor listaProcessoContentProcessor;
    private final ProcessoContentProcessor processoContentProcessor;

    public ProcessoEmailSender(MailService mailService, ParametroService parametroService, ProtocoloProperties emailProperties, UsuarioService usuarioService, HistoricoEnvioEmailService<HistoricoProcessoEmail, ProcessoPK> historicoEnvioEmailService, ListaProcessoContentProcessor listaProcessoContentProcessor, ProcessoContentProcessor processoContentProcessor) {
        super(mailService, parametroService, emailProperties, usuarioService, historicoEnvioEmailService);
        this.listaProcessoContentProcessor = listaProcessoContentProcessor;
        this.processoContentProcessor = processoContentProcessor;
    }

    public void enviarListaProcessoPorEmail(List<Processo> processos) {
        if (!this.validaConfiguracaoEmail()) {
            throw new EloValidationException("Configura\u00e7\u00f5es de email inv\u00e1lida. Provavelmente n\u00e3o foram configurados os par\u00e2metros de smtp, porta, usuario e senha.");
        }
        String remetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
        Pessoa pessoa = processos.get(0).getPessoa();
        String emailRequerente = Optional.ofNullable(pessoa.getContato()).orElse(new Contato()).getEmail();
        if (emailRequerente.isEmpty()) {
            throw new EloValidationException("Pessoa sem e-mail configurado.");
        }
        String content = this.listaProcessoContentProcessor.process(processos);
        boolean sucessoEnvioEmail = this.enviarEmail(this.buildMailParams(emailRequerente, remetente, "Listagem de processos do requerente", content));
        if (sucessoEnvioEmail) {
            List historicoProcessoEmailList = processos.stream().map(processo -> (HistoricoProcessoEmail)this.historicoEnvioEmailService.createHistorico((DomainEntity)processo, TipoEnvioEmailEnum.LISTA_PROCESSOS_PESSOA, new EmailInfo(remetente, emailRequerente, "Listagem de processos do requerente", content), pessoa)).collect(Collectors.toList());
            this.historicoEnvioEmailService.saveAll(historicoProcessoEmailList);
        }
    }

    public void enviarEmailProcessosAtrasados(List<Processo> processos) {
        if (!this.validaConfiguracaoEmail()) {
            return;
        }
        boolean enviaEmailRequerente = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.AVISA_POR_EMAIL_REQUERENTE_PROCESSO_ATRASO.getCodigo()));
        boolean enviaEmailResponsaveisLocal = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.AVISA_POR_EMAIL_RESPONSAVEIS_LOCAL_PROCESSO_ATRASO.getCodigo()));
        boolean enviaEmailLocal = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.AVISA_POR_EMAIL_LOCAL_PROCESSO_ATRASO.getCodigo()));
        String emailRemetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
        if (!enviaEmailRequerente) {
            log.warn("O envio de emails para processos em atraso para o requerente est\u00e1 desabilitado.");
        }
        if (!enviaEmailResponsaveisLocal) {
            log.warn("O envio de emails para processos em atraso para os respons\u00e1veis do local est\u00e1 desabilitado.");
        }
        if (!enviaEmailLocal) {
            log.warn("O envio de emails para processos em atraso para o local est\u00e1 desabilitado.");
        }
        if (!(enviaEmailRequerente || enviaEmailResponsaveisLocal || enviaEmailLocal)) {
            return;
        }
        processos.forEach(processo -> {
            String assunto = String.format("%s em atraso", processo.getIdentificacaoProcesso());
            String content = this.processoContentProcessor.process(processo);
            if (enviaEmailRequerente) {
                this.enviarEmailRequerente(processo, emailRemetente, assunto, content, TipoEnvioEmailEnum.PROCESSO_EM_ATRASO_REQUERENTE, (DomainEntity)processo);
            }
            if (enviaEmailLocal) {
                this.enviarEmailLocal(processo.getLocalAtual(), emailRemetente, assunto, content, TipoEnvioEmailEnum.PROCESSO_EM_ATRASO_LOCAL, (DomainEntity)processo);
            }
            if (enviaEmailResponsaveisLocal) {
                this.avisaUsuariosDoLocal(processo.getLocalAtual(), emailRemetente, assunto, content, TipoEnvioEmailEnum.PROCESSO_EM_ATRASO_RESPONSAVEL_LOCAL, (DomainEntity)processo);
            }
        });
    }
}

