/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.senders.impl;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.domain.EmailInfo;
import br.com.elotech.protocolo.domain.HistoricoEnvioEmailEntity;
import br.com.elotech.protocolo.domain.HistoricoProcessoArquivoEmail;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoPK;
import br.com.elotech.protocolo.enums.TipoEnvioEmailEnum;
import br.com.elotech.protocolo.mail.processors.ArquivoContentProcessor;
import br.com.elotech.protocolo.mail.senders.EntityEmailSender;
import br.com.elotech.protocolo.service.HistoricoEnvioEmailService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import com.google.common.base.Strings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessoArquivoEmailSender
extends EntityEmailSender<HistoricoProcessoArquivoEmail, ProcessoArquivoPK> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoArquivoEmailSender.class);
    private final ArquivoContentProcessor arquivoContentProcessor;
    private static final String ASSUNTO_ARQUIVO_RECUSADO = "Processo %d/%d - Arquivo recusado: %s";

    public ProcessoArquivoEmailSender(MailService mailService, ParametroService parametroService, ProtocoloProperties emailProperties, UsuarioService usuarioService, HistoricoEnvioEmailService<HistoricoProcessoArquivoEmail, ProcessoArquivoPK> historicoEnvioEmailService, ArquivoContentProcessor arquivoContentProcessor) {
        super(mailService, parametroService, emailProperties, usuarioService, historicoEnvioEmailService);
        this.arquivoContentProcessor = arquivoContentProcessor;
    }

    public void enviarEmailArquivoRecusado(ProcessoArquivo arquivo) {
        if (!this.validaConfiguracaoEmail()) {
            return;
        }
        if (!this.parametroService.getParamValueAsBoolean(ParametroEnum.ENVIA_EMAIL_REQUERENTE_ARQUIVO_RECUSADO.getCodigo()).booleanValue()) {
            log.warn("Email para arquivo recusado n\u00e3o ser\u00e1 enviado pois o par\u00e2metro est\u00e1 desabilitado");
            return;
        }
        Processo processo = arquivo.getId().getProcesso();
        if (Boolean.FALSE.equals(processo.possuiContato())) {
            log.warn("O email do requerente n\u00e3o est\u00e1 presente.");
            return;
        }
        String emailContato = processo.getPessoa().getContato().getEmail();
        if (Strings.isNullOrEmpty((String)emailContato)) {
            log.warn("O email do requerente n\u00e3o est\u00e1 presente.");
            return;
        }
        String emailRemetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
        String assunto = String.format(ASSUNTO_ARQUIVO_RECUSADO, processo.getId().getNumero(), processo.getId().getAno(), arquivo.getNome());
        String content = this.arquivoContentProcessor.process(arquivo);
        MailParams mailParams = MailParams.builder().encoding(this.emailProperties.getMail().getEncoding()).to(emailContato).from(emailRemetente).subject(assunto).html(true).multipart(false).content(content).build();
        boolean sucessoEnvioEmail = this.enviarEmail(mailParams);
        if (sucessoEnvioEmail) {
            this.historicoEnvioEmailService.save((HistoricoEnvioEmailEntity)((HistoricoProcessoArquivoEmail)this.historicoEnvioEmailService.createHistorico((DomainEntity)arquivo, TipoEnvioEmailEnum.ARQUIVO_PROCESSO_RECUSADO, new EmailInfo(emailRemetente, emailContato, assunto, content))));
        }
    }
}

