/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.senders.impl;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.domain.EmailInfo;
import br.com.elotech.protocolo.domain.HistoricoEnvioEmailEntity;
import br.com.elotech.protocolo.domain.HistoricoProcessoArquivoAssinaturaEmail;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.enums.TipoEnvioEmailEnum;
import br.com.elotech.protocolo.mail.processors.ProcessoArquivoAssinaturaContentProcessor;
import br.com.elotech.protocolo.mail.senders.EntityEmailSender;
import br.com.elotech.protocolo.service.HistoricoEnvioEmailService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessoArquivoAssinaturaEmailSender
extends EntityEmailSender<HistoricoProcessoArquivoAssinaturaEmail, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoArquivoAssinaturaEmailSender.class);
    private static final String ASSUNTO = "Processo %d/%d. Solicita\u00e7\u00e3o de Assinatura no arquivo %s.";
    private final ProcessoArquivoAssinaturaContentProcessor contentProcessor;

    public ProcessoArquivoAssinaturaEmailSender(MailService mailService, ProtocoloProperties emailProperties, ParametroService parametroService, UsuarioService usuarioService, HistoricoEnvioEmailService<HistoricoProcessoArquivoAssinaturaEmail, Long> historicoEnvioEmailService, ProcessoArquivoAssinaturaContentProcessor contentProcessor) {
        super(mailService, parametroService, emailProperties, usuarioService, historicoEnvioEmailService);
        this.contentProcessor = contentProcessor;
    }

    public void enviarEmailSolicitandoAssinatura(ProcessoArquivoAssinatura processoArquivoAssinatura) {
        if (!this.validaConfiguracaoEmail()) {
            return;
        }
        boolean deveEnviarEmail = this.parametroService.getParamValueAsBoolean(ParametroEnum.ENVIA_EMAIL_SOLICITACAO_ASSINATURA.getCodigo());
        String emailRemetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
        Usuario usuario = processoArquivoAssinatura.getUsuario();
        String emailUsuario = usuario.getEmail();
        if (!deveEnviarEmail) {
            log.debug("N\u00e3o foi poss\u00edvel notificar o assinante solicitado por email. O Par\u00e2metro est\u00e1 desabilitado.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)emailRemetente)) {
            log.debug("N\u00e3o foi poss\u00edvel notificar o assinante solicitado por email. O email do remetente padr\u00e3o n\u00e3o foi informado.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)emailUsuario)) {
            log.debug("N\u00e3o foi poss\u00edvel notificar o assinante solicitado por email. O email do usu\u00e1rio {} est\u00e1 inv\u00e1lido.", (Object)usuario.getNome());
            return;
        }
        String assunto = String.format(ASSUNTO, processoArquivoAssinatura.getNumeroProcesso(), processoArquivoAssinatura.getAnoProcesso(), processoArquivoAssinatura.getArquivo().getNome());
        String content = this.contentProcessor.process(processoArquivoAssinatura);
        MailParams mailParams = MailParams.builder().encoding(this.emailProperties.getMail().getEncoding()).to(processoArquivoAssinatura.getUsuario().getEmail()).from(emailRemetente).subject(assunto).html(true).multipart(false).content(content).build();
        boolean sucessoEnvioEmail = this.enviarEmail(mailParams);
        if (sucessoEnvioEmail) {
            EmailInfo emailInfo = new EmailInfo(emailRemetente, emailUsuario, assunto, content);
            this.historicoEnvioEmailService.save((HistoricoEnvioEmailEntity)((HistoricoProcessoArquivoAssinaturaEmail)this.historicoEnvioEmailService.createHistorico((DomainEntity)processoArquivoAssinatura, TipoEnvioEmailEnum.PROCESSO_SOLICITACAO_ASSINATURA, emailInfo, usuario)));
        }
    }
}

