/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.senders.impl;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.domain.HistoricoProcessoAndamentoEmail;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.enums.TipoEnvioEmailEnum;
import br.com.elotech.protocolo.mail.processors.ProcessoAndamentoContentProcessor;
import br.com.elotech.protocolo.mail.senders.EntityEmailSender;
import br.com.elotech.protocolo.service.HistoricoEnvioEmailService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessoAndamentoEmailSender
extends EntityEmailSender<HistoricoProcessoAndamentoEmail, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoAndamentoEmailSender.class);
    private static final String ASSUNTO = "Novo andamento para o processo %d/%d - tipo %s.";
    private final ProcessoAndamentoContentProcessor contentProcessor;

    public ProcessoAndamentoEmailSender(MailService mailService, ProtocoloProperties emailProperties, ParametroService parametroService, UsuarioService usuarioService, HistoricoEnvioEmailService<HistoricoProcessoAndamentoEmail, Long> historicoEnvioEmailService, ProcessoAndamentoContentProcessor contentProcessor) {
        super(mailService, parametroService, emailProperties, usuarioService, historicoEnvioEmailService);
        this.contentProcessor = contentProcessor;
    }

    public void enviarEmailSolicitacaoRemetente(ProcessoAndamento processoAndamento) {
        if (!this.validaConfiguracaoEmail()) {
            return;
        }
        Processo processo = processoAndamento.getProcesso();
        String emailRemetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
        String assunto = String.format(ASSUNTO, processo.getId().getNumero(), processo.getId().getAno(), processo.getId().getTipo().getDescricao());
        String content = this.contentProcessor.process(processoAndamento);
        this.enviarEmailRequerente(processo, emailRemetente, assunto, content, TipoEnvioEmailEnum.PROCESSO_ANDAMENTO_SOLICITACAO_REQUERENTE, (DomainEntity)processoAndamento);
    }
}

