/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.senders;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.common.dto.MailResultInfo;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.domain.EmailInfo;
import br.com.elotech.protocolo.domain.HistoricoEnvioEmailEntity;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.enums.TipoEnvioEmailEnum;
import br.com.elotech.protocolo.mail.exception.SendMailException;
import br.com.elotech.protocolo.mail.utils.ConfiguracaoEmailUtils;
import br.com.elotech.protocolo.service.HistoricoEnvioEmailService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityEmailSender<T extends HistoricoEnvioEmailEntity<E>, E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityEmailSender.class);
    private final MailService mailService;
    protected final ParametroService parametroService;
    protected final ProtocoloProperties emailProperties;
    protected final UsuarioService usuarioService;
    protected final HistoricoEnvioEmailService<T, E> historicoEnvioEmailService;
    public static final long TIMEOUT_ENVIO_EMAIL = 1L;
    protected static final String ASSUNTO_PADRAO = "Listagem de processos do requerente";

    public EntityEmailSender(MailService mailService, ParametroService parametroService, ProtocoloProperties emailProperties, UsuarioService usuarioService, HistoricoEnvioEmailService<T, E> historicoEnvioEmailService) {
        this.mailService = mailService;
        this.parametroService = parametroService;
        this.emailProperties = emailProperties;
        this.usuarioService = usuarioService;
        this.historicoEnvioEmailService = historicoEnvioEmailService;
    }

    protected boolean validaConfiguracaoEmail() {
        if (!ConfiguracaoEmailUtils.isEmailConfigurado((ParametroService)this.parametroService)) {
            log.warn("Configura\u00e7\u00e3o de e-mail vazia, n\u00e3o ser\u00e1 poss\u00edvel enviar emails.");
            return false;
        }
        return true;
    }

    protected MailParams buildMailParams(String to, String from, String subject, String content) {
        return MailParams.builder().encoding(this.emailProperties.getMail().getEncoding()).to(to).from(from).subject(subject).html(true).multipart(false).content(content).build();
    }

    protected boolean enviarEmail(MailParams mailParams) {
        try {
            MailResultInfo resultadoEnvio = (MailResultInfo)this.mailService.sendEmail(mailParams).get(1L, TimeUnit.MINUTES);
            StringBuilder resultadoString = new StringBuilder(String.format("%s ao enviar email. ", resultadoEnvio.isSuccess() ? "Sucesso" : "Falha"));
            if (!resultadoEnvio.isSuccess()) {
                resultadoString.append(String.format("Causa: %s %n Destinat\u00e1rios: %s", resultadoEnvio.getMessage(), resultadoEnvio.getTo()));
            }
            log.info(resultadoString.toString());
            return resultadoEnvio.isSuccess();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new SendMailException(mailParams, (Throwable)e);
        }
    }

    protected void enviarEmailRequerente(Processo processo, String emailRemetente, String assunto, String content, TipoEnvioEmailEnum tipoEnvio, DomainEntity<E> domainEntity) {
        if (!processo.possuiContato().booleanValue()) {
            log.warn("Processo [{}] n\u00e3o possui contato", (Object)processo.getId().toString());
            return;
        }
        if (!processo.getPessoa().hasContatoEmail().booleanValue()) {
            log.warn("Requerente [{}] - [{}] n\u00e3o possui e-mail.", (Object)processo.getPessoa().getId(), (Object)processo.getPessoa().getNome());
            return;
        }
        String emailRequerente = processo.getPessoa().getContato().getEmail().trim();
        if (this.historicoEnvioEmailService.existeAvisoEmailPessoa(domainEntity.getId(), tipoEnvio, processo.getPessoa())) {
            log.warn("Email para o requerente [{}] - [{}] j\u00e1 foi enviado.", (Object)processo.getPessoa().getId(), (Object)processo.getPessoa().getNome());
            return;
        }
        boolean sucessoEnvioEmail = this.enviarEmail(this.buildMailParams(emailRequerente, emailRemetente, assunto, content));
        if (sucessoEnvioEmail) {
            EmailInfo emailInfo = new EmailInfo(emailRemetente, emailRequerente, assunto, content);
            this.historicoEnvioEmailService.save(this.historicoEnvioEmailService.createHistorico(domainEntity, tipoEnvio, emailInfo, processo.getPessoa()));
        }
    }

    protected void avisaUsuariosDoLocal(Local local, String emailRemetente, String assunto, String content, TipoEnvioEmailEnum tipoEnvio, DomainEntity<E> domainEntity) {
        StringJoiner emailsUsuarios = new StringJoiner(",");
        List<UsuarioLocal> usuariosLocal = this.usuarioService.getUsuarioLocalByLocal(local).stream().filter(ul -> ul.getId().getUsuario().possuiEmail()).filter(ul -> !this.historicoEnvioEmailService.existeAvisoEmailUsuario(domainEntity.getId(), tipoEnvio, ul.getId().getUsuario())).collect(Collectors.toList());
        usuariosLocal.forEach(ul -> emailsUsuarios.add(ul.getId().getUsuario().getEmail()));
        if (emailsUsuarios.toString().isEmpty()) {
            log.warn("Nenhum usuario do local [{}] - [{}] possui email.", (Object)local.getId(), (Object)local.getDescricao());
            return;
        }
        boolean sucessoEnvioEmail = this.enviarEmail(this.buildMailParams(emailsUsuarios.toString(), emailRemetente, assunto, content));
        if (sucessoEnvioEmail) {
            List historicoEnvioList = usuariosLocal.stream().map(ul -> this.historicoEnvioEmailService.createHistorico(domainEntity, tipoEnvio, new EmailInfo(emailRemetente, ul.getId().getUsuario().getEmail(), assunto, content), ul.getId().getUsuario())).collect(Collectors.toList());
            this.historicoEnvioEmailService.saveAll(historicoEnvioList);
        }
    }

    protected void enviarEmailLocal(Local local, String emailRemetente, String assunto, String content, TipoEnvioEmailEnum tipoEnvio, DomainEntity<E> domainEntity) {
        if (Boolean.FALSE.equals(local.possuiEmailPreenchido())) {
            log.warn("O local [{}] - [{}] n\u00e3o possui email.", (Object)local.getId().getId(), (Object)local.getDescricao());
            return;
        }
        if (this.historicoEnvioEmailService.existeAvisoEmail(domainEntity.getId(), tipoEnvio)) {
            log.warn("Email para o local [{}] - [{}] j\u00e1 foi enviado.", (Object)local.getId().getId(), (Object)local.getDescricao());
            return;
        }
        boolean sucessoEnvioEmail = this.enviarEmail(this.buildMailParams(local.getEmail(), emailRemetente, assunto, content));
        if (sucessoEnvioEmail) {
            this.historicoEnvioEmailService.save(this.historicoEnvioEmailService.createHistorico(domainEntity, tipoEnvio, new EmailInfo(emailRemetente, local.getEmail(), assunto, content)));
        }
    }

    protected void enviarEmailUsuario(Usuario usuario, String emailRemetente, String assunto, String content, TipoEnvioEmailEnum tipoEnvio, DomainEntity<E> domainEntity) {
        if (!usuario.possuiEmail().booleanValue()) {
            log.warn("Usu\u00e1rio [{}] - [{}] n\u00e3o possui email", (Object)usuario.getId(), (Object)usuario.getNome());
            return;
        }
        if (this.historicoEnvioEmailService.existeAvisoEmailUsuario(domainEntity.getId(), tipoEnvio, usuario)) {
            log.warn("Email para o usuario [{}] - [{}] j\u00e1 foi enviado.", (Object)usuario.getId(), (Object)usuario.getNome());
            return;
        }
        String emailDestinatario = usuario.getEmail();
        boolean sucessoEnvioEmail = this.enviarEmail(this.buildMailParams(emailDestinatario, emailRemetente, assunto, content));
        if (sucessoEnvioEmail) {
            this.historicoEnvioEmailService.save(this.historicoEnvioEmailService.createHistorico(domainEntity, tipoEnvio, new EmailInfo(emailRemetente, emailDestinatario, assunto, content)));
        }
    }
}

