/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.processors;

import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.service.ParametroService;
import java.util.Locale;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Component
public class TramitacaoContentProcessor {
    private final SpringTemplateEngine templateEngine;
    private final ParametroService parametroService;

    public TramitacaoContentProcessor(SpringTemplateEngine templateEngine, ParametroService parametroService) {
        this.templateEngine = templateEngine;
        this.parametroService = parametroService;
    }

    public String process(Tramite tramite) {
        Context context = new Context(Locale.getDefault());
        ProcessoPK idProcesso = tramite.getId().getProcesso().getId();
        String linkCidadao = this.parametroService.getParamValueAsString(ParametroEnum.URL_OXY_CIDADAO.getCodigo());
        String mensagemAvisoInicial = this.parametroService.getParamValueAsString(ParametroEnum.MENSAGEM_AVISO_INICIAL.getCodigo());
        String mensagemAvisoFinal = this.parametroService.getParamValueAsString(ParametroEnum.MENSAGEM_AVISO_FINAL.getCodigo());
        context.setVariable("tramite", (Object)tramite);
        context.setVariable("mensagemAvisoInicial", (Object)mensagemAvisoInicial);
        context.setVariable("mensagemAvisoFinal", (Object)mensagemAvisoFinal);
        if (!StringUtils.isEmpty((Object)linkCidadao) && Funcao.ARQUIVADO.equals((Object)tramite.getFuncao())) {
            context.setVariable("linkCidadao", (Object)String.format("%s/processos/tipo=%s&numero=%s&ano=%s&entidade=%s/avaliar", linkCidadao, idProcesso.getTipo().getId(), idProcesso.getNumero(), idProcesso.getAno(), idProcesso.getEntidade().getId()));
        }
        return this.templateEngine.process("emailTramitacao", (IContext)context);
    }
}

