/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.processors;

import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.service.ParametroService;
import java.util.Locale;
import org.springframework.stereotype.Component;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Component
public class ProcessoContentProcessor {
    private final SpringTemplateEngine templateEngine;
    private final ParametroService parametroService;

    public ProcessoContentProcessor(SpringTemplateEngine templateEngine, ParametroService parametroService) {
        this.templateEngine = templateEngine;
        this.parametroService = parametroService;
    }

    public String process(Processo processo) {
        Context context = new Context(Locale.getDefault());
        String linkCidadao = this.parametroService.getParamValueAsString(ParametroEnum.URL_OXY_CIDADAO.getCodigo());
        context.setVariable("processo", (Object)processo);
        if (!linkCidadao.isEmpty()) {
            context.setVariable("linkCidadao", (Object)String.format("%s/processos/tipo=%s&numero=%s&ano=%s&entidade=%s/resumo", linkCidadao, processo.getId().getTipo().getId(), processo.getId().getNumero(), processo.getId().getAno(), processo.getId().getEntidade().getId()));
        }
        return this.templateEngine.process("emailProcessoEmAtraso", (IContext)context);
    }
}

