/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.processors;

import br.com.elotech.adm.utils.URLDomainUtils;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Component
public class ProcessoArquivoAssinaturaContentProcessor {
    private final Environment environment;
    private final SpringTemplateEngine templateEngine;
    @Value(value="${multitenant.enabled:false}")
    private final Boolean multitenant = false;

    public ProcessoArquivoAssinaturaContentProcessor(Environment environment, SpringTemplateEngine templateEngine) {
        this.environment = environment;
        this.templateEngine = templateEngine;
    }

    public String process(ProcessoArquivoAssinatura processoArquivoAssinatura) {
        Context context = new Context(Locale.getDefault());
        context.setVariable("nomeUsuario", (Object)processoArquivoAssinatura.getUsuario().getNome());
        context.setVariable("numeroProcesso", (Object)processoArquivoAssinatura.getNumeroProcesso());
        context.setVariable("anoProcesso", (Object)processoArquivoAssinatura.getAnoProcesso());
        context.setVariable("nomeArquivo", (Object)processoArquivoAssinatura.getNome());
        context.setVariable("linkProcesso", (Object)this.getLinkProcesso(processoArquivoAssinatura));
        return this.templateEngine.process("emailSolicitacaoAssinatura", (IContext)context);
    }

    private String getLinkProcesso(ProcessoArquivoAssinatura processoArquivoAssinatura) {
        if (this.multitenant.booleanValue()) {
            URLDomainUtils urlDomainUtils = new URLDomainUtils(this.environment);
            String path = "/protocolo/processos-novo/view/".concat(processoArquivoAssinatura.getIdProcesso());
            return urlDomainUtils.getDomainUrlByTenantWithPath(TenantContextHolder.getCurrentTenantId(), path);
        }
        return null;
    }
}

