/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.mail.processors;

import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.service.ParametroService;
import java.util.Locale;
import org.springframework.stereotype.Component;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Component
public class ProcessoAndamentoContentProcessor {
    private final SpringTemplateEngine templateEngine;
    private final ParametroService parametroService;

    public ProcessoAndamentoContentProcessor(SpringTemplateEngine templateEngine, ParametroService parametroService) {
        this.templateEngine = templateEngine;
        this.parametroService = parametroService;
    }

    public String process(ProcessoAndamento processoAndamento) {
        Context context = new Context(Locale.getDefault());
        String linkCidadao = this.parametroService.getParamValueAsString(ParametroEnum.URL_OXY_CIDADAO.getCodigo());
        context.setVariable("processoAndamento", (Object)processoAndamento);
        context.setVariable("processo", (Object)processoAndamento.getProcesso());
        if (!linkCidadao.isEmpty()) {
            context.setVariable("linkCidadao", (Object)String.format("%s/processos/tipo=%s&numero=%s&ano=%s&entidade=%s/resumo", linkCidadao, processoAndamento.getProcesso().getId().getTipo().getId(), processoAndamento.getProcesso().getId().getNumero(), processoAndamento.getProcesso().getId().getAno(), processoAndamento.getProcesso().getId().getEntidade().getId()));
        }
        return this.templateEngine.process("emailProcessoAndamento", (IContext)context);
    }
}

