/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.license.management;

import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.license_management.context.LicenseContext;
import br.com.elotech.license_management.context.LicenseContextValues;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.UsuarioEntidade;
import br.com.elotech.protocolo.domain.UsuarioEntidadePK;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.io.Serializable;
import java.security.Principal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class LicenseContextProtocolo
implements LicenseContext {
    private static final String USUARIO_ANONIMO = "anonymousUser";
    private final EntidadeService entidadeService;
    private final UsuarioService usuarioService;

    public LicenseContextProtocolo(EntidadeService entidadeService, UsuarioService usuarioService) {
        this.entidadeService = entidadeService;
        this.usuarioService = usuarioService;
    }

    public LicenseContextValues getLicenseContextValues() {
        long headerValueEntidade = ContextHolder.getHeaderValueEntidade().intValue();
        if (headerValueEntidade <= 0L) {
            return LicenseContextValues.builder().isExcludeAll(true).build();
        }
        String username = Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Principal::getName).orElse(USUARIO_ANONIMO);
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)Long.valueOf(headerValueEntidade));
        if (Objects.isNull(entidade)) {
            throw new RegistroNaoEncontradoException(String.format("A entidade %d n\u00e3o foi encontrada", headerValueEntidade));
        }
        if (!USUARIO_ANONIMO.equals(username)) {
            List entidades = this.usuarioService.findEntidadesByUsername(username);
            if (entidades.stream().map(UsuarioEntidade::getId).map(UsuarioEntidadePK::getEntidade).noneMatch(arg_0 -> ((Entidade)entidade).equals(arg_0))) {
                throw new BadCredentialsException("O usu\u00e1rio logado n\u00e3o possui acesso a entidade logada");
            }
        }
        LicenseContextValues contextValues = new LicenseContextValues();
        contextValues.setNomeEntidade(entidade.getNome());
        contextValues.setCodigoModulo("4");
        contextValues.setData(LocalDate.now());
        contextValues.getUrlExclusions().add("/api/userinfo");
        contextValues.getUrlExclusions().add("/api/info");
        contextValues.getUrlExclusions().add("/api/entidades");
        contextValues.getUrlExclusions().add("/api/tiposprocesso");
        contextValues.getUrlExclusions().add("/api/consultaprocesso");
        contextValues.getUrlExclusions().add("/api/actuator/info");
        contextValues.getUrlExclusions().add("/api/actuator/prometheus");
        contextValues.getUrlExclusions().add("/api/actuator/health");
        return contextValues;
    }
}

