/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.interceptor;

import br.com.elotech.protocolo.security.AuthenticationClientUnico;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class UnicoAuthenticationInterceptorRequestInterceptor
implements RequestInterceptor {
    private final AuthenticationClientUnico authenticationClientUnico;
    private final ProtocoloConfigService protocoloConfigService;

    public UnicoAuthenticationInterceptorRequestInterceptor(AuthenticationClientUnico authenticationClientUnico, ProtocoloConfigService protocoloConfigService) {
        this.authenticationClientUnico = authenticationClientUnico;
        this.protocoloConfigService = protocoloConfigService;
    }

    public void apply(RequestTemplate template) {
        boolean isRequestToPainel;
        Boolean isUnico = this.protocoloConfigService.isUnicoWhathever();
        boolean bl = isRequestToPainel = Objects.nonNull(template.feignTarget()) && Objects.nonNull(template.feignTarget().url()) && template.feignTarget().url().contains("/painel-api/api");
        if (isUnico.booleanValue() && !isRequestToPainel && !this.protocoloConfigService.isModoCloud()) {
            template.removeHeader("Authorization");
            template.header("Authorization", new String[]{this.authenticationClientUnico.authenticateAndReturnToken()});
            template.removeHeader("X-AUTHORIZATION");
        }
    }
}

