/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.interceptor;

import br.com.elotech.protocolo.service.util.ActiveProfileUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Order(value=5)
public class OnPremisseTenantForwardedHeaderInterceptor
implements RequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnPremisseTenantForwardedHeaderInterceptor.class);
    public static final String FORWARDED_HEADER = "x-forwarded-host";
    @Value(value="${elotech.tenantId:}")
    private String tenantId;
    @Value(value="${elotech.unicoParcial:false}")
    private Boolean unicoParcial;
    private final Environment environment;

    public OnPremisseTenantForwardedHeaderInterceptor(Environment environment) {
        this.environment = environment;
    }

    public boolean isCloud() {
        return ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"cloud");
    }

    public Boolean isUnicoWhathever() {
        return ActiveProfileUtils.isProfileActive((Environment)this.environment, (String)"unico") != false || this.unicoParcial != false;
    }

    public void apply(RequestTemplate template) {
        boolean isRequestToUnicoOnPremise;
        boolean bl = isRequestToUnicoOnPremise = !this.isCloud() && this.isUnicoWhathever() != false && Objects.nonNull(template.feignTarget()) && Objects.nonNull(template.feignTarget().url()) && template.feignTarget().url().contains("unico-api");
        if (isRequestToUnicoOnPremise) {
            OnPremisseTenantForwardedHeaderInterceptor.removeKeycloakTokenForUnicoClientAuth((RequestTemplate)template);
        }
        if (StringUtils.isNotBlank((CharSequence)this.tenantId)) {
            template.removeHeader("x-forwarded-host");
            template.header("x-forwarded-host", new String[]{String.format("%s.any", this.tenantId)});
        }
    }

    private static void removeKeycloakTokenForUnicoClientAuth(RequestTemplate template) {
        template.removeHeader("Authorization");
    }
}

