/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.interceptor;

import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class OnPremisseTenantFeignInterceptor
implements RequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnPremisseTenantFeignInterceptor.class);
    @Value(value="${elotech.tenantId:}")
    private String tenantId = "";
    @Value(value="${elotech.tenantMultiRealm:false}")
    private Boolean tenantMultiRealm = false;
    private final KeycloakResolver keycloakResolver;
    public static final String FORWARDED_HEADER = "x-forwarded-host";

    public void apply(RequestTemplate template) {
        if (!TenantContextHolder.hasTenant() && StringUtils.isNotBlank((CharSequence)this.tenantId)) {
            Tenant tenant = Tenant.of((String)this.tenantId);
            if (this.tenantMultiRealm.booleanValue()) {
                tenant.setMultiRealm(Boolean.TRUE);
                KeycloakDeployment deployment = this.keycloakResolver.getKeycloakDeploymentById("OxyElotech");
                tenant.setRealmSecret(deployment.getResourceCredentials().get("secret").toString());
            }
            TenantContextHolder.setTenant((Tenant)tenant);
        }
        if (TenantContextHolder.hasTenant()) {
            template.removeHeader(FORWARDED_HEADER);
            template.header(FORWARDED_HEADER, new String[]{TenantContextHolder.getCurrentTenantId()});
        }
        if (StringUtils.isNotBlank((CharSequence)this.tenantId)) {
            template.removeHeader(FORWARDED_HEADER);
            template.header(FORWARDED_HEADER, new String[]{this.tenantId});
        }
    }

    @Generated
    public OnPremisseTenantFeignInterceptor(KeycloakResolver keycloakResolver) {
        this.keycloakResolver = keycloakResolver;
    }
}

