/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.hibernate.envers;

import br.com.elotech.core.jpa.hibernate.envers.RevisionListenerDefault;
import br.com.elotech.core.utils.SecurityUtils;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.multitenant.context.HeaderContextHolder;
import br.com.elotech.protocolo.hibernate.envers.RevisionProtocolo;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.keycloak.TokenVerifier;
import org.keycloak.representations.JsonWebToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class EnversListener
extends RevisionListenerDefault {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnversListener.class);
    private static final String PREFERRED_USERNAME = "preferred_username";

    public EnversListener(Optional<PhysicalNamingStrategy> physicalNamingStrategy) {
        super(physicalNamingStrategy);
    }

    public void newRevision(Object revisionEntity) {
        super.newRevision(revisionEntity);
        RevisionProtocolo revision = (RevisionProtocolo)revisionEntity;
        this.useAuthentication(revision);
    }

    private void useAuthentication(RevisionProtocolo revision) {
        if (Objects.nonNull(HeaderContextHolder.getXAuthorizationToken())) {
            EnversListener.handleXAuthorizationToken((RevisionProtocolo)revision);
            return;
        }
        EnversListener.handleAuthorization((RevisionProtocolo)revision);
    }

    private static void handleAuthorization(RevisionProtocolo revision) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        log.debug("Authentication: {}", (Object)authentication);
        if (authentication != null) {
            String username = SecurityUtils.getUsername();
            if (StringUtils.isNotBlank((CharSequence)username)) {
                revision.setUserName(username);
            }
            if (ContextHolder.getHeaderValueStr((String)"CLIENT_ID") != null) {
                revision.setUserName(String.format("%s@%s", authentication.getName(), ContextHolder.getHeaderValueStr((String)"CLIENT_ID")));
            }
        }
    }

    private static void handleXAuthorizationToken(RevisionProtocolo revision) {
        try {
            JsonWebToken jsonWebToken = TokenVerifier.create((String)HeaderContextHolder.getXAuthorizationToken(), JsonWebToken.class).getToken();
            if (jsonWebToken.isExpired()) {
                throw new IllegalArgumentException("O token expirou. Fa\u00e7a login novamente.");
            }
            Object preferredUsername = jsonWebToken.getOtherClaims().get("preferred_username");
            revision.setUserName(Optional.ofNullable(preferredUsername).map(Object::toString).orElseThrow(() -> new IllegalArgumentException("Usu\u00e1rio n\u00e3o encontrado no token")));
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Erro ao obter o token de autoriza\u00e7\u00e3o", ex);
        }
    }
}

