/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.function;

import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.dto.PessoaTributosDTO;
import java.util.Optional;
import java.util.function.Function;

public class PessoaToTributosDTO
implements Function<Pessoa, PessoaTributosDTO> {
    @Override
    public PessoaTributosDTO apply(Pessoa pessoa) {
        PessoaTributosDTO pessoaTributos = new PessoaTributosDTO();
        pessoa.setContato(PessoaTributosDTO.validarContato((Pessoa)pessoa));
        pessoaTributos.setActiveFormOrigem("Protocolo - Gera\u00e7\u00e3o de Taxas");
        pessoaTributos.setCelular(pessoa.getContato().getCelular());
        pessoaTributos.setCnpjCpf(pessoa.getCnpjCpf());
        pessoaTributos.setEmail(pessoa.getContato().getEmail());
        pessoaTributos.setNome(pessoa.getNome());
        pessoaTributos.setTipoPessoa(pessoa.getTipoPessoa());
        pessoaTributos.setRg(pessoa.getRg());
        if (!pessoa.getEnderecos().isEmpty()) {
            EnderecoPessoa endereco = (EnderecoPessoa)pessoa.getEnderecos().get(0);
            Optional.ofNullable(endereco.getLogradouro()).ifPresent(log -> pessoaTributos.setLogradouro(log.getDescricao()));
            Optional.ofNullable(endereco.getBairro()).ifPresent(bai -> pessoaTributos.setBairro(bai.getDescricao()));
            Optional.ofNullable(endereco.getCidade()).ifPresent(cid -> pessoaTributos.setCidade(cid.getDescricao()));
            Optional.ofNullable(endereco.getUf()).ifPresent(uf -> pessoaTributos.setUf(uf.getId()));
            pessoaTributos.setComplemento(endereco.getComplemento());
            pessoaTributos.setCep(endereco.getCep());
            pessoaTributos.setNumero(endereco.getNumero());
        }
        return pessoaTributos;
    }
}

