/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.dto;

import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.TaxaServicoDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequisicaoDebitoTributosDTO {
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long guiaRecolhimento;
    private Long subDivida;
    private String receitaLista;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate dataLancamento;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate dataVencimento;
    private BigDecimal valorPrincipal;
    private String telaOrigemDebito;
    private String observacao;

    public static String montarObservacao(Processo processo, List<TaxaServicoDTO> taxas) {
        StringBuilder builderObservacao = new StringBuilder().append(String.format("Processo %d/%d \n", processo.getId().getNumero(), processo.getId().getAno())).append(String.format("Assunto: %s \n", processo.getAssunto().getDescricao())).append(String.format("Senha do processo: %s \n", processo.getSenhaInternet()));
        StringBuilder dadosImobiliarios = new StringBuilder();
        if (!RequisicaoDebitoTributosDTO.isEmptyOrNull((Object)processo.getZona()).booleanValue()) {
            dadosImobiliarios.append(String.format("Zona: %s ", processo.getZona()));
        }
        if (!RequisicaoDebitoTributosDTO.isEmptyOrNull((Object)processo.getQuadra()).booleanValue()) {
            dadosImobiliarios.append(String.format("Quadra: %s ", processo.getQuadra()));
        }
        if (!RequisicaoDebitoTributosDTO.isEmptyOrNull((Object)processo.getData()).booleanValue()) {
            dadosImobiliarios.append(String.format("Lote: %s ", processo.getData()));
        }
        if (!RequisicaoDebitoTributosDTO.isEmptyOrNull((Object)processo.getCadastro()).booleanValue()) {
            dadosImobiliarios.append(String.format("Cadastro: %s ", processo.getCadastro()));
        }
        if (!dadosImobiliarios.toString().isEmpty()) {
            dadosImobiliarios.append(System.lineSeparator());
        }
        builderObservacao.append((CharSequence)dadosImobiliarios).append("Taxas: \n");
        taxas.forEach(taxa -> builderObservacao.append(String.format("%s - Valor unit\u00e1rio: R$ %.2f - Quantidade: %.2f - Valor total: R$ %.2f \n", taxa.getDescricao(), taxa.getValor(), taxa.getQuantidade(), taxa.getQuantidade().multiply(taxa.getValor()))));
        BigDecimal totalTaxas = taxas.stream().map(taxa -> taxa.getQuantidade().multiply(taxa.getValor())).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
        return builderObservacao.append(String.format("Valor total: R$ %.2f", totalTaxas)).toString();
    }

    private static Boolean isEmptyOrNull(Object value) {
        return Objects.isNull(value) || value.toString().isEmpty();
    }

    @Generated
    public RequisicaoDebitoTributosDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getReceitaLista() {
        return this.receitaLista;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public String getTelaOrigemDebito() {
        return this.telaOrigemDebito;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setReceitaLista(String receitaLista) {
        this.receitaLista = receitaLista;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setTelaOrigemDebito(String telaOrigemDebito) {
        this.telaOrigemDebito = telaOrigemDebito;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequisicaoDebitoTributosDTO)) {
            return false;
        }
        RequisicaoDebitoTributosDTO other = (RequisicaoDebitoTributosDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$guiaRecolhimento = this.getGuiaRecolhimento();
        Long other$guiaRecolhimento = other.getGuiaRecolhimento();
        if (this$guiaRecolhimento == null ? other$guiaRecolhimento != null : !((Object)this$guiaRecolhimento).equals(other$guiaRecolhimento)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        String this$receitaLista = this.getReceitaLista();
        String other$receitaLista = other.getReceitaLista();
        if (this$receitaLista == null ? other$receitaLista != null : !this$receitaLista.equals(other$receitaLista)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        String this$telaOrigemDebito = this.getTelaOrigemDebito();
        String other$telaOrigemDebito = other.getTelaOrigemDebito();
        if (this$telaOrigemDebito == null ? other$telaOrigemDebito != null : !this$telaOrigemDebito.equals(other$telaOrigemDebito)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        return !(this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequisicaoDebitoTributosDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $guiaRecolhimento = this.getGuiaRecolhimento();
        result = result * 59 + ($guiaRecolhimento == null ? 43 : ((Object)$guiaRecolhimento).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        String $receitaLista = this.getReceitaLista();
        result = result * 59 + ($receitaLista == null ? 43 : $receitaLista.hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        String $telaOrigemDebito = this.getTelaOrigemDebito();
        result = result * 59 + ($telaOrigemDebito == null ? 43 : $telaOrigemDebito.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RequisicaoDebitoTributosDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", subDivida=" + this.getSubDivida() + ", receitaLista=" + this.getReceitaLista() + ", dataLancamento=" + String.valueOf(this.getDataLancamento()) + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", valorPrincipal=" + String.valueOf(this.getValorPrincipal()) + ", telaOrigemDebito=" + this.getTelaOrigemDebito() + ", observacao=" + this.getObservacao() + ")";
    }
}

