/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain.util;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Objects;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter(autoApply=true)
public class JSR310LocalTimeConverter
implements AttributeConverter<LocalTime, Timestamp> {
    public Timestamp convertToDatabaseColumn(LocalTime entityTime) {
        if (Objects.nonNull(entityTime)) {
            return Timestamp.valueOf(entityTime.atDate(LocalDate.now()));
        }
        return null;
    }

    public LocalTime convertToEntityAttribute(Timestamp dbTime) {
        if (Objects.nonNull(dbTime)) {
            return dbTime.toLocalDateTime().toLocalTime();
        }
        return null;
    }
}

