/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain.util;

import br.com.elotech.protocolo.domain.util.JSR310LocalDateDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;

public final class JSR310LocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    private static final DateTimeFormatter ISO_DATE_OPTIONAL_TIME;
    public static final JSR310LocalDateDeserializer INSTANCE;

    private JSR310LocalDateDeserializer() {
    }

    public LocalDate deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[parser.getCurrentToken().ordinal()]) {
            case 1: {
                if (parser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    throw context.wrongTokenException(parser, JsonToken.class, JsonToken.END_ARRAY, "Expected array to end.");
                }
                int year = parser.getIntValue();
                parser.nextToken();
                int month = parser.getIntValue();
                parser.nextToken();
                int day = parser.getIntValue();
                return LocalDate.of(year, month, day);
            }
            case 2: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return LocalDate.parse(string, ISO_DATE_OPTIONAL_TIME);
            }
        }
        throw context.wrongTokenException(parser, JsonToken.class, JsonToken.START_ARRAY, "Expected array or string.");
    }

    static {
        INSTANCE = new JSR310LocalDateDeserializer();
        ISO_DATE_OPTIONAL_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_OFFSET_TIME).toFormatter();
    }
}

