/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain.support;

import br.com.elotech.adm.domain.support.UsuarioLogado;
import br.com.elotech.protocolo.domain.support.AuditInfo;
import br.com.elotech.protocolo.domain.support.Auditable;
import br.com.elotech.protocolo.service.UsuarioLogadoProtocoloService;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

public class AuditListener {
    private UsuarioLogadoProtocoloService usuarioLogadoProtocoloService = new UsuarioLogadoProtocoloService();

    @PrePersist
    public void setCreatedOn(Auditable auditable) {
        String nomeUsuario = this.getUsuarioLogado().getNome();
        AuditInfo audit = Optional.ofNullable(auditable.getAudit()).orElse(new AuditInfo());
        audit.setDataCriacao(LocalDateTime.now());
        audit.setDataAlteracao(LocalDateTime.now());
        audit.setUsuarioCriacao(nomeUsuario);
        audit.setUsuarioAlteracao(nomeUsuario);
        auditable.setAudit(audit);
    }

    @PreUpdate
    public void setUpdatedOn(Auditable auditable) {
        if (Objects.isNull(auditable.getAudit())) {
            this.setCreatedOn(auditable);
        } else {
            auditable.getAudit().setUsuarioAlteracao(this.getUsuarioLogado().getNome());
            auditable.getAudit().setDataAlteracao(LocalDateTime.now());
        }
    }

    private UsuarioLogado getUsuarioLogado() {
        return this.usuarioLogadoProtocoloService.getUsuarioLogadoToken();
    }
}

