/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.protocolo.domain.UsuarioLocalPK;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="usuario_local")
public class UsuarioLocal
implements EloEntity<UsuarioLocalPK> {
    @EmbeddedId
    private UsuarioLocalPK id = new UsuarioLocalPK();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padrao;

    public UsuarioLocal() {
    }

    public UsuarioLocal(UsuarioLocalPK id) {
        this.id = id;
        this.padrao = Boolean.FALSE;
    }

    public UsuarioLocal(UsuarioLocalPK id, Boolean padrao) {
        this.id = id;
        this.padrao = padrao;
    }

    public UsuarioLocalPK getId() {
        return this.id;
    }

    public void setId(UsuarioLocalPK id) {
        this.id = id;
    }

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public static UsuarioPermissaoLocalDTO toUsuarioPermissaoLocalDTO(UsuarioLocal usuarioLocal) {
        UsuarioPermissaoLocalDTO dto = new UsuarioPermissaoLocalDTO();
        if (usuarioLocal == null) {
            return dto;
        }
        dto.setLoginUsuario(usuarioLocal.getId().getUsuario().getId());
        dto.setNomeUsuario(usuarioLocal.getId().getUsuario().getNome());
        return dto;
    }

    @Generated
    public String toString() {
        return "UsuarioLocal(id=" + String.valueOf(this.getId()) + ", padrao=" + this.getPadrao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsuarioLocal)) {
            return false;
        }
        UsuarioLocal other = (UsuarioLocal)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$padrao = this.getPadrao();
        Boolean other$padrao = other.getPadrao();
        if (this$padrao == null ? other$padrao != null : !((Object)this$padrao).equals(other$padrao)) {
            return false;
        }
        UsuarioLocalPK this$id = this.getId();
        UsuarioLocalPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UsuarioLocal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $padrao = this.getPadrao();
        result = result * 59 + ($padrao == null ? 43 : ((Object)$padrao).hashCode());
        UsuarioLocalPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

