/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioEntidadePK;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="usuario_entidade")
@DynamicInsert
@DynamicUpdate
public class UsuarioEntidade
implements EloEntity<UsuarioEntidadePK> {
    @EmbeddedId
    @Valid
    private UsuarioEntidadePK id = new UsuarioEntidadePK();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padrao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean alteraTodosProc = Boolean.FALSE;

    public UsuarioEntidadePK getId() {
        return this.id;
    }

    public void setId(UsuarioEntidadePK id) {
        this.id = id;
    }

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public Boolean getAlteraTodosProc() {
        return this.alteraTodosProc;
    }

    public void setAlteraTodosProc(Boolean alteraTodosProc) {
        this.alteraTodosProc = alteraTodosProc;
    }

    public static UsuarioEntidade of(Usuario usuario, Entidade entidade) {
        return new UsuarioEntidade().withUsuario(usuario).withEntidade(entidade);
    }

    public static UsuarioEntidade of(Usuario usuario, Entidade entidade, Boolean alteraTodosProc) {
        return new UsuarioEntidade().withUsuario(usuario).withEntidade(entidade).withAlteraTodosProc(alteraTodosProc);
    }

    public UsuarioEntidade withEntidade(Entidade entidade) {
        this.id.setEntidade(entidade);
        return this;
    }

    public UsuarioEntidade withUsuario(Usuario usuario) {
        this.id.setUsuario(usuario);
        return this;
    }

    public UsuarioEntidade withPadrao(Boolean padrao) {
        this.setPadrao(padrao);
        return this;
    }

    public UsuarioEntidade withAlteraTodosProc(Boolean alteraTodosProc) {
        this.setAlteraTodosProc(alteraTodosProc);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsuarioEntidade)) {
            return false;
        }
        UsuarioEntidade other = (UsuarioEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UsuarioEntidadePK this$id = this.getId();
        UsuarioEntidadePK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UsuarioEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UsuarioEntidadePK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UsuarioEntidade(id=" + String.valueOf(this.getId()) + ", padrao=" + this.getPadrao() + ", alteraTodosProc=" + this.getAlteraTodosProc() + ")";
    }
}

