/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Secretaria;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.UsuarioEntidade;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioModeloImpressao;
import br.com.elotech.protocolo.domain.UsuarioModulo;
import br.com.elotech.protocolo.domain.UsuarioSeletor;
import br.com.elotech.protocolo.domain.UsuarioTipoProcesso;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="usuario")
@DynamicInsert
@DynamicUpdate
public class Usuario
implements EloEntity<String>,
Serializable {
    private static final long NIVEL_USUARIO = 9999L;
    @Id
    @Column(name="login1")
    @Length(max=250)
    private @Length(max=250) String id;
    @Length(max=36)
    @Column(name="idkeycloak")
    private @Length(max=36) String idKeycloak;
    @Length(max=50)
    private @Length(max=50) String nome;
    @Length(max=15)
    private @Length(max=15) String senha;
    private Long local;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean visualiza;
    @Length(max=1)
    private @Length(max=1) String nivelTramite;
    private Long nivelAcesso = 9999L;
    @Length(max=60)
    private @Length(max=60) String nomeProg;
    @Column(name="usuario")
    private Long codigoUsuario;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padrao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean verificaMensagens;
    private Long tempoVerificacao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;
    @Length(max=60)
    private @Length(max=60) String email;
    @Column(name="bo_anexararquivo")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean boAnexarArquivo;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String cpf;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean imprimePapeleta;
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.usuario")
    @Valid
    private final Set<UsuarioEntidade> entidades = new HashSet();
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.usuario")
    @Valid
    private final Set<UsuarioModulo> modulos = new HashSet();
    @OneToMany(mappedBy="id.usuario", orphanRemoval=true)
    @Valid
    private Set<UsuarioSeletor> seletores = new HashSet();
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.usuario")
    private List<UsuarioTipoProcesso> usuarioTipoProcesso = new ArrayList();
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.usuario")
    private List<UsuarioModeloImpressao> usuarioModeloImpressao = new ArrayList();
    @OneToMany
    @JoinTable(name="usuario_assunto", joinColumns={@JoinColumn(name="usuario", referencedColumnName="login1")}, inverseJoinColumns={@JoinColumn(name="assunto", referencedColumnName="codigo")})
    private Set<Assunto> assuntos;
    @OneToMany
    @JoinTable(name="usuario_secretaria", joinColumns={@JoinColumn(name="usuario", referencedColumnName="login1")}, inverseJoinColumns={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="secretaria", referencedColumnName="numero")})
    private Set<Secretaria> secretarias;
    @JsonIgnore
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.usuario")
    private Set<UsuarioLocal> usuarioLocal = new HashSet();
    @Column(name="DATACADASTRO")
    private LocalDateTime dataCriacao;
    @Column(name="DATAALTERACAO")
    private LocalDateTime dataAlteracao;
    @Column(name="exclui_arquivos")
    private Boolean excluirArquivos = Boolean.FALSE;
    @Column(name="editar_processo_tramitado")
    private Boolean editarProcessoTramitado = Boolean.FALSE;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToMany(mappedBy="observadores")
    private Set<TipoProcesso> tipos = new HashSet();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ouvidor;

    public UsuarioPermissaoLocalDTO toUsuarioPermissaoLocalDto() {
        UsuarioPermissaoLocalDTO usuarioPermissaoLocalDTO = new UsuarioPermissaoLocalDTO();
        usuarioPermissaoLocalDTO.setLoginUsuario(this.getId());
        usuarioPermissaoLocalDTO.setNomeUsuario(this.getNome());
        return usuarioPermissaoLocalDTO;
    }

    public String getIdKeycloak() {
        return this.idKeycloak;
    }

    public void setIdKeycloak(String idKeycloak) {
        this.idKeycloak = idKeycloak;
    }

    public Usuario(String id) {
        this.id = id;
    }

    public Usuario(String id, String nome) {
        this.id = id;
        this.nome = nome;
    }

    public Usuario() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Long getLocal() {
        return this.local;
    }

    public void setLocal(Long local) {
        this.local = local;
    }

    public Boolean getVisualiza() {
        return this.visualiza;
    }

    public void setVisualiza(Boolean visualiza) {
        this.visualiza = visualiza;
    }

    public String getNivelTramite() {
        return this.nivelTramite;
    }

    public void setNivelTramite(String nivelTramite) {
        this.nivelTramite = nivelTramite;
    }

    public Long getNivelAcesso() {
        return this.nivelAcesso;
    }

    public void setNivelAcesso(Long nivelAcesso) {
        this.nivelAcesso = nivelAcesso;
    }

    public String getNomeProg() {
        return this.nomeProg;
    }

    public void setNomeProg(String nomeProg) {
        this.nomeProg = nomeProg;
    }

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public Boolean getVerificaMensagens() {
        return this.verificaMensagens;
    }

    public void setVerificaMensagens(Boolean verificaMensagens) {
        this.verificaMensagens = verificaMensagens;
    }

    public Long getTempoVerificacao() {
        return this.tempoVerificacao;
    }

    public void setTempoVerificacao(Long tempoVerificacao) {
        this.tempoVerificacao = tempoVerificacao;
    }

    public Boolean getAtivo() {
        return BooleanUtils.isTrue((Boolean)this.ativo);
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getBoAnexarArquivo() {
        return this.boAnexarArquivo;
    }

    public void setBoAnexarArquivo(Boolean boAnexarArquivo) {
        this.boAnexarArquivo = boAnexarArquivo;
    }

    public Set<UsuarioEntidade> getEntidades() {
        return this.entidades;
    }

    public Set<UsuarioModulo> getModulos() {
        return this.modulos;
    }

    public Usuario withSenha(String senha) {
        this.setSenha(senha);
        return this;
    }

    public Usuario withAtivo(Boolean ativo) {
        this.setAtivo(ativo);
        return this;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Boolean getImprimePapeleta() {
        return this.imprimePapeleta;
    }

    public void setImprimePapeleta(Boolean imprimePapeleta) {
        this.imprimePapeleta = imprimePapeleta;
    }

    public Set<UsuarioSeletor> getSeletores() {
        return this.seletores;
    }

    public void setSeletores(Set<UsuarioSeletor> seletores) {
        this.seletores = seletores;
    }

    public List<UsuarioTipoProcesso> getUsuarioTipoProcesso() {
        return this.usuarioTipoProcesso;
    }

    public void setUsuarioTipoProcesso(List<UsuarioTipoProcesso> usuarioTipoProcesso) {
        this.usuarioTipoProcesso = usuarioTipoProcesso;
    }

    public List<UsuarioModeloImpressao> getUsuarioModeloImpressao() {
        return this.usuarioModeloImpressao;
    }

    public void setUsuarioModeloImpressao(List<UsuarioModeloImpressao> usuarioModeloImpressao) {
        this.usuarioModeloImpressao = usuarioModeloImpressao;
    }

    public Set<Secretaria> getSecretarias() {
        if (Objects.isNull(this.secretarias)) {
            this.secretarias = new HashSet();
        }
        return this.secretarias;
    }

    public void setSecretarias(Set<Secretaria> secretarias) {
        this.secretarias = secretarias;
    }

    public Long getCodigoUsuario() {
        return this.codigoUsuario;
    }

    public void setCodigoUsuario(Long codigoUsuario) {
        this.codigoUsuario = codigoUsuario;
    }

    public Set<Assunto> getAssuntos() {
        if (Objects.isNull(this.assuntos)) {
            this.assuntos = new HashSet();
        }
        return this.assuntos;
    }

    public void setAssuntos(Set<Assunto> assuntos) {
        this.assuntos = assuntos;
    }

    public Boolean possuiEmail() {
        return this.email != null && !StringUtils.isBlank((CharSequence)this.email);
    }

    @JsonIgnore
    public Set<UsuarioLocal> getUsuarioLocal() {
        return this.usuarioLocal;
    }

    public void setUsuarioLocal(Set<UsuarioLocal> usuarioLocal) {
        this.usuarioLocal = usuarioLocal;
    }

    public LocalDateTime getDataCadastro() {
        return this.dataCriacao;
    }

    public void setDataCriacao(LocalDateTime dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    public LocalDateTime getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDateTime dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public Boolean getExcluirArquivos() {
        return this.excluirArquivos;
    }

    public void setExcluirArquivos(Boolean excluirArquivos) {
        this.excluirArquivos = excluirArquivos;
    }

    public Boolean getEditarProcessoTramitado() {
        return this.editarProcessoTramitado;
    }

    public void setEditarProcessoTramitado(Boolean editarProcessoTramitado) {
        this.editarProcessoTramitado = editarProcessoTramitado;
    }

    public Set<TipoProcesso> getTipos() {
        return this.tipos;
    }

    public void setTipos(Set<TipoProcesso> tipos) {
        this.tipos = tipos;
    }

    public Boolean getOuvidor() {
        return this.ouvidor;
    }

    public void setOuvidor(Boolean ouvidor) {
        this.ouvidor = ouvidor;
    }

    @Generated
    public String toString() {
        return "Usuario(id=" + this.getId() + ", nome=" + this.getNome() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Usuario)) {
            return false;
        }
        Usuario other = (Usuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Usuario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

