/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.protocolo.domain.Caixa;
import br.com.elotech.protocolo.domain.HistoricoTramiteEmail;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.TramitePK;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.Funcao;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Audited
@Table(name="tramitacao")
public class Tramite
implements EloEntity<TramitePK>,
DomainEntity<TramitePK> {
    public static final String PARECER_RECEBIMENTO_AUTOMATICO = "Recebido Automaticamente no Encerramento do Processo";
    @EmbeddedId
    private TramitePK id = new TramitePK();
    @ManyToOne
    @NotAudited
    private Situacao situacao;
    private Funcao funcao;
    private LocalDate data;
    private LocalTime hora;
    private String parecer;
    @NotAudited
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumns(value={@JoinColumn(name="entidadeLocal", referencedColumnName="entidade"), @JoinColumn(name="local", referencedColumnName="codigo")})
    private Local local;
    @ManyToOne
    @NotAudited
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumn(name="usuario_responsavel_tramite", referencedColumnName="login1")
    private Usuario usuarioResponsavelTramite;
    @Column(name="USUARIOREG")
    private String usuarioRegistro;
    @Column(name="usuarioalteracao")
    private String usuarioAlteracao;
    @Column(name="DATAREG")
    private LocalDate dataRegistro;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="usuarioReg", referencedColumnName="login1", insertable=false, updatable=false)})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Usuario usuario;
    @Column(name="CAIXA")
    private String caixaLegado;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="CODCAIXA", referencedColumnName="CODIGO"), @JoinColumn(name="ANOCAIXA", referencedColumnName="ANO")})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Caixa caixa;
    private Long lote;
    @Column(name="nrofolhas")
    private Integer quantidadeFolhas;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean notaPrivada;
    @Column(name="parecerresposta")
    private String parecerResposta;
    @Column(name="dataparecerresposta")
    private LocalDateTime dataParecerResposta;
    @Column(name="lotesequencia")
    private Long loteSequencia;
    @NotAudited
    @OneToMany(fetch=FetchType.LAZY, mappedBy="domainEntity")
    private List<HistoricoTramiteEmail> historicos = new ArrayList();

    public Tramite() {
        this.id = new TramitePK();
    }

    public static TramiteBuilder novaAbertura(Processo processo) {
        return Tramite.novoTramite((Processo)processo, (Funcao)Funcao.ABERTO);
    }

    public static TramiteBuilder novoEncaminhamento(Processo processo) {
        return Tramite.novoTramite((Processo)processo, (Funcao)Funcao.ENCAMINHADO);
    }

    public static TramiteBuilder novoRecebimento(Processo processo) {
        return Tramite.novoTramite((Processo)processo, (Funcao)Funcao.RECEBIDO);
    }

    public static TramiteBuilder novoArquivamento(Processo processo) {
        return Tramite.novoTramite((Processo)processo, (Funcao)Funcao.ARQUIVADO);
    }

    private static TramiteBuilder novoTramite(Processo processo, Funcao funcao) {
        return new TramiteBuilder(processo, funcao);
    }

    public static List<Tramite> ordenarTramitesPorSequenciaNoLote(List<Tramite> tramites) {
        return tramites.stream().sorted(Comparator.comparing(Tramite::getLoteSequencia, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    public Situacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(Situacao situacao) {
        this.situacao = situacao;
    }

    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    public LocalTime getHora() {
        return this.hora;
    }

    public void setHora(LocalTime hora) {
        this.hora = hora;
    }

    public String getParecer() {
        return this.parecer;
    }

    public void setParecer(String parecer) {
        this.parecer = parecer;
    }

    public Local getLocal() {
        return this.local;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public String getUsuarioRegistro() {
        return this.usuarioRegistro;
    }

    public void setUsuarioRegistro(String usuarioRegistro) {
        this.usuarioRegistro = usuarioRegistro;
    }

    public void setUsuarioAlteracao(String usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public LocalDate getDataRegistro() {
        return this.dataRegistro;
    }

    public void setDataRegistro(LocalDate dataRegistro) {
        this.dataRegistro = dataRegistro;
    }

    public Caixa getCaixa() {
        return this.caixa;
    }

    public Long getLoteSequencia() {
        return this.loteSequencia;
    }

    public void setLoteSequencia(Long loteSequencia) {
        this.loteSequencia = loteSequencia;
    }

    public void setCaixa(Caixa caixa) {
        this.caixa = caixa;
    }

    public String getParecerResposta() {
        return this.parecerResposta;
    }

    public void setParecerResposta(String parecerResposta) {
        this.parecerResposta = parecerResposta;
    }

    public LocalDateTime getDataParecerResposta() {
        return this.dataParecerResposta;
    }

    public void setDataParecerResposta(LocalDateTime dataParecerResposta) {
        this.dataParecerResposta = dataParecerResposta;
    }

    public TramitePK getId() {
        return this.id;
    }

    public void setId(TramitePK id) {
        this.id = id;
    }

    public String getCaixaLegado() {
        return this.caixaLegado;
    }

    public void setCaixaLegado(String caixaLegado) {
        this.caixaLegado = caixaLegado;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public Long getLote() {
        return this.lote;
    }

    public void setLote(Long lote) {
        this.lote = lote;
    }

    public Long getSequencia() {
        return this.id.getSequencia();
    }

    public Integer getQuantidadeFolhas() {
        return this.quantidadeFolhas;
    }

    public void setQuantidadeFolhas(Integer quantidadeFolhas) {
        this.quantidadeFolhas = quantidadeFolhas;
    }

    public Boolean getNotaPrivada() {
        return this.notaPrivada;
    }

    public void setNotaPrivada(Boolean notaPrivada) {
        this.notaPrivada = notaPrivada;
    }

    public Usuario getUsuarioResponsavelTramite() {
        return this.usuarioResponsavelTramite;
    }

    public void setUsuarioResponsavelTramite(Usuario usuarioResponsavelTramite) {
        this.usuarioResponsavelTramite = usuarioResponsavelTramite;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tramite)) {
            return false;
        }
        Tramite other = (Tramite)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TramitePK this$id = this.getId();
        TramitePK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tramite;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TramitePK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Tramite(id=" + String.valueOf(this.getId()) + ", situacao=" + String.valueOf(this.getSituacao()) + ", funcao=" + String.valueOf(this.getFuncao()) + ", data=" + String.valueOf(this.getData()) + ", parecer=" + this.getParecer() + ")";
    }

    @Generated
    public List<HistoricoTramiteEmail> getHistoricos() {
        return this.historicos;
    }
}

