/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoProcessoEntidade;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.Prioridade;
import br.com.elotech.protocolo.dto.mp.TipoProcessoMP;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tiposprotocolo")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Audited
public class TipoProcesso
implements EloEntity<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @EloSequence(sequenceName="GEN_TIPOSPROTOCOLO")
    @Column(name="codigo")
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotBlank
    @Length(max=25)
    @Caption(value="Tipo")
    private @NotBlank @Length(max=25) String descricao;
    private Long diasVencimento;
    private String caminhoCapa;
    private String caminhoRequerimento;
    private String caminhoCapaAgrupamentoArquivo;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="bo_compra")
    private Boolean compra;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="bo_ativo")
    private Boolean ativo = Boolean.TRUE;
    @Column(name="tipo_dataflex")
    private Long tipoDataFlex;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="imprimecomprovantesn")
    private Boolean imprimeComprovante;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="imprimecapaprocessosn")
    private Boolean imprimeCapaProcesso;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="imprimeetiquetasn")
    private Boolean imprimeEtiqueta;
    @Column(name="padrao_sigiloso")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean sigiloso = Boolean.TRUE;
    @Column(name="tipointerno")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean tipoInterno = Boolean.FALSE;
    @Column(name="comunicacaointerna")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean comunicacaoInterna = Boolean.FALSE;
    @Column(name="padraofisico")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padraoFisico = Boolean.FALSE;
    @JoinColumn(name="situacaopadrao_id")
    @ManyToOne
    private Situacao situacaoPadrao;
    @JoinColumn(name="assuntopadrao_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Assunto assuntoPadrao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean assuntoFixo = Boolean.FALSE;
    private Prioridade prioridadePadrao;
    @Enumerated(value=EnumType.STRING)
    private TipoProcessoMP tipoProcessoMp;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean consultaExterna = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean uploadAnexoSemRestricao = Boolean.FALSE;
    @OneToMany(mappedBy="tipoProcesso", cascade={CascadeType.ALL}, orphanRemoval=true)
    @NotAudited
    private List<TipoProcessoEntidade> tipoProcessoEntidade = new ArrayList();
    @ManyToMany
    @JoinTable(name="assunto_tipoprocesso", joinColumns={@JoinColumn(name="tipoprocesso_id")}, inverseJoinColumns={@JoinColumn(name="assunto_id")})
    private Set<Assunto> assuntos = new HashSet();
    @ManyToMany
    @JoinTable(name="situacao_tipoprocesso", joinColumns={@JoinColumn(name="tipoprocesso_id")}, inverseJoinColumns={@JoinColumn(name="situacao_id")})
    private Set<Situacao> situacoes = new HashSet();
    @ManyToMany
    @NotAudited
    @JoinTable(name="observador_tipoprocesso", joinColumns={@JoinColumn(name="tipoprocesso_id")}, inverseJoinColumns={@JoinColumn(name="usuario_id")})
    @JsonIgnoreProperties(value={"usuarioTipoProcesso"})
    private Set<Usuario> observadores = new HashSet();

    public TipoProcesso() {
    }

    public TipoProcesso(Long id) {
        this.id = id;
    }

    public String getCaminhoCapa() {
        return Optional.ofNullable(this.caminhoCapa).orElse(RelatorioProtocolo.CAPA_PROCESSO.getDefaultRpt());
    }

    public String getCaminhoRequerimento() {
        return Optional.ofNullable(this.caminhoRequerimento).orElse(RelatorioProtocolo.REQUERIMENTO_PROCESSO.getDefaultRpt());
    }

    public String getCaminhoCapaAgrupamentoArquivo() {
        return Optional.ofNullable(this.caminhoCapaAgrupamentoArquivo).orElse(RelatorioProtocolo.CAPA_PROCESSO.getDefaultRpt());
    }

    public static TipoProcesso of(Long id) {
        TipoProcesso tipoProcesso = new TipoProcesso();
        tipoProcesso.setId(id);
        return tipoProcesso;
    }

    public Boolean isProcessoCompras() {
        return Objects.nonNull(this.compra) && this.compra != false;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getDiasVencimento() {
        return this.diasVencimento;
    }

    @Generated
    public Boolean getCompra() {
        return this.compra;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Long getTipoDataFlex() {
        return this.tipoDataFlex;
    }

    @Generated
    public Boolean getImprimeComprovante() {
        return this.imprimeComprovante;
    }

    @Generated
    public Boolean getImprimeCapaProcesso() {
        return this.imprimeCapaProcesso;
    }

    @Generated
    public Boolean getImprimeEtiqueta() {
        return this.imprimeEtiqueta;
    }

    @Generated
    public Boolean getSigiloso() {
        return this.sigiloso;
    }

    @Generated
    public Boolean getTipoInterno() {
        return this.tipoInterno;
    }

    @Generated
    public Boolean getComunicacaoInterna() {
        return this.comunicacaoInterna;
    }

    @Generated
    public Boolean getPadraoFisico() {
        return this.padraoFisico;
    }

    @Generated
    public Situacao getSituacaoPadrao() {
        return this.situacaoPadrao;
    }

    @Generated
    public Assunto getAssuntoPadrao() {
        return this.assuntoPadrao;
    }

    @Generated
    public Boolean getAssuntoFixo() {
        return this.assuntoFixo;
    }

    @Generated
    public Prioridade getPrioridadePadrao() {
        return this.prioridadePadrao;
    }

    @Generated
    public TipoProcessoMP getTipoProcessoMp() {
        return this.tipoProcessoMp;
    }

    @Generated
    public Boolean getConsultaExterna() {
        return this.consultaExterna;
    }

    @Generated
    public Boolean getUploadAnexoSemRestricao() {
        return this.uploadAnexoSemRestricao;
    }

    @Generated
    public List<TipoProcessoEntidade> getTipoProcessoEntidade() {
        return this.tipoProcessoEntidade;
    }

    @Generated
    public Set<Assunto> getAssuntos() {
        return this.assuntos;
    }

    @Generated
    public Set<Situacao> getSituacoes() {
        return this.situacoes;
    }

    @Generated
    public Set<Usuario> getObservadores() {
        return this.observadores;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setDiasVencimento(Long diasVencimento) {
        this.diasVencimento = diasVencimento;
    }

    @Generated
    public void setCaminhoCapa(String caminhoCapa) {
        this.caminhoCapa = caminhoCapa;
    }

    @Generated
    public void setCaminhoRequerimento(String caminhoRequerimento) {
        this.caminhoRequerimento = caminhoRequerimento;
    }

    @Generated
    public void setCaminhoCapaAgrupamentoArquivo(String caminhoCapaAgrupamentoArquivo) {
        this.caminhoCapaAgrupamentoArquivo = caminhoCapaAgrupamentoArquivo;
    }

    @Generated
    public void setCompra(Boolean compra) {
        this.compra = compra;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setTipoDataFlex(Long tipoDataFlex) {
        this.tipoDataFlex = tipoDataFlex;
    }

    @Generated
    public void setImprimeComprovante(Boolean imprimeComprovante) {
        this.imprimeComprovante = imprimeComprovante;
    }

    @Generated
    public void setImprimeCapaProcesso(Boolean imprimeCapaProcesso) {
        this.imprimeCapaProcesso = imprimeCapaProcesso;
    }

    @Generated
    public void setImprimeEtiqueta(Boolean imprimeEtiqueta) {
        this.imprimeEtiqueta = imprimeEtiqueta;
    }

    @Generated
    public void setSigiloso(Boolean sigiloso) {
        this.sigiloso = sigiloso;
    }

    @Generated
    public void setTipoInterno(Boolean tipoInterno) {
        this.tipoInterno = tipoInterno;
    }

    @Generated
    public void setComunicacaoInterna(Boolean comunicacaoInterna) {
        this.comunicacaoInterna = comunicacaoInterna;
    }

    @Generated
    public void setPadraoFisico(Boolean padraoFisico) {
        this.padraoFisico = padraoFisico;
    }

    @Generated
    public void setSituacaoPadrao(Situacao situacaoPadrao) {
        this.situacaoPadrao = situacaoPadrao;
    }

    @Generated
    public void setAssuntoPadrao(Assunto assuntoPadrao) {
        this.assuntoPadrao = assuntoPadrao;
    }

    @Generated
    public void setAssuntoFixo(Boolean assuntoFixo) {
        this.assuntoFixo = assuntoFixo;
    }

    @Generated
    public void setPrioridadePadrao(Prioridade prioridadePadrao) {
        this.prioridadePadrao = prioridadePadrao;
    }

    @Generated
    public void setTipoProcessoMp(TipoProcessoMP tipoProcessoMp) {
        this.tipoProcessoMp = tipoProcessoMp;
    }

    @Generated
    public void setConsultaExterna(Boolean consultaExterna) {
        this.consultaExterna = consultaExterna;
    }

    @Generated
    public void setUploadAnexoSemRestricao(Boolean uploadAnexoSemRestricao) {
        this.uploadAnexoSemRestricao = uploadAnexoSemRestricao;
    }

    @Generated
    public void setTipoProcessoEntidade(List<TipoProcessoEntidade> tipoProcessoEntidade) {
        this.tipoProcessoEntidade = tipoProcessoEntidade;
    }

    @Generated
    public void setAssuntos(Set<Assunto> assuntos) {
        this.assuntos = assuntos;
    }

    @Generated
    public void setSituacoes(Set<Situacao> situacoes) {
        this.situacoes = situacoes;
    }

    @JsonIgnoreProperties(value={"usuarioTipoProcesso"})
    @Generated
    public void setObservadores(Set<Usuario> observadores) {
        this.observadores = observadores;
    }

    @Generated
    public String toString() {
        return "TipoProcesso(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TipoProcesso)) {
            return false;
        }
        TipoProcesso other = (TipoProcesso)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TipoProcesso;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

