/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.TipoProcesso;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Audited
@Table(name="situacoes")
public class Situacao
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="GEN_SITUACOES")
    @Column(name="codigo")
    private Long id;
    @Length(max=40)
    @Caption(value="Situa\u00e7\u00e3o")
    private @Length(max=40) String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean arquivamento = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean pagamentoPendente = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativa = Boolean.TRUE;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToMany(mappedBy="situacoes")
    private Set<TipoProcesso> tipos = new HashSet();

    public static Situacao of(Long id) {
        Situacao situacao = new Situacao();
        situacao.setId(id);
        return situacao;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getArquivamento() {
        return this.arquivamento;
    }

    @Generated
    public Boolean getPagamentoPendente() {
        return this.pagamentoPendente;
    }

    @Generated
    public Boolean getAtiva() {
        return this.ativa;
    }

    @Generated
    public Set<TipoProcesso> getTipos() {
        return this.tipos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setArquivamento(Boolean arquivamento) {
        this.arquivamento = arquivamento;
    }

    @Generated
    public void setPagamentoPendente(Boolean pagamentoPendente) {
        this.pagamentoPendente = pagamentoPendente;
    }

    @Generated
    public void setAtiva(Boolean ativa) {
        this.ativa = ativa;
    }

    @JsonIgnore
    @Generated
    public void setTipos(Set<TipoProcesso> tipos) {
        this.tipos = tipos;
    }

    @Generated
    public Situacao() {
    }

    @Generated
    public Situacao(Long id, String descricao, Boolean arquivamento, Boolean pagamentoPendente, Boolean ativa, Set<TipoProcesso> tipos) {
        this.id = id;
        this.descricao = descricao;
        this.arquivamento = arquivamento;
        this.pagamentoPendente = pagamentoPendente;
        this.ativa = ativa;
        this.tipos = tipos;
    }

    @Generated
    public String toString() {
        return "Situacao(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Situacao)) {
            return false;
        }
        Situacao other = (Situacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Situacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

