/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Roteiro;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="roteirolocal")
@Audited
public class RoteiroLocal
implements EloEntity<Long> {
    @Id
    @NotNull
    @EloSequence(sequenceName="GEN_ROTEIROLOCAL", applyOnMerge=true)
    private Long id;
    @NotNull
    @ManyToOne
    @JsonIgnore
    @NotAudited
    private Entidade entidade;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="local", referencedColumnName="codigo"))})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Local local;
    @ManyToOne
    @JoinColumn(name="roteiro", insertable=true, updatable=true, nullable=true)
    @JsonIgnore
    @MetaModelIgnore
    private Roteiro roteiro;
    @Column(name="QTDEDIAS")
    private Long quantidadeDias;
    private Long sequencia;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean permiteArquivamento;

    public Long getQuantidadeDias() {
        return this.quantidadeDias;
    }

    public void setQuantidadeDias(Long quantidadeDias) {
        this.quantidadeDias = quantidadeDias;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public Local getLocal() {
        return this.local;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public Roteiro getRoteiro() {
        return this.roteiro;
    }

    public void setRoteiro(Roteiro roteiro) {
        this.roteiro = roteiro;
    }

    public Long getSequencia() {
        return this.sequencia;
    }

    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getPermiteArquivamento() {
        return Boolean.TRUE.equals(this.permiteArquivamento);
    }

    public void setPermiteArquivamento(Boolean permiteArquivamento) {
        this.permiteArquivamento = permiteArquivamento;
    }

    public static boolean permiteArquivamentoProcesso(List<RoteiroLocal> locais, Integer index, Local localTramite) {
        return locais.get(index).getPermiteArquivamento() != false && locais.get(index).getLocal().equals((Object)localTramite);
    }

    @Generated
    public String toString() {
        return "RoteiroLocal(id=" + this.getId() + ", entidade=" + String.valueOf(this.getEntidade()) + ", local=" + String.valueOf(this.getLocal()) + ", roteiro=" + String.valueOf(this.getRoteiro()) + ", quantidadeDias=" + this.getQuantidadeDias() + ", sequencia=" + this.getSequencia() + ", permiteArquivamento=" + this.getPermiteArquivamento() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoteiroLocal)) {
            return false;
        }
        RoteiroLocal other = (RoteiroLocal)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RoteiroLocal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

