/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.RoteiroLocal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="roteiro")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@DynamicInsert
@DynamicUpdate
@Audited
@FilterDef(name="byEntidade", defaultCondition="entidade = :idEntidade", parameters={@ParamDef(name="idEntidade", type="integer")})
@Filter(name="byEntidade")
public class Roteiro
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="GEN_ROTEIRO")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Caption(value="Descri\u00e7\u00e3o")
    @Length(max=250)
    @NotBlank
    private @Length(max=250) @NotBlank String descricao;
    @NotNull
    @ManyToOne
    @JsonIgnore
    @NotAudited
    private Entidade entidade;
    @OrderBy(value="sequencia")
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="roteiro")
    private List<RoteiroLocal> roteiroLocal = new ArrayList();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo = Boolean.TRUE;

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public List<RoteiroLocal> getRoteiroLocal() {
        return this.roteiroLocal;
    }

    public void setRoteiroLocal(List<RoteiroLocal> roteiroLocal) {
        this.roteiroLocal = roteiroLocal;
    }

    public List<RoteiroLocal> getRoteirosLocaisOrdenadoPorSequencia() {
        return this.getRoteiroLocal().stream().sorted(Comparator.comparingLong(RoteiroLocal::getSequencia)).collect(Collectors.toList());
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public String toString() {
        return "Roteiro(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Roteiro)) {
            return false;
        }
        Roteiro other = (Roteiro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Roteiro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

