/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoInteressado;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class ProtocoloMapperInteressado {
    public void mapToListProcessoInteressado(ProcessoDTO dto, Processo existing, Processo processo, BiFunction<ProcessoInteressadoDTO, ProcessoInteressado, ProcessoInteressado> toProcessoInteressadoFunc) {
        List<ProcessoInteressado> listToDelete = processo.getInteressados().stream().filter(arq -> !this.existsInteressado(dto, arq)).collect(Collectors.toList());
        listToDelete.forEach(arq -> processo.getInteressados().remove(arq));
        Long maxCodigo = dto.maxCodigoInteressado();
        for (ProcessoInteressadoDTO arq2 : dto.getInteressados()) {
            if (!arq2.isNew()) continue;
            ProcessoInteressado processoInteressado = toProcessoInteressadoFunc.apply(arq2, new ProcessoInteressado());
            processoInteressado.getId().setProcessoPK(existing.getId());
            maxCodigo = maxCodigo + 1L;
            processoInteressado.getId().setCodigo(maxCodigo);
            processo.getInteressados().add(processoInteressado);
        }
    }

    private boolean existsInteressado(ProcessoDTO processoDTO, ProcessoInteressado processoInteressado) {
        return processoDTO.getInteressados().stream().anyMatch(arq -> processoInteressado.getId().getCodigo().equals(arq.getCodigo()));
    }
}

