/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.AssuntoArquivo;
import br.com.elotech.protocolo.domain.AssuntoDocumento;
import br.com.elotech.protocolo.domain.AssuntoDocumentoPK;
import br.com.elotech.protocolo.domain.AssuntoEntidade;
import br.com.elotech.protocolo.domain.Bairro;
import br.com.elotech.protocolo.domain.Caixa;
import br.com.elotech.protocolo.domain.CaixaPK;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.domain.Contato;
import br.com.elotech.protocolo.domain.Coordenadoria;
import br.com.elotech.protocolo.domain.CoordenadoriaPK;
import br.com.elotech.protocolo.domain.Diretoria;
import br.com.elotech.protocolo.domain.DiretoriaPK;
import br.com.elotech.protocolo.domain.Documento;
import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.EnderecoPessoaPK;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Escolaridade;
import br.com.elotech.protocolo.domain.Exercicio;
import br.com.elotech.protocolo.domain.ExercicioPK;
import br.com.elotech.protocolo.domain.Gerencia;
import br.com.elotech.protocolo.domain.GerenciaPK;
import br.com.elotech.protocolo.domain.GrauSigilo;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.Logradouro;
import br.com.elotech.protocolo.domain.ModeloImpressao;
import br.com.elotech.protocolo.domain.Modulo;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroGrupo;
import br.com.elotech.protocolo.domain.ParametroPK;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.domain.ProcessoAndamentoAlteracaoRequerente;
import br.com.elotech.protocolo.domain.ProcessoAnexo;
import br.com.elotech.protocolo.domain.ProcessoAnexoPK;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.ProcessoArquivoPK;
import br.com.elotech.protocolo.domain.ProcessoAssinaturaConfig;
import br.com.elotech.protocolo.domain.ProcessoFavorito;
import br.com.elotech.protocolo.domain.ProcessoFavoritoPK;
import br.com.elotech.protocolo.domain.ProcessoInteressado;
import br.com.elotech.protocolo.domain.ProcessoInteressadoPK;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Roteiro;
import br.com.elotech.protocolo.domain.RoteiroLocal;
import br.com.elotech.protocolo.domain.Secretaria;
import br.com.elotech.protocolo.domain.SecretariaPK;
import br.com.elotech.protocolo.domain.Seletor;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoAndamento;
import br.com.elotech.protocolo.domain.TipoAusencia;
import br.com.elotech.protocolo.domain.TipoLogradouro;
import br.com.elotech.protocolo.domain.TipoNotificacao;
import br.com.elotech.protocolo.domain.TipoNotificacaoPK;
import br.com.elotech.protocolo.domain.TipoParticipante;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.TipoProcessoEntidade;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.TramitePK;
import br.com.elotech.protocolo.domain.Unidade;
import br.com.elotech.protocolo.domain.UnidadeFederacao;
import br.com.elotech.protocolo.domain.UnidadeOrcamentaria;
import br.com.elotech.protocolo.domain.UnidadeOrcamentariaPK;
import br.com.elotech.protocolo.domain.UnidadePK;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioAusencia;
import br.com.elotech.protocolo.domain.UsuarioEntidade;
import br.com.elotech.protocolo.domain.UsuarioEntidadePK;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioLocalPK;
import br.com.elotech.protocolo.domain.UsuarioModeloImpressao;
import br.com.elotech.protocolo.domain.UsuarioModeloImpressaoPK;
import br.com.elotech.protocolo.domain.UsuarioPermissao;
import br.com.elotech.protocolo.domain.UsuarioResponsavel;
import br.com.elotech.protocolo.domain.UsuarioSeletor;
import br.com.elotech.protocolo.domain.UsuarioSeletorPK;
import br.com.elotech.protocolo.domain.UsuarioTipoProcesso;
import br.com.elotech.protocolo.domain.UsuarioTipoProcessoPK;
import br.com.elotech.protocolo.domain.support.AuditInfo;
import br.com.elotech.protocolo.dto.AssuntoArquivoDTO;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.AssuntoDocumentoDTO;
import br.com.elotech.protocolo.dto.AssuntoEntidadeDTO;
import br.com.elotech.protocolo.dto.AssuntoPesquisaDTO;
import br.com.elotech.protocolo.dto.AuditInfoDTO;
import br.com.elotech.protocolo.dto.BairroDTO;
import br.com.elotech.protocolo.dto.CaixaDTO;
import br.com.elotech.protocolo.dto.CidadeDTO;
import br.com.elotech.protocolo.dto.CoordenadoriaDTO;
import br.com.elotech.protocolo.dto.DiretoriaDTO;
import br.com.elotech.protocolo.dto.DocumentoDTO;
import br.com.elotech.protocolo.dto.EnderecoPessoaDTO;
import br.com.elotech.protocolo.dto.EntidadeAutoCompleteDTO;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.EscolaridadeDTO;
import br.com.elotech.protocolo.dto.ExercicioDTO;
import br.com.elotech.protocolo.dto.GerenciaDTO;
import br.com.elotech.protocolo.dto.GrauSigiloDTO;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.LogradouroDTO;
import br.com.elotech.protocolo.dto.ModeloImpressaoDTO;
import br.com.elotech.protocolo.dto.ModuloDTO;
import br.com.elotech.protocolo.dto.ObservadorDTO;
import br.com.elotech.protocolo.dto.ParametroDTO;
import br.com.elotech.protocolo.dto.ParametroGrupoDTO;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoAlteracaoRequerenteDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoSimpleDTO;
import br.com.elotech.protocolo.dto.ProcessoAnexoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoAssinaturaDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoAssinaturaConfigDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoFavoritoDTO;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.dto.ProcessoPKDTO;
import br.com.elotech.protocolo.dto.RoteiroDTO;
import br.com.elotech.protocolo.dto.RoteiroLocalDTO;
import br.com.elotech.protocolo.dto.SecretariaDTO;
import br.com.elotech.protocolo.dto.SeletorDTO;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.dto.TipoAndamentoDTO;
import br.com.elotech.protocolo.dto.TipoAusenciaDTO;
import br.com.elotech.protocolo.dto.TipoLogradouroDTO;
import br.com.elotech.protocolo.dto.TipoNotificacaoDTO;
import br.com.elotech.protocolo.dto.TipoParticipanteDTO;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoEntidadeDTO;
import br.com.elotech.protocolo.dto.TipoProcessoSimpleDTO;
import br.com.elotech.protocolo.dto.TramiteDTO;
import br.com.elotech.protocolo.dto.UnidadeDTO;
import br.com.elotech.protocolo.dto.UnidadeFederacaoDTO;
import br.com.elotech.protocolo.dto.UnidadeOrcamentariaDTO;
import br.com.elotech.protocolo.dto.UserInfoDTO;
import br.com.elotech.protocolo.dto.UsuarioAusenciaDTO;
import br.com.elotech.protocolo.dto.UsuarioDTO;
import br.com.elotech.protocolo.dto.UsuarioEntidadeDTO;
import br.com.elotech.protocolo.dto.UsuarioLocalDTO;
import br.com.elotech.protocolo.dto.UsuarioModeloImpressaoDTO;
import br.com.elotech.protocolo.dto.UsuarioPermissaoDTO;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import br.com.elotech.protocolo.dto.UsuarioResponsavelDTO;
import br.com.elotech.protocolo.dto.UsuarioSimpleDTO;
import br.com.elotech.protocolo.dto.UsuarioTipoProcessoDTO;
import br.com.elotech.protocolo.dto.mp.DadosProcessoMPDTO;
import br.com.elotech.protocolo.enums.ParametroSistemaEnum;
import br.com.elotech.protocolo.enums.TipoAndamentoEnum;
import br.com.elotech.protocolo.enums.TipoGrauSigiloEnum;
import br.com.elotech.protocolo.enums.TipoModeloImpressaoEnum;
import br.com.elotech.protocolo.mp.domain.DadosProcessoMP;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="delegate")
public class ProtocoloMapperImpl_
implements ProtocoloMapper {
    public Processo toProcesso(ProcessoDTO dto, Processo existing) {
        if (dto == null) {
            return null;
        }
        existing.setFuncao(dto.getFuncao());
        existing.setData(dto.getLote());
        existing.setSenhaInternet(dto.getSenhaInternet());
        existing.setUnidade(this.toUnidade(dto.getUnidade()));
        existing.setDataProcesso(dto.getDataProcesso());
        existing.setComplementoAssunto(dto.getComplementoAssunto());
        existing.setDigitacao(dto.getDigitacao());
        existing.setNumeroAntigo(dto.getNumeroAntigo());
        existing.setUsuarioRegistro(dto.getUsuarioRegistro());
        existing.setObservacao(dto.getObservacao());
        existing.setZona(dto.getZona());
        existing.setQuadra(dto.getQuadra());
        existing.setCadastro(dto.getCadastro());
        existing.setProcessoReferencia(dto.getProcessoReferencia());
        existing.setSigiloso(dto.getSigiloso());
        existing.setGrauSigilo(this.toGrauSigilo(dto.getGrauSigilo()));
        existing.setExterno(dto.getExterno());
        existing.setUuid(dto.getUuid());
        existing.setIdProcessoTaxa(dto.getIdProcessoTaxa());
        existing.setCidadeAux(dto.getCidadeAux());
        existing.setUf(dto.getUf());
        existing.setCep(dto.getCep());
        existing.setEndereco(dto.getEndereco());
        existing.setNumeroEndereco(dto.getNumeroEndereco());
        existing.setComplemento(dto.getComplemento());
        existing.setBairroAux(dto.getBairroAux());
        existing.setProcessoAvaliado(dto.getProcessoAvaliado());
        existing.setOuvidoria(dto.getOuvidoria());
        existing.setOuvidoriaAnonima(dto.getOuvidoriaAnonima());
        existing.setUltimaAtualizacao(dto.getUltimaAtualizacao());
        existing.setEmail(dto.getEmail());
        existing.setCelular(dto.getCelular());
        existing.setParalisado(dto.getParalisado());
        existing.setPermiteAcessoUsuarioLogado(dto.isPermiteAcessoUsuarioLogado());
        existing.setEscolaridade(this.toEscolaridade(dto.getEscolaridade()));
        existing.setSexo(dto.getSexo());
        existing.setPrioridade(dto.getPrioridade());
        existing.setNota(dto.getNota());
        existing.setNotaObservacao(dto.getNotaObservacao());
        existing.setPrevisaoConclusao(dto.getPrevisaoConclusao());
        existing.setFechado(dto.getFechado());
        if (existing.getAndamentos() != null) {
            List list = this.processoAndamentoSimpleDTOListToProcessoAndamentoList(dto.getAndamentos());
            if (list != null) {
                existing.getAndamentos().clear();
                existing.getAndamentos().addAll(list);
            } else {
                existing.setAndamentos(null);
            }
        } else {
            List list = this.processoAndamentoSimpleDTOListToProcessoAndamentoList(dto.getAndamentos());
            if (list != null) {
                existing.setAndamentos(list);
            }
        }
        existing.setProcessoFisico(dto.getProcessoFisico());
        existing.setTramitaEntreEntidades(dto.getTramitaEntreEntidades());
        existing.setFilaIntegracaoAssinatura(dto.getFilaIntegracaoAssinatura());
        existing.setPrazoDesclassificacao(dto.getPrazoDesclassificacao());
        existing.setFundamentacaoLegal(dto.getFundamentacaoLegal());
        existing.setRequerimentoTributos(dto.getRequerimentoTributos());
        existing.setTipoOuvidoria(dto.getTipoOuvidoria());
        existing.setProcessoMp(this.toDadosProcessoMP(dto.getProcessoMp()));
        existing.setUsuarioAlteracao(dto.getUsuarioAlteracao());
        existing.setSolicitacaoJson(dto.getSolicitacaoJson());
        existing.setNumeroJaExistente(dto.getNumeroJaExistente());
        existing.setRoteiro(dto.getRoteiro());
        existing.setBloqueioAnexoExterno(dto.getBloqueioAnexoExterno());
        existing.setDenunciado(dto.getDenunciado());
        return existing;
    }

    public ProcessoAssinaturaConfig toProcessoAssinaturaConfig(ProcessoAssinaturaConfigDTO dto, ProcessoAssinaturaConfig existing) {
        if (dto == null) {
            return null;
        }
        existing.setEntidade(this.dtoEntidadeId(dto));
        existing.setParecerArquivamento(dto.getParecerArquivamento());
        existing.setId(dto.getId());
        return existing;
    }

    public ProcessoDTO toProcessoDTO(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoDTO processoDTO = new ProcessoDTO();
        processoDTO.setUsuarioResponsavelTramite(this.usuarioToUsuarioPermissaoLocalDTO(processo.getUsuarioResponsavelTramite()));
        processoDTO.setFuncao(processo.getFuncao());
        processoDTO.setTipo(this.toTipoProcessoSimpleDTO(this.processoIdTipo(processo)));
        processoDTO.setAno(this.processoIdAno(processo));
        processoDTO.setNumero(this.processoIdNumero(processo));
        processoDTO.setEndereco(processo.getEndereco());
        processoDTO.setLote(processo.getData());
        processoDTO.setProcessoMp(this.toDadosProcessoMPDTO(processo.getProcessoMp()));
        processoDTO.setBairroAux(processo.getBairroAux());
        processoDTO.setFundamentacaoLegal(processo.getFundamentacaoLegal());
        processoDTO.setPrazoDesclassificacao(processo.getPrazoDesclassificacao());
        processoDTO.setEntidade(this.toEntidadeDTO(this.processoIdEntidade(processo)));
        processoDTO.setNumeroEndereco(processo.getNumeroEndereco());
        processoDTO.setUf(processo.getUf());
        processoDTO.setCidadeAux(processo.getCidadeAux());
        processoDTO.setSenhaInternet(processo.getSenhaInternet());
        processoDTO.setPessoa(this.toPessoaDTO(processo.getPessoa()));
        processoDTO.setDataProcesso(processo.getDataProcesso());
        processoDTO.setSituacao(this.toSituacaoDTO(processo.getSituacao()));
        processoDTO.setAssunto(this.toAssuntoDTO(processo.getAssunto()));
        processoDTO.setComplementoAssunto(processo.getComplementoAssunto());
        processoDTO.setEmail(processo.getEmail());
        processoDTO.setCelular(processo.getCelular());
        processoDTO.setLocalOrigem(this.toLocalDTO(processo.getLocalOrigem()));
        processoDTO.setUnidade(this.toUnidadeDTO(processo.getUnidade()));
        processoDTO.setLocalDestino(this.toLocalDTO(processo.getLocalDestino()));
        processoDTO.setLocalAtual(this.toLocalDTO(processo.getLocalAtual()));
        processoDTO.setDigitacao(processo.getDigitacao());
        processoDTO.setUsuarioRegistro(processo.getUsuarioRegistro());
        processoDTO.setUsuarioAlteracao(processo.getUsuarioAlteracao());
        processoDTO.setSolicitacaoJson(processo.getSolicitacaoJson());
        processoDTO.setZona(processo.getZona());
        processoDTO.setQuadra(processo.getQuadra());
        processoDTO.setCadastro(processo.getCadastro());
        processoDTO.setSigiloso(processo.getSigiloso());
        processoDTO.setDataRegistro(processo.getDataRegistro());
        processoDTO.setTramites(this.tramiteListToTramiteDTOList(processo.getTramites()));
        processoDTO.setProcessosAnexos(this.processoAnexoListToProcessoAnexoDTOList(processo.getProcessosAnexos()));
        processoDTO.setArquivos(this.processoArquivoListToProcessoArquivoDTOList(processo.getArquivos()));
        processoDTO.setInteressados(this.processoInteressadoListToProcessoInteressadoDTOList(processo.getInteressados()));
        processoDTO.setObservacao(processo.getObservacao());
        processoDTO.setProcessoReferencia(processo.getProcessoReferencia());
        processoDTO.setExterno(processo.getExterno());
        processoDTO.setParalisado(processo.getParalisado());
        processoDTO.setGrauSigilo(this.toGrauSigiloDTO(processo.getGrauSigilo()));
        processoDTO.setUuid(processo.getUuid());
        processoDTO.setCep(processo.getCep());
        processoDTO.setComplemento(processo.getComplemento());
        processoDTO.setIdProcessoTaxa(processo.getIdProcessoTaxa());
        processoDTO.setBoletoPago(processo.getBoletoPago());
        processoDTO.setProcessoAvaliado(processo.getProcessoAvaliado());
        processoDTO.setOuvidoria(processo.getOuvidoria());
        processoDTO.setOuvidoriaAnonima(processo.getOuvidoriaAnonima());
        processoDTO.setUltimaAtualizacao(processo.getUltimaAtualizacao());
        processoDTO.setEscolaridade(this.toEscolaridadeDTO(processo.getEscolaridade()));
        processoDTO.setProcessoVencido(processo.getProcessoVencido());
        processoDTO.setFechado(processo.getFechado());
        processoDTO.setSexo(processo.getSexo());
        processoDTO.setNumeroAntigo(processo.getNumeroAntigo());
        processoDTO.setPermiteAcessoUsuarioLogado(processo.getPermiteAcessoUsuarioLogado());
        processoDTO.setPrioridade(processo.getPrioridade());
        processoDTO.setNota(processo.getNota());
        processoDTO.setNotaObservacao(processo.getNotaObservacao());
        processoDTO.setPrevisaoConclusao(processo.getPrevisaoConclusao());
        processoDTO.setAndamentos(this.processoAndamentoListToProcessoAndamentoSimpleDTOList(processo.getAndamentos()));
        processoDTO.setProcessoFisico(processo.getProcessoFisico());
        processoDTO.setTramitaEntreEntidades(processo.getTramitaEntreEntidades());
        processoDTO.setRequerimentoTributos(processo.getRequerimentoTributos());
        if (processo.hasFilaIntegracaoAssinatura()) {
            processoDTO.setFilaIntegracaoAssinatura(processo.getFilaIntegracaoAssinatura());
        }
        processoDTO.setNumeroJaExistente(processo.getNumeroJaExistente());
        processoDTO.setTipoOuvidoria(processo.getTipoOuvidoria());
        processoDTO.setRoteiro(processo.getRoteiro());
        processoDTO.setBloqueioAnexoExterno(processo.getBloqueioAnexoExterno());
        processoDTO.setDenunciado(processo.getDenunciado());
        processoDTO.setId(processo.getId().getKey());
        return processoDTO;
    }

    public ProcessoAssinaturaConfigDTO toProcessoAssinaturaConfigDTO(ProcessoAssinaturaConfig processoAssinaturaConfig) {
        if (processoAssinaturaConfig == null) {
            return null;
        }
        ProcessoAssinaturaConfigDTO processoAssinaturaConfigDTO = new ProcessoAssinaturaConfigDTO();
        processoAssinaturaConfigDTO.setEntidade(this.processoAssinaturaConfigToEntidadeDTO(processoAssinaturaConfig));
        processoAssinaturaConfigDTO.setAssunto(this.toAssuntoDTO(processoAssinaturaConfig.getAssunto()));
        processoAssinaturaConfigDTO.setSituacao(this.toSituacaoDTO(processoAssinaturaConfig.getSituacao()));
        processoAssinaturaConfigDTO.setPessoa(this.toPessoaDTO(processoAssinaturaConfig.getPessoa()));
        processoAssinaturaConfigDTO.setLocalDestino(this.toLocalDTO(processoAssinaturaConfig.getLocalDestino()));
        processoAssinaturaConfigDTO.setLocalOrigem(this.toLocalDTO(processoAssinaturaConfig.getLocalOrigem()));
        processoAssinaturaConfigDTO.setTipoIntegracao(processoAssinaturaConfig.getTipoIntegracao());
        processoAssinaturaConfigDTO.setId(processoAssinaturaConfig.getId());
        processoAssinaturaConfigDTO.setTipoProcesso(this.toTipoProcessoSimpleDTO(processoAssinaturaConfig.getTipoProcesso()));
        processoAssinaturaConfigDTO.setSituacaoArquivamento(this.toSituacaoDTO(processoAssinaturaConfig.getSituacaoArquivamento()));
        processoAssinaturaConfigDTO.setLocalArquivamento(this.toLocalDTO(processoAssinaturaConfig.getLocalArquivamento()));
        processoAssinaturaConfigDTO.setParecerArquivamento(processoAssinaturaConfig.getParecerArquivamento());
        return processoAssinaturaConfigDTO;
    }

    public Tramite toTramite(TramiteDTO dto, Tramite tramite) {
        if (dto == null) {
            return null;
        }
        if (dto.getSituacao() != null) {
            if (tramite.getSituacao() == null) {
                tramite.setSituacao(new Situacao());
            }
            this.toSituacao(dto.getSituacao(), tramite.getSituacao());
        } else {
            tramite.setSituacao(null);
        }
        tramite.setFuncao(dto.getFuncao());
        tramite.setData(dto.getData());
        tramite.setHora(dto.getHora());
        tramite.setParecer(dto.getParecer());
        if (dto.getLocal() != null) {
            if (tramite.getLocal() == null) {
                tramite.setLocal(new Local());
            }
            this.toLocal(dto.getLocal(), tramite.getLocal());
        } else {
            tramite.setLocal(null);
        }
        tramite.setUsuarioRegistro(dto.getUsuarioRegistro());
        tramite.setDataRegistro(dto.getDataRegistro());
        if (dto.getCaixa() != null) {
            if (tramite.getCaixa() == null) {
                tramite.setCaixa(new Caixa());
            }
            this.toCaixa(dto.getCaixa(), tramite.getCaixa());
        } else {
            tramite.setCaixa(null);
        }
        tramite.setParecerResposta(dto.getParecerResposta());
        tramite.setDataParecerResposta(dto.getDataParecerResposta());
        tramite.setLote(dto.getLote());
        tramite.setQuantidadeFolhas(dto.getQuantidadeFolhas());
        tramite.setNotaPrivada(dto.getNotaPrivada());
        return tramite;
    }

    public TramiteDTO tramiteToDTO(Tramite tramite) {
        if (tramite == null) {
            return null;
        }
        TramiteDTO tramiteDTO = new TramiteDTO();
        tramiteDTO.setNomeUsuario(this.tramiteUsuarioNome(tramite));
        tramiteDTO.setSequencia(this.tramiteIdSequencia(tramite));
        tramiteDTO.setUsuarioResponsavelTramite(this.tramiteUsuarioResponsavelTramiteId(tramite));
        tramiteDTO.setSituacao(this.toSituacaoDTO(tramite.getSituacao()));
        tramiteDTO.setFuncao(tramite.getFuncao());
        tramiteDTO.setData(tramite.getData());
        tramiteDTO.setHora(tramite.getHora());
        tramiteDTO.setParecer(tramite.getParecer());
        tramiteDTO.setParecerResposta(tramite.getParecerResposta());
        tramiteDTO.setDataParecerResposta(tramite.getDataParecerResposta());
        tramiteDTO.setUsuarioRegistro(tramite.getUsuarioRegistro());
        tramiteDTO.setDataRegistro(tramite.getDataRegistro());
        tramiteDTO.setLote(tramite.getLote());
        tramiteDTO.setLocal(this.toLocalDTO(tramite.getLocal()));
        tramiteDTO.setCaixa(this.toCaixaDTO(tramite.getCaixa()));
        tramiteDTO.setQuantidadeFolhas(tramite.getQuantidadeFolhas());
        tramiteDTO.setNotaPrivada(tramite.getNotaPrivada());
        return tramiteDTO;
    }

    public TramitePK toTramitePK(TramiteDTO dto) {
        if (dto == null) {
            return null;
        }
        TramitePK tramitePK = new TramitePK();
        tramitePK.setSequencia(dto.getSequencia());
        return tramitePK;
    }

    public ProcessoFavorito toProcessoFavorito(ProcessoFavoritoDTO dto) {
        if (dto == null) {
            return null;
        }
        ProcessoFavorito processoFavorito = new ProcessoFavorito();
        processoFavorito.setId(this.processoFavoritoDTOToProcessoFavoritoPK(dto));
        return processoFavorito;
    }

    public ProcessoFavoritoDTO toProcessoFavoritoDTO(ProcessoFavorito entity) {
        if (entity == null) {
            return null;
        }
        ProcessoFavoritoDTO processoFavoritoDTO = new ProcessoFavoritoDTO();
        processoFavoritoDTO.setEntidade(this.toEntidadeDTO(this.entityIdProcessoIdEntidade(entity)));
        processoFavoritoDTO.setTipo(this.toTipoProcessoSimpleDTO(this.entityIdProcessoIdTipo(entity)));
        processoFavoritoDTO.setUsuario(this.entityIdUsuarioId(entity));
        processoFavoritoDTO.setAno(this.entityIdProcessoIdAno(entity));
        processoFavoritoDTO.setNumero(this.entityIdProcessoIdNumero(entity));
        processoFavoritoDTO.setId(entity.getId().getProcesso().getId().getKey());
        return processoFavoritoDTO;
    }

    public ProcessoArquivoPK toProcessoArquivoPK(ProcessoArquivoDTO dto) {
        if (dto == null) {
            return null;
        }
        ProcessoArquivoPK processoArquivoPK = new ProcessoArquivoPK();
        processoArquivoPK.setSequencia(dto.getSequencia());
        return processoArquivoPK;
    }

    public ProcessoArquivo toProcessoArquivo(ProcessoArquivoDTO dto, ProcessoArquivo processoArquivo) {
        if (dto == null) {
            return null;
        }
        processoArquivo.setNome(dto.getNome());
        processoArquivo.setDescricao(dto.getDescricao());
        processoArquivo.setIdentificador(dto.getIdentificador());
        processoArquivo.setUrlS3(dto.getUrlS3());
        processoArquivo.setOrdem(dto.getOrdem());
        processoArquivo.setIdAndamento(dto.getIdAndamento());
        processoArquivo.setSequenciaTramitacao(dto.getSequenciaTramitacao());
        processoArquivo.setUsuario(dto.getUsuario());
        processoArquivo.setUsuarioNome(dto.getUsuarioNome());
        processoArquivo.setDataCriacao(dto.getDataCriacao());
        processoArquivo.setAgrupamento(dto.getAgrupamento());
        if (dto.getDocumento() != null) {
            if (processoArquivo.getDocumento() == null) {
                processoArquivo.setDocumento(new Documento());
            }
            this.toDocumento(dto.getDocumento(), processoArquivo.getDocumento());
        } else {
            processoArquivo.setDocumento(null);
        }
        processoArquivo.setAnalise(dto.getAnalise());
        processoArquivo.setMotivoRecusa(dto.getMotivoRecusa());
        processoArquivo.setSigiloExterno(dto.getSigiloExterno());
        processoArquivo.setSalvoPeloSistema(dto.getSalvoPeloSistema());
        processoArquivo.setQtdAssinaturas(dto.getQtdAssinaturas());
        processoArquivo.setQtdAssinaturasPendentes(dto.getQtdAssinaturasPendentes());
        processoArquivo.setCancelado(dto.getCancelado());
        processoArquivo.setMotivoCancelamento(dto.getMotivoCancelamento());
        processoArquivo.setDataCancelamento(dto.getDataCancelamento());
        processoArquivo.setTipoIntegracaoAssinatura(dto.getTipoIntegracaoAssinatura());
        processoArquivo.setIdIntegracaoAssinatura(dto.getIdIntegracaoAssinatura());
        processoArquivo.setFilaIntegracaoAssinatura(dto.getFilaIntegracaoAssinatura());
        processoArquivo.setObrigaPosicionamentoAssinatura(dto.getObrigaPosicionamentoAssinatura());
        return processoArquivo;
    }

    public ProcessoArquivoDTO toProcessoArquivoDTO(ProcessoArquivo processoArquivo) {
        if (processoArquivo == null) {
            return null;
        }
        ProcessoArquivoDTO processoArquivoDTO = new ProcessoArquivoDTO();
        processoArquivoDTO.setSequencia(this.processoArquivoIdSequencia(processoArquivo));
        processoArquivoDTO.setNome(processoArquivo.getNome());
        processoArquivoDTO.setDescricao(processoArquivo.getDescricao());
        processoArquivoDTO.setIdArquivo(processoArquivo.getIdArquivo());
        processoArquivoDTO.setUrlS3(processoArquivo.getUrlS3());
        processoArquivoDTO.setIdentificador(processoArquivo.getIdentificador());
        processoArquivoDTO.setSequenciaTramitacao(processoArquivo.getSequenciaTramitacao());
        processoArquivoDTO.setUsuario(processoArquivo.getUsuario());
        processoArquivoDTO.setUsuarioNome(processoArquivo.getUsuarioNome());
        processoArquivoDTO.setOrdem(processoArquivo.getOrdem());
        processoArquivoDTO.setIdAndamento(processoArquivo.getIdAndamento());
        processoArquivoDTO.setDataCriacao(processoArquivo.getDataCriacao());
        processoArquivoDTO.setAgrupamento(processoArquivo.getAgrupamento());
        processoArquivoDTO.setDocumento(this.toDocumentoDTO(processoArquivo.getDocumento()));
        processoArquivoDTO.setAnalise(processoArquivo.getAnalise());
        processoArquivoDTO.setMotivoRecusa(processoArquivo.getMotivoRecusa());
        processoArquivoDTO.setSigiloExterno(processoArquivo.getSigiloExterno());
        processoArquivoDTO.setSalvoPeloSistema(processoArquivo.getSalvoPeloSistema());
        processoArquivoDTO.setAssinaturas(this.processoArquivoAssinaturaListToProcessoArquivoAssinaturaDTOList(processoArquivo.getAssinaturas()));
        processoArquivoDTO.setQtdAssinaturas(processoArquivo.getQtdAssinaturas());
        processoArquivoDTO.setQtdAssinaturasPendentes(processoArquivo.getQtdAssinaturasPendentes());
        processoArquivoDTO.setCancelado(processoArquivo.getCancelado());
        processoArquivoDTO.setMotivoCancelamento(processoArquivo.getMotivoCancelamento());
        processoArquivoDTO.setDataCancelamento(processoArquivo.getDataCancelamento());
        processoArquivoDTO.setSituacao(processoArquivo.getSituacao());
        processoArquivoDTO.setTipoIntegracaoAssinatura(processoArquivo.getTipoIntegracaoAssinatura());
        processoArquivoDTO.setIdIntegracaoAssinatura(processoArquivo.getIdIntegracaoAssinatura());
        processoArquivoDTO.setFilaIntegracaoAssinatura(processoArquivo.getFilaIntegracaoAssinatura());
        processoArquivoDTO.setObrigaPosicionamentoAssinatura(processoArquivo.getObrigaPosicionamentoAssinatura());
        return processoArquivoDTO;
    }

    public LocalPK toLocalPK(LocalDTO localDto) {
        if (localDto == null) {
            return null;
        }
        LocalPK localPK = new LocalPK();
        localPK.setEntidade(this.toEntidade(localDto.getEntidade()));
        localPK.setId(localDto.getId());
        return localPK;
    }

    public Local toLocal(LocalDTO localDTO, Local existing) {
        if (localDTO == null) {
            return null;
        }
        if (localDTO.getRoteiroAtivo() != null) {
            existing.setRoteiroAtivo(localDTO.getRoteiroAtivo().booleanValue());
        }
        existing.setDescricao(localDTO.getDescricao());
        existing.setAtivo(localDTO.getAtivo());
        existing.setSigla(localDTO.getSigla());
        existing.setTelefone(localDTO.getTelefone());
        existing.setEmail(localDTO.getEmail());
        existing.setQuantidadeFilhos(localDTO.getQuantidadeFilhos());
        existing.setId(this.toLocalPK(localDTO));
        return existing;
    }

    public Local toLocal(LocalDTO localDTO) {
        if (localDTO == null) {
            return null;
        }
        Local local = new Local();
        if (localDTO.getRoteiroAtivo() != null) {
            local.setRoteiroAtivo(localDTO.getRoteiroAtivo().booleanValue());
        }
        local.setDescricao(localDTO.getDescricao());
        local.setAtivo(localDTO.getAtivo());
        local.setDiretoria(this.toDiretoria(localDTO.getDiretoria()));
        local.setGerencia(this.toGerencia(localDTO.getGerencia()));
        local.setCoordenadoria(this.toCoordenadoria(localDTO.getCoordenadoria()));
        local.setUnidadeOrcamentaria(this.toUnidadeOrcamentaria(localDTO.getUnidadeOrcamentaria()));
        local.setSigla(localDTO.getSigla());
        local.setTelefone(localDTO.getTelefone());
        local.setEmail(localDTO.getEmail());
        local.setLocalPai(this.toLocal(localDTO.getLocalPai()));
        local.setQuantidadeFilhos(localDTO.getQuantidadeFilhos());
        local.setId(this.toLocalPK(localDTO));
        return local;
    }

    public LocalDTO toLocalDTO(Local local) {
        if (local == null) {
            return null;
        }
        LocalDTO.LocalDTOBuilder localDTO = LocalDTO.builder();
        localDTO.entidade(this.toEntidadeDTO(this.localIdEntidade(local)));
        localDTO.id(this.localIdId(local));
        localDTO.descricao(local.getDescricao());
        localDTO.ativo(local.getAtivo());
        localDTO.sigla(local.getSigla());
        localDTO.telefone(local.getTelefone());
        localDTO.diretoria(this.toDiretoriaDTO(local.getDiretoria()));
        localDTO.gerencia(this.toGerenciaDTO(local.getGerencia()));
        localDTO.coordenadoria(this.toCoordenadoriaDTO(local.getCoordenadoria()));
        localDTO.responsavel(this.toUsuarioResponsavelDTO(local.getResponsavel()));
        localDTO.unidadeOrcamentaria(this.toUnidadeOrcamentariaDTO(local.getUnidadeOrcamentaria()));
        localDTO.email(local.getEmail());
        localDTO.localPai(this.toLocalDTO(local.getLocalPai()));
        localDTO.quantidadeFilhos(local.getQuantidadeFilhos());
        localDTO.roteiroAtivo(Boolean.valueOf(local.getRoteiroAtivo()));
        return localDTO.build();
    }

    public Entidade toEntidade(EntidadeDTO entidadeDTO) {
        if (entidadeDTO == null) {
            return null;
        }
        Entidade entidade = new Entidade();
        entidade.setId(entidadeDTO.getId());
        entidade.setNome(entidadeDTO.getNome());
        return entidade;
    }

    public EntidadeDTO toEntidadeDTO(Entidade entidade) {
        if (entidade == null) {
            return null;
        }
        EntidadeDTO entidadeDTO = new EntidadeDTO();
        entidadeDTO.setId(entidade.getId());
        entidadeDTO.setNome(entidade.getNome());
        entidadeDTO.setPrincipal(entidade.isPrincipal());
        return entidadeDTO;
    }

    public Pessoa toPessoa(PessoaDTO pessoaDTO, Pessoa existing) {
        if (pessoaDTO == null) {
            return null;
        }
        existing.setSequenciaEndereco(this.pessoaDTOEnderecoPrincipalId(pessoaDTO));
        existing.setId(pessoaDTO.getId());
        existing.setNome(pessoaDTO.getNome());
        existing.setCargo(pessoaDTO.getCargo());
        existing.setRg(pessoaDTO.getRg());
        existing.setCnpjCpf(pessoaDTO.getCnpjCpf());
        existing.setTipoPessoa(pessoaDTO.getTipoPessoa());
        existing.setAtivo(pessoaDTO.getAtivo());
        existing.setIdUnico(pessoaDTO.getIdUnico());
        existing.setDataNascimento(pessoaDTO.getDataNascimento());
        existing.setDadosSigilosos(pessoaDTO.getDadosSigilosos());
        if (existing.getEnderecos() != null) {
            existing.getEnderecos().clear();
            List list = this.enderecoPessoaDTOListToEnderecoPessoaList(pessoaDTO.getEnderecos());
            if (list != null) {
                existing.getEnderecos().addAll(list);
            }
        }
        existing.setContato(this.toContato(pessoaDTO));
        return existing;
    }

    public Pessoa toPessoa(PessoaDTO pessoaDTO) {
        List list;
        if (pessoaDTO == null) {
            return null;
        }
        Pessoa pessoa = new Pessoa();
        pessoa.setSequenciaEndereco(this.pessoaDTOEnderecoPrincipalId(pessoaDTO));
        pessoa.setId(pessoaDTO.getId());
        pessoa.setNome(pessoaDTO.getNome());
        pessoa.setCargo(pessoaDTO.getCargo());
        pessoa.setRg(pessoaDTO.getRg());
        pessoa.setCnpjCpf(pessoaDTO.getCnpjCpf());
        pessoa.setTipoPessoa(pessoaDTO.getTipoPessoa());
        pessoa.setAtivo(pessoaDTO.getAtivo());
        pessoa.setIdUnico(pessoaDTO.getIdUnico());
        pessoa.setDataNascimento(pessoaDTO.getDataNascimento());
        pessoa.setDadosSigilosos(pessoaDTO.getDadosSigilosos());
        if (pessoa.getEnderecos() != null && (list = this.enderecoPessoaDTOListToEnderecoPessoaList(pessoaDTO.getEnderecos())) != null) {
            pessoa.getEnderecos().addAll(list);
        }
        pessoa.setContato(this.toContato(pessoaDTO));
        return pessoa;
    }

    public PessoaDTO toPessoaDTO(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        PessoaDTO.PessoaDTOBuilder pessoaDTO = PessoaDTO.builder();
        pessoaDTO.celular(this.pessoaContatoCelular(pessoa));
        pessoaDTO.telefone(this.pessoaContatoTelefone(pessoa));
        pessoaDTO.email(this.pessoaContatoEmail(pessoa));
        pessoaDTO.id(pessoa.getId());
        pessoaDTO.tipoPessoa(pessoa.getTipoPessoa());
        pessoaDTO.nome(pessoa.getNome());
        pessoaDTO.cnpjCpf(pessoa.getCnpjCpf());
        pessoaDTO.cargo(pessoa.getCargo());
        pessoaDTO.rg(pessoa.getRg());
        pessoaDTO.enderecoPrincipal(this.toEnderecoPessoaDTO(pessoa.getEnderecoPrincipal()));
        pessoaDTO.enderecos(this.enderecoPessoaListToEnderecoPessoaDTOList(pessoa.getEnderecos()));
        pessoaDTO.ativo(pessoa.getAtivo());
        pessoaDTO.idUnico(pessoa.getIdUnico());
        pessoaDTO.dataNascimento(pessoa.getDataNascimento());
        pessoaDTO.dadosSigilosos(pessoa.getDadosSigilosos());
        return pessoaDTO.build();
    }

    public Bairro toBairro(BairroDTO bairroDTO) {
        if (bairroDTO == null) {
            return null;
        }
        Bairro bairro = new Bairro();
        bairro.setDescricao(bairroDTO.getDescricao());
        bairro.setId(bairroDTO.getId());
        bairro.setCidade(this.toCidade(bairroDTO.getCidade()));
        bairro.setAtivo(bairroDTO.getAtivo());
        return bairro;
    }

    public Bairro toBairro(BairroDTO dto, Bairro existing) {
        if (dto == null) {
            return null;
        }
        existing.setDescricao(dto.getDescricao());
        existing.setId(dto.getId());
        if (dto.getCidade() != null) {
            if (existing.getCidade() == null) {
                existing.setCidade(new Cidade());
            }
            this.toCidade(dto.getCidade(), existing.getCidade());
        } else {
            existing.setCidade(null);
        }
        existing.setAtivo(dto.getAtivo());
        return existing;
    }

    public BairroDTO toBairroDTO(Bairro bairro) {
        if (bairro == null) {
            return null;
        }
        BairroDTO bairroDTO = new BairroDTO();
        bairroDTO.setAtivo(bairro.getAtivo());
        bairroDTO.setId(bairro.getId());
        bairroDTO.setDescricao(bairro.getDescricao());
        bairroDTO.setCidade(this.toCidadeDTO(bairro.getCidade()));
        return bairroDTO;
    }

    public ProcessoAnexo toProcessoAnexo(ProcessoAnexoDTO processoAnexoDTO, ProcessoAnexo existing) {
        if (processoAnexoDTO == null) {
            return null;
        }
        existing.setData(processoAnexoDTO.getData());
        existing.setUsuario(processoAnexoDTO.getUsuario());
        existing.setUnidade(this.toUnidade(processoAnexoDTO.getUnidade()));
        return existing;
    }

    public ProcessoAnexoDTO toProcessoAnexoDTO(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        ProcessoAnexoDTO processoAnexoDTO = new ProcessoAnexoDTO();
        processoAnexoDTO.setEntidade(this.toEntidadeDTO(this.processoAnexoProcessoIdEntidade(processoAnexo)));
        processoAnexoDTO.setTipoAnexo(this.toTipoProcessoSimpleDTO(this.processoAnexoIdTipoAnexo(processoAnexo)));
        processoAnexoDTO.setSequencia(this.processoAnexoIdSequencia(processoAnexo));
        processoAnexoDTO.setTipo(this.toTipoProcessoSimpleDTO(this.processoAnexoProcessoIdTipo(processoAnexo)));
        processoAnexoDTO.setAno(this.processoAnexoProcessoIdAno(processoAnexo));
        processoAnexoDTO.setNumeroAnexo(this.processoAnexoIdNumeroAnexo(processoAnexo));
        processoAnexoDTO.setNumero(this.processoAnexoProcessoIdNumero(processoAnexo));
        processoAnexoDTO.setEntidadeAnexo(this.toEntidadeDTO(this.processoAnexoIdEntidadeAnexo(processoAnexo)));
        processoAnexoDTO.setAnoAnexo(this.processoAnexoIdAnoAnexo(processoAnexo));
        processoAnexoDTO.setUnidade(this.toUnidadeDTO(processoAnexo.getUnidade()));
        processoAnexoDTO.setData(processoAnexo.getData());
        processoAnexoDTO.setUsuario(processoAnexo.getUsuario());
        return processoAnexoDTO;
    }

    public TipoLogradouro toTipoLogradouro(TipoLogradouroDTO dto) {
        if (dto == null) {
            return null;
        }
        TipoLogradouro tipoLogradouro = new TipoLogradouro();
        tipoLogradouro.setId(dto.getId());
        tipoLogradouro.setDescricao(dto.getDescricao());
        return tipoLogradouro;
    }

    public TipoLogradouroDTO toTipoLogradouroDTO(TipoLogradouro tipoLogradouro) {
        if (tipoLogradouro == null) {
            return null;
        }
        TipoLogradouroDTO tipoLogradouroDTO = new TipoLogradouroDTO();
        tipoLogradouroDTO.setId(tipoLogradouro.getId());
        tipoLogradouroDTO.setDescricao(tipoLogradouro.getDescricao());
        return tipoLogradouroDTO;
    }

    public Logradouro toLogradouro(LogradouroDTO logradouroDTO, Logradouro existing) {
        if (logradouroDTO == null) {
            return null;
        }
        existing.setDescricao(logradouroDTO.getDescricao());
        existing.setId(logradouroDTO.getId());
        existing.setTipoLogradouro(this.toTipoLogradouro(logradouroDTO.getTipoLogradouro()));
        if (logradouroDTO.getCidade() != null) {
            if (existing.getCidade() == null) {
                existing.setCidade(new Cidade());
            }
            this.toCidade(logradouroDTO.getCidade(), existing.getCidade());
        } else {
            existing.setCidade(null);
        }
        existing.setAtivo(logradouroDTO.getAtivo());
        return existing;
    }

    public Logradouro toLogradouro(LogradouroDTO logradouroDTO) {
        if (logradouroDTO == null) {
            return null;
        }
        Logradouro logradouro = new Logradouro();
        logradouro.setDescricao(logradouroDTO.getDescricao());
        logradouro.setId(logradouroDTO.getId());
        logradouro.setTipoLogradouro(this.toTipoLogradouro(logradouroDTO.getTipoLogradouro()));
        logradouro.setCidade(this.toCidade(logradouroDTO.getCidade()));
        logradouro.setAtivo(logradouroDTO.getAtivo());
        return logradouro;
    }

    public LogradouroDTO toLogradouroDTO(Logradouro logradouro) {
        if (logradouro == null) {
            return null;
        }
        LogradouroDTO logradouroDTO = new LogradouroDTO();
        logradouroDTO.setId(logradouro.getId());
        logradouroDTO.setTipoLogradouro(this.toTipoLogradouroDTO(logradouro.getTipoLogradouro()));
        logradouroDTO.setDescricao(logradouro.getDescricao());
        logradouroDTO.setCidade(this.toCidadeDTO(logradouro.getCidade()));
        logradouroDTO.setAtivo(logradouro.getAtivo());
        return logradouroDTO;
    }

    public Contato toContato(PessoaDTO pessoaDTO) {
        if (pessoaDTO == null) {
            return null;
        }
        Contato contato = new Contato();
        contato.setTelefone(pessoaDTO.getTelefone());
        contato.setCelular(pessoaDTO.getCelular());
        contato.setEmail(pessoaDTO.getEmail());
        return contato;
    }

    public UnidadeFederacao toUnidadeFederacao(UnidadeFederacaoDTO dto) {
        if (dto == null) {
            return null;
        }
        UnidadeFederacao unidadeFederacao = new UnidadeFederacao();
        unidadeFederacao.setId(dto.getId());
        unidadeFederacao.setDescricao(dto.getDescricao());
        return unidadeFederacao;
    }

    public UnidadeFederacaoDTO toUnidadeFederacao(UnidadeFederacao uf) {
        if (uf == null) {
            return null;
        }
        UnidadeFederacaoDTO unidadeFederacaoDTO = new UnidadeFederacaoDTO();
        unidadeFederacaoDTO.setId(uf.getId());
        unidadeFederacaoDTO.setDescricao(uf.getDescricao());
        return unidadeFederacaoDTO;
    }

    public Cidade toCidade(CidadeDTO cidadeDTO) {
        if (cidadeDTO == null) {
            return null;
        }
        Cidade cidade = new Cidade();
        cidade.setId(cidadeDTO.getId());
        cidade.setUf(this.toUnidadeFederacao(cidadeDTO.getUf()));
        cidade.setDescricao(cidadeDTO.getDescricao());
        cidade.setAtivo(cidadeDTO.getAtivo());
        return cidade;
    }

    public Cidade toCidade(CidadeDTO dto, Cidade existing) {
        if (dto == null) {
            return null;
        }
        existing.setId(dto.getId());
        existing.setUf(this.toUnidadeFederacao(dto.getUf()));
        existing.setDescricao(dto.getDescricao());
        existing.setAtivo(dto.getAtivo());
        return existing;
    }

    public CidadeDTO toCidadeDTO(Cidade cidade) {
        if (cidade == null) {
            return null;
        }
        CidadeDTO cidadeDTO = new CidadeDTO();
        cidadeDTO.setId(cidade.getId());
        cidadeDTO.setUf(this.toUnidadeFederacao(cidade.getUf()));
        cidadeDTO.setDescricao(cidade.getDescricao());
        cidadeDTO.setAtivo(cidade.getAtivo());
        return cidadeDTO;
    }

    public EnderecoPessoa toEnderecoPessoa(EnderecoPessoaDTO enderecoPessoaDTO) {
        if (enderecoPessoaDTO == null) {
            return null;
        }
        EnderecoPessoa enderecoPessoa = new EnderecoPessoa();
        enderecoPessoa.setTipoEndereco(enderecoPessoaDTO.getTipoEndereco());
        enderecoPessoa.setNumero(enderecoPessoaDTO.getNumero());
        enderecoPessoa.setComplemento(enderecoPessoaDTO.getComplemento());
        enderecoPessoa.setEndereco(enderecoPessoaDTO.getEndereco());
        enderecoPessoa.setUf(this.toUnidadeFederacao(enderecoPessoaDTO.getUf()));
        enderecoPessoa.setCidade(this.toCidade(enderecoPessoaDTO.getCidade()));
        enderecoPessoa.setLogradouro(this.toLogradouro(enderecoPessoaDTO.getLogradouro()));
        enderecoPessoa.setBairro(this.toBairro(enderecoPessoaDTO.getBairro()));
        enderecoPessoa.setCep(enderecoPessoaDTO.getCep());
        enderecoPessoa.setPk(this.toEnderecoPessoaPK(enderecoPessoaDTO));
        return enderecoPessoa;
    }

    public EnderecoPessoaDTO toEnderecoPessoaDTO(EnderecoPessoa enderecoPessoa) {
        if (enderecoPessoa == null) {
            return null;
        }
        EnderecoPessoaDTO enderecoPessoaDTO = new EnderecoPessoaDTO();
        enderecoPessoaDTO.setId(this.enderecoPessoaPkCodigo(enderecoPessoa));
        enderecoPessoaDTO.setTipoEndereco(enderecoPessoa.getTipoEndereco());
        enderecoPessoaDTO.setEndereco(enderecoPessoa.getEndereco());
        enderecoPessoaDTO.setNumero(enderecoPessoa.getNumero());
        enderecoPessoaDTO.setComplemento(enderecoPessoa.getComplemento());
        enderecoPessoaDTO.setCep(enderecoPessoa.getCep());
        enderecoPessoaDTO.setCidade(this.toCidadeDTO(enderecoPessoa.getCidade()));
        enderecoPessoaDTO.setLogradouro(this.toLogradouroDTO(enderecoPessoa.getLogradouro()));
        enderecoPessoaDTO.setBairro(this.toBairroDTO(enderecoPessoa.getBairro()));
        enderecoPessoaDTO.setUf(this.toUnidadeFederacao(enderecoPessoa.getUf()));
        enderecoPessoaDTO.setEnderecoFormatado(enderecoPessoa.getEnderecoFormatado());
        return enderecoPessoaDTO;
    }

    public EnderecoPessoaPK toEnderecoPessoaPK(EnderecoPessoaDTO enderecoPessoaDTO) {
        if (enderecoPessoaDTO == null) {
            return null;
        }
        EnderecoPessoaPK enderecoPessoaPK = new EnderecoPessoaPK();
        enderecoPessoaPK.setCodigo(enderecoPessoaDTO.getId());
        return enderecoPessoaPK;
    }

    public CaixaDTO toCaixaDTO(Caixa caixa) {
        if (caixa == null) {
            return null;
        }
        CaixaDTO caixaDTO = new CaixaDTO();
        caixaDTO.setCodigo(this.caixaIdCodigo(caixa));
        caixaDTO.setAno(this.caixaIdAno(caixa));
        caixaDTO.setNumero(caixa.getNumero());
        caixaDTO.setDescricao(caixa.getDescricao());
        caixaDTO.setLocalizacao(caixa.getLocalizacao());
        caixaDTO.setAtivo(caixa.getAtivo());
        caixaDTO.setId(caixa.getId().getKey());
        return caixaDTO;
    }

    public Caixa toCaixa(CaixaDTO caixa) {
        if (caixa == null) {
            return null;
        }
        Caixa caixa1 = new Caixa();
        caixa1.setDescricao(caixa.getDescricao());
        caixa1.setAtivo(caixa.getAtivo());
        caixa1.setNumero(caixa.getNumero());
        caixa1.setLocalizacao(caixa.getLocalizacao());
        caixa1.setId(this.toCaixaPK(caixa.getCodigo(), caixa.getAno()));
        return caixa1;
    }

    public Caixa toCaixa(CaixaDTO caixa, Caixa existing) {
        if (caixa == null) {
            return null;
        }
        existing.setDescricao(caixa.getDescricao());
        existing.setAtivo(caixa.getAtivo());
        existing.setNumero(caixa.getNumero());
        existing.setLocalizacao(caixa.getLocalizacao());
        existing.setId(this.toCaixaPK(caixa.getCodigo(), caixa.getAno()));
        return existing;
    }

    public CaixaPK toCaixaPK(Long id, Long ano) {
        if (id == null && ano == null) {
            return null;
        }
        CaixaPK caixaPK = new CaixaPK();
        if (id != null) {
            caixaPK.setCodigo(id);
        }
        if (ano != null) {
            caixaPK.setAno(ano);
        }
        return caixaPK;
    }

    public UsuarioPermissao toUsuarioPermissao(UsuarioSeletor usuarioSeletor) {
        if (usuarioSeletor == null) {
            return null;
        }
        UsuarioPermissao usuarioPermissao = new UsuarioPermissao();
        usuarioPermissao.setNome(this.usuarioSeletorIdSeletorId(usuarioSeletor));
        usuarioPermissao.setInserir(usuarioSeletor.getInserir());
        usuarioPermissao.setAlterar(usuarioSeletor.getAlterar());
        usuarioPermissao.setExcluir(usuarioSeletor.getExcluir());
        return usuarioPermissao;
    }

    public Assunto toAssunto(AssuntoDTO assuntoDTO, Assunto existing) {
        if (assuntoDTO == null) {
            return null;
        }
        existing.setTermoAceite(assuntoDTO.getTermoAceite());
        existing.setId(assuntoDTO.getId());
        existing.setDescricao(assuntoDTO.getDescricao());
        existing.setAssuntoInterno(assuntoDTO.getAssuntoInterno());
        existing.setPossuiTaxas(assuntoDTO.getPossuiTaxas());
        existing.setAtivo(assuntoDTO.getAtivo());
        existing.setSigiloso(assuntoDTO.getSigiloso());
        existing.setPossuiParticipantesExtrasExterno(assuntoDTO.getPossuiParticipantesExtrasExterno());
        existing.setMensagem(assuntoDTO.getMensagem());
        existing.setComplemento(assuntoDTO.getComplemento());
        if (existing.getAssuntoDocumento() != null) {
            list = this.assuntoDocumentoDTOListToAssuntoDocumentoList(assuntoDTO.getAssuntoDocumento());
            if (list != null) {
                existing.getAssuntoDocumento().clear();
                existing.getAssuntoDocumento().addAll(list);
            } else {
                existing.setAssuntoDocumento(null);
            }
        } else {
            list = this.assuntoDocumentoDTOListToAssuntoDocumentoList(assuntoDTO.getAssuntoDocumento());
            if (list != null) {
                existing.setAssuntoDocumento(list);
            }
        }
        if (existing.getAssuntoEntidade() != null) {
            list1 = this.assuntoEntidadeDTOListToAssuntoEntidadeList(assuntoDTO.getAssuntoEntidade());
            if (list1 != null) {
                existing.getAssuntoEntidade().clear();
                existing.getAssuntoEntidade().addAll(list1);
            } else {
                existing.setAssuntoEntidade(null);
            }
        } else {
            list1 = this.assuntoEntidadeDTOListToAssuntoEntidadeList(assuntoDTO.getAssuntoEntidade());
            if (list1 != null) {
                existing.setAssuntoEntidade(list1);
            }
        }
        existing.setRoteiro(this.toRoteiro(assuntoDTO.getRoteiro()));
        existing.setPrazoArquivamento(assuntoDTO.getPrazoArquivamento());
        existing.setDestinacaoFinal(assuntoDTO.getDestinacaoFinal());
        existing.setObrigaDadosImovel(assuntoDTO.getObrigaDadosImovel());
        existing.setControlaTramitacao(assuntoDTO.getControlaTramitacao());
        existing.setOuvidoria(assuntoDTO.getOuvidoria());
        existing.setNotaExplicativa(assuntoDTO.getNotaExplicativa());
        existing.setObrigaArquivosAssuntoInterno(assuntoDTO.getObrigaArquivosAssuntoInterno());
        existing.setObrigaArquivosAssuntoExterno(assuntoDTO.getObrigaArquivosAssuntoExterno());
        existing.setTermoResponsabilidade(assuntoDTO.getTermoResponsabilidade());
        existing.setBloqueiaAberturaExternaAnonima(assuntoDTO.getBloqueiaAberturaExternaAnonima());
        existing.setObrigaEnderecoComplementar(assuntoDTO.getObrigaEnderecoComplementar());
        existing.setDenunciado(assuntoDTO.getDenunciado());
        existing.setCarregaRequerimentoExterno(assuntoDTO.getCarregaRequerimentoExterno());
        existing.setExibeDadosImovel(assuntoDTO.getExibeDadosImovel());
        existing.setRequerimento(assuntoDTO.getRequerimento());
        existing.setObservacao(assuntoDTO.getObservacao());
        if (existing.getArquivos() != null) {
            list2 = this.assuntoArquivoDTOListToAssuntoArquivoList(assuntoDTO.getArquivos());
            if (list2 != null) {
                existing.getArquivos().clear();
                existing.getArquivos().addAll(list2);
            } else {
                existing.setArquivos(null);
            }
        } else {
            list2 = this.assuntoArquivoDTOListToAssuntoArquivoList(assuntoDTO.getArquivos());
            if (list2 != null) {
                existing.setArquivos(list2);
            }
        }
        existing.setObrigaComplementoAssunto(assuntoDTO.getObrigaComplementoAssunto());
        existing.setEsic(assuntoDTO.getEsic());
        return existing;
    }

    public AssuntoDTO toAssuntoDTO(Assunto assunto) {
        if (assunto == null) {
            return null;
        }
        AssuntoDTO.AssuntoDTOBuilder assuntoDTO = AssuntoDTO.builder();
        assuntoDTO.id(assunto.getId());
        assuntoDTO.descricao(assunto.getDescricao());
        assuntoDTO.possuiTaxas(assunto.getPossuiTaxas());
        assuntoDTO.controlaTramitacao(assunto.getControlaTramitacao());
        assuntoDTO.assuntoInterno(assunto.getAssuntoInterno());
        assuntoDTO.ativo(assunto.getAtivo());
        assuntoDTO.possuiParticipantesExtrasExterno(assunto.getPossuiParticipantesExtrasExterno());
        assuntoDTO.mensagem(assunto.getMensagem());
        assuntoDTO.complemento(assunto.getComplemento());
        assuntoDTO.assuntoDocumento(this.assuntoDocumentoListToAssuntoDocumentoDTOList(assunto.getAssuntoDocumento()));
        assuntoDTO.assuntoEntidade(this.assuntoEntidadeListToAssuntoEntidadeDTOList(assunto.getAssuntoEntidade()));
        assuntoDTO.roteiro(this.toRoteiroDTO(assunto.getRoteiro()));
        assuntoDTO.prazoArquivamento(assunto.getPrazoArquivamento());
        assuntoDTO.destinacaoFinal(assunto.getDestinacaoFinal());
        assuntoDTO.obrigaDadosImovel(assunto.getObrigaDadosImovel());
        assuntoDTO.ouvidoria(assunto.getOuvidoria());
        assuntoDTO.termoAceite(assunto.getTermoAceite());
        assuntoDTO.notaExplicativa(assunto.getNotaExplicativa());
        assuntoDTO.termoResponsabilidade(assunto.getTermoResponsabilidade());
        assuntoDTO.obrigaArquivosAssuntoInterno(assunto.getObrigaArquivosAssuntoInterno());
        assuntoDTO.sigiloso(assunto.getSigiloso());
        assuntoDTO.obrigaArquivosAssuntoExterno(assunto.getObrigaArquivosAssuntoExterno());
        assuntoDTO.carregaRequerimentoExterno(assunto.getCarregaRequerimentoExterno());
        assuntoDTO.exibeDadosImovel(assunto.getExibeDadosImovel());
        assuntoDTO.requerimento(assunto.getRequerimento());
        assuntoDTO.observacao(assunto.getObservacao());
        assuntoDTO.bloqueiaAberturaExternaAnonima(assunto.getBloqueiaAberturaExternaAnonima());
        assuntoDTO.obrigaEnderecoComplementar(assunto.getObrigaEnderecoComplementar());
        assuntoDTO.denunciado(assunto.getDenunciado());
        assuntoDTO.arquivos(this.assuntoArquivoListToAssuntoArquivoDTOList(assunto.getArquivos()));
        assuntoDTO.assuntoPai(this.toAssuntoDTO(assunto.getAssuntoPai()));
        assuntoDTO.obrigaComplementoAssunto(assunto.getObrigaComplementoAssunto());
        assuntoDTO.esic(assunto.getEsic());
        return assuntoDTO.build();
    }

    public Assunto toAssunto(AssuntoDTO assuntoDTO) {
        if (assuntoDTO == null) {
            return null;
        }
        Assunto assunto = new Assunto();
        assunto.setId(assuntoDTO.getId());
        assunto.setDescricao(assuntoDTO.getDescricao());
        assunto.setAssuntoInterno(assuntoDTO.getAssuntoInterno());
        assunto.setPossuiTaxas(assuntoDTO.getPossuiTaxas());
        assunto.setAtivo(assuntoDTO.getAtivo());
        assunto.setSigiloso(assuntoDTO.getSigiloso());
        assunto.setPossuiParticipantesExtrasExterno(assuntoDTO.getPossuiParticipantesExtrasExterno());
        assunto.setMensagem(assuntoDTO.getMensagem());
        assunto.setComplemento(assuntoDTO.getComplemento());
        assunto.setAssuntoDocumento(this.assuntoDocumentoDTOListToAssuntoDocumentoList(assuntoDTO.getAssuntoDocumento()));
        assunto.setAssuntoEntidade(this.assuntoEntidadeDTOListToAssuntoEntidadeList(assuntoDTO.getAssuntoEntidade()));
        assunto.setRoteiro(this.toRoteiro(assuntoDTO.getRoteiro()));
        assunto.setPrazoArquivamento(assuntoDTO.getPrazoArquivamento());
        assunto.setDestinacaoFinal(assuntoDTO.getDestinacaoFinal());
        assunto.setObrigaDadosImovel(assuntoDTO.getObrigaDadosImovel());
        assunto.setControlaTramitacao(assuntoDTO.getControlaTramitacao());
        assunto.setOuvidoria(assuntoDTO.getOuvidoria());
        assunto.setTermoAceite(assuntoDTO.getTermoAceite());
        assunto.setNotaExplicativa(assuntoDTO.getNotaExplicativa());
        assunto.setObrigaArquivosAssuntoInterno(assuntoDTO.getObrigaArquivosAssuntoInterno());
        assunto.setObrigaArquivosAssuntoExterno(assuntoDTO.getObrigaArquivosAssuntoExterno());
        assunto.setTermoResponsabilidade(assuntoDTO.getTermoResponsabilidade());
        assunto.setBloqueiaAberturaExternaAnonima(assuntoDTO.getBloqueiaAberturaExternaAnonima());
        assunto.setObrigaEnderecoComplementar(assuntoDTO.getObrigaEnderecoComplementar());
        assunto.setDenunciado(assuntoDTO.getDenunciado());
        assunto.setCarregaRequerimentoExterno(assuntoDTO.getCarregaRequerimentoExterno());
        assunto.setExibeDadosImovel(assuntoDTO.getExibeDadosImovel());
        assunto.setRequerimento(assuntoDTO.getRequerimento());
        assunto.setObservacao(assuntoDTO.getObservacao());
        assunto.setArquivos(this.assuntoArquivoDTOListToAssuntoArquivoList(assuntoDTO.getArquivos()));
        assunto.setAssuntoPai(this.toAssunto(assuntoDTO.getAssuntoPai()));
        assunto.setObrigaComplementoAssunto(assuntoDTO.getObrigaComplementoAssunto());
        assunto.setEsic(assuntoDTO.getEsic());
        return assunto;
    }

    public AssuntoPesquisaDTO toAssuntoPesquisaDTO(Assunto assunto) {
        if (assunto == null) {
            return null;
        }
        AssuntoPesquisaDTO.AssuntoPesquisaDTOBuilder assuntoPesquisaDTO = AssuntoPesquisaDTO.builder();
        assuntoPesquisaDTO.id(assunto.getId());
        assuntoPesquisaDTO.descricao(assunto.getDescricao());
        return assuntoPesquisaDTO.build();
    }

    public AssuntoEntidade toAssuntoEntidade(AssuntoEntidadeDTO assuntoEntidadeDTO) {
        if (assuntoEntidadeDTO == null) {
            return null;
        }
        AssuntoEntidade assuntoEntidade = new AssuntoEntidade();
        assuntoEntidade.setId(assuntoEntidadeDTO.getId());
        assuntoEntidade.setEntidade(this.toEntidade(assuntoEntidadeDTO.getEntidade()));
        return assuntoEntidade;
    }

    public AssuntoEntidadeDTO toAssuntoEntidadeDTO(AssuntoEntidade assuntoEntidade) {
        if (assuntoEntidade == null) {
            return null;
        }
        AssuntoEntidadeDTO assuntoEntidadeDTO = new AssuntoEntidadeDTO();
        assuntoEntidadeDTO.setId(assuntoEntidade.getId());
        assuntoEntidadeDTO.setEntidade(this.toEntidadeDTO(assuntoEntidade.getEntidade()));
        return assuntoEntidadeDTO;
    }

    public TipoProcessoEntidade toTipoProcessoEntidade(TipoProcessoEntidadeDTO assuntoEntidadeDTO) {
        if (assuntoEntidadeDTO == null) {
            return null;
        }
        TipoProcessoEntidade tipoProcessoEntidade = new TipoProcessoEntidade();
        tipoProcessoEntidade.setId(assuntoEntidadeDTO.getId());
        tipoProcessoEntidade.setEntidade(this.toEntidade(assuntoEntidadeDTO.getEntidade()));
        return tipoProcessoEntidade;
    }

    public TipoProcessoEntidadeDTO toTipoProcessoEntidadeDTO(TipoProcessoEntidade assuntoEntidade) {
        if (assuntoEntidade == null) {
            return null;
        }
        TipoProcessoEntidadeDTO tipoProcessoEntidadeDTO = new TipoProcessoEntidadeDTO();
        tipoProcessoEntidadeDTO.setId(assuntoEntidade.getId());
        tipoProcessoEntidadeDTO.setEntidade(this.toEntidadeDTO(assuntoEntidade.getEntidade()));
        return tipoProcessoEntidadeDTO;
    }

    public AssuntoDocumento toAssuntoDocumento(AssuntoDocumentoDTO assuntoDocumentoDTO) {
        if (assuntoDocumentoDTO == null) {
            return null;
        }
        AssuntoDocumento assuntoDocumento = new AssuntoDocumento();
        assuntoDocumento.setQuantcopias(assuntoDocumentoDTO.getQuantidadecopias());
        assuntoDocumento.setAutenticado(assuntoDocumentoDTO.getAutenticado());
        assuntoDocumento.setObrigatoriointerno(assuntoDocumentoDTO.getObrigatoriointerno());
        assuntoDocumento.setObrigatorioexterno(assuntoDocumentoDTO.getObrigatorioexterno());
        assuntoDocumento.setId(this.toAssuntoDocumentoPK(assuntoDocumentoDTO.getDocumento()));
        return assuntoDocumento;
    }

    public AssuntoDocumentoPK toAssuntoDocumentoPK(DocumentoDTO documento) {
        if (documento == null) {
            return null;
        }
        AssuntoDocumentoPK assuntoDocumentoPK = new AssuntoDocumentoPK();
        assuntoDocumentoPK.setDocumento(this.toDocumento(documento));
        return assuntoDocumentoPK;
    }

    public AssuntoDocumentoDTO toAssuntoDocumentoDTO(AssuntoDocumento assuntoDocumento) {
        if (assuntoDocumento == null) {
            return null;
        }
        AssuntoDocumentoDTO assuntoDocumentoDTO = new AssuntoDocumentoDTO();
        assuntoDocumentoDTO.setDocumento(this.toDocumentoDTO(this.assuntoDocumentoIdDocumento(assuntoDocumento)));
        assuntoDocumentoDTO.setQuantidadecopias(assuntoDocumento.getQuantcopias());
        assuntoDocumentoDTO.setAutenticado(assuntoDocumento.getAutenticado());
        assuntoDocumentoDTO.setObrigatoriointerno(assuntoDocumento.getObrigatoriointerno());
        assuntoDocumentoDTO.setObrigatorioexterno(assuntoDocumento.getObrigatorioexterno());
        return assuntoDocumentoDTO;
    }

    public AssuntoArquivo toAssuntoArquivo(AssuntoArquivoDTO assuntoArquivoDTO) {
        if (assuntoArquivoDTO == null) {
            return null;
        }
        AssuntoArquivo assuntoArquivo = new AssuntoArquivo();
        assuntoArquivo.setId(assuntoArquivoDTO.getId());
        assuntoArquivo.setNome(assuntoArquivoDTO.getNome());
        assuntoArquivo.setArquivoId(assuntoArquivoDTO.getArquivoId());
        return assuntoArquivo;
    }

    public AssuntoArquivoDTO toAssuntoArquivoDTO(AssuntoArquivo assuntoArquivo) {
        if (assuntoArquivo == null) {
            return null;
        }
        AssuntoArquivoDTO assuntoArquivoDTO = new AssuntoArquivoDTO();
        assuntoArquivoDTO.setId(assuntoArquivo.getId());
        assuntoArquivoDTO.setArquivoId(assuntoArquivo.getArquivoId());
        assuntoArquivoDTO.setNome(assuntoArquivo.getNome());
        return assuntoArquivoDTO;
    }

    public AssuntoDocumento toAssuntoDocumento(AssuntoDocumentoDTO dto, AssuntoDocumento assuntoDocumento) {
        if (dto == null) {
            return null;
        }
        assuntoDocumento.setQuantcopias(dto.getQuantidadecopias());
        assuntoDocumento.setAutenticado(dto.getAutenticado());
        assuntoDocumento.setObrigatoriointerno(dto.getObrigatoriointerno());
        assuntoDocumento.setObrigatorioexterno(dto.getObrigatorioexterno());
        return assuntoDocumento;
    }

    public Usuario toUsuario(UsuarioDTO usuarioDTO, Usuario existing) {
        if (usuarioDTO == null) {
            return null;
        }
        existing.setId(usuarioDTO.getId());
        existing.setNome(usuarioDTO.getNome());
        existing.setSenha(usuarioDTO.getSenha());
        existing.setLocal(usuarioDTO.getLocal());
        existing.setVisualiza(usuarioDTO.getVisualiza());
        existing.setNivelTramite(usuarioDTO.getNivelTramite());
        existing.setNivelAcesso(usuarioDTO.getNivelAcesso());
        existing.setNomeProg(usuarioDTO.getNomeProg());
        existing.setPadrao(usuarioDTO.getPadrao());
        existing.setVerificaMensagens(usuarioDTO.getVerificaMensagens());
        existing.setTempoVerificacao(usuarioDTO.getTempoVerificacao());
        existing.setAtivo(usuarioDTO.getAtivo());
        existing.setEmail(usuarioDTO.getEmail());
        existing.setBoAnexarArquivo(usuarioDTO.getBoAnexarArquivo());
        existing.setCpf(usuarioDTO.getCpf());
        existing.setImprimePapeleta(usuarioDTO.getImprimePapeleta());
        if (existing.getUsuarioTipoProcesso() != null) {
            list = this.usuarioTipoProcessoDTOListToUsuarioTipoProcessoList(usuarioDTO.getUsuarioTipoProcesso());
            if (list != null) {
                existing.getUsuarioTipoProcesso().clear();
                existing.getUsuarioTipoProcesso().addAll(list);
            } else {
                existing.setUsuarioTipoProcesso(null);
            }
        } else {
            list = this.usuarioTipoProcessoDTOListToUsuarioTipoProcessoList(usuarioDTO.getUsuarioTipoProcesso());
            if (list != null) {
                existing.setUsuarioTipoProcesso(list);
            }
        }
        if (existing.getUsuarioModeloImpressao() != null) {
            list1 = this.usuarioModeloImpressaoDTOListToUsuarioModeloImpressaoList(usuarioDTO.getUsuarioModeloImpressao());
            if (list1 != null) {
                existing.getUsuarioModeloImpressao().clear();
                existing.getUsuarioModeloImpressao().addAll(list1);
            } else {
                existing.setUsuarioModeloImpressao(null);
            }
        } else {
            list1 = this.usuarioModeloImpressaoDTOListToUsuarioModeloImpressaoList(usuarioDTO.getUsuarioModeloImpressao());
            if (list1 != null) {
                existing.setUsuarioModeloImpressao(list1);
            }
        }
        if (existing.getUsuarioLocal() != null) {
            set = this.usuarioLocalDTOListToUsuarioLocalSet(usuarioDTO.getUsuarioLocal());
            if (set != null) {
                existing.getUsuarioLocal().clear();
                existing.getUsuarioLocal().addAll(set);
            } else {
                existing.setUsuarioLocal(null);
            }
        } else {
            set = this.usuarioLocalDTOListToUsuarioLocalSet(usuarioDTO.getUsuarioLocal());
            if (set != null) {
                existing.setUsuarioLocal(set);
            }
        }
        existing.setExcluirArquivos(usuarioDTO.getExcluirArquivos());
        existing.setEditarProcessoTramitado(usuarioDTO.getEditarProcessoTramitado());
        existing.setOuvidor(usuarioDTO.getOuvidor());
        return existing;
    }

    public UsuarioDTO toUsuarioDTO(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        UsuarioDTO usuarioDTO = new UsuarioDTO();
        usuarioDTO.setId(usuario.getId());
        usuarioDTO.setNome(usuario.getNome());
        usuarioDTO.setSenha(usuario.getSenha());
        usuarioDTO.setLocal(usuario.getLocal());
        usuarioDTO.setVisualiza(usuario.getVisualiza());
        usuarioDTO.setNivelTramite(usuario.getNivelTramite());
        usuarioDTO.setNivelAcesso(usuario.getNivelAcesso());
        usuarioDTO.setNomeProg(usuario.getNomeProg());
        usuarioDTO.setPadrao(usuario.getPadrao());
        usuarioDTO.setVerificaMensagens(usuario.getVerificaMensagens());
        usuarioDTO.setTempoVerificacao(usuario.getTempoVerificacao());
        usuarioDTO.setAtivo(usuario.getAtivo());
        usuarioDTO.setEmail(usuario.getEmail());
        usuarioDTO.setBoAnexarArquivo(usuario.getBoAnexarArquivo());
        usuarioDTO.setCpf(usuario.getCpf());
        usuarioDTO.setImprimePapeleta(usuario.getImprimePapeleta());
        usuarioDTO.setExcluirArquivos(usuario.getExcluirArquivos());
        usuarioDTO.setEditarProcessoTramitado(usuario.getEditarProcessoTramitado());
        usuarioDTO.setUsuarioTipoProcesso(this.usuarioTipoProcessoListToUsuarioTipoProcessoDTOList(usuario.getUsuarioTipoProcesso()));
        usuarioDTO.setUsuarioModeloImpressao(this.usuarioModeloImpressaoListToUsuarioModeloImpressaoDTOList(usuario.getUsuarioModeloImpressao()));
        usuarioDTO.setSecretarias(this.secretariaSetToSecretariaDTOSet(usuario.getSecretarias()));
        usuarioDTO.setAssuntos(this.assuntoSetToAssuntoDTOSet(usuario.getAssuntos()));
        usuarioDTO.setUsuarioLocal(this.usuarioLocalSetToUsuarioLocalDTOList(usuario.getUsuarioLocal()));
        usuarioDTO.setOuvidor(usuario.getOuvidor());
        usuarioDTO.setEntidades(this.usuarioEntidadeSetToUsuarioEntidadeDTOList(usuario.getEntidades()));
        return usuarioDTO;
    }

    public UsuarioTipoProcesso toUsuarioTipoProcesso(UsuarioTipoProcessoDTO usuarioTipoProcessoDTO) {
        if (usuarioTipoProcessoDTO == null) {
            return null;
        }
        UsuarioTipoProcesso usuarioTipoProcesso = new UsuarioTipoProcesso();
        usuarioTipoProcesso.setPrioritario(usuarioTipoProcessoDTO.getPrioritario());
        usuarioTipoProcesso.setId(this.toUsuarioTipoProcessoPK(usuarioTipoProcessoDTO.getTipoProcesso()));
        return usuarioTipoProcesso;
    }

    public UsuarioTipoProcessoPK toUsuarioTipoProcessoPK(TipoProcessoDTO tipoProcesso) {
        if (tipoProcesso == null) {
            return null;
        }
        UsuarioTipoProcessoPK usuarioTipoProcessoPK = new UsuarioTipoProcessoPK();
        usuarioTipoProcessoPK.setTipoProcesso(this.toTipoProcesso(tipoProcesso));
        return usuarioTipoProcessoPK;
    }

    public UsuarioTipoProcessoPK toUsuarioTipoProcessoPK(TipoProcessoSimpleDTO tipoProcesso) {
        if (tipoProcesso == null) {
            return null;
        }
        UsuarioTipoProcessoPK usuarioTipoProcessoPK = new UsuarioTipoProcessoPK();
        usuarioTipoProcessoPK.setTipoProcesso(this.toTipoProcesso(tipoProcesso));
        return usuarioTipoProcessoPK;
    }

    public UsuarioTipoProcessoDTO toUsuarioTipoProcessoDTO(UsuarioTipoProcesso usuarioTipoProcesso) {
        if (usuarioTipoProcesso == null) {
            return null;
        }
        UsuarioTipoProcessoDTO usuarioTipoProcessoDTO = new UsuarioTipoProcessoDTO();
        usuarioTipoProcessoDTO.setTipoProcesso(this.toTipoProcessoSimpleDTO(this.usuarioTipoProcessoIdTipoProcesso(usuarioTipoProcesso)));
        usuarioTipoProcessoDTO.setPrioritario(usuarioTipoProcesso.isPrioritario());
        return usuarioTipoProcessoDTO;
    }

    public UsuarioTipoProcesso toUsuarioTipoProcesso(UsuarioTipoProcessoDTO dto, UsuarioTipoProcesso usuarioTipoProcesso) {
        if (dto == null) {
            return null;
        }
        usuarioTipoProcesso.setPrioritario(dto.getPrioritario());
        return usuarioTipoProcesso;
    }

    public UsuarioModeloImpressao toUsuarioModeloImpressao(UsuarioModeloImpressaoDTO usuarioModeloImpressaoDTO) {
        if (usuarioModeloImpressaoDTO == null) {
            return null;
        }
        UsuarioModeloImpressao usuarioModeloImpressao = new UsuarioModeloImpressao();
        usuarioModeloImpressao.setId(this.toUsuarioModeloImpressaoPK(usuarioModeloImpressaoDTO.getModeloImpressao()));
        return usuarioModeloImpressao;
    }

    public UsuarioModeloImpressaoPK toUsuarioModeloImpressaoPK(ModeloImpressaoDTO modeloImpressao) {
        if (modeloImpressao == null) {
            return null;
        }
        UsuarioModeloImpressaoPK usuarioModeloImpressaoPK = new UsuarioModeloImpressaoPK();
        usuarioModeloImpressaoPK.setModeloImpressao(this.modeloImpressaoDTOToModeloImpressao(modeloImpressao));
        return usuarioModeloImpressaoPK;
    }

    public UsuarioModeloImpressaoDTO toUsuarioModeloImpressaoDTO(UsuarioModeloImpressao usuarioModeloImpressao) {
        if (usuarioModeloImpressao == null) {
            return null;
        }
        UsuarioModeloImpressaoDTO usuarioModeloImpressaoDTO = new UsuarioModeloImpressaoDTO();
        usuarioModeloImpressaoDTO.setModeloImpressao(this.modeloImpressaoToModeloImpressaoDTO(this.usuarioModeloImpressaoIdModeloImpressao(usuarioModeloImpressao)));
        return usuarioModeloImpressaoDTO;
    }

    public UsuarioModeloImpressao toUsuarioModeloImpressao(UsuarioModeloImpressaoDTO dto, UsuarioModeloImpressao usuarioModeloImpressao) {
        if (dto == null) {
            return null;
        }
        return usuarioModeloImpressao;
    }

    public UsuarioLocalPK toUsuarioLocalPK(Local local) {
        if (local == null) {
            return null;
        }
        UsuarioLocalPK usuarioLocalPK = new UsuarioLocalPK();
        usuarioLocalPK.setLocal(local);
        return usuarioLocalPK;
    }

    public UsuarioLocalDTO toUsuarioLocalDTO(UsuarioLocal usuarioLocal) {
        if (usuarioLocal == null) {
            return null;
        }
        UsuarioLocalDTO usuarioLocalDTO = new UsuarioLocalDTO();
        usuarioLocalDTO.setLocal(this.toLocalDTO(this.usuarioLocalIdLocal(usuarioLocal)));
        usuarioLocalDTO.setPadrao(usuarioLocal.getPadrao());
        return usuarioLocalDTO;
    }

    public UsuarioLocal toUsuarioLocal(UsuarioLocalDTO usuarioLocalDTO) {
        if (usuarioLocalDTO == null) {
            return null;
        }
        UsuarioLocal usuarioLocal = new UsuarioLocal();
        usuarioLocal.setPadrao(usuarioLocalDTO.getPadrao());
        usuarioLocal.setId(this.toUsuarioLocalPK(this.toLocal(usuarioLocalDTO.getLocal())));
        return usuarioLocal;
    }

    public UsuarioLocal toUsuarioLocal(UsuarioLocalDTO usuarioLocalDTO, UsuarioLocal usuarioLocal) {
        if (usuarioLocalDTO == null) {
            return null;
        }
        usuarioLocal.setPadrao(usuarioLocalDTO.getPadrao());
        return usuarioLocal;
    }

    public UserInfoDTO toUsuarioPermissaoDTO(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        userInfoDTO.setUsuario(usuario.getId());
        userInfoDTO.setTelas(this.usuarioSeletorSetToUsuarioPermissaoDTOList(usuario.getSeletores()));
        userInfoDTO.setNome(usuario.getNome());
        userInfoDTO.setEmail(usuario.getEmail());
        userInfoDTO.setEditarProcessoTramitado(usuario.getEditarProcessoTramitado());
        userInfoDTO.setOuvidor(usuario.getOuvidor());
        return userInfoDTO;
    }

    public Seletor toSeletor(SeletorDTO dto) {
        if (dto == null) {
            return null;
        }
        Seletor seletor = new Seletor();
        seletor.setId(dto.getId());
        seletor.setDescricao(dto.getDescricao());
        seletor.setNivel(dto.getNivel());
        seletor.setOrdem(dto.getOrdem());
        return seletor;
    }

    public SeletorDTO toSeletorDTO(Seletor seletor) {
        if (seletor == null) {
            return null;
        }
        SeletorDTO seletorDTO = new SeletorDTO();
        seletorDTO.setId(seletor.getId());
        seletorDTO.setDescricao(seletor.getDescricao());
        seletorDTO.setNivel(seletor.getNivel());
        seletorDTO.setOrdem(seletor.getOrdem());
        return seletorDTO;
    }

    public Modulo toModulo(ModuloDTO moduloDTO) {
        if (moduloDTO == null) {
            return null;
        }
        Modulo modulo = new Modulo();
        modulo.setId(moduloDTO.getId());
        modulo.setDescricao(moduloDTO.getDescricao());
        modulo.setPath(moduloDTO.getPath());
        return modulo;
    }

    public ModuloDTO toModuloDTO(Modulo modulo) {
        if (modulo == null) {
            return null;
        }
        ModuloDTO.ModuloDTOBuilder moduloDTO = ModuloDTO.builder();
        moduloDTO.id(modulo.getId());
        moduloDTO.descricao(modulo.getDescricao());
        moduloDTO.path(modulo.getPath());
        return moduloDTO.build();
    }

    public UsuarioPermissaoDTO toUsuarioTelaDTO(UsuarioSeletor usuarioSeletor) {
        if (usuarioSeletor == null) {
            return null;
        }
        UsuarioPermissaoDTO usuarioPermissaoDTO = new UsuarioPermissaoDTO();
        usuarioPermissaoDTO.setModulo(this.toModuloDTO(this.usuarioSeletorIdModulo(usuarioSeletor)));
        usuarioPermissaoDTO.setSeletor(this.toSeletorDTO(this.usuarioSeletorIdSeletor(usuarioSeletor)));
        usuarioPermissaoDTO.setFavorito(usuarioSeletor.getFavorito());
        usuarioPermissaoDTO.setInserir(usuarioSeletor.getInserir());
        usuarioPermissaoDTO.setAlterar(usuarioSeletor.getAlterar());
        usuarioPermissaoDTO.setExcluir(usuarioSeletor.getExcluir());
        usuarioPermissaoDTO.setFuncaoEspecial(usuarioSeletor.getFuncaoEspecial());
        usuarioPermissaoDTO.setPesquisaVazia(usuarioSeletor.getPesquisaVazia());
        return usuarioPermissaoDTO;
    }

    public UsuarioEntidadeDTO toUsuarioEntidadeDTO(UsuarioEntidade usuarioEntidade) {
        if (usuarioEntidade == null) {
            return null;
        }
        UsuarioEntidadeDTO usuarioEntidadeDTO = new UsuarioEntidadeDTO();
        usuarioEntidadeDTO.setEntidade(this.toEntidadeDTO(this.usuarioEntidadeIdEntidade(usuarioEntidade)));
        usuarioEntidadeDTO.setPadrao(usuarioEntidade.getPadrao());
        usuarioEntidadeDTO.setAlteraTodosProc(usuarioEntidade.getAlteraTodosProc());
        return usuarioEntidadeDTO;
    }

    public ExercicioDTO toExercicioDTO(Exercicio exercicio) {
        if (exercicio == null) {
            return null;
        }
        ExercicioDTO exercicioDTO = new ExercicioDTO();
        exercicioDTO.setId(this.exercicioIdExercicio(exercicio));
        exercicioDTO.setAberto(exercicio.getAberto());
        exercicioDTO.setFechado(exercicio.getFechado());
        return exercicioDTO;
    }

    public EntidadeAutoCompleteDTO toEntidadeAutoCompleteDTO(Entidade entidade) {
        if (entidade == null) {
            return null;
        }
        EntidadeAutoCompleteDTO entidadeAutoCompleteDTO = new EntidadeAutoCompleteDTO();
        entidadeAutoCompleteDTO.setId(entidade.getId());
        entidadeAutoCompleteDTO.setNome(entidade.getNome());
        return entidadeAutoCompleteDTO;
    }

    public Documento toDocumento(DocumentoDTO documentoDTO) {
        if (documentoDTO == null) {
            return null;
        }
        Documento documento = new Documento();
        documento.setId(documentoDTO.getId());
        documento.setDescricao(documentoDTO.getDescricao());
        return documento;
    }

    public Documento toDocumento(DocumentoDTO documentoDTO, Documento existing) {
        if (documentoDTO == null) {
            return null;
        }
        existing.setId(documentoDTO.getId());
        existing.setDescricao(documentoDTO.getDescricao());
        return existing;
    }

    public DocumentoDTO toDocumentoDTO(Documento documento) {
        if (documento == null) {
            return null;
        }
        DocumentoDTO documentoDTO = new DocumentoDTO();
        documentoDTO.setId(documento.getId());
        documentoDTO.setDescricao(documento.getDescricao());
        return documentoDTO;
    }

    public UnidadePK toUnidadePK(Long id, EntidadeDTO entidade) {
        if (id == null && entidade == null) {
            return null;
        }
        UnidadePK unidadePK = new UnidadePK();
        if (id != null) {
            unidadePK.setCodigo(id);
        }
        unidadePK.setEntidade(this.toEntidade(entidade));
        return unidadePK;
    }

    public Unidade toUnidade(UnidadeDTO unidade) {
        if (unidade == null) {
            return null;
        }
        Unidade unidade1 = new Unidade();
        unidade1.setDescricao(unidade.getDescricao());
        unidade1.setId(this.toUnidadePK(unidade.getId(), unidade.getEntidade()));
        return unidade1;
    }

    public UnidadeDTO toUnidadeDTO(Unidade unidade) {
        if (unidade == null) {
            return null;
        }
        UnidadeDTO unidadeDTO = new UnidadeDTO();
        unidadeDTO.setEntidade(this.toEntidadeDTO(this.unidadeIdEntidade(unidade)));
        unidadeDTO.setId(this.unidadeIdCodigo(unidade));
        unidadeDTO.setDescricao(unidade.getDescricao());
        return unidadeDTO;
    }

    public TipoNotificacao toTipoNotificacao(TipoNotificacaoDTO dto, TipoNotificacao tipoNotificacao) {
        if (dto == null) {
            return null;
        }
        tipoNotificacao.setDescricao(dto.getDescricao());
        tipoNotificacao.setModelo(dto.getModelo());
        return tipoNotificacao;
    }

    public TipoNotificacaoDTO toTipoNotificacaoDTO(TipoNotificacao tipoNotificacao) {
        if (tipoNotificacao == null) {
            return null;
        }
        TipoNotificacaoDTO tipoNotificacaoDTO = new TipoNotificacaoDTO();
        tipoNotificacaoDTO.setEntidade(this.toEntidadeDTO(this.tipoNotificacaoIdEntidade(tipoNotificacao)));
        tipoNotificacaoDTO.setId(this.tipoNotificacaoIdId(tipoNotificacao));
        tipoNotificacaoDTO.setDescricao(tipoNotificacao.getDescricao());
        tipoNotificacaoDTO.setModelo(tipoNotificacao.getModelo());
        return tipoNotificacaoDTO;
    }

    public TipoNotificacaoPK toTipoNotificacaoPK(EntidadeDTO entidade, Long id) {
        if (entidade == null && id == null) {
            return null;
        }
        TipoNotificacaoPK tipoNotificacaoPK = new TipoNotificacaoPK();
        if (entidade != null) {
            tipoNotificacaoPK.setEntidade(this.toEntidade(entidade));
        }
        if (id != null) {
            tipoNotificacaoPK.setId(id);
        }
        return tipoNotificacaoPK;
    }

    public Situacao toSituacao(SituacaoDTO situacaoDTO, Situacao existing) {
        if (situacaoDTO == null) {
            return null;
        }
        existing.setId(situacaoDTO.getId());
        existing.setDescricao(situacaoDTO.getDescricao());
        existing.setArquivamento(situacaoDTO.getArquivamento());
        existing.setPagamentoPendente(situacaoDTO.getPagamentoPendente());
        existing.setAtiva(situacaoDTO.getAtiva());
        return existing;
    }

    public Situacao toSituacao(SituacaoDTO situacaoDTO) {
        if (situacaoDTO == null) {
            return null;
        }
        Situacao situacao = new Situacao();
        situacao.setId(situacaoDTO.getId());
        situacao.setDescricao(situacaoDTO.getDescricao());
        situacao.setArquivamento(situacaoDTO.getArquivamento());
        situacao.setPagamentoPendente(situacaoDTO.getPagamentoPendente());
        situacao.setAtiva(situacaoDTO.getAtiva());
        return situacao;
    }

    public SituacaoDTO toSituacaoDTO(Situacao situacao) {
        if (situacao == null) {
            return null;
        }
        SituacaoDTO.SituacaoDTOBuilder situacaoDTO = SituacaoDTO.builder();
        situacaoDTO.id(situacao.getId());
        situacaoDTO.descricao(situacao.getDescricao());
        situacaoDTO.arquivamento(situacao.getArquivamento());
        situacaoDTO.pagamentoPendente(situacao.getPagamentoPendente());
        situacaoDTO.ativa(situacao.getAtiva());
        return situacaoDTO.build();
    }

    public TipoProcesso toTipoProcesso(TipoProcessoDTO tipoProcessoDTO) {
        if (tipoProcessoDTO == null) {
            return null;
        }
        TipoProcesso tipoProcesso = new TipoProcesso();
        tipoProcesso.setId(tipoProcessoDTO.getId());
        tipoProcesso.setDescricao(tipoProcessoDTO.getDescricao());
        tipoProcesso.setDiasVencimento(tipoProcessoDTO.getDiasVencimento());
        tipoProcesso.setCaminhoCapa(tipoProcessoDTO.getCaminhoCapa());
        tipoProcesso.setCaminhoRequerimento(tipoProcessoDTO.getCaminhoRequerimento());
        tipoProcesso.setCaminhoCapaAgrupamentoArquivo(tipoProcessoDTO.getCaminhoCapaAgrupamentoArquivo());
        tipoProcesso.setCompra(tipoProcessoDTO.getCompra());
        tipoProcesso.setAtivo(tipoProcessoDTO.getAtivo());
        tipoProcesso.setImprimeComprovante(tipoProcessoDTO.getImprimeComprovante());
        tipoProcesso.setImprimeCapaProcesso(tipoProcessoDTO.getImprimeCapaProcesso());
        tipoProcesso.setImprimeEtiqueta(tipoProcessoDTO.getImprimeEtiqueta());
        tipoProcesso.setSigiloso(tipoProcessoDTO.getSigiloso());
        tipoProcesso.setTipoInterno(tipoProcessoDTO.getTipoInterno());
        tipoProcesso.setComunicacaoInterna(tipoProcessoDTO.getComunicacaoInterna());
        tipoProcesso.setPadraoFisico(tipoProcessoDTO.getPadraoFisico());
        tipoProcesso.setAssuntoPadrao(this.toAssunto(tipoProcessoDTO.getAssuntoPadrao()));
        tipoProcesso.setAssuntoFixo(tipoProcessoDTO.getAssuntoFixo());
        tipoProcesso.setPrioridadePadrao(tipoProcessoDTO.getPrioridadePadrao());
        tipoProcesso.setTipoProcessoMp(tipoProcessoDTO.getTipoProcessoMp());
        tipoProcesso.setConsultaExterna(tipoProcessoDTO.getConsultaExterna());
        tipoProcesso.setUploadAnexoSemRestricao(tipoProcessoDTO.getUploadAnexoSemRestricao());
        tipoProcesso.setTipoProcessoEntidade(this.tipoProcessoEntidadeDTOListToTipoProcessoEntidadeList(tipoProcessoDTO.getTipoProcessoEntidade()));
        tipoProcesso.setAssuntos(this.assuntoDTOSetToAssuntoSet(tipoProcessoDTO.getAssuntos()));
        tipoProcesso.setSituacoes(this.situacaoDTOSetToSituacaoSet(tipoProcessoDTO.getSituacoes()));
        tipoProcesso.setObservadores(this.observadorDTOSetToUsuarioSet(tipoProcessoDTO.getObservadores()));
        return tipoProcesso;
    }

    public TipoProcesso toTipoProcesso(TipoProcessoSimpleDTO tipoProcessoSimpleDTO) {
        if (tipoProcessoSimpleDTO == null) {
            return null;
        }
        TipoProcesso tipoProcesso = new TipoProcesso();
        tipoProcesso.setId(tipoProcessoSimpleDTO.getId());
        tipoProcesso.setDescricao(tipoProcessoSimpleDTO.getDescricao());
        tipoProcesso.setSigiloso(tipoProcessoSimpleDTO.getSigiloso());
        tipoProcesso.setTipoProcessoMp(tipoProcessoSimpleDTO.getTipoProcessoMp());
        return tipoProcesso;
    }

    public TipoProcesso toTipoProcesso(TipoProcessoDTO tipoProcessoDTO, TipoProcesso existing) {
        if (tipoProcessoDTO == null) {
            return null;
        }
        existing.setId(tipoProcessoDTO.getId());
        existing.setDescricao(tipoProcessoDTO.getDescricao());
        existing.setDiasVencimento(tipoProcessoDTO.getDiasVencimento());
        existing.setCaminhoCapa(tipoProcessoDTO.getCaminhoCapa());
        existing.setCaminhoRequerimento(tipoProcessoDTO.getCaminhoRequerimento());
        existing.setCaminhoCapaAgrupamentoArquivo(tipoProcessoDTO.getCaminhoCapaAgrupamentoArquivo());
        existing.setCompra(tipoProcessoDTO.getCompra());
        existing.setAtivo(tipoProcessoDTO.getAtivo());
        existing.setImprimeComprovante(tipoProcessoDTO.getImprimeComprovante());
        existing.setImprimeCapaProcesso(tipoProcessoDTO.getImprimeCapaProcesso());
        existing.setImprimeEtiqueta(tipoProcessoDTO.getImprimeEtiqueta());
        existing.setSigiloso(tipoProcessoDTO.getSigiloso());
        existing.setTipoInterno(tipoProcessoDTO.getTipoInterno());
        existing.setComunicacaoInterna(tipoProcessoDTO.getComunicacaoInterna());
        existing.setPadraoFisico(tipoProcessoDTO.getPadraoFisico());
        existing.setAssuntoFixo(tipoProcessoDTO.getAssuntoFixo());
        existing.setPrioridadePadrao(tipoProcessoDTO.getPrioridadePadrao());
        existing.setTipoProcessoMp(tipoProcessoDTO.getTipoProcessoMp());
        existing.setConsultaExterna(tipoProcessoDTO.getConsultaExterna());
        existing.setUploadAnexoSemRestricao(tipoProcessoDTO.getUploadAnexoSemRestricao());
        if (existing.getTipoProcessoEntidade() != null) {
            list = this.tipoProcessoEntidadeDTOListToTipoProcessoEntidadeList(tipoProcessoDTO.getTipoProcessoEntidade());
            if (list != null) {
                existing.getTipoProcessoEntidade().clear();
                existing.getTipoProcessoEntidade().addAll(list);
            } else {
                existing.setTipoProcessoEntidade(null);
            }
        } else {
            list = this.tipoProcessoEntidadeDTOListToTipoProcessoEntidadeList(tipoProcessoDTO.getTipoProcessoEntidade());
            if (list != null) {
                existing.setTipoProcessoEntidade(list);
            }
        }
        if (existing.getAssuntos() != null) {
            set = this.assuntoDTOSetToAssuntoSet(tipoProcessoDTO.getAssuntos());
            if (set != null) {
                existing.getAssuntos().clear();
                existing.getAssuntos().addAll(set);
            } else {
                existing.setAssuntos(null);
            }
        } else {
            set = this.assuntoDTOSetToAssuntoSet(tipoProcessoDTO.getAssuntos());
            if (set != null) {
                existing.setAssuntos(set);
            }
        }
        if (existing.getSituacoes() != null) {
            set1 = this.situacaoDTOSetToSituacaoSet(tipoProcessoDTO.getSituacoes());
            if (set1 != null) {
                existing.getSituacoes().clear();
                existing.getSituacoes().addAll(set1);
            } else {
                existing.setSituacoes(null);
            }
        } else {
            set1 = this.situacaoDTOSetToSituacaoSet(tipoProcessoDTO.getSituacoes());
            if (set1 != null) {
                existing.setSituacoes(set1);
            }
        }
        if (existing.getObservadores() != null) {
            set2 = this.observadorDTOSetToUsuarioSet(tipoProcessoDTO.getObservadores());
            if (set2 != null) {
                existing.getObservadores().clear();
                existing.getObservadores().addAll(set2);
            } else {
                existing.setObservadores(null);
            }
        } else {
            set2 = this.observadorDTOSetToUsuarioSet(tipoProcessoDTO.getObservadores());
            if (set2 != null) {
                existing.setObservadores(set2);
            }
        }
        return existing;
    }

    public TipoProcesso toTipoProcesso(TipoProcessoSimpleDTO tipoProcessoSimpleDTO, TipoProcesso existing) {
        if (tipoProcessoSimpleDTO == null) {
            return null;
        }
        existing.setId(tipoProcessoSimpleDTO.getId());
        existing.setDescricao(tipoProcessoSimpleDTO.getDescricao());
        existing.setSigiloso(tipoProcessoSimpleDTO.getSigiloso());
        existing.setTipoProcessoMp(tipoProcessoSimpleDTO.getTipoProcessoMp());
        return existing;
    }

    public TipoProcessoDTO toTipoProcessoDTO(TipoProcesso tipoProcesso) {
        if (tipoProcesso == null) {
            return null;
        }
        TipoProcessoDTO tipoProcessoDTO = new TipoProcessoDTO();
        tipoProcessoDTO.setId(tipoProcesso.getId());
        tipoProcessoDTO.setDescricao(tipoProcesso.getDescricao());
        tipoProcessoDTO.setDiasVencimento(tipoProcesso.getDiasVencimento());
        tipoProcessoDTO.setCaminhoCapa(tipoProcesso.getCaminhoCapa());
        tipoProcessoDTO.setCaminhoRequerimento(tipoProcesso.getCaminhoRequerimento());
        tipoProcessoDTO.setCaminhoCapaAgrupamentoArquivo(tipoProcesso.getCaminhoCapaAgrupamentoArquivo());
        tipoProcessoDTO.setCompra(tipoProcesso.getCompra());
        tipoProcessoDTO.setAtivo(tipoProcesso.getAtivo());
        tipoProcessoDTO.setSigiloso(tipoProcesso.getSigiloso());
        tipoProcessoDTO.setImprimeComprovante(tipoProcesso.getImprimeComprovante());
        tipoProcessoDTO.setImprimeCapaProcesso(tipoProcesso.getImprimeCapaProcesso());
        tipoProcessoDTO.setImprimeEtiqueta(tipoProcesso.getImprimeEtiqueta());
        tipoProcessoDTO.setTipoInterno(tipoProcesso.getTipoInterno());
        tipoProcessoDTO.setComunicacaoInterna(tipoProcesso.getComunicacaoInterna());
        tipoProcessoDTO.setPadraoFisico(tipoProcesso.getPadraoFisico());
        tipoProcessoDTO.setUploadAnexoSemRestricao(tipoProcesso.getUploadAnexoSemRestricao());
        tipoProcessoDTO.setTipoProcessoMp(tipoProcesso.getTipoProcessoMp());
        tipoProcessoDTO.setTipoProcessoEntidade(this.tipoProcessoEntidadeListToTipoProcessoEntidadeDTOList(tipoProcesso.getTipoProcessoEntidade()));
        tipoProcessoDTO.setAssuntos(this.assuntoSetToAssuntoDTOSet(tipoProcesso.getAssuntos()));
        tipoProcessoDTO.setSituacoes(this.situacaoSetToSituacaoDTOSet(tipoProcesso.getSituacoes()));
        tipoProcessoDTO.setObservadores(this.usuarioSetToObservadorDTOSet(tipoProcesso.getObservadores()));
        tipoProcessoDTO.setSituacaoPadrao(this.toSituacaoDTO(tipoProcesso.getSituacaoPadrao()));
        tipoProcessoDTO.setAssuntoPadrao(this.toAssuntoDTO(tipoProcesso.getAssuntoPadrao()));
        tipoProcessoDTO.setAssuntoFixo(tipoProcesso.getAssuntoFixo());
        tipoProcessoDTO.setPrioridadePadrao(tipoProcesso.getPrioridadePadrao());
        tipoProcessoDTO.setConsultaExterna(tipoProcesso.getConsultaExterna());
        return tipoProcessoDTO;
    }

    public TipoProcessoSimpleDTO toTipoProcessoSimpleDTO(TipoProcesso tipoProcesso) {
        if (tipoProcesso == null) {
            return null;
        }
        TipoProcessoSimpleDTO tipoProcessoSimpleDTO = new TipoProcessoSimpleDTO();
        tipoProcessoSimpleDTO.setId(tipoProcesso.getId());
        tipoProcessoSimpleDTO.setDescricao(tipoProcesso.getDescricao());
        tipoProcessoSimpleDTO.setTipoProcessoMp(tipoProcesso.getTipoProcessoMp());
        tipoProcessoSimpleDTO.setSigiloso(tipoProcesso.getSigiloso());
        return tipoProcessoSimpleDTO;
    }

    public Diretoria toDiretoria(DiretoriaDTO diretoria) {
        if (diretoria == null) {
            return null;
        }
        Diretoria diretoria1 = new Diretoria();
        diretoria1.setDescricao(diretoria.getDescricao());
        diretoria1.setId(this.toDiretoriaPK(diretoria.getId(), diretoria.getEntidade()));
        return diretoria1;
    }

    public DiretoriaDTO toDiretoriaDTO(Diretoria diretoria) {
        if (diretoria == null) {
            return null;
        }
        DiretoriaDTO diretoriaDTO = new DiretoriaDTO();
        diretoriaDTO.setEntidade(this.toEntidadeDTO(this.diretoriaIdEntidade(diretoria)));
        diretoriaDTO.setId(this.diretoriaIdId(diretoria));
        diretoriaDTO.setDescricao(diretoria.getDescricao());
        return diretoriaDTO;
    }

    public DiretoriaPK toDiretoriaPK(Long id, EntidadeDTO entidade) {
        if (id == null && entidade == null) {
            return null;
        }
        DiretoriaPK diretoriaPK = new DiretoriaPK();
        if (id != null) {
            diretoriaPK.setId(id);
        }
        diretoriaPK.setEntidade(this.toEntidade(entidade));
        return diretoriaPK;
    }

    public Gerencia toGerencia(GerenciaDTO gerencia) {
        if (gerencia == null) {
            return null;
        }
        Gerencia gerencia1 = new Gerencia();
        gerencia1.setDescricao(gerencia.getDescricao());
        gerencia1.setId(this.toGerenciaPK(gerencia.getId(), gerencia.getEntidade()));
        return gerencia1;
    }

    public GerenciaDTO toGerenciaDTO(Gerencia gerencia) {
        if (gerencia == null) {
            return null;
        }
        GerenciaDTO gerenciaDTO = new GerenciaDTO();
        gerenciaDTO.setEntidade(this.toEntidadeDTO(this.gerenciaIdEntidade(gerencia)));
        gerenciaDTO.setId(this.gerenciaIdId(gerencia));
        gerenciaDTO.setDescricao(gerencia.getDescricao());
        return gerenciaDTO;
    }

    public GerenciaPK toGerenciaPK(Long id, EntidadeDTO entidade) {
        if (id == null && entidade == null) {
            return null;
        }
        GerenciaPK gerenciaPK = new GerenciaPK();
        if (id != null) {
            gerenciaPK.setId(id);
        }
        gerenciaPK.setEntidade(this.toEntidade(entidade));
        return gerenciaPK;
    }

    public Coordenadoria toCoordenadoria(CoordenadoriaDTO coordenadoria) {
        if (coordenadoria == null) {
            return null;
        }
        Coordenadoria coordenadoria1 = new Coordenadoria();
        coordenadoria1.setDescricao(coordenadoria.getDescricao());
        coordenadoria1.setId(this.toCoordenadoriaPK(coordenadoria.getId(), coordenadoria.getEntidade()));
        return coordenadoria1;
    }

    public CoordenadoriaDTO toCoordenadoriaDTO(Coordenadoria coordenadoria) {
        if (coordenadoria == null) {
            return null;
        }
        CoordenadoriaDTO coordenadoriaDTO = new CoordenadoriaDTO();
        coordenadoriaDTO.setEntidade(this.toEntidadeDTO(this.coordenadoriaIdEntidade(coordenadoria)));
        coordenadoriaDTO.setId(this.coordenadoriaIdId(coordenadoria));
        coordenadoriaDTO.setDescricao(coordenadoria.getDescricao());
        return coordenadoriaDTO;
    }

    public CoordenadoriaPK toCoordenadoriaPK(Long id, EntidadeDTO entidade) {
        if (id == null && entidade == null) {
            return null;
        }
        CoordenadoriaPK coordenadoriaPK = new CoordenadoriaPK();
        if (id != null) {
            coordenadoriaPK.setId(id);
        }
        if (entidade != null) {
            coordenadoriaPK.setEntidade(this.toEntidade(entidade));
        }
        return coordenadoriaPK;
    }

    public ParametroDTO toParametroDTO(Parametro parametro) {
        if (parametro == null) {
            return null;
        }
        ParametroDTO parametroDTO = new ParametroDTO();
        parametroDTO.setEntidade(this.toEntidadeDTO(this.parametroIdEntidade(parametro)));
        parametroDTO.setId(this.parametroIdId(parametro));
        parametroDTO.setExercicio(this.parametroIdExercicio(parametro));
        parametroDTO.setModulo(this.toModuloDTO(this.parametroIdModulo(parametro)));
        parametroDTO.setDescricao(parametro.getDescricao());
        parametroDTO.setTipo(parametro.getTipo());
        parametroDTO.setObservacao(parametro.getObservacao());
        parametroDTO.setValor(parametro.getValor());
        parametroDTO.setGrupo(this.toParametroGrupo(parametro.getGrupo()));
        if (parametro.getSistema() != null) {
            parametroDTO.setSistema(parametro.getSistema().name());
        }
        return parametroDTO;
    }

    public DiretoriaPK toDiretoriaPK(EntidadeDTO entidade, Long id) {
        if (entidade == null && id == null) {
            return null;
        }
        DiretoriaPK diretoriaPK = new DiretoriaPK();
        if (entidade != null) {
            diretoriaPK.setEntidade(this.toEntidade(entidade));
            diretoriaPK.setId(entidade.getId());
        }
        return diretoriaPK;
    }

    public Secretaria toSecretaria(SecretariaDTO dto, Secretaria secretaria) {
        if (dto == null) {
            return null;
        }
        secretaria.setDescricao(dto.getDescricao());
        if (dto.getResponsavel() != null) {
            if (secretaria.getResponsavel() == null) {
                secretaria.setResponsavel(new Pessoa());
            }
            this.toPessoa(dto.getResponsavel(), secretaria.getResponsavel());
        } else {
            secretaria.setResponsavel(null);
        }
        secretaria.setEmail(dto.getEmail());
        secretaria.setSenhaEmail(dto.getSenhaEmail());
        secretaria.setId(this.toSecretariaPK(dto.getEntidade(), dto.getId()));
        return secretaria;
    }

    public SecretariaDTO toSecretariaDTO(Secretaria secretaria) {
        if (secretaria == null) {
            return null;
        }
        SecretariaDTO secretariaDTO = new SecretariaDTO();
        secretariaDTO.setEntidade(this.toEntidadeDTO(this.secretariaIdEntidade(secretaria)));
        secretariaDTO.setId(this.secretariaIdId(secretaria));
        secretariaDTO.setDescricao(secretaria.getDescricao());
        secretariaDTO.setResponsavel(this.toPessoaDTO(secretaria.getResponsavel()));
        secretariaDTO.setEmail(secretaria.getEmail());
        secretariaDTO.setSenhaEmail(secretaria.getSenhaEmail());
        return secretariaDTO;
    }

    public SecretariaPK toSecretariaPK(EntidadeDTO entidade, Long id) {
        if (entidade == null && id == null) {
            return null;
        }
        SecretariaPK secretariaPK = new SecretariaPK();
        if (entidade != null) {
            secretariaPK.setEntidade(this.toEntidade(entidade));
        }
        if (id != null) {
            secretariaPK.setId(id);
        }
        return secretariaPK;
    }

    public ParametroPK toParametroPK(EntidadeDTO entidade, ModuloDTO modulo, Long exercicio, Long id) {
        if (entidade == null && modulo == null && exercicio == null && id == null) {
            return null;
        }
        ParametroPK parametroPK = new ParametroPK();
        if (entidade != null) {
            parametroPK.setEntidade(this.toEntidade(entidade));
        }
        if (modulo != null) {
            parametroPK.setModulo(this.toModulo(modulo));
        }
        if (exercicio != null) {
            parametroPK.setExercicio(exercicio);
        }
        if (id != null) {
            parametroPK.setId(id);
        }
        return parametroPK;
    }

    public Parametro toParametro(ParametroDTO parametro) {
        if (parametro == null) {
            return null;
        }
        Parametro parametro1 = new Parametro();
        parametro1.setExercicio(parametro.getExercicio());
        parametro1.setDescricao(parametro.getDescricao());
        parametro1.setTipo(parametro.getTipo());
        parametro1.setObservacao(parametro.getObservacao());
        parametro1.setValor(parametro.getValor());
        parametro1.setGrupo(this.toParametroGrupo(parametro.getGrupo()));
        if (parametro.getSistema() != null) {
            parametro1.setSistema(Enum.valueOf(ParametroSistemaEnum.class, parametro.getSistema()));
        }
        parametro1.setId(this.toParametroPK(parametro.getEntidade(), parametro.getModulo(), parametro.getExercicio(), parametro.getId()));
        return parametro1;
    }

    public UsuarioResponsavel toUsuarioResponsavel(UsuarioResponsavelDTO usuarioResponsavelDTO, UsuarioResponsavel existing) {
        if (usuarioResponsavelDTO == null) {
            return null;
        }
        existing.setId(usuarioResponsavelDTO.getId());
        existing.setNome(usuarioResponsavelDTO.getNome());
        return existing;
    }

    public UsuarioResponsavelDTO toUsuarioResponsavelDTO(UsuarioResponsavel usuarioResponsavel) {
        if (usuarioResponsavel == null) {
            return null;
        }
        UsuarioResponsavelDTO usuarioResponsavelDTO = new UsuarioResponsavelDTO();
        usuarioResponsavelDTO.setId(usuarioResponsavel.getId());
        usuarioResponsavelDTO.setNome(usuarioResponsavel.getNome());
        return usuarioResponsavelDTO;
    }

    public UnidadeOrcamentariaDTO toUnidadeOrcamentariaDTO(UnidadeOrcamentaria unidadeOrcamentaria) {
        if (unidadeOrcamentaria == null) {
            return null;
        }
        UnidadeOrcamentariaDTO unidadeOrcamentariaDTO = new UnidadeOrcamentariaDTO();
        unidadeOrcamentariaDTO.setCodigo(this.unidadeOrcamentariaIdCodigo(unidadeOrcamentaria));
        unidadeOrcamentariaDTO.setOrgao(this.toUnidadeDTO(this.unidadeOrcamentariaIdOrgao(unidadeOrcamentaria)));
        unidadeOrcamentariaDTO.setDescricao(unidadeOrcamentaria.getDescricao());
        unidadeOrcamentariaDTO.setId(unidadeOrcamentaria.getId().getKey());
        return unidadeOrcamentariaDTO;
    }

    public UnidadeOrcamentariaPK toUnidadeOrcamentariaPK(UnidadeOrcamentariaDTO dto) {
        if (dto == null) {
            return null;
        }
        UnidadeOrcamentariaPK unidadeOrcamentariaPK = new UnidadeOrcamentariaPK();
        unidadeOrcamentariaPK.setCodigo(dto.getCodigo());
        unidadeOrcamentariaPK.setOrgao(this.toUnidade(dto.getOrgao()));
        return unidadeOrcamentariaPK;
    }

    public UnidadeOrcamentaria toUnidadeOrcamentaria(UnidadeOrcamentariaDTO dto) {
        if (dto == null) {
            return null;
        }
        UnidadeOrcamentaria unidadeOrcamentaria = new UnidadeOrcamentaria();
        unidadeOrcamentaria.setDescricao(dto.getDescricao());
        unidadeOrcamentaria.setId(this.toUnidadeOrcamentariaPK(dto));
        return unidadeOrcamentaria;
    }

    public ParametroGrupo toParametroGrupo(ParametroGrupoDTO parametroGrupoDTO) {
        if (parametroGrupoDTO == null) {
            return null;
        }
        ParametroGrupo parametroGrupo = new ParametroGrupo();
        parametroGrupo.setGrupoPai(this.toParametroGrupo(parametroGrupoDTO.getGrupo()));
        parametroGrupo.setId(parametroGrupoDTO.getId());
        parametroGrupo.setDescricao(parametroGrupoDTO.getDescricao());
        return parametroGrupo;
    }

    public ParametroGrupoDTO toParametroGrupo(ParametroGrupo parametroGrupo) {
        if (parametroGrupo == null) {
            return null;
        }
        ParametroGrupoDTO parametroGrupoDTO = new ParametroGrupoDTO();
        parametroGrupoDTO.setGrupo(this.toParametroGrupo(parametroGrupo.getGrupoPai()));
        parametroGrupoDTO.setId(parametroGrupo.getId());
        parametroGrupoDTO.setDescricao(parametroGrupo.getDescricao());
        return parametroGrupoDTO;
    }

    public Roteiro toRoteiro(RoteiroDTO roteiroDTO) {
        if (roteiroDTO == null) {
            return null;
        }
        Roteiro roteiro = new Roteiro();
        roteiro.setDescricao(roteiroDTO.getDescricao());
        roteiro.setId(roteiroDTO.getId());
        roteiro.setEntidade(this.toEntidade(roteiroDTO.getEntidade()));
        roteiro.setAtivo(roteiroDTO.getAtivo());
        return roteiro;
    }

    public RoteiroDTO toRoteiroDTO(Roteiro roteiro) {
        if (roteiro == null) {
            return null;
        }
        RoteiroDTO roteiroDTO = new RoteiroDTO();
        roteiroDTO.setId(roteiro.getId());
        roteiroDTO.setEntidade(this.toEntidadeDTO(roteiro.getEntidade()));
        roteiroDTO.setDescricao(roteiro.getDescricao());
        roteiroDTO.setRoteiroLocal(this.roteiroLocalListToRoteiroLocalDTOList(roteiro.getRoteiroLocal()));
        roteiroDTO.setAtivo(roteiro.getAtivo());
        return roteiroDTO;
    }

    public RoteiroLocal toRoteiroLocal(RoteiroLocalDTO roteiroLocalDTO) {
        if (roteiroLocalDTO == null) {
            return null;
        }
        RoteiroLocal roteiroLocal = new RoteiroLocal();
        roteiroLocal.setQuantidadeDias(roteiroLocalDTO.getQuantidadeDias());
        roteiroLocal.setEntidade(this.toEntidade(roteiroLocalDTO.getEntidade()));
        roteiroLocal.setLocal(this.toLocal(roteiroLocalDTO.getLocal()));
        roteiroLocal.setSequencia(roteiroLocalDTO.getSequencia());
        roteiroLocal.setId(roteiroLocalDTO.getId());
        roteiroLocal.setPermiteArquivamento(roteiroLocalDTO.getPermiteArquivamento());
        return roteiroLocal;
    }

    public RoteiroLocalDTO toRoteiroLocalDTO(RoteiroLocal roteiroLocal) {
        if (roteiroLocal == null) {
            return null;
        }
        RoteiroLocalDTO roteiroLocalDTO = new RoteiroLocalDTO();
        roteiroLocalDTO.setId(roteiroLocal.getId());
        roteiroLocalDTO.setLocal(this.toLocalDTO(roteiroLocal.getLocal()));
        roteiroLocalDTO.setEntidade(this.toEntidadeDTO(roteiroLocal.getEntidade()));
        roteiroLocalDTO.setQuantidadeDias(roteiroLocal.getQuantidadeDias());
        roteiroLocalDTO.setSequencia(roteiroLocal.getSequencia());
        roteiroLocalDTO.setPermiteArquivamento(roteiroLocal.getPermiteArquivamento());
        return roteiroLocalDTO;
    }

    public ProcessoPKDTO toProcessoPKDTO(ProcessoPK processoPK) {
        if (processoPK == null) {
            return null;
        }
        ProcessoPKDTO.ProcessoPKDTOBuilder processoPKDTO = ProcessoPKDTO.builder();
        processoPKDTO.entidade(this.toEntidadeDTO(processoPK.getEntidade()));
        processoPKDTO.tipo(this.toTipoProcessoSimpleDTO(processoPK.getTipo()));
        processoPKDTO.ano(processoPK.getAno());
        processoPKDTO.numero(processoPK.getNumero());
        return processoPKDTO.build();
    }

    public GrauSigilo toGrauSigilo(GrauSigiloDTO grauSigiloDTO) {
        if (grauSigiloDTO == null) {
            return null;
        }
        GrauSigilo grauSigilo = new GrauSigilo();
        if (grauSigiloDTO.getTipo() != null) {
            grauSigilo.setTipo(Enum.valueOf(TipoGrauSigiloEnum.class, grauSigiloDTO.getTipo()));
        }
        grauSigilo.setId(grauSigiloDTO.getId());
        grauSigilo.setDescricao(grauSigiloDTO.getDescricao());
        grauSigilo.setFundamentoLegal(grauSigiloDTO.getFundamentoLegal());
        return grauSigilo;
    }

    public GrauSigiloDTO toGrauSigiloDTO(GrauSigilo grauSigilo) {
        if (grauSigilo == null) {
            return null;
        }
        GrauSigiloDTO grauSigiloDTO = new GrauSigiloDTO();
        if (grauSigilo.getTipo() != null) {
            grauSigiloDTO.setTipo(grauSigilo.getTipo().name());
        }
        grauSigiloDTO.setId(grauSigilo.getId());
        grauSigiloDTO.setDescricao(grauSigilo.getDescricao());
        grauSigiloDTO.setFundamentoLegal(grauSigilo.getFundamentoLegal());
        return grauSigiloDTO;
    }

    public EscolaridadeDTO toEscolaridadeDTO(Escolaridade escolaridade) {
        if (escolaridade == null) {
            return null;
        }
        EscolaridadeDTO escolaridadeDTO = new EscolaridadeDTO();
        escolaridadeDTO.setId(escolaridade.getId());
        escolaridadeDTO.setDescricao(escolaridade.getDescricao());
        return escolaridadeDTO;
    }

    public Escolaridade toEscolaridade(EscolaridadeDTO escolaridadeDTO) {
        if (escolaridadeDTO == null) {
            return null;
        }
        Escolaridade escolaridade = new Escolaridade();
        escolaridade.setId(escolaridadeDTO.getId());
        escolaridade.setDescricao(escolaridadeDTO.getDescricao());
        return escolaridade;
    }

    public ProcessoInteressadoDTO toProcessoInteressadoDTO(ProcessoInteressado processoInteressado) {
        if (processoInteressado == null) {
            return null;
        }
        ProcessoInteressadoDTO processoInteressadoDTO = new ProcessoInteressadoDTO();
        processoInteressadoDTO.setCodigo(this.processoInteressadoIdCodigo(processoInteressado));
        processoInteressadoDTO.setPessoa(this.toPessoaDTO(processoInteressado.getPessoa()));
        if (processoInteressado.getTipoInteresse() != null) {
            processoInteressadoDTO.setTipoInteresse(processoInteressado.getTipoInteresse().name());
        }
        processoInteressadoDTO.setTipoParticipante(this.toTipoParticipanteDTO(processoInteressado.getTipoParticipante()));
        processoInteressadoDTO.setLocalTrabalho(processoInteressado.getLocalTrabalho());
        return processoInteressadoDTO;
    }

    public ProcessoInteressadoPK toProcessoInteressadoPK(ProcessoInteressadoDTO dto) {
        if (dto == null) {
            return null;
        }
        ProcessoInteressadoPK processoInteressadoPK = new ProcessoInteressadoPK();
        processoInteressadoPK.setCodigo(dto.getCodigo());
        return processoInteressadoPK;
    }

    public ProcessoInteressado toProcessoInteressado(ProcessoInteressadoDTO dto, ProcessoInteressado existing) {
        if (dto == null) {
            return null;
        }
        existing.setTipoParticipante(this.toTipoParticipante(dto.getTipoParticipante()));
        existing.setLocalTrabalho(dto.getLocalTrabalho());
        return existing;
    }

    public TipoParticipante toTipoParticipante(TipoParticipanteDTO dto) {
        if (dto == null) {
            return null;
        }
        TipoParticipante tipoParticipante = new TipoParticipante();
        tipoParticipante.setId(dto.getId());
        tipoParticipante.setDescricao(dto.getDescricao());
        return tipoParticipante;
    }

    public TipoParticipanteDTO toTipoParticipanteDTO(TipoParticipante tipoParticipante) {
        if (tipoParticipante == null) {
            return null;
        }
        TipoParticipanteDTO tipoParticipanteDTO = new TipoParticipanteDTO();
        tipoParticipanteDTO.setId(tipoParticipante.getId());
        tipoParticipanteDTO.setDescricao(tipoParticipante.getDescricao());
        return tipoParticipanteDTO;
    }

    public ProcessoAndamento toProcessoAndamento(ProcessoAndamentoDTO dto) {
        if (dto == null) {
            return null;
        }
        ProcessoAndamento processoAndamento = new ProcessoAndamento();
        processoAndamento.setProcesso(this.processoAndamentoDTOToProcesso(dto));
        processoAndamento.setId(dto.getId());
        processoAndamento.setNumeroAndamento(dto.getNumeroAndamento());
        processoAndamento.setDataHora(dto.getDataHora());
        processoAndamento.setUsuario(dto.getUsuario());
        processoAndamento.setUsuarioNome(dto.getUsuarioNome());
        processoAndamento.setDescricao(dto.getDescricao());
        processoAndamento.setSolicitacaoRequerente(dto.getSolicitacaoRequerente());
        processoAndamento.setRespostaRequerente(dto.getRespostaRequerente());
        processoAndamento.setDataHoraResposta(dto.getDataHoraResposta());
        processoAndamento.setModulo(dto.getModulo());
        processoAndamento.setDataInicio(dto.getDataInicio());
        processoAndamento.setDataTermino(dto.getDataTermino());
        processoAndamento.setDataFinalizacao(dto.getDataFinalizacao());
        processoAndamento.setFinalizado(dto.getFinalizado());
        processoAndamento.setTramite(dto.getTramite());
        processoAndamento.setObservadorExtId(dto.getObservadorExtId());
        processoAndamento.setDiasSuspensao(dto.getDiasSuspensao());
        processoAndamento.setAssuntoOld(this.toAssunto(dto.getAssuntoOld()));
        processoAndamento.setAssuntoNew(this.toAssunto(dto.getAssuntoNew()));
        processoAndamento.setSituacao(dto.getSituacao());
        processoAndamento.setResposta(dto.getResposta());
        processoAndamento.setAlteracaoRequerente(this.processoAndamentoAlteracaoRequerenteDTOToProcessoAndamentoAlteracaoRequerente(dto.getAlteracaoRequerente()));
        return processoAndamento;
    }

    public ProcessoAndamento toProcessoAndamento(ProcessoAndamentoSimpleDTO dto) {
        if (dto == null) {
            return null;
        }
        ProcessoAndamento processoAndamento = new ProcessoAndamento();
        processoAndamento.setProcesso(this.processoAndamentoSimpleDTOToProcesso(dto));
        processoAndamento.setId(dto.getId());
        processoAndamento.setNumeroAndamento(dto.getNumeroAndamento());
        processoAndamento.setDataHora(dto.getDataHora());
        processoAndamento.setUsuario(dto.getUsuario());
        processoAndamento.setUsuarioNome(dto.getUsuarioNome());
        processoAndamento.setDescricao(dto.getDescricao());
        processoAndamento.setSolicitacaoRequerente(dto.getSolicitacaoRequerente());
        processoAndamento.setRespostaRequerente(dto.getRespostaRequerente());
        processoAndamento.setDataHoraResposta(dto.getDataHoraResposta());
        processoAndamento.setModulo(dto.getModulo());
        processoAndamento.setDataInicio(dto.getDataInicio());
        processoAndamento.setDataTermino(dto.getDataTermino());
        processoAndamento.setDataFinalizacao(dto.getDataFinalizacao());
        processoAndamento.setFinalizado(dto.getFinalizado());
        processoAndamento.setTramite(dto.getTramite());
        processoAndamento.setObservadorExtId(dto.getObservadorExtId());
        processoAndamento.setDiasSuspensao(dto.getDiasSuspensao());
        processoAndamento.setAssuntoOld(this.toAssunto(dto.getAssuntoOld()));
        processoAndamento.setAssuntoNew(this.toAssunto(dto.getAssuntoNew()));
        processoAndamento.setSituacao(dto.getSituacao());
        processoAndamento.setResposta(dto.getResposta());
        processoAndamento.setBloqueioAnexoExterno(dto.getBloqueioAnexoExterno());
        processoAndamento.setRequerenteSigiloso(dto.getRequerenteSigiloso());
        processoAndamento.setAlteracaoRequerente(this.processoAndamentoAlteracaoRequerenteDTOToProcessoAndamentoAlteracaoRequerente(dto.getAlteracaoRequerente()));
        return processoAndamento;
    }

    public ProcessoAndamentoDTO toProcessoAndamentoDTO(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        ProcessoAndamentoDTO processoAndamentoDTO = new ProcessoAndamentoDTO();
        processoAndamentoDTO.setEntidade(this.toEntidadeDTO(this.processoAndamentoProcessoIdEntidade(processoAndamento)));
        processoAndamentoDTO.setTipo(this.toTipoProcessoSimpleDTO(this.processoAndamentoProcessoIdTipo(processoAndamento)));
        processoAndamentoDTO.setAno(this.processoAndamentoProcessoIdAno(processoAndamento));
        processoAndamentoDTO.setNumero(this.processoAndamentoProcessoIdNumero(processoAndamento));
        processoAndamentoDTO.setId(processoAndamento.getId());
        processoAndamentoDTO.setNumeroAndamento(processoAndamento.getNumeroAndamento());
        processoAndamentoDTO.setDataHora(processoAndamento.getDataHora());
        processoAndamentoDTO.setDescricao(processoAndamento.getDescricao());
        processoAndamentoDTO.setUsuario(processoAndamento.getUsuario());
        processoAndamentoDTO.setUsuarioNome(processoAndamento.getUsuarioNome());
        processoAndamentoDTO.setTramite(processoAndamento.getTramite());
        processoAndamentoDTO.setSolicitacaoRequerente(processoAndamento.getSolicitacaoRequerente());
        processoAndamentoDTO.setRespostaRequerente(processoAndamento.getRespostaRequerente());
        processoAndamentoDTO.setDataHoraResposta(processoAndamento.getDataHoraResposta());
        processoAndamentoDTO.setModulo(processoAndamento.getModulo());
        processoAndamentoDTO.setTipoAndamento(this.toTipoAndamentoDTO(processoAndamento.getTipoAndamento()));
        processoAndamentoDTO.setDataInicio(processoAndamento.getDataInicio());
        processoAndamentoDTO.setDataTermino(processoAndamento.getDataTermino());
        processoAndamentoDTO.setDataFinalizacao(processoAndamento.getDataFinalizacao());
        processoAndamentoDTO.setFinalizado(processoAndamento.getFinalizado());
        processoAndamentoDTO.setObservadorExtId(processoAndamento.getObservadorExtId());
        processoAndamentoDTO.setDiasSuspensao(processoAndamento.getDiasSuspensao());
        processoAndamentoDTO.setAssuntoOld(this.toAssuntoDTO(processoAndamento.getAssuntoOld()));
        processoAndamentoDTO.setAssuntoNew(this.toAssuntoDTO(processoAndamento.getAssuntoNew()));
        processoAndamentoDTO.setSituacao(processoAndamento.getSituacao());
        processoAndamentoDTO.setLocal(this.toLocalDTO(processoAndamento.getLocal()));
        processoAndamentoDTO.setUsuarioResponsavel(this.toUsuarioDTO(processoAndamento.getUsuarioResponsavel()));
        processoAndamentoDTO.setResposta(processoAndamento.getResposta());
        processoAndamentoDTO.setAlteracaoRequerente(this.processoAndamentoAlteracaoRequerenteToProcessoAndamentoAlteracaoRequerenteDTO(processoAndamento.getAlteracaoRequerente()));
        return processoAndamentoDTO;
    }

    public TipoAndamento toTipoAndamento(TipoAndamentoDTO tipoAndamentoDTO) {
        if (tipoAndamentoDTO == null) {
            return null;
        }
        TipoAndamento tipoAndamento = new TipoAndamento();
        tipoAndamento.setId(tipoAndamentoDTO.getId());
        tipoAndamento.setDescricao(tipoAndamentoDTO.getDescricao());
        tipoAndamento.setControlaPrazo(tipoAndamentoDTO.getControlaPrazo());
        tipoAndamento.setPrazoBase(tipoAndamentoDTO.getPrazoBase());
        if (tipoAndamentoDTO.getTipo() != null) {
            tipoAndamento.setTipo(Enum.valueOf(TipoAndamentoEnum.class, tipoAndamentoDTO.getTipo()));
        }
        tipoAndamento.setAudit(this.toAuditInfo(tipoAndamentoDTO.getAudit()));
        return tipoAndamento;
    }

    public TipoAndamentoDTO toTipoAndamentoDTO(TipoAndamento tipoAndamento) {
        if (tipoAndamento == null) {
            return null;
        }
        TipoAndamentoDTO tipoAndamentoDTO = new TipoAndamentoDTO();
        tipoAndamentoDTO.setId(tipoAndamento.getId());
        tipoAndamentoDTO.setDescricao(tipoAndamento.getDescricao());
        tipoAndamentoDTO.setControlaPrazo(tipoAndamento.getControlaPrazo());
        tipoAndamentoDTO.setPrazoBase(tipoAndamento.getPrazoBase());
        if (tipoAndamento.getTipo() != null) {
            tipoAndamentoDTO.setTipo(tipoAndamento.getTipo().name());
        }
        tipoAndamentoDTO.setAudit(this.toAuditInfoDTO(tipoAndamento.getAudit()));
        return tipoAndamentoDTO;
    }

    public DadosProcessoMPDTO toDadosProcessoMPDTO(DadosProcessoMP dadosProcessoMP) {
        if (dadosProcessoMP == null) {
            return null;
        }
        DadosProcessoMPDTO dadosProcessoMPDTO = new DadosProcessoMPDTO();
        dadosProcessoMPDTO.setDistribuicao(this.usuarioToUsuarioPermissaoLocalDTO1(dadosProcessoMP.getDistribuicao()));
        dadosProcessoMPDTO.setId(dadosProcessoMP.getId());
        dadosProcessoMPDTO.setTitulo(dadosProcessoMP.getTitulo());
        dadosProcessoMPDTO.setDescricao(dadosProcessoMP.getDescricao());
        dadosProcessoMPDTO.setPrivado(dadosProcessoMP.getPrivado());
        dadosProcessoMPDTO.setInteressado(dadosProcessoMP.getInteressado());
        dadosProcessoMPDTO.setTipoDocumento(dadosProcessoMP.getTipoDocumento());
        dadosProcessoMPDTO.setRequerente(dadosProcessoMP.getRequerente());
        dadosProcessoMPDTO.setRequerido(dadosProcessoMP.getRequerido());
        dadosProcessoMPDTO.setDataAutuacao(dadosProcessoMP.getDataAutuacao());
        dadosProcessoMPDTO.setNumeroAutuacao(dadosProcessoMP.getNumeroAutuacao());
        dadosProcessoMPDTO.setTipoRequerente(dadosProcessoMP.getTipoRequerente());
        dadosProcessoMPDTO.setTipoRequerido(dadosProcessoMP.getTipoRequerido());
        dadosProcessoMPDTO.setProtocoloGeral(dadosProcessoMP.getProtocoloGeral());
        dadosProcessoMPDTO.setRequerenteSigiloso(dadosProcessoMP.getRequerenteSigiloso());
        dadosProcessoMPDTO.setNumeroProcedimentoOrigem(dadosProcessoMP.getNumeroProcedimentoOrigem());
        dadosProcessoMPDTO.setComarca(dadosProcessoMP.getComarca());
        dadosProcessoMPDTO.setPromotor(dadosProcessoMP.getPromotor());
        dadosProcessoMPDTO.setPromotoria(dadosProcessoMP.getPromotoria());
        dadosProcessoMPDTO.setDataRecomendacao(dadosProcessoMP.getDataRecomendacao());
        dadosProcessoMPDTO.setDataCienciaRecomendacao(dadosProcessoMP.getDataCienciaRecomendacao());
        dadosProcessoMPDTO.setDataCitacao(dadosProcessoMP.getDataCitacao());
        dadosProcessoMPDTO.setDataAlegacoesFinais(dadosProcessoMP.getDataAlegacoesFinais());
        dadosProcessoMPDTO.setResolucaoRestauradora(dadosProcessoMP.getResolucaoRestauradora());
        dadosProcessoMPDTO.setConclusaoPAD(dadosProcessoMP.getConclusaoPAD());
        dadosProcessoMPDTO.setSancaoDisciplinar(dadosProcessoMP.getSancaoDisciplinar());
        dadosProcessoMPDTO.setComissao(dadosProcessoMP.getComissao());
        dadosProcessoMPDTO.setDataRecurso(dadosProcessoMP.getDataRecurso());
        dadosProcessoMPDTO.setRecursoCG(dadosProcessoMP.getRecursoCG());
        dadosProcessoMPDTO.setPrazoPrescricional(dadosProcessoMP.getPrazoPrescricional());
        dadosProcessoMPDTO.setRecursoProcessado(dadosProcessoMP.getRecursoProcessado());
        dadosProcessoMPDTO.setPrazoConclusao(dadosProcessoMP.getPrazoConclusao());
        dadosProcessoMPDTO.setDispositivoLegal(dadosProcessoMP.getDispositivoLegal());
        dadosProcessoMPDTO.setDataPublicacao(dadosProcessoMP.getDataPublicacao());
        dadosProcessoMPDTO.setNumeroProcedimento(dadosProcessoMP.getNumeroProcedimento());
        dadosProcessoMPDTO.setDataInstauracao(dadosProcessoMP.getDataInstauracao());
        dadosProcessoMPDTO.setDataInterrogatorio(dadosProcessoMP.getDataInterrogatorio());
        dadosProcessoMPDTO.setNome(dadosProcessoMP.getNome());
        dadosProcessoMPDTO.setOrigem(dadosProcessoMP.getOrigem());
        dadosProcessoMPDTO.setDataVista(dadosProcessoMP.getDataVista());
        dadosProcessoMPDTO.setTipoProcedimento(dadosProcessoMP.getTipoProcedimento());
        dadosProcessoMPDTO.setDataOitiva(dadosProcessoMP.getDataOitiva());
        dadosProcessoMPDTO.setDiligencias(dadosProcessoMP.getDiligencias());
        dadosProcessoMPDTO.setResolucaoInstauradora(dadosProcessoMP.getResolucaoInstauradora());
        dadosProcessoMPDTO.setTad(dadosProcessoMP.getTad());
        dadosProcessoMPDTO.setDataAcordo(dadosProcessoMP.getDataAcordo());
        dadosProcessoMPDTO.setPrazo(dadosProcessoMP.getPrazo());
        return dadosProcessoMPDTO;
    }

    public DadosProcessoMP toDadosProcessoMP(DadosProcessoMPDTO dadosProcessoMPDTO) {
        if (dadosProcessoMPDTO == null) {
            return null;
        }
        DadosProcessoMP dadosProcessoMP = new DadosProcessoMP();
        dadosProcessoMP.setDistribuicao(this.usuarioPermissaoLocalDTOToUsuario(dadosProcessoMPDTO.getDistribuicao()));
        dadosProcessoMP.setId(dadosProcessoMPDTO.getId());
        dadosProcessoMP.setTitulo(dadosProcessoMPDTO.getTitulo());
        dadosProcessoMP.setDescricao(dadosProcessoMPDTO.getDescricao());
        dadosProcessoMP.setPrivado(dadosProcessoMPDTO.getPrivado());
        dadosProcessoMP.setInteressado(dadosProcessoMPDTO.getInteressado());
        dadosProcessoMP.setTipoDocumento(dadosProcessoMPDTO.getTipoDocumento());
        dadosProcessoMP.setRequerente(dadosProcessoMPDTO.getRequerente());
        dadosProcessoMP.setRequerido(dadosProcessoMPDTO.getRequerido());
        dadosProcessoMP.setDataAutuacao(dadosProcessoMPDTO.getDataAutuacao());
        dadosProcessoMP.setNumeroAutuacao(dadosProcessoMPDTO.getNumeroAutuacao());
        dadosProcessoMP.setTipoRequerente(dadosProcessoMPDTO.getTipoRequerente());
        dadosProcessoMP.setTipoRequerido(dadosProcessoMPDTO.getTipoRequerido());
        dadosProcessoMP.setProtocoloGeral(dadosProcessoMPDTO.getProtocoloGeral());
        dadosProcessoMP.setRequerenteSigiloso(dadosProcessoMPDTO.getRequerenteSigiloso());
        dadosProcessoMP.setNumeroProcedimentoOrigem(dadosProcessoMPDTO.getNumeroProcedimentoOrigem());
        dadosProcessoMP.setComarca(dadosProcessoMPDTO.getComarca());
        dadosProcessoMP.setPromotor(dadosProcessoMPDTO.getPromotor());
        dadosProcessoMP.setPromotoria(dadosProcessoMPDTO.getPromotoria());
        dadosProcessoMP.setDataRecomendacao(dadosProcessoMPDTO.getDataRecomendacao());
        dadosProcessoMP.setDataCienciaRecomendacao(dadosProcessoMPDTO.getDataCienciaRecomendacao());
        dadosProcessoMP.setDataCitacao(dadosProcessoMPDTO.getDataCitacao());
        dadosProcessoMP.setDataAlegacoesFinais(dadosProcessoMPDTO.getDataAlegacoesFinais());
        dadosProcessoMP.setResolucaoRestauradora(dadosProcessoMPDTO.getResolucaoRestauradora());
        dadosProcessoMP.setConclusaoPAD(dadosProcessoMPDTO.getConclusaoPAD());
        dadosProcessoMP.setSancaoDisciplinar(dadosProcessoMPDTO.getSancaoDisciplinar());
        dadosProcessoMP.setComissao(dadosProcessoMPDTO.getComissao());
        dadosProcessoMP.setDataRecurso(dadosProcessoMPDTO.getDataRecurso());
        dadosProcessoMP.setRecursoCG(dadosProcessoMPDTO.getRecursoCG());
        dadosProcessoMP.setPrazoPrescricional(dadosProcessoMPDTO.getPrazoPrescricional());
        dadosProcessoMP.setRecursoProcessado(dadosProcessoMPDTO.getRecursoProcessado());
        dadosProcessoMP.setPrazoConclusao(dadosProcessoMPDTO.getPrazoConclusao());
        dadosProcessoMP.setDataVista(dadosProcessoMPDTO.getDataVista());
        dadosProcessoMP.setDispositivoLegal(dadosProcessoMPDTO.getDispositivoLegal());
        dadosProcessoMP.setDataPublicacao(dadosProcessoMPDTO.getDataPublicacao());
        dadosProcessoMP.setNumeroProcedimento(dadosProcessoMPDTO.getNumeroProcedimento());
        dadosProcessoMP.setDataInstauracao(dadosProcessoMPDTO.getDataInstauracao());
        dadosProcessoMP.setDataInterrogatorio(dadosProcessoMPDTO.getDataInterrogatorio());
        dadosProcessoMP.setNome(dadosProcessoMPDTO.getNome());
        dadosProcessoMP.setOrigem(dadosProcessoMPDTO.getOrigem());
        dadosProcessoMP.setDiligencias(dadosProcessoMPDTO.getDiligencias());
        dadosProcessoMP.setDataOitiva(dadosProcessoMPDTO.getDataOitiva());
        dadosProcessoMP.setTipoProcedimento(dadosProcessoMPDTO.getTipoProcedimento());
        dadosProcessoMP.setResolucaoInstauradora(dadosProcessoMPDTO.getResolucaoInstauradora());
        dadosProcessoMP.setTad(dadosProcessoMPDTO.getTad());
        dadosProcessoMP.setDataAcordo(dadosProcessoMPDTO.getDataAcordo());
        dadosProcessoMP.setPrazo(dadosProcessoMPDTO.getPrazo());
        return dadosProcessoMP;
    }

    public TipoAusencia toTipoAusencia(TipoAusenciaDTO tipoAusenciaDTO) {
        if (tipoAusenciaDTO == null) {
            return null;
        }
        TipoAusencia tipoAusencia = new TipoAusencia();
        tipoAusencia.setId(tipoAusenciaDTO.getId());
        tipoAusencia.setDescricao(tipoAusenciaDTO.getDescricao());
        tipoAusencia.setAtivo(tipoAusenciaDTO.getAtivo());
        tipoAusencia.setAudit(this.toAuditInfo(tipoAusenciaDTO.getAudit()));
        return tipoAusencia;
    }

    public TipoAusenciaDTO toTipoAusenciaDTO(TipoAusencia tipoAusencia) {
        if (tipoAusencia == null) {
            return null;
        }
        TipoAusenciaDTO tipoAusenciaDTO = new TipoAusenciaDTO();
        tipoAusenciaDTO.setId(tipoAusencia.getId());
        tipoAusenciaDTO.setDescricao(tipoAusencia.getDescricao());
        tipoAusenciaDTO.setAtivo(tipoAusencia.getAtivo());
        tipoAusenciaDTO.setAudit(this.toAuditInfoDTO(tipoAusencia.getAudit()));
        return tipoAusenciaDTO;
    }

    public AuditInfo toAuditInfo(AuditInfoDTO auditInfoDTO) {
        if (auditInfoDTO == null) {
            return null;
        }
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setUsuarioCriacao(auditInfoDTO.getUsuarioCriacao());
        auditInfo.setUsuarioAlteracao(auditInfoDTO.getUsuarioAlteracao());
        auditInfo.setDataAlteracao(auditInfoDTO.getDataAlteracao());
        auditInfo.setDataCriacao(auditInfoDTO.getDataCriacao());
        return auditInfo;
    }

    public AuditInfoDTO toAuditInfoDTO(AuditInfo auditInfo) {
        if (auditInfo == null) {
            return null;
        }
        AuditInfoDTO auditInfoDTO = new AuditInfoDTO();
        auditInfoDTO.setUsuarioCriacao(auditInfo.getUsuarioCriacao());
        auditInfoDTO.setUsuarioAlteracao(auditInfo.getUsuarioAlteracao());
        auditInfoDTO.setDataAlteracao(auditInfo.getDataAlteracao());
        auditInfoDTO.setDataCriacao(auditInfo.getDataCriacao());
        return auditInfoDTO;
    }

    public UsuarioAusencia toUsuarioAusencia(UsuarioAusenciaDTO usuarioAusenciaDTO) {
        if (usuarioAusenciaDTO == null) {
            return null;
        }
        UsuarioAusencia usuarioAusencia = new UsuarioAusencia();
        usuarioAusencia.setId(usuarioAusenciaDTO.getId());
        usuarioAusencia.setDescricao(usuarioAusenciaDTO.getDescricao());
        usuarioAusencia.setAtivo(usuarioAusenciaDTO.getAtivo());
        usuarioAusencia.setTipoAusencia(this.toTipoAusencia(usuarioAusenciaDTO.getTipoAusencia()));
        usuarioAusencia.setDataInicio(usuarioAusenciaDTO.getDataInicio());
        usuarioAusencia.setDataTermino(usuarioAusenciaDTO.getDataTermino());
        usuarioAusencia.setAudit(this.toAuditInfo(usuarioAusenciaDTO.getAudit()));
        return usuarioAusencia;
    }

    public UsuarioAusenciaDTO toUsuarioAusenciaDTO(UsuarioAusencia usuarioAusencia) {
        if (usuarioAusencia == null) {
            return null;
        }
        UsuarioAusenciaDTO usuarioAusenciaDTO = new UsuarioAusenciaDTO();
        usuarioAusenciaDTO.setUsuarioId(this.usuarioAusenciaUsuarioId(usuarioAusencia));
        usuarioAusenciaDTO.setUsuarioNome(this.usuarioAusenciaUsuarioNome(usuarioAusencia));
        usuarioAusenciaDTO.setId(usuarioAusencia.getId());
        usuarioAusenciaDTO.setDescricao(usuarioAusencia.getDescricao());
        usuarioAusenciaDTO.setAtivo(usuarioAusencia.getAtivo());
        usuarioAusenciaDTO.setDataInicio(usuarioAusencia.getDataInicio());
        usuarioAusenciaDTO.setDataTermino(usuarioAusencia.getDataTermino());
        usuarioAusenciaDTO.setTipoAusencia(this.toTipoAusenciaDTO(usuarioAusencia.getTipoAusencia()));
        usuarioAusenciaDTO.setAudit(this.toAuditInfoDTO(usuarioAusencia.getAudit()));
        return usuarioAusenciaDTO;
    }

    protected List<ProcessoAndamento> processoAndamentoSimpleDTOListToProcessoAndamentoList(List<ProcessoAndamentoSimpleDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoAndamento> list1 = new ArrayList<ProcessoAndamento>(list.size());
        for (ProcessoAndamentoSimpleDTO processoAndamentoSimpleDTO : list) {
            list1.add(this.toProcessoAndamento(processoAndamentoSimpleDTO));
        }
        return list1;
    }

    private Long dtoEntidadeId(ProcessoAssinaturaConfigDTO processoAssinaturaConfigDTO) {
        if (processoAssinaturaConfigDTO == null) {
            return null;
        }
        EntidadeDTO entidade = processoAssinaturaConfigDTO.getEntidade();
        if (entidade == null) {
            return null;
        }
        Long id = entidade.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected UsuarioPermissaoLocalDTO usuarioToUsuarioPermissaoLocalDTO(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        UsuarioPermissaoLocalDTO.UsuarioPermissaoLocalDTOBuilder usuarioPermissaoLocalDTO = UsuarioPermissaoLocalDTO.builder();
        usuarioPermissaoLocalDTO.nomeUsuario(usuario.getNome());
        usuarioPermissaoLocalDTO.loginUsuario(usuario.getId());
        usuarioPermissaoLocalDTO.ativo(usuario.getAtivo());
        return usuarioPermissaoLocalDTO.build();
    }

    private TipoProcesso processoIdTipo(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        TipoProcesso tipo = id.getTipo();
        if (tipo == null) {
            return null;
        }
        return tipo;
    }

    private Long processoIdAno(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long ano = id.getAno();
        if (ano == null) {
            return null;
        }
        return ano;
    }

    private Long processoIdNumero(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long numero = id.getNumero();
        if (numero == null) {
            return null;
        }
        return numero;
    }

    private Entidade processoIdEntidade(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    protected List<TramiteDTO> tramiteListToTramiteDTOList(List<Tramite> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TramiteDTO> list1 = new ArrayList<TramiteDTO>(list.size());
        for (Tramite tramite : list) {
            list1.add(this.tramiteToDTO(tramite));
        }
        return list1;
    }

    protected List<ProcessoAnexoDTO> processoAnexoListToProcessoAnexoDTOList(List<ProcessoAnexo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoAnexoDTO> list1 = new ArrayList<ProcessoAnexoDTO>(list.size());
        for (ProcessoAnexo processoAnexo : list) {
            list1.add(this.toProcessoAnexoDTO(processoAnexo));
        }
        return list1;
    }

    protected List<ProcessoArquivoDTO> processoArquivoListToProcessoArquivoDTOList(List<ProcessoArquivo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoArquivoDTO> list1 = new ArrayList<ProcessoArquivoDTO>(list.size());
        for (ProcessoArquivo processoArquivo : list) {
            list1.add(this.toProcessoArquivoDTO(processoArquivo));
        }
        return list1;
    }

    protected List<ProcessoInteressadoDTO> processoInteressadoListToProcessoInteressadoDTOList(List<ProcessoInteressado> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoInteressadoDTO> list1 = new ArrayList<ProcessoInteressadoDTO>(list.size());
        for (ProcessoInteressado processoInteressado : list) {
            list1.add(this.toProcessoInteressadoDTO(processoInteressado));
        }
        return list1;
    }

    protected ProcessoAndamentoAlteracaoRequerenteDTO processoAndamentoAlteracaoRequerenteToProcessoAndamentoAlteracaoRequerenteDTO(ProcessoAndamentoAlteracaoRequerente processoAndamentoAlteracaoRequerente) {
        if (processoAndamentoAlteracaoRequerente == null) {
            return null;
        }
        ProcessoAndamentoAlteracaoRequerenteDTO processoAndamentoAlteracaoRequerenteDTO = new ProcessoAndamentoAlteracaoRequerenteDTO();
        processoAndamentoAlteracaoRequerenteDTO.setRequerenteOld(this.toPessoaDTO(processoAndamentoAlteracaoRequerente.getRequerenteOld()));
        processoAndamentoAlteracaoRequerenteDTO.setRequerenteNew(this.toPessoaDTO(processoAndamentoAlteracaoRequerente.getRequerenteNew()));
        return processoAndamentoAlteracaoRequerenteDTO;
    }

    protected ProcessoAndamentoSimpleDTO processoAndamentoToProcessoAndamentoSimpleDTO(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        ProcessoAndamentoSimpleDTO processoAndamentoSimpleDTO = new ProcessoAndamentoSimpleDTO();
        processoAndamentoSimpleDTO.setId(processoAndamento.getId());
        processoAndamentoSimpleDTO.setNumeroAndamento(processoAndamento.getNumeroAndamento());
        processoAndamentoSimpleDTO.setDataHora(processoAndamento.getDataHora());
        processoAndamentoSimpleDTO.setDescricao(processoAndamento.getDescricao());
        processoAndamentoSimpleDTO.setUsuario(processoAndamento.getUsuario());
        processoAndamentoSimpleDTO.setUsuarioNome(processoAndamento.getUsuarioNome());
        processoAndamentoSimpleDTO.setTramite(processoAndamento.getTramite());
        processoAndamentoSimpleDTO.setSolicitacaoRequerente(processoAndamento.getSolicitacaoRequerente());
        processoAndamentoSimpleDTO.setRespostaRequerente(processoAndamento.getRespostaRequerente());
        processoAndamentoSimpleDTO.setDataHoraResposta(processoAndamento.getDataHoraResposta());
        processoAndamentoSimpleDTO.setModulo(processoAndamento.getModulo());
        processoAndamentoSimpleDTO.setTipoAndamento(this.toTipoAndamentoDTO(processoAndamento.getTipoAndamento()));
        processoAndamentoSimpleDTO.setDataInicio(processoAndamento.getDataInicio());
        processoAndamentoSimpleDTO.setDataTermino(processoAndamento.getDataTermino());
        processoAndamentoSimpleDTO.setDataFinalizacao(processoAndamento.getDataFinalizacao());
        processoAndamentoSimpleDTO.setFinalizado(processoAndamento.getFinalizado());
        processoAndamentoSimpleDTO.setObservadorExtId(processoAndamento.getObservadorExtId());
        processoAndamentoSimpleDTO.setDiasSuspensao(processoAndamento.getDiasSuspensao());
        processoAndamentoSimpleDTO.setAssuntoOld(this.toAssuntoDTO(processoAndamento.getAssuntoOld()));
        processoAndamentoSimpleDTO.setAssuntoNew(this.toAssuntoDTO(processoAndamento.getAssuntoNew()));
        processoAndamentoSimpleDTO.setSituacao(processoAndamento.getSituacao());
        processoAndamentoSimpleDTO.setLocal(this.toLocalDTO(processoAndamento.getLocal()));
        processoAndamentoSimpleDTO.setUsuarioResponsavel(this.toUsuarioDTO(processoAndamento.getUsuarioResponsavel()));
        processoAndamentoSimpleDTO.setResposta(processoAndamento.getResposta());
        processoAndamentoSimpleDTO.setBloqueioAnexoExterno(processoAndamento.getBloqueioAnexoExterno());
        processoAndamentoSimpleDTO.setRequerenteSigiloso(processoAndamento.getRequerenteSigiloso());
        processoAndamentoSimpleDTO.setAlteracaoRequerente(this.processoAndamentoAlteracaoRequerenteToProcessoAndamentoAlteracaoRequerenteDTO(processoAndamento.getAlteracaoRequerente()));
        return processoAndamentoSimpleDTO;
    }

    protected List<ProcessoAndamentoSimpleDTO> processoAndamentoListToProcessoAndamentoSimpleDTOList(List<ProcessoAndamento> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoAndamentoSimpleDTO> list1 = new ArrayList<ProcessoAndamentoSimpleDTO>(list.size());
        for (ProcessoAndamento processoAndamento : list) {
            list1.add(this.processoAndamentoToProcessoAndamentoSimpleDTO(processoAndamento));
        }
        return list1;
    }

    protected EntidadeDTO processoAssinaturaConfigToEntidadeDTO(ProcessoAssinaturaConfig processoAssinaturaConfig) {
        if (processoAssinaturaConfig == null) {
            return null;
        }
        EntidadeDTO entidadeDTO = new EntidadeDTO();
        entidadeDTO.setId(processoAssinaturaConfig.getEntidade());
        return entidadeDTO;
    }

    private String tramiteUsuarioNome(Tramite tramite) {
        if (tramite == null) {
            return null;
        }
        Usuario usuario = tramite.getUsuario();
        if (usuario == null) {
            return null;
        }
        String nome = usuario.getNome();
        if (nome == null) {
            return null;
        }
        return nome;
    }

    private Long tramiteIdSequencia(Tramite tramite) {
        if (tramite == null) {
            return null;
        }
        TramitePK id = tramite.getId();
        if (id == null) {
            return null;
        }
        Long sequencia = id.getSequencia();
        if (sequencia == null) {
            return null;
        }
        return sequencia;
    }

    private String tramiteUsuarioResponsavelTramiteId(Tramite tramite) {
        if (tramite == null) {
            return null;
        }
        Usuario usuarioResponsavelTramite = tramite.getUsuarioResponsavelTramite();
        if (usuarioResponsavelTramite == null) {
            return null;
        }
        String id = usuarioResponsavelTramite.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected ProcessoPK processoFavoritoDTOToProcessoPK(ProcessoFavoritoDTO processoFavoritoDTO) {
        if (processoFavoritoDTO == null) {
            return null;
        }
        ProcessoPK processoPK = new ProcessoPK();
        processoPK.setTipo(this.toTipoProcesso(processoFavoritoDTO.getTipo()));
        processoPK.setNumero(processoFavoritoDTO.getNumero());
        processoPK.setEntidade(this.toEntidade(processoFavoritoDTO.getEntidade()));
        processoPK.setAno(processoFavoritoDTO.getAno());
        return processoPK;
    }

    protected Processo processoFavoritoDTOToProcesso(ProcessoFavoritoDTO processoFavoritoDTO) {
        if (processoFavoritoDTO == null) {
            return null;
        }
        Processo processo = new Processo();
        processo.setId(this.processoFavoritoDTOToProcessoPK(processoFavoritoDTO));
        return processo;
    }

    protected Usuario processoFavoritoDTOToUsuario(ProcessoFavoritoDTO processoFavoritoDTO) {
        if (processoFavoritoDTO == null) {
            return null;
        }
        Usuario usuario = new Usuario();
        usuario.setId(processoFavoritoDTO.getUsuario());
        return usuario;
    }

    protected ProcessoFavoritoPK processoFavoritoDTOToProcessoFavoritoPK(ProcessoFavoritoDTO processoFavoritoDTO) {
        if (processoFavoritoDTO == null) {
            return null;
        }
        ProcessoFavoritoPK processoFavoritoPK = new ProcessoFavoritoPK();
        processoFavoritoPK.setProcesso(this.processoFavoritoDTOToProcesso(processoFavoritoDTO));
        processoFavoritoPK.setUsuario(this.processoFavoritoDTOToUsuario(processoFavoritoDTO));
        return processoFavoritoPK;
    }

    private Entidade entityIdProcessoIdEntidade(ProcessoFavorito processoFavorito) {
        if (processoFavorito == null) {
            return null;
        }
        ProcessoFavoritoPK id = processoFavorito.getId();
        if (id == null) {
            return null;
        }
        Processo processo = id.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id1 = processo.getId();
        if (id1 == null) {
            return null;
        }
        Entidade entidade = id1.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private TipoProcesso entityIdProcessoIdTipo(ProcessoFavorito processoFavorito) {
        if (processoFavorito == null) {
            return null;
        }
        ProcessoFavoritoPK id = processoFavorito.getId();
        if (id == null) {
            return null;
        }
        Processo processo = id.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id1 = processo.getId();
        if (id1 == null) {
            return null;
        }
        TipoProcesso tipo = id1.getTipo();
        if (tipo == null) {
            return null;
        }
        return tipo;
    }

    private String entityIdUsuarioId(ProcessoFavorito processoFavorito) {
        if (processoFavorito == null) {
            return null;
        }
        ProcessoFavoritoPK id = processoFavorito.getId();
        if (id == null) {
            return null;
        }
        Usuario usuario = id.getUsuario();
        if (usuario == null) {
            return null;
        }
        String id1 = usuario.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Long entityIdProcessoIdAno(ProcessoFavorito processoFavorito) {
        if (processoFavorito == null) {
            return null;
        }
        ProcessoFavoritoPK id = processoFavorito.getId();
        if (id == null) {
            return null;
        }
        Processo processo = id.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id1 = processo.getId();
        if (id1 == null) {
            return null;
        }
        Long ano = id1.getAno();
        if (ano == null) {
            return null;
        }
        return ano;
    }

    private Long entityIdProcessoIdNumero(ProcessoFavorito processoFavorito) {
        if (processoFavorito == null) {
            return null;
        }
        ProcessoFavoritoPK id = processoFavorito.getId();
        if (id == null) {
            return null;
        }
        Processo processo = id.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id1 = processo.getId();
        if (id1 == null) {
            return null;
        }
        Long numero = id1.getNumero();
        if (numero == null) {
            return null;
        }
        return numero;
    }

    private Long processoArquivoIdSequencia(ProcessoArquivo processoArquivo) {
        if (processoArquivo == null) {
            return null;
        }
        ProcessoArquivoPK id = processoArquivo.getId();
        if (id == null) {
            return null;
        }
        Long sequencia = id.getSequencia();
        if (sequencia == null) {
            return null;
        }
        return sequencia;
    }

    protected UsuarioSimpleDTO usuarioToUsuarioSimpleDTO(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        UsuarioSimpleDTO usuarioSimpleDTO = new UsuarioSimpleDTO();
        usuarioSimpleDTO.setId(usuario.getId());
        usuarioSimpleDTO.setNome(usuario.getNome());
        usuarioSimpleDTO.setBoAnexarArquivo(usuario.getBoAnexarArquivo());
        usuarioSimpleDTO.setCpf(usuario.getCpf());
        return usuarioSimpleDTO;
    }

    protected ProcessoArquivoAssinaturaDTO processoArquivoAssinaturaToProcessoArquivoAssinaturaDTO(ProcessoArquivoAssinatura processoArquivoAssinatura) {
        if (processoArquivoAssinatura == null) {
            return null;
        }
        ProcessoArquivoAssinaturaDTO processoArquivoAssinaturaDTO = new ProcessoArquivoAssinaturaDTO();
        processoArquivoAssinaturaDTO.setId(processoArquivoAssinatura.getId());
        processoArquivoAssinaturaDTO.setUsuario(this.usuarioToUsuarioSimpleDTO(processoArquivoAssinatura.getUsuario()));
        processoArquivoAssinaturaDTO.setUsuarioSolicitante(this.usuarioToUsuarioSimpleDTO(processoArquivoAssinatura.getUsuarioSolicitante()));
        processoArquivoAssinaturaDTO.setDataCriacao(processoArquivoAssinatura.getDataCriacao());
        processoArquivoAssinaturaDTO.setDataAssinatura(processoArquivoAssinatura.getDataAssinatura());
        processoArquivoAssinaturaDTO.setDataRecusa(processoArquivoAssinatura.getDataRecusa());
        processoArquivoAssinaturaDTO.setMotivoRecusa(processoArquivoAssinatura.getMotivoRecusa());
        processoArquivoAssinaturaDTO.setSituacao(processoArquivoAssinatura.getSituacao());
        return processoArquivoAssinaturaDTO;
    }

    protected List<ProcessoArquivoAssinaturaDTO> processoArquivoAssinaturaListToProcessoArquivoAssinaturaDTOList(List<ProcessoArquivoAssinatura> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoArquivoAssinaturaDTO> list1 = new ArrayList<ProcessoArquivoAssinaturaDTO>(list.size());
        for (ProcessoArquivoAssinatura processoArquivoAssinatura : list) {
            list1.add(this.processoArquivoAssinaturaToProcessoArquivoAssinaturaDTO(processoArquivoAssinatura));
        }
        return list1;
    }

    private Entidade localIdEntidade(Local local) {
        if (local == null) {
            return null;
        }
        LocalPK id = local.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long localIdId(Local local) {
        if (local == null) {
            return null;
        }
        LocalPK id = local.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Long pessoaDTOEnderecoPrincipalId(PessoaDTO pessoaDTO) {
        if (pessoaDTO == null) {
            return null;
        }
        EnderecoPessoaDTO enderecoPrincipal = pessoaDTO.getEnderecoPrincipal();
        if (enderecoPrincipal == null) {
            return null;
        }
        Long id = enderecoPrincipal.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected List<EnderecoPessoa> enderecoPessoaDTOListToEnderecoPessoaList(List<EnderecoPessoaDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<EnderecoPessoa> list1 = new ArrayList<EnderecoPessoa>(list.size());
        for (EnderecoPessoaDTO enderecoPessoaDTO : list) {
            list1.add(this.toEnderecoPessoa(enderecoPessoaDTO));
        }
        return list1;
    }

    private String pessoaContatoCelular(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        Contato contato = pessoa.getContato();
        if (contato == null) {
            return null;
        }
        String celular = contato.getCelular();
        if (celular == null) {
            return null;
        }
        return celular;
    }

    private String pessoaContatoTelefone(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        Contato contato = pessoa.getContato();
        if (contato == null) {
            return null;
        }
        String telefone = contato.getTelefone();
        if (telefone == null) {
            return null;
        }
        return telefone;
    }

    private String pessoaContatoEmail(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        Contato contato = pessoa.getContato();
        if (contato == null) {
            return null;
        }
        String email = contato.getEmail();
        if (email == null) {
            return null;
        }
        return email;
    }

    protected List<EnderecoPessoaDTO> enderecoPessoaListToEnderecoPessoaDTOList(List<EnderecoPessoa> list) {
        if (list == null) {
            return null;
        }
        ArrayList<EnderecoPessoaDTO> list1 = new ArrayList<EnderecoPessoaDTO>(list.size());
        for (EnderecoPessoa enderecoPessoa : list) {
            list1.add(this.toEnderecoPessoaDTO(enderecoPessoa));
        }
        return list1;
    }

    private Entidade processoAnexoProcessoIdEntidade(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        Processo processo = processoAnexo.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private TipoProcesso processoAnexoIdTipoAnexo(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        ProcessoAnexoPK id = processoAnexo.getId();
        if (id == null) {
            return null;
        }
        TipoProcesso tipoAnexo = id.getTipoAnexo();
        if (tipoAnexo == null) {
            return null;
        }
        return tipoAnexo;
    }

    private Long processoAnexoIdSequencia(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        ProcessoAnexoPK id = processoAnexo.getId();
        if (id == null) {
            return null;
        }
        Long sequencia = id.getSequencia();
        if (sequencia == null) {
            return null;
        }
        return sequencia;
    }

    private TipoProcesso processoAnexoProcessoIdTipo(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        Processo processo = processoAnexo.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        TipoProcesso tipo = id.getTipo();
        if (tipo == null) {
            return null;
        }
        return tipo;
    }

    private Long processoAnexoProcessoIdAno(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        Processo processo = processoAnexo.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long ano = id.getAno();
        if (ano == null) {
            return null;
        }
        return ano;
    }

    private Long processoAnexoIdNumeroAnexo(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        ProcessoAnexoPK id = processoAnexo.getId();
        if (id == null) {
            return null;
        }
        Long numeroAnexo = id.getNumeroAnexo();
        if (numeroAnexo == null) {
            return null;
        }
        return numeroAnexo;
    }

    private Long processoAnexoProcessoIdNumero(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        Processo processo = processoAnexo.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long numero = id.getNumero();
        if (numero == null) {
            return null;
        }
        return numero;
    }

    private Entidade processoAnexoIdEntidadeAnexo(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        ProcessoAnexoPK id = processoAnexo.getId();
        if (id == null) {
            return null;
        }
        Entidade entidadeAnexo = id.getEntidadeAnexo();
        if (entidadeAnexo == null) {
            return null;
        }
        return entidadeAnexo;
    }

    private Long processoAnexoIdAnoAnexo(ProcessoAnexo processoAnexo) {
        if (processoAnexo == null) {
            return null;
        }
        ProcessoAnexoPK id = processoAnexo.getId();
        if (id == null) {
            return null;
        }
        Long anoAnexo = id.getAnoAnexo();
        if (anoAnexo == null) {
            return null;
        }
        return anoAnexo;
    }

    private Long enderecoPessoaPkCodigo(EnderecoPessoa enderecoPessoa) {
        if (enderecoPessoa == null) {
            return null;
        }
        EnderecoPessoaPK pk = enderecoPessoa.getPk();
        if (pk == null) {
            return null;
        }
        Long codigo = pk.getCodigo();
        if (codigo == null) {
            return null;
        }
        return codigo;
    }

    private Long caixaIdCodigo(Caixa caixa) {
        if (caixa == null) {
            return null;
        }
        CaixaPK id = caixa.getId();
        if (id == null) {
            return null;
        }
        Long codigo = id.getCodigo();
        if (codigo == null) {
            return null;
        }
        return codigo;
    }

    private Long caixaIdAno(Caixa caixa) {
        if (caixa == null) {
            return null;
        }
        CaixaPK id = caixa.getId();
        if (id == null) {
            return null;
        }
        Long ano = id.getAno();
        if (ano == null) {
            return null;
        }
        return ano;
    }

    private String usuarioSeletorIdSeletorId(UsuarioSeletor usuarioSeletor) {
        if (usuarioSeletor == null) {
            return null;
        }
        UsuarioSeletorPK id = usuarioSeletor.getId();
        if (id == null) {
            return null;
        }
        Seletor seletor = id.getSeletor();
        if (seletor == null) {
            return null;
        }
        String id1 = seletor.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    protected List<AssuntoDocumento> assuntoDocumentoDTOListToAssuntoDocumentoList(List<AssuntoDocumentoDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AssuntoDocumento> list1 = new ArrayList<AssuntoDocumento>(list.size());
        for (AssuntoDocumentoDTO assuntoDocumentoDTO : list) {
            list1.add(this.toAssuntoDocumento(assuntoDocumentoDTO));
        }
        return list1;
    }

    protected List<AssuntoEntidade> assuntoEntidadeDTOListToAssuntoEntidadeList(List<AssuntoEntidadeDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AssuntoEntidade> list1 = new ArrayList<AssuntoEntidade>(list.size());
        for (AssuntoEntidadeDTO assuntoEntidadeDTO : list) {
            list1.add(this.toAssuntoEntidade(assuntoEntidadeDTO));
        }
        return list1;
    }

    protected List<AssuntoArquivo> assuntoArquivoDTOListToAssuntoArquivoList(List<AssuntoArquivoDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AssuntoArquivo> list1 = new ArrayList<AssuntoArquivo>(list.size());
        for (AssuntoArquivoDTO assuntoArquivoDTO : list) {
            list1.add(this.toAssuntoArquivo(assuntoArquivoDTO));
        }
        return list1;
    }

    protected List<AssuntoDocumentoDTO> assuntoDocumentoListToAssuntoDocumentoDTOList(List<AssuntoDocumento> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AssuntoDocumentoDTO> list1 = new ArrayList<AssuntoDocumentoDTO>(list.size());
        for (AssuntoDocumento assuntoDocumento : list) {
            list1.add(this.toAssuntoDocumentoDTO(assuntoDocumento));
        }
        return list1;
    }

    protected List<AssuntoEntidadeDTO> assuntoEntidadeListToAssuntoEntidadeDTOList(List<AssuntoEntidade> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AssuntoEntidadeDTO> list1 = new ArrayList<AssuntoEntidadeDTO>(list.size());
        for (AssuntoEntidade assuntoEntidade : list) {
            list1.add(this.toAssuntoEntidadeDTO(assuntoEntidade));
        }
        return list1;
    }

    protected List<AssuntoArquivoDTO> assuntoArquivoListToAssuntoArquivoDTOList(List<AssuntoArquivo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AssuntoArquivoDTO> list1 = new ArrayList<AssuntoArquivoDTO>(list.size());
        for (AssuntoArquivo assuntoArquivo : list) {
            list1.add(this.toAssuntoArquivoDTO(assuntoArquivo));
        }
        return list1;
    }

    private Documento assuntoDocumentoIdDocumento(AssuntoDocumento assuntoDocumento) {
        if (assuntoDocumento == null) {
            return null;
        }
        AssuntoDocumentoPK id = assuntoDocumento.getId();
        if (id == null) {
            return null;
        }
        Documento documento = id.getDocumento();
        if (documento == null) {
            return null;
        }
        return documento;
    }

    protected List<UsuarioTipoProcesso> usuarioTipoProcessoDTOListToUsuarioTipoProcessoList(List<UsuarioTipoProcessoDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioTipoProcesso> list1 = new ArrayList<UsuarioTipoProcesso>(list.size());
        for (UsuarioTipoProcessoDTO usuarioTipoProcessoDTO : list) {
            list1.add(this.toUsuarioTipoProcesso(usuarioTipoProcessoDTO));
        }
        return list1;
    }

    protected List<UsuarioModeloImpressao> usuarioModeloImpressaoDTOListToUsuarioModeloImpressaoList(List<UsuarioModeloImpressaoDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioModeloImpressao> list1 = new ArrayList<UsuarioModeloImpressao>(list.size());
        for (UsuarioModeloImpressaoDTO usuarioModeloImpressaoDTO : list) {
            list1.add(this.toUsuarioModeloImpressao(usuarioModeloImpressaoDTO));
        }
        return list1;
    }

    protected Set<UsuarioLocal> usuarioLocalDTOListToUsuarioLocalSet(List<UsuarioLocalDTO> list) {
        if (list == null) {
            return null;
        }
        HashSet<UsuarioLocal> set = new HashSet<UsuarioLocal>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (UsuarioLocalDTO usuarioLocalDTO : list) {
            set.add(this.toUsuarioLocal(usuarioLocalDTO));
        }
        return set;
    }

    protected List<UsuarioTipoProcessoDTO> usuarioTipoProcessoListToUsuarioTipoProcessoDTOList(List<UsuarioTipoProcesso> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioTipoProcessoDTO> list1 = new ArrayList<UsuarioTipoProcessoDTO>(list.size());
        for (UsuarioTipoProcesso usuarioTipoProcesso : list) {
            list1.add(this.toUsuarioTipoProcessoDTO(usuarioTipoProcesso));
        }
        return list1;
    }

    protected List<UsuarioModeloImpressaoDTO> usuarioModeloImpressaoListToUsuarioModeloImpressaoDTOList(List<UsuarioModeloImpressao> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioModeloImpressaoDTO> list1 = new ArrayList<UsuarioModeloImpressaoDTO>(list.size());
        for (UsuarioModeloImpressao usuarioModeloImpressao : list) {
            list1.add(this.toUsuarioModeloImpressaoDTO(usuarioModeloImpressao));
        }
        return list1;
    }

    protected Set<SecretariaDTO> secretariaSetToSecretariaDTOSet(Set<Secretaria> set) {
        if (set == null) {
            return null;
        }
        HashSet<SecretariaDTO> set1 = new HashSet<SecretariaDTO>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Secretaria secretaria : set) {
            set1.add(this.toSecretariaDTO(secretaria));
        }
        return set1;
    }

    protected Set<AssuntoDTO> assuntoSetToAssuntoDTOSet(Set<Assunto> set) {
        if (set == null) {
            return null;
        }
        HashSet<AssuntoDTO> set1 = new HashSet<AssuntoDTO>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Assunto assunto : set) {
            set1.add(this.toAssuntoDTO(assunto));
        }
        return set1;
    }

    protected List<UsuarioLocalDTO> usuarioLocalSetToUsuarioLocalDTOList(Set<UsuarioLocal> set) {
        if (set == null) {
            return null;
        }
        ArrayList<UsuarioLocalDTO> list = new ArrayList<UsuarioLocalDTO>(set.size());
        for (UsuarioLocal usuarioLocal : set) {
            list.add(this.toUsuarioLocalDTO(usuarioLocal));
        }
        return list;
    }

    protected List<UsuarioEntidadeDTO> usuarioEntidadeSetToUsuarioEntidadeDTOList(Set<UsuarioEntidade> set) {
        if (set == null) {
            return null;
        }
        ArrayList<UsuarioEntidadeDTO> list = new ArrayList<UsuarioEntidadeDTO>(set.size());
        for (UsuarioEntidade usuarioEntidade : set) {
            list.add(this.toUsuarioEntidadeDTO(usuarioEntidade));
        }
        return list;
    }

    private TipoProcesso usuarioTipoProcessoIdTipoProcesso(UsuarioTipoProcesso usuarioTipoProcesso) {
        if (usuarioTipoProcesso == null) {
            return null;
        }
        UsuarioTipoProcessoPK id = usuarioTipoProcesso.getId();
        if (id == null) {
            return null;
        }
        TipoProcesso tipoProcesso = id.getTipoProcesso();
        if (tipoProcesso == null) {
            return null;
        }
        return tipoProcesso;
    }

    protected ModeloImpressao modeloImpressaoDTOToModeloImpressao(ModeloImpressaoDTO modeloImpressaoDTO) {
        if (modeloImpressaoDTO == null) {
            return null;
        }
        ModeloImpressao modeloImpressao = new ModeloImpressao();
        modeloImpressao.setId(modeloImpressaoDTO.getId());
        modeloImpressao.setEntidade(this.toEntidade(modeloImpressaoDTO.getEntidade()));
        if (modeloImpressaoDTO.getTipo() != null) {
            modeloImpressao.setTipo(Enum.valueOf(TipoModeloImpressaoEnum.class, modeloImpressaoDTO.getTipo()));
        }
        modeloImpressao.setDescricao(modeloImpressaoDTO.getDescricao());
        modeloImpressao.setAtivo(modeloImpressaoDTO.getAtivo());
        modeloImpressao.setModelo(modeloImpressaoDTO.getModelo());
        return modeloImpressao;
    }

    private ModeloImpressao usuarioModeloImpressaoIdModeloImpressao(UsuarioModeloImpressao usuarioModeloImpressao) {
        if (usuarioModeloImpressao == null) {
            return null;
        }
        UsuarioModeloImpressaoPK id = usuarioModeloImpressao.getId();
        if (id == null) {
            return null;
        }
        ModeloImpressao modeloImpressao = id.getModeloImpressao();
        if (modeloImpressao == null) {
            return null;
        }
        return modeloImpressao;
    }

    protected ModeloImpressaoDTO modeloImpressaoToModeloImpressaoDTO(ModeloImpressao modeloImpressao) {
        if (modeloImpressao == null) {
            return null;
        }
        ModeloImpressaoDTO modeloImpressaoDTO = new ModeloImpressaoDTO();
        modeloImpressaoDTO.setId(modeloImpressao.getId());
        if (modeloImpressao.getTipo() != null) {
            modeloImpressaoDTO.setTipo(modeloImpressao.getTipo().name());
        }
        modeloImpressaoDTO.setDescricao(modeloImpressao.getDescricao());
        modeloImpressaoDTO.setAtivo(modeloImpressao.getAtivo());
        modeloImpressaoDTO.setModelo(modeloImpressao.getModelo());
        modeloImpressaoDTO.setEntidade(this.toEntidadeDTO(modeloImpressao.getEntidade()));
        return modeloImpressaoDTO;
    }

    private Local usuarioLocalIdLocal(UsuarioLocal usuarioLocal) {
        if (usuarioLocal == null) {
            return null;
        }
        UsuarioLocalPK id = usuarioLocal.getId();
        if (id == null) {
            return null;
        }
        Local local = id.getLocal();
        if (local == null) {
            return null;
        }
        return local;
    }

    protected List<UsuarioPermissaoDTO> usuarioSeletorSetToUsuarioPermissaoDTOList(Set<UsuarioSeletor> set) {
        if (set == null) {
            return null;
        }
        ArrayList<UsuarioPermissaoDTO> list = new ArrayList<UsuarioPermissaoDTO>(set.size());
        for (UsuarioSeletor usuarioSeletor : set) {
            list.add(this.toUsuarioTelaDTO(usuarioSeletor));
        }
        return list;
    }

    private Modulo usuarioSeletorIdModulo(UsuarioSeletor usuarioSeletor) {
        if (usuarioSeletor == null) {
            return null;
        }
        UsuarioSeletorPK id = usuarioSeletor.getId();
        if (id == null) {
            return null;
        }
        Modulo modulo = id.getModulo();
        if (modulo == null) {
            return null;
        }
        return modulo;
    }

    private Seletor usuarioSeletorIdSeletor(UsuarioSeletor usuarioSeletor) {
        if (usuarioSeletor == null) {
            return null;
        }
        UsuarioSeletorPK id = usuarioSeletor.getId();
        if (id == null) {
            return null;
        }
        Seletor seletor = id.getSeletor();
        if (seletor == null) {
            return null;
        }
        return seletor;
    }

    private Entidade usuarioEntidadeIdEntidade(UsuarioEntidade usuarioEntidade) {
        if (usuarioEntidade == null) {
            return null;
        }
        UsuarioEntidadePK id = usuarioEntidade.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long exercicioIdExercicio(Exercicio exercicio) {
        if (exercicio == null) {
            return null;
        }
        ExercicioPK id = exercicio.getId();
        if (id == null) {
            return null;
        }
        Long exercicio1 = id.getExercicio();
        if (exercicio1 == null) {
            return null;
        }
        return exercicio1;
    }

    private Entidade unidadeIdEntidade(Unidade unidade) {
        if (unidade == null) {
            return null;
        }
        UnidadePK id = unidade.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long unidadeIdCodigo(Unidade unidade) {
        if (unidade == null) {
            return null;
        }
        UnidadePK id = unidade.getId();
        if (id == null) {
            return null;
        }
        Long codigo = id.getCodigo();
        if (codigo == null) {
            return null;
        }
        return codigo;
    }

    private Entidade tipoNotificacaoIdEntidade(TipoNotificacao tipoNotificacao) {
        if (tipoNotificacao == null) {
            return null;
        }
        TipoNotificacaoPK id = tipoNotificacao.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long tipoNotificacaoIdId(TipoNotificacao tipoNotificacao) {
        if (tipoNotificacao == null) {
            return null;
        }
        TipoNotificacaoPK id = tipoNotificacao.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    protected List<TipoProcessoEntidade> tipoProcessoEntidadeDTOListToTipoProcessoEntidadeList(List<TipoProcessoEntidadeDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TipoProcessoEntidade> list1 = new ArrayList<TipoProcessoEntidade>(list.size());
        for (TipoProcessoEntidadeDTO tipoProcessoEntidadeDTO : list) {
            list1.add(this.toTipoProcessoEntidade(tipoProcessoEntidadeDTO));
        }
        return list1;
    }

    protected Set<Assunto> assuntoDTOSetToAssuntoSet(Set<AssuntoDTO> set) {
        if (set == null) {
            return null;
        }
        HashSet<Assunto> set1 = new HashSet<Assunto>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (AssuntoDTO assuntoDTO : set) {
            set1.add(this.toAssunto(assuntoDTO));
        }
        return set1;
    }

    protected Set<Situacao> situacaoDTOSetToSituacaoSet(Set<SituacaoDTO> set) {
        if (set == null) {
            return null;
        }
        HashSet<Situacao> set1 = new HashSet<Situacao>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SituacaoDTO situacaoDTO : set) {
            set1.add(this.toSituacao(situacaoDTO));
        }
        return set1;
    }

    protected Usuario observadorDTOToUsuario(ObservadorDTO observadorDTO) {
        if (observadorDTO == null) {
            return null;
        }
        Usuario usuario = new Usuario();
        usuario.setId(observadorDTO.getId());
        usuario.setNome(observadorDTO.getNome());
        return usuario;
    }

    protected Set<Usuario> observadorDTOSetToUsuarioSet(Set<ObservadorDTO> set) {
        if (set == null) {
            return null;
        }
        HashSet<Usuario> set1 = new HashSet<Usuario>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (ObservadorDTO observadorDTO : set) {
            set1.add(this.observadorDTOToUsuario(observadorDTO));
        }
        return set1;
    }

    protected List<TipoProcessoEntidadeDTO> tipoProcessoEntidadeListToTipoProcessoEntidadeDTOList(List<TipoProcessoEntidade> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TipoProcessoEntidadeDTO> list1 = new ArrayList<TipoProcessoEntidadeDTO>(list.size());
        for (TipoProcessoEntidade tipoProcessoEntidade : list) {
            list1.add(this.toTipoProcessoEntidadeDTO(tipoProcessoEntidade));
        }
        return list1;
    }

    protected Set<SituacaoDTO> situacaoSetToSituacaoDTOSet(Set<Situacao> set) {
        if (set == null) {
            return null;
        }
        HashSet<SituacaoDTO> set1 = new HashSet<SituacaoDTO>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Situacao situacao : set) {
            set1.add(this.toSituacaoDTO(situacao));
        }
        return set1;
    }

    protected ObservadorDTO usuarioToObservadorDTO(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        ObservadorDTO observadorDTO = new ObservadorDTO();
        observadorDTO.setId(usuario.getId());
        observadorDTO.setNome(usuario.getNome());
        return observadorDTO;
    }

    protected Set<ObservadorDTO> usuarioSetToObservadorDTOSet(Set<Usuario> set) {
        if (set == null) {
            return null;
        }
        HashSet<ObservadorDTO> set1 = new HashSet<ObservadorDTO>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Usuario usuario : set) {
            set1.add(this.usuarioToObservadorDTO(usuario));
        }
        return set1;
    }

    private Entidade diretoriaIdEntidade(Diretoria diretoria) {
        if (diretoria == null) {
            return null;
        }
        DiretoriaPK id = diretoria.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long diretoriaIdId(Diretoria diretoria) {
        if (diretoria == null) {
            return null;
        }
        DiretoriaPK id = diretoria.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Entidade gerenciaIdEntidade(Gerencia gerencia) {
        if (gerencia == null) {
            return null;
        }
        GerenciaPK id = gerencia.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long gerenciaIdId(Gerencia gerencia) {
        if (gerencia == null) {
            return null;
        }
        GerenciaPK id = gerencia.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Entidade coordenadoriaIdEntidade(Coordenadoria coordenadoria) {
        if (coordenadoria == null) {
            return null;
        }
        CoordenadoriaPK id = coordenadoria.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long coordenadoriaIdId(Coordenadoria coordenadoria) {
        if (coordenadoria == null) {
            return null;
        }
        CoordenadoriaPK id = coordenadoria.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Entidade parametroIdEntidade(Parametro parametro) {
        if (parametro == null) {
            return null;
        }
        ParametroPK id = parametro.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long parametroIdId(Parametro parametro) {
        if (parametro == null) {
            return null;
        }
        ParametroPK id = parametro.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Long parametroIdExercicio(Parametro parametro) {
        if (parametro == null) {
            return null;
        }
        ParametroPK id = parametro.getId();
        if (id == null) {
            return null;
        }
        Long exercicio = id.getExercicio();
        if (exercicio == null) {
            return null;
        }
        return exercicio;
    }

    private Modulo parametroIdModulo(Parametro parametro) {
        if (parametro == null) {
            return null;
        }
        ParametroPK id = parametro.getId();
        if (id == null) {
            return null;
        }
        Modulo modulo = id.getModulo();
        if (modulo == null) {
            return null;
        }
        return modulo;
    }

    private Entidade secretariaIdEntidade(Secretaria secretaria) {
        if (secretaria == null) {
            return null;
        }
        SecretariaPK id = secretaria.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private Long secretariaIdId(Secretaria secretaria) {
        if (secretaria == null) {
            return null;
        }
        SecretariaPK id = secretaria.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Long unidadeOrcamentariaIdCodigo(UnidadeOrcamentaria unidadeOrcamentaria) {
        if (unidadeOrcamentaria == null) {
            return null;
        }
        UnidadeOrcamentariaPK id = unidadeOrcamentaria.getId();
        if (id == null) {
            return null;
        }
        Long codigo = id.getCodigo();
        if (codigo == null) {
            return null;
        }
        return codigo;
    }

    private Unidade unidadeOrcamentariaIdOrgao(UnidadeOrcamentaria unidadeOrcamentaria) {
        if (unidadeOrcamentaria == null) {
            return null;
        }
        UnidadeOrcamentariaPK id = unidadeOrcamentaria.getId();
        if (id == null) {
            return null;
        }
        Unidade orgao = id.getOrgao();
        if (orgao == null) {
            return null;
        }
        return orgao;
    }

    protected List<RoteiroLocalDTO> roteiroLocalListToRoteiroLocalDTOList(List<RoteiroLocal> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RoteiroLocalDTO> list1 = new ArrayList<RoteiroLocalDTO>(list.size());
        for (RoteiroLocal roteiroLocal : list) {
            list1.add(this.toRoteiroLocalDTO(roteiroLocal));
        }
        return list1;
    }

    private Long processoInteressadoIdCodigo(ProcessoInteressado processoInteressado) {
        if (processoInteressado == null) {
            return null;
        }
        ProcessoInteressadoPK id = processoInteressado.getId();
        if (id == null) {
            return null;
        }
        Long codigo = id.getCodigo();
        if (codigo == null) {
            return null;
        }
        return codigo;
    }

    protected ProcessoPK processoAndamentoDTOToProcessoPK(ProcessoAndamentoDTO processoAndamentoDTO) {
        if (processoAndamentoDTO == null) {
            return null;
        }
        ProcessoPK processoPK = new ProcessoPK();
        processoPK.setNumero(processoAndamentoDTO.getNumero());
        processoPK.setTipo(this.toTipoProcesso(processoAndamentoDTO.getTipo()));
        processoPK.setAno(processoAndamentoDTO.getAno());
        processoPK.setEntidade(this.toEntidade(processoAndamentoDTO.getEntidade()));
        return processoPK;
    }

    protected Processo processoAndamentoDTOToProcesso(ProcessoAndamentoDTO processoAndamentoDTO) {
        if (processoAndamentoDTO == null) {
            return null;
        }
        Processo processo = new Processo();
        processo.setId(this.processoAndamentoDTOToProcessoPK(processoAndamentoDTO));
        return processo;
    }

    protected ProcessoAndamentoAlteracaoRequerente processoAndamentoAlteracaoRequerenteDTOToProcessoAndamentoAlteracaoRequerente(ProcessoAndamentoAlteracaoRequerenteDTO processoAndamentoAlteracaoRequerenteDTO) {
        if (processoAndamentoAlteracaoRequerenteDTO == null) {
            return null;
        }
        ProcessoAndamentoAlteracaoRequerente processoAndamentoAlteracaoRequerente = new ProcessoAndamentoAlteracaoRequerente();
        processoAndamentoAlteracaoRequerente.setRequerenteOld(this.toPessoa(processoAndamentoAlteracaoRequerenteDTO.getRequerenteOld()));
        processoAndamentoAlteracaoRequerente.setRequerenteNew(this.toPessoa(processoAndamentoAlteracaoRequerenteDTO.getRequerenteNew()));
        return processoAndamentoAlteracaoRequerente;
    }

    protected ProcessoPK processoAndamentoSimpleDTOToProcessoPK(ProcessoAndamentoSimpleDTO processoAndamentoSimpleDTO) {
        if (processoAndamentoSimpleDTO == null) {
            return null;
        }
        ProcessoPK processoPK = new ProcessoPK();
        processoPK.setNumero(processoAndamentoSimpleDTO.getNumero());
        processoPK.setTipo(this.toTipoProcesso(processoAndamentoSimpleDTO.getTipo()));
        processoPK.setAno(processoAndamentoSimpleDTO.getAno());
        processoPK.setEntidade(this.toEntidade(processoAndamentoSimpleDTO.getEntidade()));
        return processoPK;
    }

    protected Processo processoAndamentoSimpleDTOToProcesso(ProcessoAndamentoSimpleDTO processoAndamentoSimpleDTO) {
        if (processoAndamentoSimpleDTO == null) {
            return null;
        }
        Processo processo = new Processo();
        processo.setId(this.processoAndamentoSimpleDTOToProcessoPK(processoAndamentoSimpleDTO));
        return processo;
    }

    private Entidade processoAndamentoProcessoIdEntidade(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private TipoProcesso processoAndamentoProcessoIdTipo(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        TipoProcesso tipo = id.getTipo();
        if (tipo == null) {
            return null;
        }
        return tipo;
    }

    private Long processoAndamentoProcessoIdAno(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long ano = id.getAno();
        if (ano == null) {
            return null;
        }
        return ano;
    }

    private Long processoAndamentoProcessoIdNumero(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long numero = id.getNumero();
        if (numero == null) {
            return null;
        }
        return numero;
    }

    protected UsuarioPermissaoLocalDTO usuarioToUsuarioPermissaoLocalDTO1(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        UsuarioPermissaoLocalDTO.UsuarioPermissaoLocalDTOBuilder usuarioPermissaoLocalDTO = UsuarioPermissaoLocalDTO.builder();
        usuarioPermissaoLocalDTO.loginUsuario(usuario.getId());
        usuarioPermissaoLocalDTO.nomeUsuario(usuario.getNome());
        usuarioPermissaoLocalDTO.ativo(usuario.getAtivo());
        return usuarioPermissaoLocalDTO.build();
    }

    protected Usuario usuarioPermissaoLocalDTOToUsuario(UsuarioPermissaoLocalDTO usuarioPermissaoLocalDTO) {
        if (usuarioPermissaoLocalDTO == null) {
            return null;
        }
        Usuario usuario = new Usuario();
        usuario.setId(usuarioPermissaoLocalDTO.getLoginUsuario());
        usuario.setNome(usuarioPermissaoLocalDTO.getNomeUsuario());
        usuario.setAtivo(usuarioPermissaoLocalDTO.getAtivo());
        return usuario;
    }

    private String usuarioAusenciaUsuarioId(UsuarioAusencia usuarioAusencia) {
        if (usuarioAusencia == null) {
            return null;
        }
        Usuario usuario = usuarioAusencia.getUsuario();
        if (usuario == null) {
            return null;
        }
        String id = usuario.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String usuarioAusenciaUsuarioNome(UsuarioAusencia usuarioAusencia) {
        if (usuarioAusencia == null) {
            return null;
        }
        Usuario usuario = usuarioAusencia.getUsuario();
        if (usuario == null) {
            return null;
        }
        String nome = usuario.getNome();
        if (nome == null) {
            return null;
        }
        return nome;
    }
}

