/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.protocolo.converter.ProcessoObservadorExternoDTOConverter;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.AssuntoDocumento;
import br.com.elotech.protocolo.domain.AssuntoDocumentoPK;
import br.com.elotech.protocolo.domain.AssuntoEntidade;
import br.com.elotech.protocolo.domain.Diretoria;
import br.com.elotech.protocolo.domain.DiretoriaPK;
import br.com.elotech.protocolo.domain.Documento;
import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.domain.ProcessoAnexo;
import br.com.elotech.protocolo.domain.ProcessoAnexoPK;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoAssinaturaConfig;
import br.com.elotech.protocolo.domain.ProcessoInteressado;
import br.com.elotech.protocolo.domain.ProcessoObservador;
import br.com.elotech.protocolo.domain.ProcessoObservadorExterno;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.ProtocoloMapperArquivo;
import br.com.elotech.protocolo.domain.ProtocoloMapperInteressado;
import br.com.elotech.protocolo.domain.Roteiro;
import br.com.elotech.protocolo.domain.Secretaria;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoAndamento;
import br.com.elotech.protocolo.domain.TipoInteresseEnum;
import br.com.elotech.protocolo.domain.TipoNotificacao;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.TipoProcessoEntidade;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Unidade;
import br.com.elotech.protocolo.domain.UnidadePK;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioAusencia;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioLocalPK;
import br.com.elotech.protocolo.domain.UsuarioResponsavel;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.DiretoriaDTO;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoSimpleDTO;
import br.com.elotech.protocolo.dto.ProcessoAnexoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoAssinaturaConfigDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.dto.RoteiroDTO;
import br.com.elotech.protocolo.dto.TipoNotificacaoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.dto.TramiteDTO;
import br.com.elotech.protocolo.dto.UnidadeDTO;
import br.com.elotech.protocolo.dto.UsuarioAusenciaDTO;
import br.com.elotech.protocolo.dto.UsuarioDTO;
import br.com.elotech.protocolo.repository.AssuntoRepository;
import br.com.elotech.protocolo.repository.LocalRepository;
import br.com.elotech.protocolo.repository.PessoaRepository;
import br.com.elotech.protocolo.repository.SituacaoRepository;
import br.com.elotech.protocolo.service.DocumentoService;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.TipoAndamentoService;
import br.com.elotech.protocolo.service.TipoProcessoService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

public abstract class ProtocoloMapperDecorator
implements ProtocoloMapper {
    @Autowired
    @Qualifier(value="delegate")
    private ProtocoloMapper delegate;
    @Autowired
    @Lazy
    private AssuntoRepository assuntoRepository;
    @Autowired
    @Lazy
    private LocalRepository localRepository;
    @Autowired
    @Lazy
    private SituacaoRepository situacaoRepository;
    @Autowired
    @Lazy
    private PessoaRepository pessoaRepository;
    @Autowired
    @Lazy
    private TipoProcessoService tipoProcessoService;
    @Autowired
    private EntidadeService entidadeService;
    @Autowired
    private DocumentoService documentoService;
    @Autowired
    @Lazy
    private ProtocoloMapperArquivo protocoloMapperArquivo;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private ParametroService parametroService;
    @Autowired
    private ProtocoloMapper protocoloMapper;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    @Lazy
    private TipoAndamentoService tipoAndamentoService;

    public Processo toProcesso(ProcessoDTO dto, Processo existing) {
        Processo processo = this.delegate.toProcesso(dto, existing);
        if (Objects.nonNull(dto.getLote())) {
            processo.setData(dto.getLote());
        }
        if (Objects.nonNull(dto.getNumero())) {
            processo.getId().setNumero(dto.getNumero());
        }
        if (Objects.nonNull(dto.getNumeroJaExistente())) {
            processo.setNumeroJaExistente(dto.getNumeroJaExistente());
        }
        if (Objects.nonNull(dto.getEntidade())) {
            processo.getId().setEntidade((Entidade)this.entidadeService.findOne((Serializable)dto.getEntidade().getId()));
        }
        if (Objects.nonNull(dto.getTipo())) {
            processo.getId().setTipo((TipoProcesso)this.tipoProcessoService.findOne((Serializable)dto.getTipo().getId()));
        }
        if (Objects.nonNull(dto.getAno())) {
            processo.getId().setAno(dto.getAno());
        }
        if (Objects.nonNull(dto.getLocalOrigem())) {
            processo.setLocalOrigem((Local)this.localRepository.findOne((Object)LocalPK.of((Entidade)processo.getId().getEntidade(), (Long)dto.getLocalOrigem().getId())));
        }
        if (Objects.nonNull(dto.getLocalDestino())) {
            processo.setLocalDestino((Local)this.localRepository.findOne((Object)LocalPK.of((Entidade)processo.getId().getEntidade(), (Long)dto.getLocalDestino().getId())));
        }
        if (Objects.nonNull(dto.getAssunto())) {
            processo.setAssunto((Assunto)this.assuntoRepository.findOne((Object)dto.getAssunto().getId()));
        }
        if (Objects.nonNull(dto.getPessoa())) {
            processo.setPessoa((Pessoa)this.pessoaRepository.findOne((Object)dto.getPessoa().getId()));
        }
        if (Objects.nonNull(dto.getSituacao())) {
            processo.setSituacao((Situacao)this.situacaoRepository.findOne((Object)dto.getSituacao().getId()));
        }
        if (Objects.nonNull(dto.getUsuarioResponsavelTramite())) {
            processo.setUsuarioResponsavelTramite(this.usuarioService.findUsuarioByName(dto.getUsuarioResponsavelTramite().getLoginUsuario()));
        } else {
            processo.setUsuarioResponsavelTramite(null);
        }
        this.transformarTramites(dto, existing, processo);
        new ProtocoloMapperInteressado().mapToListProcessoInteressado(dto, existing, processo, (BiFunction)new /* Unavailable Anonymous Inner Class!! */);
        this.protocoloMapperArquivo.mapToListProcessoArquivo(dto, existing, processo, (BiFunction)new /* Unavailable Anonymous Inner Class!! */);
        processo.getObservadores().clear();
        dto.getObservadores().forEach(obs -> {
            Usuario usuario = new Usuario();
            usuario.setId(obs.getUsuario().getId());
            processo.getObservadores().add(new ProcessoObservador(obs.getId(), processo, usuario));
        });
        processo.getObservadoresExternos().removeIf(observadorExterno -> dto.getObservadoresExternos().stream().noneMatch(processoObservadorExternoDTO -> observadorExterno.getId().equals(processoObservadorExternoDTO.getId())));
        dto.getObservadoresExternos().forEach(obs -> {
            ProcessoObservadorExterno processoObservadorExterno = new ProcessoObservadorExternoDTOConverter().from(obs);
            processoObservadorExterno.setProcesso(processo);
            if (processoObservadorExterno.isNew()) {
                processo.getObservadoresExternos().add(processoObservadorExterno);
            }
        });
        if (Objects.nonNull(dto.getProcedimentoOrigem()) && StringUtils.isNotBlank((CharSequence)dto.getProcedimentoOrigem().getId())) {
            ProcessoDTO procOrigem = dto.getProcedimentoOrigem();
            processo.setProcessoReferencia(String.format("%s-%s/%s", procOrigem.getTipo().getId(), procOrigem.getNumero(), procOrigem.getAno()));
        }
        processo.getAndamentos().clear();
        processo.getAndamentos().addAll(dto.getAndamentos().stream().map(arg_0 -> this.toProcessoAndamento(arg_0)).collect(Collectors.toList()));
        return processo;
    }

    public ProcessoAssinaturaConfig toProcessoAssinaturaConfig(ProcessoAssinaturaConfigDTO dto, ProcessoAssinaturaConfig existing) {
        ProcessoAssinaturaConfig processoAssinaturaConfig = this.delegate.toProcessoAssinaturaConfig(dto, existing);
        if (Objects.nonNull(dto.getTipoProcesso())) {
            processoAssinaturaConfig.setTipoProcesso(this.delegate.toTipoProcesso(dto.getTipoProcesso()));
        }
        if (Objects.nonNull(dto.getSituacao())) {
            processoAssinaturaConfig.setSituacao(this.delegate.toSituacao(dto.getSituacao()));
        }
        if (Objects.nonNull(dto.getAssunto())) {
            processoAssinaturaConfig.setAssunto(this.delegate.toAssunto(dto.getAssunto()));
        }
        if (Objects.nonNull(dto.getLocalOrigem())) {
            processoAssinaturaConfig.setLocalOrigem(this.delegate.toLocal(dto.getLocalOrigem()));
        }
        if (Objects.nonNull(dto.getLocalDestino())) {
            processoAssinaturaConfig.setLocalDestino(this.delegate.toLocal(dto.getLocalDestino()));
        }
        if (Objects.nonNull(dto.getPessoa())) {
            processoAssinaturaConfig.setPessoa(this.delegate.toPessoa(dto.getPessoa()));
        }
        if (Objects.nonNull(dto.getTipoIntegracao())) {
            processoAssinaturaConfig.setTipoIntegracao(dto.getTipoIntegracao());
        }
        if (Objects.nonNull(dto.getSituacaoArquivamento())) {
            processoAssinaturaConfig.setSituacaoArquivamento(this.delegate.toSituacao(dto.getSituacaoArquivamento()));
        }
        if (Objects.nonNull(dto.getLocalArquivamento())) {
            processoAssinaturaConfig.setLocalArquivamento(this.delegate.toLocal(dto.getLocalArquivamento()));
        }
        return processoAssinaturaConfig;
    }

    public ProcessoInteressado toProcessoInteressado(ProcessoInteressadoDTO dto, ProcessoInteressado existing) {
        ProcessoInteressado processoInteressado = this.delegate.toProcessoInteressado(dto, existing);
        processoInteressado.setId(this.delegate.toProcessoInteressadoPK(dto));
        if (Objects.nonNull(dto.getPessoa())) {
            processoInteressado.setPessoa(this.delegate.toPessoa(dto.getPessoa()));
        }
        if (Objects.nonNull(dto.getTipoInteresse())) {
            processoInteressado.setTipoInteresse(TipoInteresseEnum.valueOf((String)dto.getTipoInteresse()));
        }
        if (Objects.nonNull(dto.getTipoParticipante())) {
            processoInteressado.setTipoParticipante(this.delegate.toTipoParticipante(dto.getTipoParticipante()));
        }
        processoInteressado.setLocalTrabalho(dto.getLocalTrabalho());
        return processoInteressado;
    }

    public ProcessoAndamento toProcessoAndamento(ProcessoAndamentoSimpleDTO dto) {
        ProcessoAndamento processoAndamento = this.delegate.toProcessoAndamento(dto);
        if (Objects.nonNull(dto.getTipoAndamento())) {
            processoAndamento.setTipoAndamento((TipoAndamento)this.tipoAndamentoService.findOne((Serializable)dto.getTipoAndamento().getId()));
        }
        return processoAndamento;
    }

    public ProcessoAndamento toProcessoAndamento(ProcessoAndamentoDTO dto) {
        ProcessoAndamento processoAndamento = this.delegate.toProcessoAndamento(dto);
        if (Objects.nonNull(dto.getTipoAndamento())) {
            processoAndamento.setTipoAndamento((TipoAndamento)this.tipoAndamentoService.findOne((Serializable)dto.getTipoAndamento().getId()));
        }
        return processoAndamento;
    }

    private void transformarTramites(ProcessoDTO dto, Processo existing, Processo processo) {
        if (processo.isNew()) {
            List<Tramite> tramites = dto.getTramites().stream().map(t -> this.toTramite(t, existing.findBySequencia(t.getSequencia()).orElse(new Tramite()))).collect(Collectors.toList());
            tramites.forEach(t -> {
                t.getId().setProcesso(processo);
                if (Objects.nonNull(t.getLocal())) {
                    t.getLocal().getId().setEntidade(processo.getId().getEntidade());
                }
            });
            processo.getTramites().addAll(tramites);
        }
    }

    public ProcessoAnexo toProcessoAnexo(ProcessoAnexoDTO dto, ProcessoAnexo existing) {
        ProcessoAnexo processoAnexo = this.delegate.toProcessoAnexo(dto, existing);
        TipoProcesso tipoProcessoAnexo = this.delegate.toTipoProcesso(dto.getTipoAnexo());
        ProcessoAnexoPK processoAnexoPk = ProcessoAnexoPK.of((TipoProcesso)tipoProcessoAnexo, (Long)dto.getAnoAnexo(), (Long)dto.getNumeroAnexo(), (Long)dto.getSequencia(), (Entidade)this.toEntidade(dto.getEntidadeAnexo()));
        processoAnexo.setId(processoAnexoPk);
        TipoProcesso tipoProcesso = this.delegate.toTipoProcesso(dto.getTipo(), null);
        Processo processo = new Processo();
        processo.setId(ProcessoPK.of((Entidade)this.toEntidade(dto.getEntidade()), (TipoProcesso)tipoProcesso, (Long)dto.getNumero(), (Long)dto.getAno()));
        processoAnexo.setProcesso(processo);
        return processoAnexo;
    }

    public Tramite toTramite(TramiteDTO dto, Tramite existing) {
        Tramite tramite = this.delegate.toTramite(dto, existing);
        tramite.setId(this.delegate.toTramitePK(dto));
        return tramite;
    }

    public ProcessoArquivo toProcessoArquivo(ProcessoArquivoDTO dto, ProcessoArquivo existing) {
        ProcessoArquivo processoArquivo = this.delegate.toProcessoArquivo(dto, existing);
        processoArquivo.setId(this.delegate.toProcessoArquivoPK(dto));
        return processoArquivo;
    }

    public Pessoa toPessoa(PessoaDTO pessoaDTO, Pessoa existing) {
        Pessoa pessoa = this.delegate.toPessoa(pessoaDTO, existing);
        if (!pessoa.getEnderecos().isEmpty()) {
            pessoa.getEnderecos().forEach(end -> end.getPk().setPessoa(pessoa));
        }
        return pessoa;
    }

    public Pessoa toPessoa(PessoaDTO pessoaDTO) {
        Pessoa pessoa = this.delegate.toPessoa(pessoaDTO);
        List enderecos = pessoa.getEnderecos();
        enderecos.forEach(end -> end.getPk().setPessoa(pessoa));
        if (pessoa.getSequenciaEndereco() == null && !pessoa.getEnderecos().isEmpty()) {
            pessoa.setSequenciaEndereco(Optional.ofNullable(((EnderecoPessoa)enderecos.get(0)).getPk().getCodigo()).orElse(1L));
        }
        return pessoa;
    }

    public Unidade toUnidade(UnidadeDTO dto) {
        Unidade unidade = this.delegate.toUnidade(dto);
        unidade.setId(this.toUnidadePK(dto.getId(), dto.getEntidade()));
        return unidade;
    }

    public UnidadePK toUnidadePK(Long idLong, EntidadeDTO entidadeDto) {
        Entidade entidade = this.toEntidade(entidadeDto);
        return UnidadePK.of((Entidade)entidade, (Long)idLong);
    }

    public Diretoria toDiretoria(DiretoriaDTO dto) {
        Diretoria diretoria = this.delegate.toDiretoria(dto);
        diretoria.setId(this.toDiretoriaPK(dto.getId(), dto.getEntidade()));
        return diretoria;
    }

    public DiretoriaPK toDiretoriaPK(Long idLong, EntidadeDTO entidadeDto) {
        Entidade entidade = this.toEntidade(entidadeDto);
        return DiretoriaPK.of((Entidade)entidade, (Long)idLong);
    }

    public TipoNotificacao toTipoNotificacao(TipoNotificacaoDTO dto, TipoNotificacao existing) {
        TipoNotificacao tipoNotificacao = this.delegate.toTipoNotificacao(dto, existing);
        tipoNotificacao.setId(this.toTipoNotificacaoPK(dto.getEntidade(), dto.getId()));
        return tipoNotificacao;
    }

    public Local toLocal(LocalDTO dto, Local existing) {
        Local local = this.delegate.toLocal(dto, existing);
        local.setId(this.toLocalPK(dto));
        local.setRoteiroAtivo(dto.getRoteiroAtivo().booleanValue());
        if (dto.getDiretoria() != null) {
            local.setDiretoria(this.toDiretoria(dto.getDiretoria()));
        } else {
            local.setDiretoria(null);
        }
        if (dto.getGerencia() != null) {
            local.setGerencia(this.toGerencia(dto.getGerencia()));
        } else {
            local.setGerencia(null);
        }
        if (dto.getCoordenadoria() != null) {
            local.setCoordenadoria(this.toCoordenadoria(dto.getCoordenadoria()));
        } else {
            local.setCoordenadoria(null);
        }
        if (dto.getResponsavel() != null) {
            local.setResponsavel(this.toUsuarioResponsavel(dto.getResponsavel(), new UsuarioResponsavel()));
        } else {
            local.setResponsavel(null);
        }
        if (dto.getUnidadeOrcamentaria() != null) {
            local.setUnidadeOrcamentaria(this.toUnidadeOrcamentaria(dto.getUnidadeOrcamentaria()));
        } else {
            local.setUnidadeOrcamentaria(null);
        }
        if (dto.getLocalPai() != null) {
            local.setLocalPai(this.delegate.toLocal(dto.getLocalPai()));
        } else {
            local.setLocalPai(null);
        }
        return local;
    }

    public Usuario toUsuario(UsuarioDTO usuarioDTO, Usuario existing) {
        Usuario usuario = this.delegate.toUsuario(usuarioDTO, existing);
        usuario.getUsuarioTipoProcesso().forEach(end -> end.getId().setUsuario(usuario));
        usuario.getUsuarioModeloImpressao().forEach(end -> end.getId().setUsuario(usuario));
        List secretarias = usuarioDTO.getSecretarias().stream().map(dto -> this.toSecretaria(dto, new Secretaria())).collect(Collectors.toList());
        usuario.getSecretarias().clear();
        usuario.getSecretarias().addAll(secretarias);
        List assuntos = usuarioDTO.getAssuntos().stream().map(dto -> (Assunto)this.assuntoRepository.findOne((Object)dto.getId())).collect(Collectors.toList());
        usuario.getAssuntos().clear();
        usuario.getAssuntos().addAll(assuntos);
        usuario.getUsuarioLocal().clear();
        usuarioDTO.getUsuarioLocal().forEach(usuarioLocal -> {
            Local local = this.toLocal(usuarioLocal.getLocal());
            UsuarioLocalPK id = new UsuarioLocalPK(usuario, local);
            usuario.getUsuarioLocal().add(new UsuarioLocal(id, usuarioLocal.getPadrao()));
        });
        return usuario;
    }

    public TipoProcesso toTipoProcesso(TipoProcessoDTO tipoProcessoDTO, TipoProcesso existing) {
        TipoProcesso tipoProcesso = this.delegate.toTipoProcesso(tipoProcessoDTO, existing);
        tipoProcesso.getTipoProcessoEntidade().clear();
        List tipoProcessoEntidadeList = tipoProcessoDTO.getTipoProcessoEntidade().stream().map(tp -> {
            TipoProcessoEntidade tipoProcessoEntidade = new TipoProcessoEntidade();
            tipoProcessoEntidade.setEntidade((Entidade)this.entidadeService.findOne((Serializable)tp.getEntidade().getId()));
            tipoProcessoEntidade.setTipoProcesso(tipoProcesso);
            return tipoProcessoEntidade;
        }).collect(Collectors.toList());
        tipoProcesso.getTipoProcessoEntidade().addAll(tipoProcessoEntidadeList);
        if (Objects.nonNull(tipoProcessoDTO.getSituacaoPadrao())) {
            tipoProcesso.setSituacaoPadrao(this.delegate.toSituacao(tipoProcessoDTO.getSituacaoPadrao()));
        } else {
            tipoProcesso.setSituacaoPadrao(null);
        }
        if (Objects.nonNull(tipoProcessoDTO.getAssuntoPadrao())) {
            tipoProcesso.setAssuntoPadrao(this.delegate.toAssunto(tipoProcessoDTO.getAssuntoPadrao()));
            tipoProcesso.setAssuntoFixo(tipoProcessoDTO.getAssuntoFixo());
        } else {
            tipoProcesso.setAssuntoPadrao(null);
            tipoProcesso.setAssuntoFixo(Boolean.valueOf(false));
        }
        return tipoProcesso;
    }

    public Assunto toAssunto(AssuntoDTO assuntoDTO, Assunto existing) {
        Assunto assunto = this.delegate.toAssunto(assuntoDTO, existing);
        ArrayList arquivosAssunto = new ArrayList(assunto.getArquivos());
        assunto.getAssuntoDocumento().clear();
        assunto.getArquivos().clear();
        assunto.getAssuntoEntidade().clear();
        assunto.setAssuntoPai(this.delegate.toAssunto(assuntoDTO.getAssuntoPai()));
        this.entityManager.flush();
        assunto.getArquivos().addAll(arquivosAssunto);
        List documentos = assuntoDTO.getAssuntoDocumento().stream().map(ad -> {
            AssuntoDocumentoPK id = new AssuntoDocumentoPK();
            id.setAssunto(assunto);
            id.setDocumento((Documento)this.documentoService.findOne((Serializable)ad.getDocumento().getId()));
            AssuntoDocumento assuntoDocumento = new AssuntoDocumento();
            assuntoDocumento.setId(id);
            assuntoDocumento.setAutenticado(ad.getAutenticado());
            assuntoDocumento.setObrigatoriointerno(ad.getObrigatoriointerno());
            assuntoDocumento.setObrigatorioexterno(ad.getObrigatorioexterno());
            assuntoDocumento.setQuantcopias(ad.getQuantidadecopias());
            return assuntoDocumento;
        }).collect(Collectors.toList());
        assunto.getAssuntoDocumento().addAll(documentos);
        List assuntoEntidades = assuntoDTO.getAssuntoEntidade().stream().map(ae -> {
            AssuntoEntidade assuntoEntidade = new AssuntoEntidade();
            assuntoEntidade.setEntidade((Entidade)this.entidadeService.findOne((Serializable)ae.getEntidade().getId()));
            assuntoEntidade.setAssunto(assunto);
            return assuntoEntidade;
        }).collect(Collectors.toList());
        assunto.getAssuntoEntidade().addAll(assuntoEntidades);
        return assunto;
    }

    public Roteiro toRoteiro(RoteiroDTO roteiroDTO) {
        Roteiro roteiro = this.delegate.toRoteiro(roteiroDTO);
        List lstRoteiroLocal = roteiroDTO.getRoteiroLocal().stream().map(arg_0 -> ((ProtocoloMapperDecorator)this).toRoteiroLocal(arg_0)).collect(Collectors.toList());
        roteiro.setRoteiroLocal(lstRoteiroLocal);
        return roteiro;
    }

    public UsuarioAusencia toUsuarioAusencia(UsuarioAusenciaDTO usuarioAusenciaDTO) {
        if (Objects.isNull(usuarioAusenciaDTO)) {
            return null;
        }
        UsuarioAusencia usuarioAusencia = this.delegate.toUsuarioAusencia(usuarioAusenciaDTO);
        if (Objects.nonNull(usuarioAusenciaDTO.getUsuarioId())) {
            usuarioAusencia.setUsuario(this.usuarioService.findUsuarioByName(usuarioAusenciaDTO.getUsuarioId()));
        } else {
            usuarioAusencia.setUsuario(null);
        }
        return usuarioAusencia;
    }
}

