/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ProtocoloMapperArquivo {
    private final ProcessoArquivoService processoArquivoService;

    public ProtocoloMapperArquivo(ProcessoArquivoService processoArquivoService) {
        this.processoArquivoService = processoArquivoService;
    }

    public void mapToListProcessoArquivo(ProcessoDTO dto, Processo existing, Processo processo, BiFunction<ProcessoArquivoDTO, ProcessoArquivo, ProcessoArquivo> toProcessoArquivoFunc) {
        List<ProcessoArquivo> listToDelete = processo.getArquivos().stream().filter(arq -> !this.existsArquivo(dto, arq)).collect(Collectors.toList());
        listToDelete.forEach(arq -> {
            this.processoArquivoService.deletarArquivo(arq);
            processo.getArquivos().remove(arq);
        });
        Long sequencia = dto.maxSequenciaArquivos();
        for (ProcessoArquivoDTO arq2 : dto.getArquivos()) {
            if (!arq2.isNew() || arq2.getIdArquivo() == null) continue;
            ProcessoArquivo processoArquivo = toProcessoArquivoFunc.apply(arq2, new ProcessoArquivo());
            processoArquivo.getId().setProcesso(existing);
            sequencia = sequencia + 1L;
            processoArquivo.getId().setSequencia(sequencia);
            processoArquivo.setIdArquivo(arq2.getIdArquivo());
            processo.getArquivos().add(processoArquivo);
        }
    }

    private boolean existsArquivo(ProcessoDTO processoDTO, ProcessoArquivo processoArquivo) {
        return processoDTO.getArquivos().stream().anyMatch(arq -> processoArquivo.getId().getSequencia().equals(arq.getSequencia()));
    }
}

