/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.protocolo.domain.ProcessoTaxaItem;
import br.com.elotech.protocolo.dto.BoletoTributosDTO;
import br.com.elotech.protocolo.dto.DebitoTributosDTO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="PROCESSO_TAXAS")
public class ProcessoTaxa {
    @Id
    @EloSequence
    private Long id;
    @Column(name="data_vencimento")
    private LocalDate dataVencimento;
    private Long idDebito;
    private Long idBoleto;
    @Length(max=1000)
    private @Length(max=1000) String parcelas;
    @Length(max=1000)
    @Column(name="url_boleto")
    private @Length(max=1000) String urlBoleto;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="IDPROCESSOTAXA")
    private List<ProcessoTaxaItem> itens = new ArrayList();

    public static ProcessoTaxa gerarTaxaProcesso(DebitoTributosDTO debito, BoletoTributosDTO boleto) {
        ProcessoTaxa processoTaxa = new ProcessoTaxa();
        processoTaxa.setDataVencimento(boleto.getDataVencimento());
        processoTaxa.setIdBoleto(boleto.getId());
        processoTaxa.setUrlBoleto(boleto.getUrlImpressao());
        processoTaxa.setIdDebito(debito.getIdDebito());
        return processoTaxa;
    }

    public void atualizarProcessoTaxa(BoletoTributosDTO newBoleto) {
        this.setDataVencimento(newBoleto.getDataVencimento());
        this.setIdBoleto(newBoleto.getId());
        this.setUrlBoleto(newBoleto.getUrlImpressao());
    }

    @Generated
    public ProcessoTaxa() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getIdBoleto() {
        return this.idBoleto;
    }

    @Generated
    public String getParcelas() {
        return this.parcelas;
    }

    @Generated
    public String getUrlBoleto() {
        return this.urlBoleto;
    }

    @Generated
    public List<ProcessoTaxaItem> getItens() {
        return this.itens;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setIdBoleto(Long idBoleto) {
        this.idBoleto = idBoleto;
    }

    @Generated
    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setUrlBoleto(String urlBoleto) {
        this.urlBoleto = urlBoleto;
    }

    @Generated
    public void setItens(List<ProcessoTaxaItem> itens) {
        this.itens = itens;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessoTaxa)) {
            return false;
        }
        ProcessoTaxa other = (ProcessoTaxa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$idBoleto = this.getIdBoleto();
        Long other$idBoleto = other.getIdBoleto();
        if (this$idBoleto == null ? other$idBoleto != null : !((Object)this$idBoleto).equals(other$idBoleto)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        String this$parcelas = this.getParcelas();
        String other$parcelas = other.getParcelas();
        if (this$parcelas == null ? other$parcelas != null : !this$parcelas.equals(other$parcelas)) {
            return false;
        }
        String this$urlBoleto = this.getUrlBoleto();
        String other$urlBoleto = other.getUrlBoleto();
        if (this$urlBoleto == null ? other$urlBoleto != null : !this$urlBoleto.equals(other$urlBoleto)) {
            return false;
        }
        List this$itens = this.getItens();
        List other$itens = other.getItens();
        return !(this$itens == null ? other$itens != null : !((Object)this$itens).equals(other$itens));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessoTaxa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $idBoleto = this.getIdBoleto();
        result = result * 59 + ($idBoleto == null ? 43 : ((Object)$idBoleto).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        String $parcelas = this.getParcelas();
        result = result * 59 + ($parcelas == null ? 43 : $parcelas.hashCode());
        String $urlBoleto = this.getUrlBoleto();
        result = result * 59 + ($urlBoleto == null ? 43 : $urlBoleto.hashCode());
        List $itens = this.getItens();
        result = result * 59 + ($itens == null ? 43 : ((Object)$itens).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProcessoTaxa(id=" + this.getId() + ", dataVencimento=" + String.valueOf(this.getDataVencimento()) + ", idDebito=" + this.getIdDebito() + ", idBoleto=" + this.getIdBoleto() + ", parcelas=" + this.getParcelas() + ", urlBoleto=" + this.getUrlBoleto() + ", itens=" + String.valueOf(this.getItens()) + ")";
    }
}

