/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.utils.ProcessoKeyUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Embeddable
public class ProcessoPK
implements Serializable {
    @ManyToOne
    @JoinColumn(name="entidade")
    private Entidade entidade;
    @NotNull
    @ManyToOne
    @JoinColumn(name="tipo")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private TipoProcesso tipo;
    @NotNull
    @EloSequence(sequenceNameFactory="#{sequenciamentoProcessoService.getExpression(#entity)}")
    private Long numero;
    @NotNull
    private Long ano = LocalDate.now().getYear();

    public static ProcessoPK of(Entidade entidade, TipoProcesso tipo, Long numero, Long ano) {
        ProcessoPK pk = new ProcessoPK();
        pk.setEntidade(entidade);
        pk.setTipo(tipo);
        pk.setNumero(numero);
        pk.setAno(ano);
        return pk;
    }

    public String getKey() {
        if (this.isValidKey().booleanValue()) {
            return ProcessoKeyUtils.getKey((Long)this.tipo.getId(), (Long)this.numero, (Long)this.ano, (Long)this.entidade.getId());
        }
        return "";
    }

    public Boolean isValidKey() {
        return this.possuiTipoValido() && Objects.nonNull(this.numero) && Objects.nonNull(this.ano) && Objects.nonNull(this.entidade);
    }

    @JsonIgnore
    public String dataAtual() {
        return DateTimeFormatter.ofPattern("ddMMyyyy").format(LocalDateTime.now());
    }

    private boolean possuiTipoValido() {
        return Objects.nonNull(this.tipo) && Objects.nonNull(this.tipo.getId());
    }

    @Generated
    public ProcessoPK() {
    }

    @Generated
    public Entidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public TipoProcesso getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public Long getAno() {
        return this.ano;
    }

    @Generated
    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setTipo(TipoProcesso tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setAno(Long ano) {
        this.ano = ano;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessoPK)) {
            return false;
        }
        ProcessoPK other = (ProcessoPK)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$numero = this.getNumero();
        Long other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !((Object)this$numero).equals(other$numero)) {
            return false;
        }
        Long this$ano = this.getAno();
        Long other$ano = other.getAno();
        if (this$ano == null ? other$ano != null : !((Object)this$ano).equals(other$ano)) {
            return false;
        }
        Entidade this$entidade = this.getEntidade();
        Entidade other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !this$entidade.equals(other$entidade)) {
            return false;
        }
        TipoProcesso this$tipo = this.getTipo();
        TipoProcesso other$tipo = other.getTipo();
        return !(this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessoPK;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : ((Object)$numero).hashCode());
        Long $ano = this.getAno();
        result = result * 59 + ($ano == null ? 43 : ((Object)$ano).hashCode());
        Entidade $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : $entidade.hashCode());
        TipoProcesso $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProcessoPK(tipo=" + String.valueOf(this.getTipo()) + ", numero=" + this.getNumero() + ", ano=" + this.getAno() + ")";
    }
}

