/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.domain.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.TipoAndamento;
import br.com.elotech.protocolo.domain.support.AuditInfo;
import br.com.elotech.protocolo.domain.support.AuditListener;
import br.com.elotech.protocolo.domain.support.Auditable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Audited
@Table(name="processoobservadorext")
@EntityListeners(value={AuditListener.class})
public class ProcessoObservadorExterno
implements EloEntity<UUID>,
Auditable {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    @Type(type="uuid-char")
    private UUID id;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="numero", referencedColumnName="numero", updatable=false), @JoinColumn(name="tipo", referencedColumnName="tipo", updatable=false), @JoinColumn(name="ano", referencedColumnName="ano", updatable=false)})
    private Processo processo;
    @JsonIgnore
    @MetaModelIgnore
    @JoinColumn(name="pessoa_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Pessoa pessoa;
    @JsonIgnore
    @MetaModelIgnore
    @JoinColumn(name="tipoandamento_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoAndamento tipoAndamento;
    private String mensagem;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean obrigaVisualizacao = Boolean.FALSE;
    @Caption(value="E-Mail")
    @Length(max=100)
    @Column(name="emailalternativo")
    private @Length(max=100) String emailAlternativo;
    @Embedded
    @NotAudited
    private AuditInfo audit;

    public static ProcessoObservadorExterno of(UUID id) {
        ProcessoObservadorExterno processoObservadorExterno = new ProcessoObservadorExterno();
        processoObservadorExterno.setId(id);
        return processoObservadorExterno;
    }

    public String getEmail() {
        return Optional.ofNullable(this.getEmailAlternativo()).orElse(this.getPessoa().getContatoEmail());
    }

    public Boolean hasEmail() {
        String email = this.getEmail();
        return Objects.nonNull(email) && StringUtils.isNotBlank((CharSequence)email);
    }

    @Generated
    public ProcessoObservadorExterno() {
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Processo getProcesso() {
        return this.processo;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoAndamento getTipoAndamento() {
        return this.tipoAndamento;
    }

    @Generated
    public String getMensagem() {
        return this.mensagem;
    }

    @Generated
    public Boolean getObrigaVisualizacao() {
        return this.obrigaVisualizacao;
    }

    @Generated
    public String getEmailAlternativo() {
        return this.emailAlternativo;
    }

    @Generated
    public AuditInfo getAudit() {
        return this.audit;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setProcesso(Processo processo) {
        this.processo = processo;
    }

    @JsonIgnore
    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @JsonIgnore
    @Generated
    public void setTipoAndamento(TipoAndamento tipoAndamento) {
        this.tipoAndamento = tipoAndamento;
    }

    @Generated
    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    @Generated
    public void setObrigaVisualizacao(Boolean obrigaVisualizacao) {
        this.obrigaVisualizacao = obrigaVisualizacao;
    }

    @Generated
    public void setEmailAlternativo(String emailAlternativo) {
        this.emailAlternativo = emailAlternativo;
    }

    @Generated
    public void setAudit(AuditInfo audit) {
        this.audit = audit;
    }

    @Generated
    public String toString() {
        return "ProcessoObservadorExterno(id=" + String.valueOf(this.getId()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessoObservadorExterno)) {
            return false;
        }
        ProcessoObservadorExterno other = (ProcessoObservadorExterno)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessoObservadorExterno;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

