/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.HistoricoProcessoArquivoAssinaturaEmail;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Audited
@Table(name="arquivos_assinatura")
public class ProcessoArquivoAssinatura
implements EloEntity<Long>,
DomainEntity<Long> {
    @Id
    @EloSequence(sequenceName="ID_ARQUIVO_ASSINATURA", applyOnMerge=true)
    private Long id;
    @NotNull
    @JoinColumn(name="usuario")
    @ManyToOne(fetch=FetchType.LAZY)
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Usuario usuario;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usuariosolicitante")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Usuario usuarioSolicitante;
    @NotNull
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="tipo", referencedColumnName="tipo", updatable=false), @JoinColumn(name="numero", referencedColumnName="numero", updatable=false), @JoinColumn(name="sequencia", referencedColumnName="sequencia", updatable=false), @JoinColumn(name="ano", referencedColumnName="ano", updatable=false)})
    public ProcessoArquivo arquivo;
    @Enumerated(value=EnumType.STRING)
    private AssinaturaSituacaoEnum situacao = AssinaturaSituacaoEnum.PENDENTE;
    @NotNull
    @Column(updatable=false)
    private LocalDateTime dataCriacao = LocalDateTime.now();
    @NotAudited
    @Formula(value="CAST(CAST(CAST(datacriacao AS DATE) AS varchar(10)) AS DATE)")
    private LocalDate dataCriacaoDate;
    @Column(name="dataassinatura")
    private LocalDateTime dataAssinatura;
    @NotAudited
    @Formula(value="CAST(CAST(CAST(dataassinatura AS DATE) AS varchar(10)) AS DATE)")
    private LocalDate dataAssinaturaDate;
    @Column(name="datarecusa")
    private LocalDateTime dataRecusa;
    @Column(name="dataassinando")
    private LocalDateTime dataAssinando;
    @Column(name="motivorecusa")
    private String motivoRecusa;
    private String erro;
    @Column(name="tipoassinante")
    private String tipoAssinante = "";
    @NotAudited
    @Column(name="entidade", insertable=false, updatable=false)
    private Long entidade;
    private Long fluxoAssinanteSequencia;
    @Column(name="idprocessamento")
    private String idProcessamento;
    @OneToMany(mappedBy="domainEntity", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoProcessoArquivoAssinaturaEmail> historicoEmailList = new ArrayList();

    public Long getNumeroProcesso() {
        return this.arquivo.getId().getProcesso().getId().getNumero();
    }

    public Long getAnoProcesso() {
        return this.arquivo.getId().getProcesso().getId().getAno();
    }

    public Long getTipoProcesso() {
        return this.arquivo.getId().getProcesso().getId().getTipo().getId();
    }

    public String getTipoProcessoDescricao() {
        return this.arquivo.getId().getProcesso().getId().getTipo().getDescricao();
    }

    public String getIdentificador() {
        return this.arquivo.getIdentificador();
    }

    public String getNome() {
        return this.arquivo.getNome();
    }

    public String getIdProcesso() {
        return this.arquivo.getId().getProcesso().getId().getKey();
    }

    public AssinaturaSituacaoEnum getSituacao() {
        return Objects.requireNonNullElse(this.situacao, AssinaturaSituacaoEnum.PENDENTE);
    }

    public String getUrlS3() {
        return this.arquivo.getUrlS3();
    }

    public Boolean getObrigaPosicionamentoAssinatura() {
        return this.arquivo.getObrigaPosicionamentoAssinatura();
    }

    public boolean aindaNaoFoiAssinadaOuRecusada() {
        return Objects.isNull(this.getDataAssinatura()) && Objects.isNull(this.getDataRecusa());
    }

    @Generated
    public ProcessoArquivoAssinatura() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public Usuario getUsuarioSolicitante() {
        return this.usuarioSolicitante;
    }

    @Generated
    public ProcessoArquivo getArquivo() {
        return this.arquivo;
    }

    @Generated
    public LocalDateTime getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public LocalDate getDataCriacaoDate() {
        return this.dataCriacaoDate;
    }

    @Generated
    public LocalDateTime getDataAssinatura() {
        return this.dataAssinatura;
    }

    @Generated
    public LocalDate getDataAssinaturaDate() {
        return this.dataAssinaturaDate;
    }

    @Generated
    public LocalDateTime getDataRecusa() {
        return this.dataRecusa;
    }

    @Generated
    public LocalDateTime getDataAssinando() {
        return this.dataAssinando;
    }

    @Generated
    public String getMotivoRecusa() {
        return this.motivoRecusa;
    }

    @Generated
    public String getErro() {
        return this.erro;
    }

    @Generated
    public String getTipoAssinante() {
        return this.tipoAssinante;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getFluxoAssinanteSequencia() {
        return this.fluxoAssinanteSequencia;
    }

    @Generated
    public String getIdProcessamento() {
        return this.idProcessamento;
    }

    @Generated
    public List<HistoricoProcessoArquivoAssinaturaEmail> getHistoricoEmailList() {
        return this.historicoEmailList;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioSolicitante(Usuario usuarioSolicitante) {
        this.usuarioSolicitante = usuarioSolicitante;
    }

    @JsonIgnore
    @Generated
    public void setArquivo(ProcessoArquivo arquivo) {
        this.arquivo = arquivo;
    }

    @Generated
    public void setSituacao(AssinaturaSituacaoEnum situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDataCriacao(LocalDateTime dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setDataCriacaoDate(LocalDate dataCriacaoDate) {
        this.dataCriacaoDate = dataCriacaoDate;
    }

    @Generated
    public void setDataAssinatura(LocalDateTime dataAssinatura) {
        this.dataAssinatura = dataAssinatura;
    }

    @Generated
    public void setDataAssinaturaDate(LocalDate dataAssinaturaDate) {
        this.dataAssinaturaDate = dataAssinaturaDate;
    }

    @Generated
    public void setDataRecusa(LocalDateTime dataRecusa) {
        this.dataRecusa = dataRecusa;
    }

    @Generated
    public void setDataAssinando(LocalDateTime dataAssinando) {
        this.dataAssinando = dataAssinando;
    }

    @Generated
    public void setMotivoRecusa(String motivoRecusa) {
        this.motivoRecusa = motivoRecusa;
    }

    @Generated
    public void setErro(String erro) {
        this.erro = erro;
    }

    @Generated
    public void setTipoAssinante(String tipoAssinante) {
        this.tipoAssinante = tipoAssinante;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setFluxoAssinanteSequencia(Long fluxoAssinanteSequencia) {
        this.fluxoAssinanteSequencia = fluxoAssinanteSequencia;
    }

    @Generated
    public void setIdProcessamento(String idProcessamento) {
        this.idProcessamento = idProcessamento;
    }

    @Generated
    public void setHistoricoEmailList(List<HistoricoProcessoArquivoAssinaturaEmail> historicoEmailList) {
        this.historicoEmailList = historicoEmailList;
    }

    @Generated
    public String toString() {
        return "ProcessoArquivoAssinatura(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessoArquivoAssinatura)) {
            return false;
        }
        ProcessoArquivoAssinatura other = (ProcessoArquivoAssinatura)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessoArquivoAssinatura;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

