/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.protocolo.domain.Documento;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.ProcessoArquivoPK;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.AnaliseArquivoDTO;
import br.com.elotech.protocolo.dto.TipoAssinaturaEnum;
import br.com.elotech.protocolo.dto.converter.AnaliseArquivoEnumConverter;
import br.com.elotech.protocolo.enums.AnaliseArquivoEnum;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.enums.SituacaoArquivoEnum;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import br.com.elotech.protocolo.specs.ProcessoArquivoSpecificationHelper;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.annotations.Formula;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.jpa.domain.Specification;

@Entity
@Audited
@Table(name="protocolo_arquivos")
public class ProcessoArquivo
implements EloEntity<ProcessoArquivoPK>,
DomainEntity<ProcessoArquivoPK> {
    @EmbeddedId
    private ProcessoArquivoPK id;
    private String nome;
    private String descricao;
    private Long idArquivo;
    private String identificador;
    private String urlS3;
    private Long ordem;
    private Long idAndamento;
    private Long sequenciaTramitacao;
    private String usuario;
    private String variaveis;
    @NotAudited
    @Formula(value="(SELECT u.nome      FROM usuario u      WHERE u.login1 = usuario)")
    private String usuarioNome;
    @NotAudited
    @Formula(value="(SELECT u.cpf      FROM usuario u      WHERE u.login1 = usuario)")
    private String usuarioCpf;
    private LocalDateTime dataCriacao = LocalDateTime.now();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean agrupamento = Boolean.FALSE;
    @JoinColumn(name="tipo_documento")
    @ManyToOne(fetch=FetchType.LAZY)
    private Documento documento;
    @Convert(converter=AnaliseArquivoEnumConverter.class)
    private AnaliseArquivoEnum analise = AnaliseArquivoEnum.NAO_ANALISADO;
    @Column(name="tipoassinatura")
    private TipoAssinaturaEnum tipoAssinatura;
    @Column(name="usuarioanalise")
    private String usuarioAnalise;
    @Column(name="dataanalise")
    private LocalDateTime dataAnalise;
    @Column(name="motivorecusa")
    private String motivoRecusa;
    @Column(name="sigiloexterno")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean sigiloExterno = Boolean.FALSE;
    @OneToMany(mappedBy="arquivo", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="dataAssinatura")
    private List<ProcessoArquivoAssinatura> assinaturas = new ArrayList();
    @Column(name="salvopelosistema")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean salvoPeloSistema;
    @Transient
    private Long qtdAssinaturas;
    @Transient
    private Long qtdAssinaturasPendentes;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean cancelado = Boolean.FALSE;
    @Length(max=1000)
    private @Length(max=1000) String motivoCancelamento;
    private LocalDateTime dataCancelamento;
    @Transient
    private SituacaoArquivoEnum situacao;
    private TipoIntegracaoEnum tipoIntegracaoAssinatura;
    private String idIntegracaoAssinatura;
    private String filaIntegracaoAssinatura;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean obrigaPosicionamentoAssinatura;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean possuiAssinaturaExterna;

    public ProcessoArquivo() {
        this.id = new ProcessoArquivoPK();
    }

    public boolean isArquivoIntegracao() {
        return StringUtils.isNotBlank((String)this.filaIntegracaoAssinatura) && Objects.nonNull(this.tipoIntegracaoAssinatura);
    }

    public Long getOrdem() {
        return (Long)ObjectUtils.defaultIfNull((Object)this.ordem, (Object)Optional.ofNullable(this.id).map(ProcessoArquivoPK::getSequencia).orElse(null));
    }

    public SituacaoArquivoEnum getSituacao() {
        if (Boolean.TRUE.equals(this.getCancelado())) {
            return SituacaoArquivoEnum.ARQUIVO_CANCELADO;
        }
        if (this.getAssinaturas().isEmpty()) {
            return SituacaoArquivoEnum.SEM_ASSINATURAS;
        }
        if (AnaliseArquivoEnum.RECUSADO.equals((Object)this.getAnalise())) {
            return SituacaoArquivoEnum.ASSINATURA_REJEITADA;
        }
        Set situacoes = this.getAssinaturas().stream().map(ProcessoArquivoAssinatura::getSituacao).collect(Collectors.toSet());
        if (situacoes.contains(AssinaturaSituacaoEnum.RECUSADO) || situacoes.contains(AssinaturaSituacaoEnum.REJEITADO)) {
            return SituacaoArquivoEnum.ASSINATURA_REJEITADA;
        }
        if (situacoes.contains(AssinaturaSituacaoEnum.PENDENTE) || situacoes.contains(AssinaturaSituacaoEnum.ASSINANDO) || situacoes.contains(null)) {
            if (situacoes.contains(AssinaturaSituacaoEnum.ASSINADO)) {
                return SituacaoArquivoEnum.ASSINATURAS_EM_ANDAMENTO;
            }
            return SituacaoArquivoEnum.AGUARDANDO_ASSINATURAS;
        }
        return SituacaoArquivoEnum.ASSINATURAS_CONCLUIDAS;
    }

    public boolean hasArquivo() {
        return this.idArquivo != null;
    }

    public void analisarArquivo(AnaliseArquivoDTO analise, String usuarioAnalise) {
        this.setAnalise(analise.getAnalise());
        this.setUsuarioAnalise(usuarioAnalise);
        this.setDataAnalise(LocalDateTime.now());
        this.setMotivoRecusa(analise.getMotivo());
    }

    public void addArquivoAssinatura(ProcessoArquivoAssinatura processoArquivoAssinatura) {
        processoArquivoAssinatura.setArquivo(this);
        this.assinaturas.add(processoArquivoAssinatura);
    }

    public Long getFluxoSequenciaAtual() {
        List processoArquivoAssinaturas = this.getAssinaturas();
        List fluxos = processoArquivoAssinaturas.stream().filter(Objects::nonNull).map(ProcessoArquivoAssinatura::getFluxoAssinanteSequencia).filter(Objects::nonNull).collect(Collectors.toList());
        if (fluxos.isEmpty()) {
            return 1L;
        }
        return (Long)Collections.max(fluxos);
    }

    public Long getQtdAssinaturas() {
        return this.assinaturas.stream().filter(ass -> AssinaturaSituacaoEnum.ASSINADO.equals((Object)ass.getSituacao())).count();
    }

    public Long getQtdAssinaturasPendentes() {
        return this.assinaturas.stream().filter(ass -> AssinaturaSituacaoEnum.PENDENTE.equals((Object)ass.getSituacao())).count();
    }

    public Boolean getPossuiAssinaturaPendenteUsuario(String usuarioId) {
        return this.assinaturas.stream().filter(a -> Objects.isNull(a.getDataAssinatura()) && AssinaturaSituacaoEnum.PENDENTE.equals((Object)a.getSituacao())).anyMatch(a -> Objects.nonNull(a.getUsuario()) && a.getUsuario().getId().equals(usuarioId));
    }

    public static Specification<ProcessoArquivo> filterSituacao(ComparisonOperator operator, String situacaoStr) {
        return ProcessoArquivoSpecificationHelper.filterSituacao((ComparisonOperator)operator, (String)situacaoStr);
    }

    public Boolean possuiAssinaturaSituacao(AssinaturaSituacaoEnum situacao) {
        return this.assinaturas.stream().anyMatch(paa -> situacao.equals((Object)paa.getSituacao()));
    }

    public boolean existeUsuarioNaListagemArquivoAssinatura(Usuario usuario) {
        return this.getAssinaturas().stream().anyMatch(assinatura -> AssinaturaSituacaoEnum.PENDENTE.equals((Object)assinatura.getSituacao()) && usuario.equals((Object)assinatura.getUsuario()));
    }

    public boolean usuarioDeUploadOuSemSolicitacoesESemIntegracao(Usuario usuario) {
        return !this.getId().getProcesso().hasFilaIntegracaoAssinatura() && (this.getUsuario().equals(usuario.getId()) || this.getAssinaturas().isEmpty());
    }

    public boolean integraFila() {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getId().getProcesso().getFilaIntegracaoAssinatura()) || this.isArquivoIntegracao();
    }

    public boolean wasLastSignature(Long idAssinatura) {
        Optional<Long> arquivoSequenciaMinima = this.getId().getProcesso().getArquivos().stream().map(a -> a.getId().getSequencia()).min(Long::compareTo);
        if (arquivoSequenciaMinima.isPresent() && this.getId().getSequencia().equals(arquivoSequenciaMinima.get())) {
            return this.getAssinaturas().stream().noneMatch(a -> Objects.isNull(a.getDataAssinatura()) && !a.getId().equals(idAssinatura));
        }
        return false;
    }

    public void verificaSeExisteSolicitacaoAssinaturaParaUsuario(Usuario usuario) {
        if (!this.existeUsuarioNaListagemArquivoAssinatura(usuario) && !this.usuarioDeUploadOuSemSolicitacoesESemIntegracao(usuario)) {
            throw new EloValidationException(String.format("N\u00e3o existe solicita\u00e7\u00e3o de assinatura para o usu\u00e1rio:%s assinar!", usuario.getNome()));
        }
    }

    @Generated
    public ProcessoArquivoPK getId() {
        return this.id;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getIdArquivo() {
        return this.idArquivo;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getUrlS3() {
        return this.urlS3;
    }

    @Generated
    public Long getIdAndamento() {
        return this.idAndamento;
    }

    @Generated
    public Long getSequenciaTramitacao() {
        return this.sequenciaTramitacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getVariaveis() {
        return this.variaveis;
    }

    @Generated
    public String getUsuarioNome() {
        return this.usuarioNome;
    }

    @Generated
    public String getUsuarioCpf() {
        return this.usuarioCpf;
    }

    @Generated
    public LocalDateTime getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public Boolean getAgrupamento() {
        return this.agrupamento;
    }

    @Generated
    public Documento getDocumento() {
        return this.documento;
    }

    @Generated
    public AnaliseArquivoEnum getAnalise() {
        return this.analise;
    }

    @Generated
    public TipoAssinaturaEnum getTipoAssinatura() {
        return this.tipoAssinatura;
    }

    @Generated
    public String getUsuarioAnalise() {
        return this.usuarioAnalise;
    }

    @Generated
    public LocalDateTime getDataAnalise() {
        return this.dataAnalise;
    }

    @Generated
    public String getMotivoRecusa() {
        return this.motivoRecusa;
    }

    @Generated
    public Boolean getSigiloExterno() {
        return this.sigiloExterno;
    }

    @Generated
    public List<ProcessoArquivoAssinatura> getAssinaturas() {
        return this.assinaturas;
    }

    @Generated
    public Boolean getSalvoPeloSistema() {
        return this.salvoPeloSistema;
    }

    @Generated
    public Boolean getCancelado() {
        return this.cancelado;
    }

    @Generated
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public LocalDateTime getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public TipoIntegracaoEnum getTipoIntegracaoAssinatura() {
        return this.tipoIntegracaoAssinatura;
    }

    @Generated
    public String getIdIntegracaoAssinatura() {
        return this.idIntegracaoAssinatura;
    }

    @Generated
    public String getFilaIntegracaoAssinatura() {
        return this.filaIntegracaoAssinatura;
    }

    @Generated
    public Boolean getObrigaPosicionamentoAssinatura() {
        return this.obrigaPosicionamentoAssinatura;
    }

    @Generated
    public Boolean getPossuiAssinaturaExterna() {
        return this.possuiAssinaturaExterna;
    }

    @Generated
    public void setId(ProcessoArquivoPK id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setIdArquivo(Long idArquivo) {
        this.idArquivo = idArquivo;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setUrlS3(String urlS3) {
        this.urlS3 = urlS3;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setIdAndamento(Long idAndamento) {
        this.idAndamento = idAndamento;
    }

    @Generated
    public void setSequenciaTramitacao(Long sequenciaTramitacao) {
        this.sequenciaTramitacao = sequenciaTramitacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setVariaveis(String variaveis) {
        this.variaveis = variaveis;
    }

    @Generated
    public void setUsuarioNome(String usuarioNome) {
        this.usuarioNome = usuarioNome;
    }

    @Generated
    public void setUsuarioCpf(String usuarioCpf) {
        this.usuarioCpf = usuarioCpf;
    }

    @Generated
    public void setDataCriacao(LocalDateTime dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setAgrupamento(Boolean agrupamento) {
        this.agrupamento = agrupamento;
    }

    @Generated
    public void setDocumento(Documento documento) {
        this.documento = documento;
    }

    @Generated
    public void setAnalise(AnaliseArquivoEnum analise) {
        this.analise = analise;
    }

    @Generated
    public void setTipoAssinatura(TipoAssinaturaEnum tipoAssinatura) {
        this.tipoAssinatura = tipoAssinatura;
    }

    @Generated
    public void setUsuarioAnalise(String usuarioAnalise) {
        this.usuarioAnalise = usuarioAnalise;
    }

    @Generated
    public void setDataAnalise(LocalDateTime dataAnalise) {
        this.dataAnalise = dataAnalise;
    }

    @Generated
    public void setMotivoRecusa(String motivoRecusa) {
        this.motivoRecusa = motivoRecusa;
    }

    @Generated
    public void setSigiloExterno(Boolean sigiloExterno) {
        this.sigiloExterno = sigiloExterno;
    }

    @Generated
    public void setAssinaturas(List<ProcessoArquivoAssinatura> assinaturas) {
        this.assinaturas = assinaturas;
    }

    @Generated
    public void setSalvoPeloSistema(Boolean salvoPeloSistema) {
        this.salvoPeloSistema = salvoPeloSistema;
    }

    @Generated
    public void setQtdAssinaturas(Long qtdAssinaturas) {
        this.qtdAssinaturas = qtdAssinaturas;
    }

    @Generated
    public void setQtdAssinaturasPendentes(Long qtdAssinaturasPendentes) {
        this.qtdAssinaturasPendentes = qtdAssinaturasPendentes;
    }

    @Generated
    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    @Generated
    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setDataCancelamento(LocalDateTime dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setTipoIntegracaoAssinatura(TipoIntegracaoEnum tipoIntegracaoAssinatura) {
        this.tipoIntegracaoAssinatura = tipoIntegracaoAssinatura;
    }

    @Generated
    public void setIdIntegracaoAssinatura(String idIntegracaoAssinatura) {
        this.idIntegracaoAssinatura = idIntegracaoAssinatura;
    }

    @Generated
    public void setFilaIntegracaoAssinatura(String filaIntegracaoAssinatura) {
        this.filaIntegracaoAssinatura = filaIntegracaoAssinatura;
    }

    @Generated
    public void setObrigaPosicionamentoAssinatura(Boolean obrigaPosicionamentoAssinatura) {
        this.obrigaPosicionamentoAssinatura = obrigaPosicionamentoAssinatura;
    }

    @Generated
    public void setPossuiAssinaturaExterna(Boolean possuiAssinaturaExterna) {
        this.possuiAssinaturaExterna = possuiAssinaturaExterna;
    }

    @Generated
    public String toString() {
        return "ProcessoArquivo(id=" + String.valueOf(this.getId()) + ", nome=" + this.getNome() + ", identificador=" + this.getIdentificador() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessoArquivo)) {
            return false;
        }
        ProcessoArquivo other = (ProcessoArquivo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProcessoArquivoPK this$id = this.getId();
        ProcessoArquivoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessoArquivo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessoArquivoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    private void setSituacao(SituacaoArquivoEnum situacao) {
        this.situacao = situacao;
    }
}

