/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamentoAlteracaoRequerente;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoAndamento;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.enums.SituacaoProcessoAndamentoEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="protocoloandamento")
public class ProcessoAndamento
implements EloEntity<Long>,
DomainEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true)
    private Long id;
    private Long numeroAndamento;
    @NotNull
    @Column(name="datahora")
    private LocalDateTime dataHora = LocalDateTime.now();
    @NotNull
    private String usuario;
    @NotNull
    @Column(name="usuarionome")
    private String usuarioNome;
    @NotAudited
    @Formula(value="(SELECT u.login1      FROM usuario u      WHERE u.login1 = usuario)")
    private String usuarioId;
    @NotAudited
    @Formula(value="(SELECT u.cpf      FROM usuario u      WHERE u.login1 = usuario)")
    private String usuarioCpf;
    @NotBlank
    private String descricao;
    @Column(name="solicitacaorequerente")
    private Boolean solicitacaoRequerente;
    @Column(name="respostarequerente")
    private String respostaRequerente;
    @Column(name="datahoraresposta")
    private LocalDateTime dataHoraResposta;
    @Enumerated(value=EnumType.STRING)
    @Column(name="moduloorigem")
    private Modulo modulo = Modulo.OXY_PROCESSOS;
    @ManyToOne
    private TipoAndamento tipoAndamento;
    private LocalDate dataInicio;
    private LocalDate dataTermino;
    private LocalDateTime dataFinalizacao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean finalizado;
    @NotNull
    @ManyToOne
    @JsonIgnore
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="numero", referencedColumnName="numero", updatable=false), @JoinColumn(name="tipo", referencedColumnName="tipo", updatable=false), @JoinColumn(name="ano", referencedColumnName="ano", updatable=false)})
    private Processo processo;
    private Long tramite;
    @Column(name="observadorext_id")
    @Type(type="uuid-char")
    private UUID observadorExtId;
    private Long diasSuspensao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="assuntoold_id")
    @JsonIgnoreProperties(value={"roteiro"})
    private Assunto assuntoOld;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="assuntonew_id")
    @JsonIgnoreProperties(value={"roteiro"})
    private Assunto assuntoNew;
    @NotAudited
    @Enumerated(value=EnumType.STRING)
    @Formula(value="(CASE WHEN finalizado = 'S' THEN 'FINALIZADO' WHEN finalizado = 'N' AND current_timestamp(6) > datatermino THEN 'VENCIDO' ELSE 'A_VENCER' END)")
    private SituacaoProcessoAndamentoEnum situacao;
    @JoinColumn
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioResponsavel;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="local", referencedColumnName="codigo"))})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Local local;
    private String resposta;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean definirSigiloso;
    @Column(name="bloqueioanexoexterno")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean bloqueioAnexoExterno;
    @Column(name="requerentesigiloso")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean requerenteSigiloso;
    @Transient
    private Situacao situacaoProcessoNew;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean tad;
    private LocalDate dataAcordo;
    private Long prazo;
    @JsonIgnore
    @MetaModelIgnore
    @OneToMany
    @JoinColumn(name="idAndamento")
    public List<ProcessoArquivo> arquivos;
    @Embedded
    private ProcessoAndamentoAlteracaoRequerente alteracaoRequerente;

    @Generated
    public ProcessoAndamento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getNumeroAndamento() {
        return this.numeroAndamento;
    }

    @Generated
    public LocalDateTime getDataHora() {
        return this.dataHora;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getUsuarioNome() {
        return this.usuarioNome;
    }

    @Generated
    public String getUsuarioId() {
        return this.usuarioId;
    }

    @Generated
    public String getUsuarioCpf() {
        return this.usuarioCpf;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getSolicitacaoRequerente() {
        return this.solicitacaoRequerente;
    }

    @Generated
    public String getRespostaRequerente() {
        return this.respostaRequerente;
    }

    @Generated
    public LocalDateTime getDataHoraResposta() {
        return this.dataHoraResposta;
    }

    @Generated
    public Modulo getModulo() {
        return this.modulo;
    }

    @Generated
    public TipoAndamento getTipoAndamento() {
        return this.tipoAndamento;
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataTermino() {
        return this.dataTermino;
    }

    @Generated
    public LocalDateTime getDataFinalizacao() {
        return this.dataFinalizacao;
    }

    @Generated
    public Boolean getFinalizado() {
        return this.finalizado;
    }

    @Generated
    public Processo getProcesso() {
        return this.processo;
    }

    @Generated
    public Long getTramite() {
        return this.tramite;
    }

    @Generated
    public UUID getObservadorExtId() {
        return this.observadorExtId;
    }

    @Generated
    public Long getDiasSuspensao() {
        return this.diasSuspensao;
    }

    @Generated
    public Assunto getAssuntoOld() {
        return this.assuntoOld;
    }

    @Generated
    public Assunto getAssuntoNew() {
        return this.assuntoNew;
    }

    @Generated
    public SituacaoProcessoAndamentoEnum getSituacao() {
        return this.situacao;
    }

    @Generated
    public Usuario getUsuarioResponsavel() {
        return this.usuarioResponsavel;
    }

    @Generated
    public Local getLocal() {
        return this.local;
    }

    @Generated
    public String getResposta() {
        return this.resposta;
    }

    @Generated
    public Boolean getDefinirSigiloso() {
        return this.definirSigiloso;
    }

    @Generated
    public Boolean getBloqueioAnexoExterno() {
        return this.bloqueioAnexoExterno;
    }

    @Generated
    public Boolean getRequerenteSigiloso() {
        return this.requerenteSigiloso;
    }

    @Generated
    public Situacao getSituacaoProcessoNew() {
        return this.situacaoProcessoNew;
    }

    @Generated
    public Boolean getTad() {
        return this.tad;
    }

    @Generated
    public LocalDate getDataAcordo() {
        return this.dataAcordo;
    }

    @Generated
    public Long getPrazo() {
        return this.prazo;
    }

    @Generated
    public List<ProcessoArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public ProcessoAndamentoAlteracaoRequerente getAlteracaoRequerente() {
        return this.alteracaoRequerente;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNumeroAndamento(Long numeroAndamento) {
        this.numeroAndamento = numeroAndamento;
    }

    @Generated
    public void setDataHora(LocalDateTime dataHora) {
        this.dataHora = dataHora;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioNome(String usuarioNome) {
        this.usuarioNome = usuarioNome;
    }

    @Generated
    public void setUsuarioId(String usuarioId) {
        this.usuarioId = usuarioId;
    }

    @Generated
    public void setUsuarioCpf(String usuarioCpf) {
        this.usuarioCpf = usuarioCpf;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setSolicitacaoRequerente(Boolean solicitacaoRequerente) {
        this.solicitacaoRequerente = solicitacaoRequerente;
    }

    @Generated
    public void setRespostaRequerente(String respostaRequerente) {
        this.respostaRequerente = respostaRequerente;
    }

    @Generated
    public void setDataHoraResposta(LocalDateTime dataHoraResposta) {
        this.dataHoraResposta = dataHoraResposta;
    }

    @Generated
    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    @Generated
    public void setTipoAndamento(TipoAndamento tipoAndamento) {
        this.tipoAndamento = tipoAndamento;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataTermino(LocalDate dataTermino) {
        this.dataTermino = dataTermino;
    }

    @Generated
    public void setDataFinalizacao(LocalDateTime dataFinalizacao) {
        this.dataFinalizacao = dataFinalizacao;
    }

    @Generated
    public void setFinalizado(Boolean finalizado) {
        this.finalizado = finalizado;
    }

    @JsonIgnore
    @Generated
    public void setProcesso(Processo processo) {
        this.processo = processo;
    }

    @Generated
    public void setTramite(Long tramite) {
        this.tramite = tramite;
    }

    @Generated
    public void setObservadorExtId(UUID observadorExtId) {
        this.observadorExtId = observadorExtId;
    }

    @Generated
    public void setDiasSuspensao(Long diasSuspensao) {
        this.diasSuspensao = diasSuspensao;
    }

    @JsonIgnoreProperties(value={"roteiro"})
    @Generated
    public void setAssuntoOld(Assunto assuntoOld) {
        this.assuntoOld = assuntoOld;
    }

    @JsonIgnoreProperties(value={"roteiro"})
    @Generated
    public void setAssuntoNew(Assunto assuntoNew) {
        this.assuntoNew = assuntoNew;
    }

    @Generated
    public void setSituacao(SituacaoProcessoAndamentoEnum situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setUsuarioResponsavel(Usuario usuarioResponsavel) {
        this.usuarioResponsavel = usuarioResponsavel;
    }

    @Generated
    public void setLocal(Local local) {
        this.local = local;
    }

    @Generated
    public void setResposta(String resposta) {
        this.resposta = resposta;
    }

    @Generated
    public void setDefinirSigiloso(Boolean definirSigiloso) {
        this.definirSigiloso = definirSigiloso;
    }

    @Generated
    public void setBloqueioAnexoExterno(Boolean bloqueioAnexoExterno) {
        this.bloqueioAnexoExterno = bloqueioAnexoExterno;
    }

    @Generated
    public void setRequerenteSigiloso(Boolean requerenteSigiloso) {
        this.requerenteSigiloso = requerenteSigiloso;
    }

    @Generated
    public void setSituacaoProcessoNew(Situacao situacaoProcessoNew) {
        this.situacaoProcessoNew = situacaoProcessoNew;
    }

    @Generated
    public void setTad(Boolean tad) {
        this.tad = tad;
    }

    @Generated
    public void setDataAcordo(LocalDate dataAcordo) {
        this.dataAcordo = dataAcordo;
    }

    @Generated
    public void setPrazo(Long prazo) {
        this.prazo = prazo;
    }

    @JsonIgnore
    @Generated
    public void setArquivos(List<ProcessoArquivo> arquivos) {
        this.arquivos = arquivos;
    }

    @Generated
    public void setAlteracaoRequerente(ProcessoAndamentoAlteracaoRequerente alteracaoRequerente) {
        this.alteracaoRequerente = alteracaoRequerente;
    }

    @Generated
    public String toString() {
        return "ProcessoAndamento(id=" + this.getId() + ", numeroAndamento=" + this.getNumeroAndamento() + ", dataHora=" + String.valueOf(this.getDataHora()) + ", usuario=" + this.getUsuario() + ", usuarioNome=" + this.getUsuarioNome() + ", usuarioId=" + this.getUsuarioId() + ", usuarioCpf=" + this.getUsuarioCpf() + ", descricao=" + this.getDescricao() + ", solicitacaoRequerente=" + this.getSolicitacaoRequerente() + ", respostaRequerente=" + this.getRespostaRequerente() + ", dataHoraResposta=" + String.valueOf(this.getDataHoraResposta()) + ", modulo=" + String.valueOf(this.getModulo()) + ", tipoAndamento=" + String.valueOf(this.getTipoAndamento()) + ", dataInicio=" + String.valueOf(this.getDataInicio()) + ", dataTermino=" + String.valueOf(this.getDataTermino()) + ", dataFinalizacao=" + String.valueOf(this.getDataFinalizacao()) + ", finalizado=" + this.getFinalizado() + ", processo=" + String.valueOf(this.getProcesso()) + ", tramite=" + this.getTramite() + ", observadorExtId=" + String.valueOf(this.getObservadorExtId()) + ", diasSuspensao=" + this.getDiasSuspensao() + ", assuntoOld=" + String.valueOf(this.getAssuntoOld()) + ", assuntoNew=" + String.valueOf(this.getAssuntoNew()) + ", situacao=" + String.valueOf(this.getSituacao()) + ", usuarioResponsavel=" + String.valueOf(this.getUsuarioResponsavel()) + ", local=" + String.valueOf(this.getLocal()) + ", resposta=" + this.getResposta() + ", definirSigiloso=" + this.getDefinirSigiloso() + ", bloqueioAnexoExterno=" + this.getBloqueioAnexoExterno() + ", requerenteSigiloso=" + this.getRequerenteSigiloso() + ", situacaoProcessoNew=" + String.valueOf(this.getSituacaoProcessoNew()) + ", tad=" + this.getTad() + ", dataAcordo=" + String.valueOf(this.getDataAcordo()) + ", prazo=" + this.getPrazo() + ", arquivos=" + String.valueOf(this.getArquivos()) + ", alteracaoRequerente=" + String.valueOf(this.getAlteracaoRequerente()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessoAndamento)) {
            return false;
        }
        ProcessoAndamento other = (ProcessoAndamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessoAndamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

