/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.rsql.annotations.RsqlUseUnaccent;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Bairro;
import br.com.elotech.protocolo.domain.Escolaridade;
import br.com.elotech.protocolo.domain.GrauSigilo;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.ORCUnidade;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.domain.ProcessoAnexo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoInteressado;
import br.com.elotech.protocolo.domain.ProcessoObservador;
import br.com.elotech.protocolo.domain.ProcessoObservadorExterno;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.RoteiroLocal;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Unidade;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.AssinaturaIntegracaoResponseDTO;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.NotaEnum;
import br.com.elotech.protocolo.dto.PessoaSexo;
import br.com.elotech.protocolo.dto.PkProcessoDTO;
import br.com.elotech.protocolo.dto.Prioridade;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import br.com.elotech.protocolo.dto.converter.NotaEnumConverter;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import br.com.elotech.protocolo.enums.StatusAgrupamento;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import br.com.elotech.protocolo.enums.TipoOuvidoriaEnum;
import br.com.elotech.protocolo.exception.AvaliacaoProcessoNaoPermitida;
import br.com.elotech.protocolo.mp.domain.DadosProcessoMP;
import br.com.elotech.protocolo.specs.ProcessoSpecificationHelper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;

@Entity
@Audited
@Table(name="processos")
@Filter(name="byEntidade")
@FilterDef(name="byEntidade", defaultCondition="(entidade = :idEntidade OR entidadeLocalDestino = :idEntidade)", parameters={@ParamDef(name="idEntidade", type="integer")})
public class Processo
implements EloEntity<ProcessoPK>,
DomainEntity<ProcessoPK> {
    @EmbeddedId
    private ProcessoPK id = new ProcessoPK();
    private String senhaInternet;
    @ManyToOne
    @NotAudited
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="unidade", referencedColumnName="codigo"))})
    @NotFound(action=NotFoundAction.IGNORE)
    private Unidade unidade;
    @ManyToOne
    @JoinColumn(name="codpessoa")
    @NotFound(action=NotFoundAction.IGNORE)
    private Pessoa pessoa;
    @ManyToOne
    @NotAudited
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumn(name="usuario_responsavel_tramite")
    private Usuario usuarioResponsavelTramite;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="dadosprocessomp_id")
    private DadosProcessoMP processoMp;
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processo", orphanRemoval=true)
    private List<ProcessoInteressado> interessados = new ArrayList();
    @ManyToOne
    @JoinColumn(name="bairro")
    @NotFound(action=NotFoundAction.IGNORE)
    private Bairro bairro;
    private LocalDate dataProcesso = LocalDate.now();
    @ManyToOne
    private Situacao situacao;
    @ManyToOne
    @JoinColumn(name="codassunto")
    @NotFound(action=NotFoundAction.IGNORE)
    private Assunto assunto;
    @RsqlUseUnaccent
    @Length(max=1000)
    @Column(name="assunto")
    private @Length(max=1000) String complementoAssunto;
    @NotNull
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidadeLocalOrigem", referencedColumnName="entidade"), @JoinColumn(name="localOrigem", referencedColumnName="codigo")})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Local localOrigem;
    private LocalDate dataOrigem;
    private LocalTime horaOrigem;
    @ManyToOne
    @Caption(value="Escolaridade")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Escolaridade escolaridade;
    @NotNull
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidadeLocalDestino", referencedColumnName="entidade"), @JoinColumn(name="localDestino", referencedColumnName="codigo")})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Local localDestino;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidadeLocalAtual", referencedColumnName="entidade"), @JoinColumn(name="localAtual", referencedColumnName="codigo")})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Local localAtual;
    private LocalDate dataDestino;
    private LocalTime horaDestino;
    @RsqlUseUnaccent
    @Length(max=4000)
    private @Length(max=4000) String digitacao;
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.processo", fetch=FetchType.LAZY)
    @NotAudited
    private List<Tramite> tramites = new ArrayList();
    @OneToMany(mappedBy="processo", cascade={CascadeType.ALL})
    @NotAudited
    private List<ProcessoAnexo> processosAnexos = new ArrayList();
    @Column(name="status")
    private Funcao funcao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean exigencia;
    @RsqlUseUnaccent
    private String motivoExigencia;
    @Column(name="USUARIOREG")
    private String usuarioRegistro;
    private String usuarioAlteracao;
    @Column(name="DATAREG")
    private LocalDateTime dataRegistro = LocalDateTime.now();
    @RsqlUseUnaccent
    @Column(name="OUTROSDADOS")
    @Length(max=4000)
    private @Length(max=4000) String observacao;
    @Column(name="SOLICITACAO_JSON")
    private String solicitacaoJson;
    @Length(max=30)
    private @Length(max=30) String zona;
    @Length(max=30)
    private @Length(max=30) String quadra;
    @Length(max=30)
    private @Length(max=30) String data;
    @Length(max=30)
    private @Length(max=30) String cadastro = "";
    private Long numeroLicitacao;
    private Long exercicioLicitacao;
    @Column(name="numeroantigo")
    private String numeroAntigo;
    private String modalidadeLicitacao = "";
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="sigiloso")
    private Boolean sigiloso = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean fechado = Boolean.FALSE;
    @Valid
    @Caption(value="Arquivos")
    @OrderBy(value="ordem desc")
    @OneToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE}, orphanRemoval=true, mappedBy="id.processo")
    @NotAudited
    private List<ProcessoArquivo> arquivos = new ArrayList();
    @NotAudited
    @OrderBy(value="datahora desc")
    @OneToMany(orphanRemoval=true, mappedBy="processo")
    private List<ProcessoAndamento> andamentos = new ArrayList();
    @Column(name="PROCESSO_REFERENCIA")
    @Length(max=30)
    private @Length(max=30) String processoReferencia = "";
    @ManyToOne
    @JoinColumn(name="grausigilo")
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private GrauSigilo grauSigilo;
    @Caption(value="Externo")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean externo = Boolean.FALSE;
    private String uuid;
    @Column(name="idboleto")
    private Long idBoleto;
    @Column(name="idprocessotaxa")
    private Long idProcessoTaxa;
    @Column(name="cidadeaux")
    @Length(max=40)
    private @Length(max=40) String cidadeAux;
    @Length(max=2)
    private @Length(max=2) String uf;
    @Length(max=9)
    private @Length(max=9) String cep;
    @Length(max=100)
    private @Length(max=100) String endereco;
    @Length(max=10)
    @Column(name="numeroendereco")
    private @Length(max=10) String numeroEndereco;
    @Length(max=50)
    private @Length(max=50) String complemento;
    @Length(max=100)
    @Column(name="bairroaux")
    private @Length(max=100) String bairroAux;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="boletopago")
    private Boolean boletoPago = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="processoavaliado")
    private Boolean processoAvaliado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean paralisado = Boolean.FALSE;
    @Column(name="usuarioavaliador")
    @Length(max=60)
    private @Length(max=60) String usuarioAvaliador;
    @Column(name="dataavaliacao")
    private LocalDateTime dataAvaliacao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ouvidoria = Boolean.FALSE;
    @Column(name="possuiTaxa")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean possuiTaxa;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ouvidoriaAnonima = Boolean.FALSE;
    private String email;
    private String celular;
    @Column(name="ultimaatualizacao")
    private LocalDateTime ultimaAtualizacao;
    @Enumerated(value=EnumType.STRING)
    private PessoaSexo sexo;
    @Column(name="prioridade")
    @Enumerated(value=EnumType.STRING)
    private Prioridade prioridade;
    @Column(name="nota")
    @Convert(converter=NotaEnumConverter.class)
    private NotaEnum nota;
    @RsqlUseUnaccent
    @Length(max=4000)
    @Column(name="notaobservacao")
    private @Length(max=4000) String notaObservacao;
    @Column(name="previsaoconclusao")
    private LocalDate previsaoConclusao;
    @Transient
    private boolean permiteAcessoUsuarioLogado = Boolean.TRUE;
    @NotAudited
    @Formula(value="statusagrupamento")
    @Enumerated(value=EnumType.STRING)
    private StatusAgrupamento statusAgrupamento;
    @Column(name="processofisico")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean processoFisico = Boolean.FALSE;
    @Column(name="tipointegracaoassinatura")
    private TipoIntegracaoEnum tipoIntegracaoAssinatura;
    @Column(name="idintegracaoassinatura")
    private String idIntegracaoAssinatura;
    @Column(name="filaintegracaoassinatura")
    private String filaIntegracaoAssinatura;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="orc_unidade_id")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private ORCUnidade unidadeOrcamentaria;
    private LocalDate prazoDesclassificacao;
    @RsqlUseUnaccent
    @Length(max=500)
    private @Length(max=500) String fundamentacaoLegal;
    @Column(name="requerimentotributos")
    private Long requerimentoTributos;
    @Column(name="tramitaentreentidades")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean tramitaEntreEntidades = Boolean.FALSE;
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processo", orphanRemoval=true)
    private List<ProcessoObservador> observadores = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processo", orphanRemoval=true)
    private List<ProcessoObservadorExterno> observadoresExternos = new ArrayList();
    @Transient
    @NotAudited
    private Boolean numeroJaExistente = Boolean.FALSE;
    @Column(name="tipoouvidoria")
    @Enumerated(value=EnumType.STRING)
    private TipoOuvidoriaEnum tipoOuvidoria;
    @Column
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean roteiro = Boolean.FALSE;
    @Column(name="bloqueioanexoexterno")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean bloqueioAnexoExterno = Boolean.FALSE;
    @RsqlUseUnaccent
    @Column(name="denunciado")
    @Length(max=200)
    private @Length(max=200) String denunciado;

    public List<ProcessoObservadorExterno> getObservadoresExternos() {
        return this.observadoresExternos;
    }

    public void setObservadoresExternos(List<ProcessoObservadorExterno> observadoresExternos) {
        this.observadoresExternos = observadoresExternos;
    }

    public boolean isNew() {
        return this.id == null || this.id.getNumero() == null || Boolean.TRUE.equals(this.numeroJaExistente);
    }

    public Tramite addTramite(Tramite tramite) {
        this.getTramites().add(tramite);
        return tramite;
    }

    public ProcessoPK getId() {
        return this.id;
    }

    public void setId(ProcessoPK id) {
        this.id = id;
    }

    public Long getUltimaSequenciaTramite() {
        return this.getTramites().stream().mapToLong(t -> t.getId().getSequencia()).max().orElse(0L);
    }

    public Processo marcarRecebido() {
        return this.alterarStatusFuncao(Funcao.RECEBIDO);
    }

    public Boolean isRecebido() {
        return Funcao.RECEBIDO.equals((Object)this.funcao);
    }

    public Processo marcarEncaminhado() {
        return this.alterarStatusFuncao(Funcao.ENCAMINHADO);
    }

    public Boolean isEncaminhado() {
        return Funcao.ENCAMINHADO.equals((Object)this.funcao);
    }

    public Boolean isArquivado() {
        return Funcao.ARQUIVADO.equals((Object)this.funcao);
    }

    public Processo marcarArquivado() {
        return this.alterarStatusFuncao(Funcao.ARQUIVADO);
    }

    private Processo alterarStatusFuncao(Funcao funcao) {
        this.setFuncao(funcao);
        return this;
    }

    public String getDataProcessoAsString() {
        return Optional.ofNullable(this.getDataProcesso()).map(DateUtils::formatDateBr).orElse("");
    }

    public Long getExercicioLicitacao() {
        return this.exercicioLicitacao;
    }

    public Tramite getUltimoTramiteByFuncao(Funcao funcao) {
        if (this.getTramites().isEmpty()) {
            throw new IllegalStateException("O processo n\u00e3o possui nenhum tr\u00e2mite");
        }
        return this.getTramites().stream().filter(t -> funcao.equals((Object)t.getFuncao())).sorted(Comparator.comparing(Tramite::getSequencia).reversed()).findFirst().orElseThrow(() -> new IllegalStateException("N\u00e3o foi poss\u00edvel encontrar nenhum tr\u00e2mite de encaminhamento para o processo"));
    }

    public Optional<Tramite> findBySequencia(Long sequencia) {
        return this.getTramites().stream().filter(t -> t.getId().getSequencia().equals(sequencia)).findFirst();
    }

    public String gerarSenha() {
        Random random = new Random();
        Integer min = 21311;
        Integer max = 88888;
        Integer novaSenha = random.nextInt(max - min + 1) + min;
        this.setSenhaInternet(novaSenha.toString());
        return novaSenha.toString();
    }

    public Optional<Tramite> getUltimoTramite() {
        return this.findBySequencia(this.getUltimaSequenciaTramite());
    }

    public Processo atualizarDatasOrigemDestino() {
        this.setDataOrigem(this.getDataProcesso());
        this.setDataDestino(this.getDataProcesso());
        this.setHoraOrigem(LocalTime.now());
        this.setHoraDestino(LocalTime.now());
        return this;
    }

    public Boolean isOuvidoriaAnonima() {
        return Boolean.TRUE.equals(this.getOuvidoria()) && Boolean.TRUE.equals(this.getOuvidoriaAnonima());
    }

    public Boolean possuiContato() {
        return Objects.nonNull(this.getPessoa()) && Objects.nonNull(this.getPessoa().getContato());
    }

    public Processo tramitarAbertura() {
        Tramite.novaAbertura((Processo)this).comLocal(this.getLocalOrigem()).comUsuario(this.getUsuarioRegistro()).criar(this.getDataProcesso());
        Tramite.novoEncaminhamento((Processo)this).comLocal(this.getLocalDestino()).comUsuario(this.getUsuarioRegistro()).comUsuarioResponsavelTramite(this.getUsuarioResponsavelLocalDto()).criar(this.getDataProcesso());
        this.setLocalAtual(this.getLocalOrigem());
        return this;
    }

    public Tramite removerTramite(Tramite tramite) {
        this.getTramites().remove(tramite);
        return tramite;
    }

    public Boolean isMesmoLocal(Processo processoAnexar) {
        return this.getLocalDestino().getId().equals((Object)processoAnexar.getLocalDestino().getId());
    }

    public Boolean isMesmoAssunto(Processo processoAnexar) {
        return this.getAssunto().getId().equals(processoAnexar.getAssunto().getId());
    }

    public Boolean isMesmoRequerente(Processo processoAnexar) {
        return this.getPessoa().getId().equals(processoAnexar.getPessoa().getId());
    }

    public Boolean isMesmoCadastro(Processo processoAnexar) {
        return this.getCadastro().equals(processoAnexar.getCadastro());
    }

    public Boolean isMesmaZona(Processo processoAnexar) {
        return Objects.isNull(this.getZona()) && Objects.isNull(processoAnexar.getZona()) || this.getZona().equals(processoAnexar.getZona());
    }

    public Boolean isMesmaQuadra(Processo processoAnexar) {
        return Objects.isNull(this.getQuadra()) && Objects.isNull(processoAnexar.getQuadra()) || this.getQuadra().equals(processoAnexar.getQuadra());
    }

    public Boolean isMesmoLote(Processo processoAnexar) {
        return Objects.isNull(this.getData()) && Objects.isNull(processoAnexar.getData()) || this.getData().equals(processoAnexar.getData());
    }

    public List<ProcessoAnexo> getProcessosAnexos() {
        if (this.processosAnexos == null) {
            return new ArrayList<ProcessoAnexo>();
        }
        return this.processosAnexos;
    }

    public Long getProximaSequenciaAnexo() {
        return this.getProcessosAnexos().stream().mapToLong(p -> p.getId().getSequencia()).sorted().max().orElse(0L) + 1L;
    }

    public String getProcessoReferenciadoAsText() {
        return String.format("%d-%d-%d/%d", this.getId().getEntidade().getId(), this.getId().getTipo().getId(), this.getId().getNumero(), this.getId().getAno());
    }

    public Processo referenciar(Processo processoReferenciar) {
        this.setProcessoReferencia(processoReferenciar.getProcessoReferenciadoAsText());
        return this;
    }

    public Processo removerReferencia() {
        this.setProcessoReferencia("");
        return this;
    }

    public String getSenhaInternet() {
        return this.senhaInternet;
    }

    public void setSenhaInternet(String senhaInternet) {
        this.senhaInternet = senhaInternet;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidade = unidade;
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public LocalDate getDataProcesso() {
        return this.dataProcesso;
    }

    public void setDataProcesso(LocalDate dataProcesso) {
        this.dataProcesso = dataProcesso;
    }

    public Situacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(Situacao situacao) {
        this.situacao = situacao;
    }

    public Assunto getAssunto() {
        return this.assunto;
    }

    public void setAssunto(Assunto assunto) {
        this.assunto = assunto;
    }

    public String getComplementoAssunto() {
        return this.complementoAssunto;
    }

    public void setComplementoAssunto(String complementoAssunto) {
        this.complementoAssunto = complementoAssunto;
    }

    public Local getLocalOrigem() {
        return this.localOrigem;
    }

    public void setLocalOrigem(Local localOrigem) {
        this.localOrigem = localOrigem;
    }

    public LocalDate getDataOrigem() {
        return this.dataOrigem;
    }

    public void setDataOrigem(LocalDate dataOrigem) {
        this.dataOrigem = dataOrigem;
    }

    public LocalTime getHoraOrigem() {
        return this.horaOrigem;
    }

    public void setHoraOrigem(LocalTime horaOrigem) {
        this.horaOrigem = horaOrigem;
    }

    public Local getLocalDestino() {
        return this.localDestino;
    }

    public void setLocalDestino(Local localDestino) {
        this.localDestino = localDestino;
    }

    public Local getLocalAtual() {
        return this.localAtual;
    }

    public void setLocalAtual(Local localAtual) {
        this.localAtual = localAtual;
    }

    public LocalDate getDataDestino() {
        return this.dataDestino;
    }

    public void setDataDestino(LocalDate dataDestino) {
        this.dataDestino = dataDestino;
    }

    public LocalTime getHoraDestino() {
        return this.horaDestino;
    }

    public void setHoraDestino(LocalTime horaDestino) {
        this.horaDestino = horaDestino;
    }

    public String getDigitacao() {
        return this.digitacao;
    }

    public void setDigitacao(String digitacao) {
        this.digitacao = digitacao;
    }

    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    public void setNumeroAntigo(String numeroAntigo) {
        this.numeroAntigo = numeroAntigo;
    }

    public String getNumeroAntigo() {
        return this.numeroAntigo;
    }

    public Boolean getExigencia() {
        return this.exigencia;
    }

    public void setExigencia(Boolean exigencia) {
        this.exigencia = exigencia;
    }

    public String getMotivoExigencia() {
        return this.motivoExigencia;
    }

    public void setMotivoExigencia(String motivoExigencia) {
        this.motivoExigencia = motivoExigencia;
    }

    public String getUsuarioRegistro() {
        return this.usuarioRegistro;
    }

    public void setUsuarioRegistro(String usuarioRegistro) {
        this.usuarioRegistro = usuarioRegistro;
    }

    public LocalDateTime getDataRegistro() {
        return this.dataRegistro;
    }

    public void setDataRegistro(LocalDateTime dataRegistro) {
        this.dataRegistro = dataRegistro;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getZona() {
        return this.zona;
    }

    public void setZona(String zona) {
        this.zona = zona;
    }

    public String getQuadra() {
        return this.quadra;
    }

    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    public String getCadastro() {
        return this.cadastro;
    }

    public void setCadastro(String cadastro) {
        this.cadastro = cadastro;
    }

    public Long getNumeroLicitacao() {
        return this.numeroLicitacao;
    }

    public void setNumeroLicitacao(Long numeroLicitacao) {
        this.numeroLicitacao = numeroLicitacao;
    }

    public String getModalidadeLicitacao() {
        return this.modalidadeLicitacao;
    }

    public void setModalidadeLicitacao(String modalidadeLicitacao) {
        this.modalidadeLicitacao = modalidadeLicitacao;
    }

    public String getProcessoReferencia() {
        return Optional.ofNullable(this.processoReferencia).orElse("");
    }

    public void setProcessoReferencia(String processoReferencia) {
        this.processoReferencia = processoReferencia;
    }

    public void setProcessosAnexos(List<ProcessoAnexo> processosAnexos) {
        this.processosAnexos = processosAnexos;
    }

    public void setExercicioLicitacao(Long exercicioLicitacao) {
        this.exercicioLicitacao = exercicioLicitacao;
    }

    public void setTramites(List<Tramite> tramites) {
        this.tramites = tramites;
    }

    public List<Tramite> getTramites() {
        return Optional.ofNullable(this.tramites).orElse(Lists.newArrayList());
    }

    public List<ProcessoArquivo> getArquivos() {
        return this.arquivos;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Bairro getBairro() {
        return this.bairro;
    }

    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    public Long getProximaSequenciaArquivo() {
        return (long)this.arquivos.size() + 1L;
    }

    public Boolean getSigiloso() {
        return this.sigiloso;
    }

    public void setSigiloso(Boolean sigiloso) {
        this.sigiloso = sigiloso;
    }

    public GrauSigilo getGrauSigilo() {
        return this.grauSigilo;
    }

    public void setGrauSigilo(GrauSigilo grauSigilo) {
        this.grauSigilo = grauSigilo;
    }

    public Boolean getExterno() {
        return BooleanUtils.toBoolean((Boolean)this.externo);
    }

    public void setExterno(Boolean externo) {
        this.externo = externo;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Long getIdBoleto() {
        return this.idBoleto;
    }

    public void setIdBoleto(Long idBoleto) {
        this.idBoleto = idBoleto;
    }

    public Long getIdProcessoTaxa() {
        return this.idProcessoTaxa;
    }

    public void setIdProcessoTaxa(Long idProcessoTaxa) {
        this.idProcessoTaxa = idProcessoTaxa;
    }

    public String getCidadeAux() {
        return this.cidadeAux;
    }

    public void setCidadeAux(String cidadeAux) {
        this.cidadeAux = cidadeAux;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public String getNumeroEndereco() {
        return this.numeroEndereco;
    }

    public void setNumeroEndereco(String numeroEndereco) {
        this.numeroEndereco = numeroEndereco;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getBairroAux() {
        return this.bairroAux;
    }

    public void setBairroAux(String bairroAux) {
        this.bairroAux = bairroAux;
    }

    public Boolean getBoletoPago() {
        return this.boletoPago;
    }

    public void setBoletoPago(Boolean boletoPago) {
        this.boletoPago = boletoPago;
    }

    public Boolean getProcessoAvaliado() {
        return this.processoAvaliado;
    }

    public void setProcessoAvaliado(Boolean processoAvaliado) {
        this.processoAvaliado = processoAvaliado;
    }

    public String getUsuarioAvaliador() {
        return this.usuarioAvaliador;
    }

    public void setUsuarioAvaliador(String usuarioAvaliador) {
        this.usuarioAvaliador = usuarioAvaliador;
    }

    public LocalDateTime getDataAvaliacao() {
        return this.dataAvaliacao;
    }

    public void setDataAvaliacao(LocalDateTime dataAvaliacao) {
        this.dataAvaliacao = dataAvaliacao;
    }

    public Boolean podeSerArquivado() {
        Integer quantidadeLocaisRoteiro = this.getAssunto().getRoteiro().getRoteiroLocal().size();
        Long quantidadeTramitesControladosPorRoteiro = this.getTramites().stream().filter(tramite -> !Funcao.ABERTO.equals((Object)tramite.getFuncao()) && !Funcao.ARQUIVADO.equals((Object)tramite.getFuncao())).count();
        return (long)quantidadeLocaisRoteiro.intValue() >= quantidadeTramitesControladosPorRoteiro / 2L;
    }

    public Boolean podeSerTramitado() {
        Integer quantidadeLocaisRoteiro = this.getAssunto().getRoteiro().getRoteiroLocal().size();
        Long quantidadeTramitesControladosPorRoteiro = this.getTramites().stream().filter(tramite -> !Funcao.ABERTO.equals((Object)tramite.getFuncao()) && !Funcao.ARQUIVADO.equals((Object)tramite.getFuncao())).count();
        return (long)quantidadeLocaisRoteiro.intValue() > quantidadeTramitesControladosPorRoteiro / 2L;
    }

    public Integer buscaIndiceProximoRoteiro() {
        long numeroTramites = this.getTramites().stream().sorted(Comparator.comparingLong(Tramite::getSequencia)).filter(tramite -> !Funcao.ABERTO.equals((Object)tramite.getFuncao()) && !Funcao.ARQUIVADO.equals((Object)tramite.getFuncao())).count();
        double indice = (double)numeroTramites / 2.0;
        if (indice != (double)((int)indice)) {
            indice += 0.5;
        }
        return (int)indice;
    }

    public static Boolean possuiProcessoComControleDeTramitacao(List<Processo> processos) {
        return processos.stream().anyMatch(processo -> processo.getAssunto().getControlaTramitacao());
    }

    public Boolean isAvaliado() {
        return BooleanUtils.isTrue((Boolean)this.getProcessoAvaliado()) && Objects.nonNull(this.getUsuarioAvaliador()) && Objects.nonNull(this.getDataAvaliacao());
    }

    public Processo avaliar(String usuarioAvaliador) {
        if (this.isAvaliado().booleanValue()) {
            throw new AvaliacaoProcessoNaoPermitida("N\u00e3o \u00e9 poss\u00edvel avaliar um processo j\u00e1 avaliado");
        }
        if (!this.getExterno().booleanValue()) {
            throw new AvaliacaoProcessoNaoPermitida("N\u00e3o \u00e9 poss\u00edvel avaliar um processo interno");
        }
        this.setProcessoAvaliado(Boolean.TRUE);
        this.setUsuarioAvaliador(usuarioAvaliador);
        this.setDataAvaliacao(LocalDateTime.now());
        return this;
    }

    public Boolean isAberto() {
        return this.getTramites().size() == 2 && Funcao.ENCAMINHADO.equals((Object)this.getFuncao());
    }

    public Boolean getOuvidoria() {
        return this.ouvidoria;
    }

    public void setOuvidoria(Boolean ouvidoria) {
        this.ouvidoria = ouvidoria;
    }

    public Boolean getOuvidoriaAnonima() {
        return this.ouvidoriaAnonima;
    }

    public void setOuvidoriaAnonima(Boolean ouvidoriaAnonima) {
        this.ouvidoriaAnonima = ouvidoriaAnonima;
    }

    public LocalDateTime getUltimaAtualizacao() {
        return this.ultimaAtualizacao;
    }

    public void setUltimaAtualizacao(LocalDateTime ultimaAtualizacao) {
        this.ultimaAtualizacao = ultimaAtualizacao;
    }

    public void atualizarTramites() {
        List lstTramites = this.getTramites().stream().sorted(Comparator.comparing(reg -> reg.getSequencia())).collect(Collectors.toList());
        ((Tramite)lstTramites.get(0)).setLocal(this.localOrigem);
        ((Tramite)lstTramites.get(1)).setLocal(this.localDestino);
    }

    public Optional<ProcessoArquivo> buscarArquivoPorIdentificador(String identificadorArquivo) {
        return this.getArquivos().stream().filter(arquivo -> arquivo.getIdentificador().equals(identificadorArquivo)).findFirst();
    }

    public Long getQuantidadeDiasParadoTramite(LocalDate dataAtual) {
        return ChronoUnit.DAYS.between(((Tramite)this.getUltimoTramite().orElseThrow(() -> new IllegalArgumentException("N\u00e3o existe tramite neste processo."))).getData(), dataAtual);
    }

    public Optional<RoteiroLocal> getRoteiroAtualPorLocal(Local localAtual) {
        return this.getAssunto().getRoteiro().getRoteiroLocal().stream().filter(roteiroLocal -> roteiroLocal.getLocal() != null && roteiroLocal.getLocal().getId() != null && localAtual != null && roteiroLocal.getLocal().getId().equals((Object)localAtual.getId())).findFirst();
    }

    public void validarQuantidadeDiasParadoLocalTramite() {
        if (Boolean.TRUE.equals(this.getProcessoVencido())) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Processo n\u00e3o pode ser encaminhado pois excedeu o limite de dias parado no local.");
        }
    }

    public Boolean getProcessoVencido() {
        Optional roteiroAtualOptional;
        if (this.possuiAssuntoComRoteiro() && (roteiroAtualOptional = this.getRoteiroAtualPorLocal(this.getLocalAtual())).isPresent()) {
            Long quantidadeDiasParadoTramite = this.getQuantidadeDiasParadoTramite(LocalDate.now());
            return quantidadeDiasParadoTramite > ((RoteiroLocal)roteiroAtualOptional.get()).getQuantidadeDias();
        }
        return false;
    }

    public boolean possuiAssuntoComRoteiro() {
        return !this.getTramites().isEmpty() && this.getAssunto() != null && this.getAssunto().getRoteiro() != null && !this.getAssunto().getRoteiro().getRoteiroLocal().isEmpty();
    }

    public List<ProcessoInteressado> getInteressados() {
        return this.interessados;
    }

    public void setInteressados(List<ProcessoInteressado> interessados) {
        this.interessados = interessados;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public Boolean getParalisado() {
        return this.paralisado;
    }

    public void setParalisado(Boolean paralisado) {
        this.paralisado = paralisado;
    }

    public void ativar() {
        this.setParalisado(Boolean.valueOf(false));
    }

    public void setPermiteAcessoUsuarioLogado(boolean permiteAcessoUsuarioLogado) {
        this.permiteAcessoUsuarioLogado = permiteAcessoUsuarioLogado;
    }

    public boolean getPermiteAcessoUsuarioLogado() {
        return this.permiteAcessoUsuarioLogado;
    }

    public UsuarioPermissaoLocalDTO getUsuarioResponsavelLocalDto() {
        if (this.usuarioResponsavelTramite != null) {
            return this.usuarioResponsavelTramite.toUsuarioPermissaoLocalDto();
        }
        return null;
    }

    public Usuario getUsuarioResponsavelTramite() {
        return this.usuarioResponsavelTramite;
    }

    public void setUsuarioResponsavelTramite(Usuario usuarioResponsavelTramite) {
        this.usuarioResponsavelTramite = usuarioResponsavelTramite;
    }

    public Optional<String> parecerProcessoByTramiteWrapper(TramiteProcessosWrapper tramite) {
        return tramite.getProcessos().stream().filter(processoDTO -> processoDTO.getTipo().getId().equals(this.getId().getTipo().getId()) && processoDTO.getNumero().equals(this.getId().getNumero()) && processoDTO.getAno().equals(this.getId().getAno())).findFirst().map(ProcessoDTO::getParecer);
    }

    public Escolaridade getEscolaridade() {
        return this.escolaridade;
    }

    public void setEscolaridade(Escolaridade escolaridade) {
        this.escolaridade = escolaridade;
    }

    public PessoaSexo getSexo() {
        return this.sexo;
    }

    public void setSexo(PessoaSexo sexo) {
        this.sexo = sexo;
    }

    public Prioridade getPrioridade() {
        return this.prioridade;
    }

    public void setPrioridade(Prioridade prioridade) {
        this.prioridade = prioridade;
    }

    public NotaEnum getNota() {
        return this.nota;
    }

    public void setNota(NotaEnum nota) {
        this.nota = nota;
    }

    public String getNotaObservacao() {
        return this.notaObservacao;
    }

    public void setNotaObservacao(String notaObservacao) {
        this.notaObservacao = notaObservacao;
    }

    public Boolean getPossuiTaxa() {
        return Boolean.TRUE.equals(this.possuiTaxa);
    }

    public void setPossuiTaxa(Boolean possuiTaxa) {
        this.possuiTaxa = possuiTaxa;
    }

    public LocalDate getPrevisaoConclusao() {
        return this.previsaoConclusao;
    }

    public void setPrevisaoConclusao(LocalDate previsaoConclusao) {
        this.previsaoConclusao = previsaoConclusao;
    }

    public StatusAgrupamento getStatusAgrupamento() {
        return this.statusAgrupamento;
    }

    public Boolean getFechado() {
        return this.fechado;
    }

    public void setFechado(Boolean fechado) {
        this.fechado = fechado;
    }

    public String getParecerByFechado() {
        return this.fechado != false ? "Fechamento de processo executado" : "Fechamento de processo estornado";
    }

    public List<ProcessoAndamento> getAndamentos() {
        return this.andamentos;
    }

    public void setAndamentos(List<ProcessoAndamento> andamentos) {
        this.andamentos = andamentos;
    }

    public Boolean getProcessoFisico() {
        return this.processoFisico;
    }

    public void setProcessoFisico(Boolean processoFisico) {
        this.processoFisico = processoFisico;
    }

    public TipoIntegracaoEnum getTipoIntegracaoAssinatura() {
        return this.tipoIntegracaoAssinatura;
    }

    public void setTipoIntegracaoAssinatura(TipoIntegracaoEnum tipoIntegracaoAssinatura) {
        this.tipoIntegracaoAssinatura = tipoIntegracaoAssinatura;
    }

    public String getIdIntegracaoAssinatura() {
        return this.idIntegracaoAssinatura;
    }

    public void setIdIntegracaoAssinatura(String idIntegracaoAssinatura) {
        this.idIntegracaoAssinatura = idIntegracaoAssinatura;
    }

    public Boolean getTramitaEntreEntidades() {
        return this.tramitaEntreEntidades;
    }

    public void setTramitaEntreEntidades(Boolean tramitaEntreEntidades) {
        this.tramitaEntreEntidades = tramitaEntreEntidades;
    }

    public ProcessoArquivo addArquivo(ProcessoArquivo processoArquivo) {
        this.getArquivos().add(processoArquivo);
        return processoArquivo;
    }

    public String getFilaIntegracaoAssinatura() {
        return this.filaIntegracaoAssinatura;
    }

    public void setFilaIntegracaoAssinatura(String filaIntegracaoAssinatura) {
        this.filaIntegracaoAssinatura = filaIntegracaoAssinatura;
    }

    public ORCUnidade getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    public void setUnidadeOrcamentaria(ORCUnidade unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    public AssinaturaIntegracaoResponseDTO toAssinaturaIntegracaoResponseDTO() {
        AssinaturaIntegracaoResponseDTO response = new AssinaturaIntegracaoResponseDTO();
        response.setId(this.getId().getNumero());
        response.setTipoIntegracao(this.getTipoIntegracaoAssinatura());
        response.setProcesso(this.toPkProcessoDTO());
        response.setProcessoFila(this.getFilaIntegracaoAssinatura());
        return response;
    }

    public static Processo of(ProcessoPK id) {
        Processo processo = new Processo();
        processo.setId(id);
        return processo;
    }

    public boolean hasFilaIntegracaoAssinatura() {
        return StringUtils.isNotBlank((CharSequence)this.filaIntegracaoAssinatura);
    }

    public PkProcessoDTO toPkProcessoDTO() {
        PkProcessoDTO pk = new PkProcessoDTO();
        pk.setAno(this.getId().getAno());
        pk.setEntidade(this.getId().getEntidade().getId());
        pk.setTipo(this.getId().getTipo().getId());
        pk.setNumero(this.getId().getNumero());
        pk.setUuidProtocolo(this.getUuid());
        return pk;
    }

    public LocalDate getPrazoDesclassificacao() {
        return this.prazoDesclassificacao;
    }

    public void setPrazoDesclassificacao(LocalDate prazoDesclassificacao) {
        this.prazoDesclassificacao = prazoDesclassificacao;
    }

    public String getFundamentacaoLegal() {
        return this.fundamentacaoLegal;
    }

    public void setFundamentacaoLegal(String fundamentacaoLegal) {
        this.fundamentacaoLegal = fundamentacaoLegal;
    }

    public Long getRequerimentoTributos() {
        return this.requerimentoTributos;
    }

    public void setRequerimentoTributos(Long requerimentoTributos) {
        this.requerimentoTributos = requerimentoTributos;
    }

    public TipoOuvidoriaEnum getTipoOuvidoria() {
        return this.tipoOuvidoria;
    }

    public void setTipoOuvidoria(TipoOuvidoriaEnum tipoOuvidoria) {
        this.tipoOuvidoria = tipoOuvidoria;
    }

    public DadosProcessoMP getProcessoMp() {
        return this.processoMp;
    }

    public void setProcessoMp(DadosProcessoMP processoMp) {
        this.processoMp = processoMp;
    }

    public String getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(String usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public String getSolicitacaoJson() {
        return this.solicitacaoJson;
    }

    public void setSolicitacaoJson(String solicitacaoJson) {
        this.solicitacaoJson = solicitacaoJson;
    }

    public void setArquivos(List<ProcessoArquivo> arquivos) {
        this.arquivos = arquivos;
    }

    public boolean isPermiteAcessoUsuarioLogado() {
        return this.permiteAcessoUsuarioLogado;
    }

    public List<ProcessoObservador> getObservadores() {
        return this.observadores;
    }

    public void setObservadores(List<ProcessoObservador> observadores) {
        this.observadores = observadores;
    }

    public Boolean getNumeroJaExistente() {
        return this.numeroJaExistente;
    }

    public void setNumeroJaExistente(Boolean numeroJaExistente) {
        this.numeroJaExistente = numeroJaExistente;
    }

    public Boolean getRoteiro() {
        return this.roteiro;
    }

    public void setRoteiro(Boolean roteiro) {
        this.roteiro = roteiro;
    }

    public String getIdentificacaoProcesso() {
        return String.format("Processo %s/%s - Tipo: %s", this.getId().getNumero().toString(), this.getId().getAno().toString(), this.getId().getTipo().getDescricao());
    }

    public Boolean getBloqueioAnexoExterno() {
        return this.bloqueioAnexoExterno;
    }

    public void setBloqueioAnexoExterno(Boolean bloqueioAnexoExterno) {
        this.bloqueioAnexoExterno = bloqueioAnexoExterno;
    }

    public Long getEntidadeId() {
        return Optional.ofNullable(this.getId()).filter(processoPK -> Objects.nonNull(processoPK.getEntidade())).map(processoPK -> processoPK.getEntidade().getId()).orElse(null);
    }

    public Long getAno() {
        if (Objects.nonNull(this.getId())) {
            return this.getId().getAno();
        }
        return null;
    }

    public static Specification<Processo> filterAssinaturaPendente(Boolean filter) {
        if (Objects.isNull(filter)) {
            return null;
        }
        Specification specification = ProcessoSpecificationHelper.filtrarProcessosAssinaturaPendente();
        return Boolean.TRUE.equals(filter) ? specification : Specification.not((Specification)specification);
    }

    public Boolean getPossuiAssinaturaPendente() {
        return !this.getArquivos().isEmpty() && this.getArquivos().stream().flatMap(pa -> pa.getAssinaturas().stream()).anyMatch(processoArquivoAssinatura -> AssinaturaSituacaoEnum.PENDENTE.equals((Object)processoArquivoAssinatura.getSituacao()));
    }

    public Boolean getPossuiAssinaturaRejeitada() {
        return !this.getArquivos().isEmpty() && this.getArquivos().stream().flatMap(pa -> pa.getAssinaturas().stream()).anyMatch(processoArquivoAssinatura -> AssinaturaSituacaoEnum.REJEITADO.equals((Object)processoArquivoAssinatura.getSituacao()));
    }

    @JsonIgnore
    public boolean isProcessoIntegracaoLegado() {
        return StringUtils.isNotBlank((CharSequence)this.getFilaIntegracaoAssinatura()) && this.getArquivos().stream().noneMatch(ProcessoArquivo::isArquivoIntegracao);
    }

    public String getDenunciado() {
        return this.denunciado;
    }

    public void setDenunciado(String denunciado) {
        this.denunciado = denunciado;
    }

    @Generated
    public String toString() {
        return "Processo(id=" + String.valueOf(this.getId()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Processo)) {
            return false;
        }
        Processo other = (Processo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProcessoPK this$id = this.getId();
        ProcessoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Processo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

