/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.protocolo.dto.EnderecoPessoaDTO;
import br.com.elotech.protocolo.dto.PessoaDTO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="pessoaatualizador")
public class PessoaAtualizador
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="ID_PESSOAATUALIZADOR", applyOnMerge=true)
    private Long id;
    @Length(max=20)
    @Column(name="cpfcnpj")
    private @Length(max=20) String cpfCnpj;
    @Length(max=100)
    private @Length(max=100) String nome;
    @Length(max=100)
    private @Length(max=100) String email;
    private String complemento;
    @Length(max=20)
    private @Length(max=20) String telefone;
    @Column(name="datanascimento")
    private LocalDate dataNascimento;
    @Length(max=9)
    private @Length(max=9) String cep;
    @Length(max=100)
    private @Length(max=100) String endereco;
    @Column(name="codbairro")
    private Long codigoBairro;
    @Column(name="codendereco")
    private Long codigoEndereco;
    @Column(name="codcidade")
    private Long codigoCidade;
    private String numero;
    @Length(max=2)
    private @Length(max=2) String uf;
    @Length(max=100)
    private @Length(max=100) String cidade;
    @Length(max=100)
    private @Length(max=100) String bairro;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean atualizado = Boolean.FALSE;
    @Length(max=50)
    @Column(name="usuarioatualizacao")
    private @Length(max=50) String usuarioAtualizacao;
    @Column(name="dataatualizacao")
    private LocalDateTime dataAtualizacao;

    public PessoaAtualizador pessoaAtualizadorByPessoa(PessoaDTO pessoa) {
        if (!pessoa.getEnderecos().isEmpty()) {
            EnderecoPessoaDTO enderecoPessoa = (EnderecoPessoaDTO)pessoa.getEnderecos().get(0);
            this.setBairro(enderecoPessoa.getBairro().getDescricao());
            this.setCodigoBairro(enderecoPessoa.getBairro().getId());
            this.setCidade(enderecoPessoa.getCidade().getDescricao());
            this.setCodigoCidade(enderecoPessoa.getCidade().getId());
            this.setUf(enderecoPessoa.getUf().getId());
            this.setEndereco(enderecoPessoa.getLogradouro().getDescricao());
            this.setCodigoEndereco(enderecoPessoa.getLogradouro().getId());
            this.setNumero(enderecoPessoa.getNumero());
            this.setComplemento(enderecoPessoa.getComplemento());
            this.setCep(enderecoPessoa.getCep());
        }
        this.setDataNascimento(pessoa.getDataNascimento());
        this.setCpfCnpj(pessoa.getCnpjCpf());
        this.setNome(pessoa.getNome());
        this.setEmail(pessoa.getEmail());
        this.setTelefone(pessoa.getCelular());
        return this;
    }

    @Generated
    public PessoaAtualizador() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getEndereco() {
        return this.endereco;
    }

    @Generated
    public Long getCodigoBairro() {
        return this.codigoBairro;
    }

    @Generated
    public Long getCodigoEndereco() {
        return this.codigoEndereco;
    }

    @Generated
    public Long getCodigoCidade() {
        return this.codigoCidade;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public Boolean getAtualizado() {
        return this.atualizado;
    }

    @Generated
    public String getUsuarioAtualizacao() {
        return this.usuarioAtualizacao;
    }

    @Generated
    public LocalDateTime getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Generated
    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    @Generated
    public void setCodigoBairro(Long codigoBairro) {
        this.codigoBairro = codigoBairro;
    }

    @Generated
    public void setCodigoEndereco(Long codigoEndereco) {
        this.codigoEndereco = codigoEndereco;
    }

    @Generated
    public void setCodigoCidade(Long codigoCidade) {
        this.codigoCidade = codigoCidade;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setAtualizado(Boolean atualizado) {
        this.atualizado = atualizado;
    }

    @Generated
    public void setUsuarioAtualizacao(String usuarioAtualizacao) {
        this.usuarioAtualizacao = usuarioAtualizacao;
    }

    @Generated
    public void setDataAtualizacao(LocalDateTime dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PessoaAtualizador)) {
            return false;
        }
        PessoaAtualizador other = (PessoaAtualizador)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigoBairro = this.getCodigoBairro();
        Long other$codigoBairro = other.getCodigoBairro();
        if (this$codigoBairro == null ? other$codigoBairro != null : !((Object)this$codigoBairro).equals(other$codigoBairro)) {
            return false;
        }
        Long this$codigoEndereco = this.getCodigoEndereco();
        Long other$codigoEndereco = other.getCodigoEndereco();
        if (this$codigoEndereco == null ? other$codigoEndereco != null : !((Object)this$codigoEndereco).equals(other$codigoEndereco)) {
            return false;
        }
        Long this$codigoCidade = this.getCodigoCidade();
        Long other$codigoCidade = other.getCodigoCidade();
        if (this$codigoCidade == null ? other$codigoCidade != null : !((Object)this$codigoCidade).equals(other$codigoCidade)) {
            return false;
        }
        Boolean this$atualizado = this.getAtualizado();
        Boolean other$atualizado = other.getAtualizado();
        if (this$atualizado == null ? other$atualizado != null : !((Object)this$atualizado).equals(other$atualizado)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$telefone = this.getTelefone();
        String other$telefone = other.getTelefone();
        if (this$telefone == null ? other$telefone != null : !this$telefone.equals(other$telefone)) {
            return false;
        }
        LocalDate this$dataNascimento = this.getDataNascimento();
        LocalDate other$dataNascimento = other.getDataNascimento();
        if (this$dataNascimento == null ? other$dataNascimento != null : !((Object)this$dataNascimento).equals(other$dataNascimento)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$endereco = this.getEndereco();
        String other$endereco = other.getEndereco();
        if (this$endereco == null ? other$endereco != null : !this$endereco.equals(other$endereco)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$uf = this.getUf();
        String other$uf = other.getUf();
        if (this$uf == null ? other$uf != null : !this$uf.equals(other$uf)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$usuarioAtualizacao = this.getUsuarioAtualizacao();
        String other$usuarioAtualizacao = other.getUsuarioAtualizacao();
        if (this$usuarioAtualizacao == null ? other$usuarioAtualizacao != null : !this$usuarioAtualizacao.equals(other$usuarioAtualizacao)) {
            return false;
        }
        LocalDateTime this$dataAtualizacao = this.getDataAtualizacao();
        LocalDateTime other$dataAtualizacao = other.getDataAtualizacao();
        return !(this$dataAtualizacao == null ? other$dataAtualizacao != null : !((Object)this$dataAtualizacao).equals(other$dataAtualizacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PessoaAtualizador;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigoBairro = this.getCodigoBairro();
        result = result * 59 + ($codigoBairro == null ? 43 : ((Object)$codigoBairro).hashCode());
        Long $codigoEndereco = this.getCodigoEndereco();
        result = result * 59 + ($codigoEndereco == null ? 43 : ((Object)$codigoEndereco).hashCode());
        Long $codigoCidade = this.getCodigoCidade();
        result = result * 59 + ($codigoCidade == null ? 43 : ((Object)$codigoCidade).hashCode());
        Boolean $atualizado = this.getAtualizado();
        result = result * 59 + ($atualizado == null ? 43 : ((Object)$atualizado).hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $telefone = this.getTelefone();
        result = result * 59 + ($telefone == null ? 43 : $telefone.hashCode());
        LocalDate $dataNascimento = this.getDataNascimento();
        result = result * 59 + ($dataNascimento == null ? 43 : ((Object)$dataNascimento).hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $endereco = this.getEndereco();
        result = result * 59 + ($endereco == null ? 43 : $endereco.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $uf = this.getUf();
        result = result * 59 + ($uf == null ? 43 : $uf.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $usuarioAtualizacao = this.getUsuarioAtualizacao();
        result = result * 59 + ($usuarioAtualizacao == null ? 43 : $usuarioAtualizacao.hashCode());
        LocalDateTime $dataAtualizacao = this.getDataAtualizacao();
        result = result * 59 + ($dataAtualizacao == null ? 43 : ((Object)$dataAtualizacao).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PessoaAtualizador(id=" + this.getId() + ", cpfCnpj=" + this.getCpfCnpj() + ", nome=" + this.getNome() + ", email=" + this.getEmail() + ", complemento=" + this.getComplemento() + ", telefone=" + this.getTelefone() + ", dataNascimento=" + String.valueOf(this.getDataNascimento()) + ", cep=" + this.getCep() + ", endereco=" + this.getEndereco() + ", codigoBairro=" + this.getCodigoBairro() + ", codigoEndereco=" + this.getCodigoEndereco() + ", codigoCidade=" + this.getCodigoCidade() + ", numero=" + this.getNumero() + ", uf=" + this.getUf() + ", cidade=" + this.getCidade() + ", bairro=" + this.getBairro() + ", atualizado=" + this.getAtualizado() + ", usuarioAtualizacao=" + this.getUsuarioAtualizacao() + ", dataAtualizacao=" + String.valueOf(this.getDataAtualizacao()) + ")";
    }
}

