/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.converter.TipoPessoaEnumConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.protocolo.domain.Bairro;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.domain.Contato;
import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.Logradouro;
import br.com.elotech.protocolo.domain.PessoaAtualizador;
import br.com.elotech.protocolo.domain.UnidadeFederacao;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="pessoa")
@DynamicInsert
@DynamicUpdate
@Audited
public class Pessoa
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s_protocolopessoa")
    @Column(name="codpessoa")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Convert(converter=TipoPessoaEnumConverter.class)
    @Column(name="pessoa")
    private TipoPessoa tipoPessoa;
    @NotNull
    @Length(max=150)
    @Caption(value="Nome")
    private @NotNull @Length(max=150) String nome;
    @Length(max=80)
    private @Length(max=80) String endimovel;
    @Length(max=40)
    private @Length(max=40) String inscrimovel;
    @Length(max=50)
    private @Length(max=50) String cargo;
    @Length(max=20)
    private @Length(max=20) String rg;
    private Long sequenciaEndereco;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.pessoa")
    private final List<EnderecoPessoa> enderecos = new ArrayList();
    @Column(name="cnpj_cpf")
    @Caption(value="CPF - CNPJ")
    private String cnpjCpf;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo = Boolean.TRUE;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="dadossigilosos")
    private Boolean dadosSigilosos;
    @Embedded
    private Contato contato;
    private Long idUnico;
    private LocalDate dataNascimento;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getEndimovel() {
        return this.endimovel;
    }

    public void setEndimovel(String endimovel) {
        this.endimovel = endimovel;
    }

    public String getInscrimovel() {
        return this.inscrimovel;
    }

    public void setInscrimovel(String inscrimovel) {
        this.inscrimovel = inscrimovel;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public Long getSequenciaEndereco() {
        return this.sequenciaEndereco;
    }

    public void setSequenciaEndereco(Long sequenciaEndereco) {
        this.sequenciaEndereco = sequenciaEndereco;
    }

    public List<EnderecoPessoa> getEnderecos() {
        return this.enderecos;
    }

    public Pessoa withId(Long id) {
        this.id = id;
        return this;
    }

    public Pessoa withNome(String nome) {
        this.nome = nome;
        return this;
    }

    public Pessoa withTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
        return this;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Contato getContato() {
        return this.contato;
    }

    public void setContato(Contato contato) {
        this.contato = contato;
    }

    public EnderecoPessoa getEnderecoPrincipal() {
        if (Objects.isNull(this.enderecos) || this.enderecos.isEmpty()) {
            return null;
        }
        for (EnderecoPessoa enderecoPessoa : this.enderecos) {
            if (enderecoPessoa.getPk().getCodigo() == null || !enderecoPessoa.getPk().getCodigo().equals(this.sequenciaEndereco)) continue;
            return enderecoPessoa;
        }
        return (EnderecoPessoa)this.enderecos.get(0);
    }

    public Boolean hasContatoEmail() {
        return Objects.nonNull(this.contato) && StringUtils.isNotBlank((CharSequence)this.contato.getEmail());
    }

    public String getContatoEmail() {
        return this.hasContatoEmail() != false ? this.getContato().getEmail() : null;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public Boolean isCpf() {
        if (this.getCnpjCpf() != null) {
            return Boolean.TRUE.equals(this.getCnpjCpf().length() == 11);
        }
        return Boolean.FALSE;
    }

    public Boolean getDadosSigilosos() {
        return this.dadosSigilosos;
    }

    public void setDadosSigilosos(Boolean dadosSigilosos) {
        this.dadosSigilosos = dadosSigilosos;
    }

    public void alterarPessoaByAtualizador(PessoaAtualizador atualizador) {
        Optional.ofNullable(atualizador.getCep()).ifPresent(cep -> {
            EnderecoPessoa endereco = new EnderecoPessoa();
            endereco.getPk().setPessoa(this);
            endereco.setCep(atualizador.getCep());
            endereco.setNumero(atualizador.getNumero());
            endereco.setComplemento(atualizador.getComplemento());
            endereco.setBairro(new Bairro(atualizador.getCodigoBairro()));
            endereco.setCidade(new Cidade(atualizador.getCodigoCidade()));
            endereco.setLogradouro(new Logradouro(atualizador.getCodigoEndereco()));
            endereco.setUf(UnidadeFederacao.of((String)atualizador.getUf()));
            this.getEnderecos().add(endereco);
        });
        this.setNome(atualizador.getNome());
        this.setDataNascimento(atualizador.getDataNascimento());
        this.setContato(new Contato(atualizador.getTelefone(), atualizador.getTelefone(), atualizador.getEmail()));
    }

    public static Pessoa of(Long id) {
        Pessoa pessoa = new Pessoa();
        pessoa.setId(id);
        return pessoa;
    }

    @Generated
    public String toString() {
        return "Pessoa(id=" + this.getId() + ", tipoPessoa=" + String.valueOf(this.getTipoPessoa()) + ", nome=" + this.getNome() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pessoa)) {
            return false;
        }
        Pessoa other = (Pessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

